/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.io.File;
import java.util.Date;
import org.opends.server.types.BackupInfo;

public class BackupDescriptor {
    private Type type;
    private Date creationDate;
    private File path;
    private String id;
    private BackupInfo info;

    public BackupDescriptor(File path, Date creationDate, Type type, String id) {
        this.path = path;
        this.creationDate = creationDate;
        this.type = type;
        this.id = id;
    }

    public BackupDescriptor(BackupInfo info) {
        this.path = new File(info.getBackupDirectory().getPath());
        this.creationDate = info.getBackupDate();
        this.type = info.isIncremental() ? Type.INCREMENTAL : Type.FULL;
        this.id = info.getBackupID();
        this.info = info;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public File getPath() {
        return this.path;
    }

    public Type getType() {
        return this.type;
    }

    public String getID() {
        return this.id;
    }

    public BackupInfo getBackupInfo() {
        return this.info;
    }

    public static enum Type {
        FULL,
        INCREMENTAL;

    }
}

