/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.server.types.DN;

public class BaseDNDescriptor
implements Comparable<BaseDNDescriptor> {
    private int nEntries;
    private int missingChanges;
    private BackendDescriptor backend;
    private long ageOfOldestMissingChange;
    private Type type;
    private final DN baseDn;
    private int replicaID = -1;
    private int hashCode;

    public BaseDNDescriptor(Type type, DN baseDn, BackendDescriptor backend, int nEntries, long ageOfOldestMissingChange, int missingChanges) {
        this.baseDn = baseDn;
        this.backend = backend;
        this.type = type;
        this.nEntries = nEntries;
        this.ageOfOldestMissingChange = ageOfOldestMissingChange;
        this.missingChanges = missingChanges;
        if (backend != null) {
            this.recalculateHashCode();
        }
    }

    public DN getDn() {
        return this.baseDn;
    }

    public boolean equals(Object v) {
        boolean equals = false;
        if (this != v) {
            if (v instanceof BaseDNDescriptor) {
                BaseDNDescriptor desc = (BaseDNDescriptor)v;
                boolean bl = equals = this.getType() == desc.getType() && this.getDn().equals(desc.getDn()) && this.getAgeOfOldestMissingChange() == desc.getAgeOfOldestMissingChange() && this.getMissingChanges() == desc.getMissingChanges() && this.getEntries() == desc.getEntries();
                if (equals && this.getBackend() != null && desc.getBackend() != null) {
                    equals = this.getBackend().getBackendID().equals(desc.getBackend().getBackendID());
                }
            }
        } else {
            equals = true;
        }
        return equals;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(BaseDNDescriptor desc) {
        int returnValue = -1;
        returnValue = desc.getDn().compareTo(this.getDn());
        if (returnValue == 0) {
            returnValue = this.getType().compareTo(desc.getType());
        }
        if (returnValue == 0 && this.getBackend() != null && desc.getBackend() != null) {
            returnValue = this.getBackend().getBackendID().compareTo(desc.getBackend().getBackendID());
        }
        if (returnValue == 0) {
            returnValue = this.compare(this.getEntries(), desc.getEntries());
        }
        if (returnValue == 0) {
            returnValue = this.compare(this.getAgeOfOldestMissingChange(), desc.getAgeOfOldestMissingChange());
        }
        if (returnValue == 0) {
            returnValue = this.compare(this.getMissingChanges(), desc.getMissingChanges());
        }
        return returnValue;
    }

    public int getEntries() {
        return this.nEntries;
    }

    public int getMissingChanges() {
        return this.missingChanges;
    }

    public void setMissingChanges(int missingChanges) {
        this.missingChanges = missingChanges;
        this.recalculateHashCode();
    }

    public long getAgeOfOldestMissingChange() {
        return this.ageOfOldestMissingChange;
    }

    public void setAgeOfOldestMissingChange(long ageOfOldestMissingChange) {
        this.ageOfOldestMissingChange = ageOfOldestMissingChange;
        this.recalculateHashCode();
    }

    public Type getType() {
        return this.type;
    }

    public BackendDescriptor getBackend() {
        return this.backend;
    }

    public void setBackend(BackendDescriptor backend) {
        this.backend = backend;
        this.recalculateHashCode();
    }

    public void setType(Type type) {
        this.type = type;
        this.recalculateHashCode();
    }

    public void setEntries(int nEntries) {
        this.nEntries = nEntries;
        this.recalculateHashCode();
    }

    public int getReplicaID() {
        return this.replicaID;
    }

    public void setReplicaID(int replicaID) {
        this.replicaID = replicaID;
        this.recalculateHashCode();
    }

    private void recalculateHashCode() {
        this.hashCode = (this.getType().toString() + this.getAgeOfOldestMissingChange() + this.getDn() + this.getBackend().getBackendID() + this.getMissingChanges()).hashCode();
    }

    private int compare(int i1, int i2) {
        if (i1 == i2) {
            return 0;
        }
        if (i1 > i2) {
            return 1;
        }
        return -1;
    }

    private int compare(long i1, long i2) {
        if (i1 == i2) {
            return 0;
        }
        if (i1 > i2) {
            return 1;
        }
        return -1;
    }

    public static enum Type {
        NOT_REPLICATED,
        REPLICATED,
        DISABLED;

    }
}

