/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.SortableTableModel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public class DBEnvironmentMonitoringTableModel
extends SortableTableModel
implements Comparator<BackendDescriptor> {
    private static final long serialVersionUID = 548035716525600536L;
    private Set<BackendDescriptor> data = new HashSet<BackendDescriptor>();
    private ArrayList<String[]> dataArray = new ArrayList();
    private ArrayList<BackendDescriptor> dataSourceArray = new ArrayList();
    private String[] columnNames = new String[0];
    private Message NO_VALUE_SET = AdminToolMessages.INFO_CTRL_PANEL_NO_MONITORING_VALUE.get();
    private Message NOT_IMPLEMENTED = AdminToolMessages.INFO_CTRL_PANEL_NOT_IMPLEMENTED.get();
    private LinkedHashSet<String> attributes = new LinkedHashSet();
    private int sortColumn = 0;
    private boolean sortAscending = true;

    public void setData(Set<BackendDescriptor> newData) {
        if (!((Object)newData).equals(this.data)) {
            this.data.clear();
            this.data.addAll(newData);
            this.updateDataArray();
            this.fireTableDataChanged();
        }
    }

    @Override
    public void forceResort() {
        this.updateDataArray();
        this.fireTableDataChanged();
    }

    public void forceDataStructureChange() {
        this.updateDataArray();
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataArray.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.dataArray.get(row)[col];
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int compare(BackendDescriptor desc1, BackendDescriptor desc2) {
        ArrayList<Integer> possibleResults = new ArrayList<Integer>();
        possibleResults.add(this.getName(desc1).compareTo(this.getName(desc2)));
        for (String attrName : this.attributes) {
            int possibleResult;
            if (desc1.getMonitoringEntry() == null) {
                possibleResult = desc2.getMonitoringEntry() == null ? 0 : -1;
            } else if (desc2.getMonitoringEntry() == null) {
                possibleResult = 1;
            } else {
                double n2;
                double n1;
                Object v1 = null;
                Object v2 = null;
                for (String attr : desc1.getMonitoringEntry().getAttributeNames()) {
                    if (!attr.equalsIgnoreCase(attrName)) continue;
                    v1 = this.getFirstMonitoringValue(desc1.getMonitoringEntry(), attrName);
                    break;
                }
                for (String attr : desc2.getMonitoringEntry().getAttributeNames()) {
                    if (!attr.equalsIgnoreCase(attrName)) continue;
                    v2 = this.getFirstMonitoringValue(desc2.getMonitoringEntry(), attrName);
                    break;
                }
                possibleResult = v1 == null ? (v2 == null ? 0 : -1) : (v2 == null ? 1 : (v1 instanceof Number ? (v1 instanceof Double || v2 instanceof Double ? ((n1 = ((Number)v1).doubleValue()) > (n2 = ((Number)v2).doubleValue()) ? 1 : (n1 < n2 ? -1 : 0)) : ((n1 = ((Number)v1).longValue()) > (n2 = ((Number)v2).longValue()) ? 1 : (n1 < n2 ? -1 : 0))) : (v2 instanceof Number ? -1 : v1.toString().compareTo(v2.toString()))));
            }
            possibleResults.add(possibleResult);
        }
        int result = (Integer)possibleResults.get(this.getSortColumn());
        if (result == 0) {
            Iterator i$ = possibleResults.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                if (i == 0) continue;
                result = i;
                break;
            }
        }
        if (!this.isSortAscending()) {
            result = -result;
        }
        return result;
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    @Override
    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public void setSortColumn(int sortColumn) {
        this.sortColumn = sortColumn;
    }

    public Collection<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(LinkedHashSet<String> operations) {
        this.attributes.clear();
        this.attributes.addAll(operations);
        this.columnNames = new String[operations.size() + 1];
        this.columnNames[0] = AdminToolMessages.INFO_CTRL_PANEL_DB_HEADER.get().toString();
        int i = 1;
        Iterator i$ = operations.iterator();
        while (i$.hasNext()) {
            String operation;
            this.columnNames[i] = operation = (String)i$.next();
            ++i;
        }
    }

    private void updateDataArray() {
        TreeSet<BackendDescriptor> sortedSet = new TreeSet<BackendDescriptor>(this);
        sortedSet.addAll(this.data);
        this.dataArray.clear();
        this.dataSourceArray.clear();
        for (BackendDescriptor ach : sortedSet) {
            String[] s = this.getLine(ach);
            this.dataArray.add(s);
            this.dataSourceArray.add(ach);
        }
        String[] line = new String[this.attributes.size() + 1];
        line[0] = "<html><b>" + AdminToolMessages.INFO_CTRL_PANEL_TOTAL_LABEL.get().toString() + "</b>";
        for (int i = 1; i < line.length; ++i) {
            boolean valueSet = false;
            boolean notImplemented = false;
            long totalValue = 0L;
            for (int j = 0; j < this.dataArray.size(); ++j) {
                String[] l = this.dataArray.get(j);
                String value = l[i];
                try {
                    long v = Long.parseLong(value);
                    totalValue += v;
                    valueSet = true;
                    continue;
                }
                catch (Throwable t) {
                    try {
                        double v = Double.parseDouble(value);
                        totalValue = (long)((double)totalValue + v);
                        valueSet = true;
                        continue;
                    }
                    catch (Throwable t2) {
                        notImplemented = this.NOT_IMPLEMENTED.toString().equals(value);
                    }
                }
            }
            line[i] = notImplemented ? this.NOT_IMPLEMENTED.toString() : (valueSet ? String.valueOf(totalValue) : this.NO_VALUE_SET.toString());
        }
        this.dataArray.add(line);
    }

    protected String[] getColumnNames() {
        return this.columnNames;
    }

    protected String getName(BackendDescriptor backend) {
        return backend.getBackendID();
    }

    protected CustomSearchResult getMonitoringEntry(BackendDescriptor backend) {
        return backend.getMonitoringEntry();
    }

    private String[] getLine(BackendDescriptor backend) {
        String[] line = new String[this.attributes.size() + 1];
        line[0] = this.getName(backend);
        int i = 1;
        CustomSearchResult monitoringEntry = this.getMonitoringEntry(backend);
        for (String attr : this.attributes) {
            Object o = this.getFirstMonitoringValue(monitoringEntry, attr);
            line[i] = o == null ? this.NO_VALUE_SET.toString() : o.toString();
            ++i;
        }
        return line;
    }

    protected Object getFirstMonitoringValue(CustomSearchResult sr, String attrName) {
        return Utilities.getFirstMonitoringValue(sr, attrName);
    }
}

