/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.AbstractIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.VLVIndexDescriptor;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.ConfigReader;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.std.client.LocalDBBackendCfgClient;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.types.DN;
import org.opends.server.types.OpenDsException;

public class DeleteIndexTask
extends Task {
    private Set<String> backendSet;
    private ArrayList<AbstractIndexDescriptor> indexesToDelete = new ArrayList();
    private ArrayList<AbstractIndexDescriptor> deletedIndexes = new ArrayList();

    public DeleteIndexTask(ControlPanelInfo info, ProgressDialog dlg, ArrayList<AbstractIndexDescriptor> indexesToDelete) {
        super(info, dlg);
        this.backendSet = new HashSet<String>();
        for (AbstractIndexDescriptor index : indexesToDelete) {
            this.backendSet.add(index.getBackend().getBackendID());
        }
        this.indexesToDelete.addAll(indexesToDelete);
    }

    @Override
    public Task.Type getType() {
        return Task.Type.DELETE_INDEX;
    }

    @Override
    public Set<String> getBackends() {
        return this.backendSet;
    }

    @Override
    public Message getTaskDescription() {
        if (this.backendSet.size() == 1) {
            return AdminToolMessages.INFO_CTRL_PANEL_DELETE_INDEX_TASK_DESCRIPTION.get(Utilities.getStringFromCollection(this.backendSet, ", "));
        }
        return AdminToolMessages.INFO_CTRL_PANEL_DELETE_INDEX_IN_BACKENDS_TASK_DESCRIPTION.get(Utilities.getStringFromCollection(this.backendSet, ", "));
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        boolean canLaunch = true;
        if (this.state == Task.State.RUNNING && this.runningOnSameServer(taskToBeLaunched)) {
            TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
            backends.retainAll(this.getBackends());
            if (backends.size() > 0) {
                incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                canLaunch = false;
            }
        }
        return canLaunch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfiguration() throws OpenDsException {
        boolean configHandlerUpdated = false;
        final int totalNumber = this.indexesToDelete.size();
        int numberDeleted = 0;
        try {
            if (!this.isServerRunning()) {
                configHandlerUpdated = true;
                this.getInfo().stopPooling();
                if (this.getInfo().mustDeregisterConfig()) {
                    DirectoryServer.deregisterBaseDN(DN.decode("cn=config"));
                }
                DirectoryServer.getInstance().initializeConfiguration(ConfigFileHandler.class.getName(), ConfigReader.configFile);
                this.getInfo().setMustDeregisterConfig(true);
            }
            boolean isFirst = true;
            for (final AbstractIndexDescriptor index : this.indexesToDelete) {
                if (!isFirst) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DeleteIndexTask.this.getProgressDialog().appendProgressHtml("<br><br>");
                        }
                    });
                }
                isFirst = false;
                if (this.isServerRunning()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            List<String> args = DeleteIndexTask.this.getObfuscatedCommandLineArguments(DeleteIndexTask.this.getDSConfigCommandLineArguments(index));
                            args.removeAll(DeleteIndexTask.this.getConfigCommandLineArguments());
                            DeleteIndexTask.this.printEquivalentCommandLine(DeleteIndexTask.this.getConfigCommandLineName(index), args, AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_DELETE_INDEX.get());
                        }
                    });
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DeleteIndexTask.this.isVLVIndex(index)) {
                            DeleteIndexTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_DELETING_VLV_INDEX.get(index.getName()), ColorAndFontConstants.progressFont));
                        } else {
                            DeleteIndexTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_DELETING_INDEX.get(index.getName()), ColorAndFontConstants.progressFont));
                        }
                    }
                });
                if (this.isServerRunning()) {
                    this.deleteIndex(this.getInfo().getDirContext(), index);
                } else {
                    this.deleteIndex(index);
                }
                final int fNumberDeleted = ++numberDeleted;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DeleteIndexTask.this.getProgressDialog().getProgressBar().setIndeterminate(false);
                        DeleteIndexTask.this.getProgressDialog().getProgressBar().setValue(fNumberDeleted * 100 / totalNumber);
                        DeleteIndexTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                    }
                });
                this.deletedIndexes.add(index);
            }
        }
        finally {
            if (configHandlerUpdated) {
                DirectoryServer.getInstance().initializeConfiguration(ConfigReader.configClassName, ConfigReader.configFile);
                this.getInfo().startPooling();
            }
        }
    }

    private boolean isVLVIndex(AbstractIndexDescriptor index) {
        return index instanceof VLVIndexDescriptor;
    }

    private void deleteIndex(AbstractIndexDescriptor index) throws OpenDsException {
        if (this.isVLVIndex(index)) {
            String dn = Utilities.getRDNString("ds-cfg-name", index.getName()) + ",cn=VLV Index," + Utilities.getRDNString("ds-cfg-backend-id", index.getBackend().getBackendID()) + ",cn=Backends,cn=config";
            DirectoryServer.getConfigHandler().deleteEntry(DN.decode(dn), null);
        } else {
            String dn = Utilities.getRDNString("ds-cfg-attribute", index.getName()) + ",cn=Index," + Utilities.getRDNString("ds-cfg-backend-id", index.getBackend().getBackendID()) + ",cn=Backends,cn=config";
            DirectoryServer.getConfigHandler().deleteEntry(DN.decode(dn), null);
        }
    }

    private void deleteIndex(InitialLdapContext ctx, AbstractIndexDescriptor index) throws OpenDsException {
        ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
        RootCfgClient root = mCtx.getRootConfiguration();
        LocalDBBackendCfgClient backend = (LocalDBBackendCfgClient)root.getBackend(index.getBackend().getBackendID());
        if (this.isVLVIndex(index)) {
            backend.removeLocalDBVLVIndex(index.getName());
        } else {
            backend.removeLocalDBIndex(index.getName());
        }
        backend.commit();
    }

    @Override
    protected String getCommandLinePath() {
        return null;
    }

    protected ArrayList<String> getCommandLineArguments() {
        return new ArrayList<String>();
    }

    private String getConfigCommandLineName(AbstractIndexDescriptor index) {
        if (this.isServerRunning()) {
            return this.getCommandLinePath("dsconfig");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTask() {
        this.state = Task.State.RUNNING;
        this.lastException = null;
        try {
            this.updateConfiguration();
            this.state = Task.State.FINISHED_SUCCESSFULLY;
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
        finally {
            for (AbstractIndexDescriptor index : this.deletedIndexes) {
                this.getInfo().unregisterModifiedIndex(index);
            }
        }
    }

    private ArrayList<String> getDSConfigCommandLineArguments(AbstractIndexDescriptor index) {
        ArrayList<String> args = new ArrayList<String>();
        if (this.isVLVIndex(index)) {
            args.add("delete-local-db-vlv-index");
        } else {
            args.add("delete-local-db-index");
        }
        args.add("--backend-name");
        args.add(index.getBackend().getBackendID());
        args.add("--index-name");
        args.add(index.getName());
        args.addAll(this.getConnectionCommandLineArguments());
        args.add("--no-prompt");
        args.add(this.getNoPropertiesFileArgument());
        return args;
    }
}

