/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.server.types.DN;

public abstract class IndexTask
extends Task {
    protected Set<String> backendSet;
    protected Set<String> baseDNs;

    protected IndexTask(ControlPanelInfo info, ProgressDialog dlg, String baseDN) {
        super(info, dlg);
        this.baseDNs = new HashSet<String>();
        this.baseDNs.add(baseDN);
        this.initializeBackendSet();
    }

    protected IndexTask(ControlPanelInfo info, ProgressDialog dlg, Collection<String> baseDNs) {
        super(info, dlg);
        this.backendSet = new HashSet<String>();
        this.baseDNs = new TreeSet<String>();
        this.baseDNs.addAll(baseDNs);
        this.initializeBackendSet();
    }

    private void initializeBackendSet() {
        this.backendSet = new TreeSet<String>();
        DN theDN = null;
        block2: for (String baseDN : this.baseDNs) {
            try {
                theDN = DN.decode(baseDN);
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Could not decode dn " + baseDN, t);
            }
            for (BackendDescriptor backend : this.getInfo().getServerDescriptor().getBackends()) {
                for (BaseDNDescriptor b : backend.getBaseDns()) {
                    if (!b.getDn().equals(theDN)) continue;
                    this.backendSet.add(backend.getBackendID());
                    break;
                }
                if (this.backendSet.size() <= 0) continue;
                continue block2;
            }
        }
    }

    @Override
    public Set<String> getBackends() {
        return this.backendSet;
    }
}

