/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.AbstractIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.IndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVIndexDescriptor;
import org.opends.guitools.controlpanel.task.IndexTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.tools.RebuildIndex;

public class RebuildIndexTask
extends IndexTask {
    private SortedSet<AbstractIndexDescriptor> indexes = new TreeSet<AbstractIndexDescriptor>();
    public static final String[] INDEXES_NOT_TO_SPECIFY = new String[]{"id2children", "id2subtree"};

    public RebuildIndexTask(ControlPanelInfo info, ProgressDialog dlg, Collection<String> baseDNs, SortedSet<AbstractIndexDescriptor> indexes) {
        super(info, dlg, baseDNs);
        this.indexes.addAll(indexes);
    }

    @Override
    public Task.Type getType() {
        return Task.Type.REBUILD_INDEXES;
    }

    @Override
    public Message getTaskDescription() {
        if (this.baseDNs.size() == 1) {
            return AdminToolMessages.INFO_CTRL_PANEL_REBUILD_INDEX_TASK_DESCRIPTION.get((CharSequence)this.baseDNs.iterator().next());
        }
        return AdminToolMessages.INFO_CTRL_PANEL_REBUILD_INDEX_TASK_DESCRIPTION.get((CharSequence)this.backendSet.iterator().next());
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        boolean canLaunch = true;
        if (this.state == Task.State.RUNNING && this.runningOnSameServer(taskToBeLaunched)) {
            TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
            backends.retainAll(this.getBackends());
            if (backends.size() > 0) {
                incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                canLaunch = false;
            }
        }
        return canLaunch;
    }

    @Override
    public void runTask() {
        this.state = Task.State.RUNNING;
        this.lastException = null;
        try {
            boolean isLocal = this.getInfo().getServerDescriptor().isLocal();
            for (final String baseDN : this.baseDNs) {
                ArrayList<String> arguments = this.getCommandLineArguments(baseDN);
                String[] args = new String[arguments.size()];
                arguments.toArray(args);
                final List<String> displayArgs = this.getObfuscatedCommandLineArguments(this.getCommandLineArguments(baseDN));
                displayArgs.removeAll(this.getConfigCommandLineArguments());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RebuildIndexTask.this.printEquivalentCommandLine(RebuildIndexTask.this.getCommandLinePath("rebuild-index"), displayArgs, AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_REBUILD_INDEX.get(baseDN));
                    }
                });
                this.returnCode = isLocal && !this.isServerRunning() ? Integer.valueOf(this.executeCommandLine(this.getCommandLinePath("rebuild-index"), args)) : Integer.valueOf(RebuildIndex.mainRebuildIndex(args, false, this.outPrintStream, this.errorPrintStream));
                if (this.returnCode == 0) continue;
                break;
            }
            if (this.returnCode != 0) {
                this.state = Task.State.FINISHED_WITH_ERROR;
            } else {
                for (AbstractIndexDescriptor index : this.indexes) {
                    this.getInfo().unregisterModifiedIndex(index);
                }
                this.state = Task.State.FINISHED_SUCCESSFULLY;
            }
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
    }

    protected ArrayList<String> getCommandLineArguments() {
        return new ArrayList<String>();
    }

    protected ArrayList<String> getCommandLineArguments(String baseDN) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--baseDN");
        args.add(baseDN);
        if (this.rebuildAll()) {
            args.add("--rebuildAll");
        } else {
            for (AbstractIndexDescriptor index : this.indexes) {
                args.add("--index");
                if (index instanceof VLVIndexDescriptor) {
                    args.add(Utilities.getVLVNameInCommandLine((VLVIndexDescriptor)index));
                    continue;
                }
                args.add(index.getName());
            }
        }
        boolean isLocal = this.getInfo().getServerDescriptor().isLocal();
        if (isLocal && this.isServerRunning()) {
            args.addAll(this.getConnectionCommandLineArguments());
            args.addAll(this.getConfigCommandLineArguments());
        }
        return args;
    }

    @Override
    protected String getCommandLinePath() {
        return null;
    }

    private boolean rebuildAll() {
        boolean rebuildAll = true;
        HashSet<BackendDescriptor> backends = new HashSet<BackendDescriptor>();
        for (AbstractIndexDescriptor index : this.indexes) {
            backends.add(index.getBackend());
        }
        block1: for (BackendDescriptor backend : backends) {
            HashSet<AbstractIndexDescriptor> allIndexes = new HashSet<AbstractIndexDescriptor>();
            allIndexes.addAll(backend.getIndexes());
            allIndexes.addAll(backend.getVLVIndexes());
            for (AbstractIndexDescriptor index : allIndexes) {
                if (this.ignoreIndex(index)) continue;
                boolean found = false;
                for (AbstractIndexDescriptor indexToRebuild : this.indexes) {
                    if (!indexToRebuild.equals(index)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                rebuildAll = false;
                continue block1;
            }
        }
        return rebuildAll;
    }

    private boolean ignoreIndex(AbstractIndexDescriptor index) {
        boolean ignoreIndex = false;
        if (index instanceof IndexDescriptor) {
            for (String name : INDEXES_NOT_TO_SPECIFY) {
                if (!name.equalsIgnoreCase(index.getName())) continue;
                ignoreIndex = true;
                break;
            }
        }
        return ignoreIndex;
    }
}

