/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.opends.guitools.controlpanel.browser.NodeRefresher;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.EntryReadErrorEvent;
import org.opends.guitools.controlpanel.task.DeleteEntryTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.AbstractBrowseEntriesPanel;
import org.opends.guitools.controlpanel.ui.AddToGroupPanel;
import org.opends.guitools.controlpanel.ui.DeleteBackendPanel;
import org.opends.guitools.controlpanel.ui.DeleteBaseDNPanel;
import org.opends.guitools.controlpanel.ui.DuplicateEntryPanel;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.GenericFrame;
import org.opends.guitools.controlpanel.ui.GenericMenuBar;
import org.opends.guitools.controlpanel.ui.LDAPEntryPanel;
import org.opends.guitools.controlpanel.ui.NewDomainPanel;
import org.opends.guitools.controlpanel.ui.NewEntryFromLDIFPanel;
import org.opends.guitools.controlpanel.ui.NewGroupPanel;
import org.opends.guitools.controlpanel.ui.NewOrganizationPanel;
import org.opends.guitools.controlpanel.ui.NewOrganizationalUnitPanel;
import org.opends.guitools.controlpanel.ui.NewUserPanel;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.ResetUserPasswordPanel;
import org.opends.guitools.controlpanel.ui.components.CustomTree;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.ui.nodes.BrowserNodeInfo;
import org.opends.guitools.controlpanel.ui.nodes.DndBrowserNodes;
import org.opends.guitools.controlpanel.util.LDAPEntryReader;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.Schema;

public class BrowseEntriesPanel
extends AbstractBrowseEntriesPanel {
    private static final long serialVersionUID = 1308129251140541645L;
    private BrowseMenuBar menuBar;
    private JPopupMenu popup;
    private JMenuItem popupDeleteMenuItem;
    private JMenuItem popupCopyDNMenuItem;
    private JMenuItem popupAddToGroupMenuItem;
    private JMenuItem popupNewEntryFromLDIFMenuItem;
    private JMenuItem popupNewUserMenuItem;
    private JMenuItem popupNewGroupMenuItem;
    private JMenuItem popupNewOUMenuItem;
    private JMenuItem popupNewOrganizationMenuItem;
    private JMenuItem popupNewDomainMenuItem;
    private JMenuItem popupResetUserPasswordMenuItem;
    private JMenuItem popupDuplicateEntryMenuItem;
    private LDAPEntryPanel entryPane;
    private GenericDialog resetUserPasswordDlg;
    private ResetUserPasswordPanel resetUserPasswordPanel;
    private GenericDialog addToGroupDlg;
    private AddToGroupPanel addToGroupPanel;
    private GenericDialog deleteBaseDNDlg;
    private GenericDialog deleteBackendDlg;
    private GenericDialog newUserDlg;
    private NewUserPanel newUserPanel;
    private GenericDialog newGroupDlg;
    private NewGroupPanel newGroupPanel;
    private GenericDialog newOUDlg;
    private NewOrganizationalUnitPanel newOUPanel;
    private GenericDialog newOrganizationDlg;
    private NewOrganizationPanel newOrganizationPanel;
    private GenericDialog newDomainDlg;
    private NewDomainPanel newDomainPanel;
    private GenericDialog newEntryFromLDIFDlg;
    private NewEntryFromLDIFPanel newEntryFromLDIFPanel;
    private GenericDialog duplicateEntryDlg;
    private DuplicateEntryPanel duplicateEntryPanel;
    private boolean ignoreTreeSelectionEvents = false;
    private LDAPEntryReader entryReader;
    private Thread entryReaderThread;
    private boolean forceRefreshWhenOpening;

    @Override
    public JMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new BrowseMenuBar(this.getInfo());
            this.menuBar.deleteMenuItem.setEnabled(false);
        }
        return this.menuBar;
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_MANAGE_ENTRIES_TITLE.get();
    }

    @Override
    public GenericDialog.ButtonType getBrowseButtonType() {
        return GenericDialog.ButtonType.CLOSE;
    }

    @Override
    protected void createBrowserController(ControlPanelInfo info) {
        super.createBrowserController(info);
        this.entryPane.setController(this.controller);
    }

    @Override
    public void okClicked() {
    }

    @Override
    public void toBeDisplayed(boolean visible) {
        super.toBeDisplayed(visible);
        boolean isAuthenticated = false;
        if (this.getInfo() != null && this.getInfo().getServerDescriptor() != null) {
            isAuthenticated = this.getInfo().getServerDescriptor().isAuthenticated();
        }
        if (visible && !this.isDisposeOnClose() && this.forceRefreshWhenOpening && isAuthenticated) {
            this.refreshClicked();
        }
        if (!visible) {
            this.forceRefreshWhenOpening = isAuthenticated;
        }
    }

    @Override
    protected Component createMainPanel() {
        JSplitPane pane = new JSplitPane(1);
        pane.setOpaque(true);
        JComponent p = this.createTreePane();
        JTree tree = this.treePane.getTree();
        this.addDragAndDropListener(tree);
        this.addTreeSelectionListener(tree);
        JScrollPane treeScroll = Utilities.createScrollPane(p);
        treeScroll.setPreferredSize(new Dimension(treeScroll.getPreferredSize().width + 30, 4 * treeScroll.getPreferredSize().height));
        pane.setDividerLocation(treeScroll.getPreferredSize().width);
        this.entryPane = new LDAPEntryPanel();
        pane.setLeftComponent(treeScroll);
        pane.setRightComponent(this.entryPane);
        pane.setResizeWeight(0.0);
        this.entryPane.setPreferredSize(new Dimension(treeScroll.getPreferredSize().width * 5 / 2, treeScroll.getPreferredSize().height));
        this.entryPane.setBorder(this.getRightPanelBorder());
        this.addPopupMenu();
        return pane;
    }

    private void addTreeSelectionListener(JTree tree) {
        TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent ev) {
                boolean enableResetPassword;
                if (BrowseEntriesPanel.this.ignoreTreeSelectionEvents) {
                    return;
                }
                TreePath path = null;
                TreePath[] paths = BrowseEntriesPanel.this.treePane.getTree().getSelectionPaths();
                if (BrowseEntriesPanel.this.entryPane.mustCheckUnsavedChanges()) {
                    BrowseEntriesPanel.this.ignoreTreeSelectionEvents = true;
                    BrowseEntriesPanel.this.treePane.getTree().setSelectionPath(BrowseEntriesPanel.this.entryPane.getTreePath());
                    switch (BrowseEntriesPanel.this.entryPane.checkUnsavedChanges()) {
                        case DO_NOT_SAVE: {
                            break;
                        }
                        case SAVE: {
                            break;
                        }
                        case CANCEL: {
                            BrowseEntriesPanel.this.ignoreTreeSelectionEvents = false;
                            return;
                        }
                    }
                    if (paths != null) {
                        BrowseEntriesPanel.this.treePane.getTree().setSelectionPaths(paths);
                    } else {
                        BrowseEntriesPanel.this.treePane.getTree().clearSelection();
                    }
                    BrowseEntriesPanel.this.ignoreTreeSelectionEvents = false;
                }
                if (paths != null && paths.length == 1) {
                    path = paths[0];
                }
                boolean enableDelete = false;
                if (paths != null && paths.length > 0) {
                    enableDelete = true;
                    for (TreePath p : paths) {
                        BasicNode n = (BasicNode)p.getLastPathComponent();
                        enableDelete = BrowseEntriesPanel.this.entryPane.canDelete(n.getDN());
                        if (!enableDelete) break;
                    }
                }
                BrowseEntriesPanel.this.popupDeleteMenuItem.setEnabled(enableDelete);
                ((BrowseEntriesPanel)BrowseEntriesPanel.this).menuBar.deleteMenuItem.setEnabled(enableDelete);
                boolean enableCopyDN = path != null;
                BrowseEntriesPanel.this.popupCopyDNMenuItem.setEnabled(enableCopyDN);
                ((BrowseEntriesPanel)BrowseEntriesPanel.this).menuBar.copyDNMenuItem.setEnabled(enableCopyDN);
                boolean enableDuplicateEntry = enableCopyDN;
                BrowseEntriesPanel.this.popupDuplicateEntryMenuItem.setEnabled(enableDuplicateEntry);
                ((BrowseEntriesPanel)BrowseEntriesPanel.this).menuBar.duplicateEntryMenuItem.setEnabled(enableDuplicateEntry);
                boolean enableAddToGroup = enableDelete;
                BrowseEntriesPanel.this.popupAddToGroupMenuItem.setEnabled(enableAddToGroup);
                ((BrowseEntriesPanel)BrowseEntriesPanel.this).menuBar.addToGroupMenuItem.setEnabled(enableAddToGroup);
                boolean bl = enableResetPassword = path != null;
                if (enableResetPassword) {
                    BasicNode node = (BasicNode)path.getLastPathComponent();
                    enableResetPassword = BrowseEntriesPanel.this.hasUserPassword(node.getObjectClassValues());
                }
                BrowseEntriesPanel.this.popupResetUserPasswordMenuItem.setEnabled(enableResetPassword);
                ((BrowseEntriesPanel)BrowseEntriesPanel.this).menuBar.resetPasswordMenuItem.setEnabled(enableResetPassword);
                boolean enableNewEntry = path != null && enableDelete;
                BrowseEntriesPanel.this.popupNewUserMenuItem.setEnabled(enableNewEntry);
                ((BrowseEntriesPanel)BrowseEntriesPanel.this).menuBar.newUserMenuItem.setEnabled(enableNewEntry);
                BrowseEntriesPanel.this.popupNewGroupMenuItem.setEnabled(enableNewEntry);
                ((BrowseEntriesPanel)BrowseEntriesPanel.this).menuBar.newGroupMenuItem.setEnabled(enableNewEntry);
                BrowseEntriesPanel.this.popupNewOUMenuItem.setEnabled(enableNewEntry);
                ((BrowseEntriesPanel)BrowseEntriesPanel.this).menuBar.newOUMenuItem.setEnabled(enableNewEntry);
                BrowseEntriesPanel.this.popupNewOrganizationMenuItem.setEnabled(enableNewEntry);
                ((BrowseEntriesPanel)BrowseEntriesPanel.this).menuBar.newOrganizationMenuItem.setEnabled(enableNewEntry);
                BrowseEntriesPanel.this.popupNewDomainMenuItem.setEnabled(enableNewEntry);
                ((BrowseEntriesPanel)BrowseEntriesPanel.this).menuBar.newDomainMenuItem.setEnabled(enableNewEntry);
                BrowseEntriesPanel.this.updateRightPane(paths);
            }
        };
        tree.getSelectionModel().addTreeSelectionListener(treeSelectionListener);
    }

    private void addDragAndDropListener(JTree tree) {
        final DragSource dragSource = DragSource.getDefaultDragSource();
        final DragSourceListener dragSourceListener = new DragSourceListener(){

            @Override
            public void dragDropEnd(DragSourceDropEvent dsde) {
            }

            @Override
            public void dragEnter(DragSourceDragEvent dsde) {
                DragSourceContext context = dsde.getDragSourceContext();
                int dropAction = dsde.getDropAction();
                if ((dropAction & 1) != 0) {
                    context.setCursor(DragSource.DefaultCopyDrop);
                } else if ((dropAction & 2) != 0) {
                    context.setCursor(DragSource.DefaultMoveDrop);
                } else {
                    context.setCursor(DragSource.DefaultCopyNoDrop);
                }
            }

            @Override
            public void dragOver(DragSourceDragEvent dsde) {
            }

            @Override
            public void dropActionChanged(DragSourceDragEvent dsde) {
            }

            @Override
            public void dragExit(DragSourceEvent dsde) {
            }
        };
        DragGestureListener dragGestureListener = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent e) {
                JTree tree = BrowseEntriesPanel.this.treePane.getTree();
                TreePath[] paths = tree.getSelectionPaths();
                if (paths != null) {
                    BrowserNodeInfo[] nodes = new BrowserNodeInfo[paths.length];
                    DndBrowserNodes dndNodes = new DndBrowserNodes();
                    for (int i = 0; i < paths.length; ++i) {
                        BrowserNodeInfo node;
                        nodes[i] = node = BrowseEntriesPanel.this.controller.getNodeInfoFromPath(paths[i]);
                    }
                    dndNodes.setParent(tree);
                    dndNodes.setNodes(nodes);
                    Cursor cursor = DragSource.DefaultCopyNoDrop;
                    dragSource.startDrag(e, cursor, dndNodes, dragSourceListener);
                }
            }
        };
        dragSource.createDefaultDragGestureRecognizer(tree, 3, dragGestureListener);
    }

    @Override
    public void setInfo(ControlPanelInfo info) {
        super.setInfo(info);
        this.entryPane.setInfo(info);
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        ServerDescriptor desc = ev.getNewDescriptor();
        this.updateMenus(desc);
        super.configurationChanged(ev);
    }

    private boolean hasUserPassword(String[] ocs) {
        boolean hasUserPassword = false;
        Schema schema = this.getInfo().getServerDescriptor().getSchema();
        if (ocs != null && schema != null) {
            AttributeType attr = schema.getAttributeType("userpassword");
            for (String oc : ocs) {
                ObjectClass objectClass = schema.getObjectClass(oc);
                if (objectClass == null || attr == null || !objectClass.isRequiredOrOptional(attr)) continue;
                hasUserPassword = true;
                break;
            }
        }
        return hasUserPassword;
    }

    private void updateMenus(ServerDescriptor desc) {
        this.menuBar.newEntryFromLDIFMenuItem.setEnabled(desc.isAuthenticated());
        this.menuBar.deleteBackendMenuItem.setEnabled(desc.isAuthenticated());
        this.menuBar.deleteBaseDNMenuItem.setEnabled(desc.isAuthenticated());
    }

    private void updateRightPane(TreePath[] paths) {
        TreePath path = null;
        if (paths != null && paths.length == 1) {
            path = paths[0];
        }
        BasicNode node = null;
        if (path != null) {
            node = (BasicNode)path.getLastPathComponent();
        }
        if (node != null) {
            String dn;
            if (this.controller.getFollowReferrals() && node.getReferral() != null && node.getRemoteUrl() == null && node.getError() != null && node.getError().getState() == NodeRefresher.State.SOLVING_REFERRAL) {
                this.entryPane.referralSolveError(node.getDN(), node.getReferral(), node.getError());
                dn = null;
            } else {
                dn = this.controller.getFollowReferrals() && node.getRemoteUrl() != null ? node.getRemoteUrl().getRawBaseDN() : node.getDN();
            }
            if (dn != null) {
                try {
                    InitialLdapContext ctx = this.controller.findConnectionForDisplayedEntry(node);
                    LDAPEntryReader reader = new LDAPEntryReader(dn, ctx);
                    reader.addEntryReadListener(this.entryPane);
                    this.entryPane.setTreePath(path);
                    this.stopCurrentReader();
                    this.startReader(reader);
                }
                catch (Throwable t) {
                    if (!this.isInterruptedException(t)) {
                        EntryReadErrorEvent ev = new EntryReadErrorEvent(this, dn, t);
                        this.entryPane.entryReadError(ev);
                    }
                }
            }
        } else {
            this.stopCurrentReader();
            if (paths != null && paths.length > 1) {
                this.entryPane.multipleEntriesSelected();
            } else {
                this.entryPane.noEntrySelected();
            }
        }
    }

    private void stopCurrentReader() {
        if (this.entryReader != null) {
            this.entryReader.setNotifyListeners(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReader(LDAPEntryReader reader) {
        this.entryReader = reader;
        if (this.entryReaderThread == null || !this.entryReaderThread.isAlive()) {
            this.entryReaderThread = new Thread(new Runnable(){
                LDAPEntryReader reader;
                CustomSearchResult sr;
                Throwable t;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread thread = BrowseEntriesPanel.this.entryReaderThread;
                                synchronized (thread) {
                                    while ((this.reader = BrowseEntriesPanel.this.entryReader) == null) {
                                        BrowseEntriesPanel.this.entryReaderThread.wait();
                                    }
                                }
                                this.sr = null;
                                this.t = null;
                                try {
                                    this.sr = this.reader.processBackgroundTask();
                                }
                                catch (Throwable th) {
                                    this.t = th;
                                }
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        reader.backgroundTaskCompleted(sr, t);
                                        if (reader == BrowseEntriesPanel.this.entryReader) {
                                            BrowseEntriesPanel.this.entryReader = null;
                                        }
                                    }
                                });
                            }
                        }
                        catch (Throwable t) {
                            BrowseEntriesPanel.this.entryReader = null;
                            continue;
                        }
                        break;
                    }
                }
            });
            this.entryReaderThread.start();
        }
        Thread thread = this.entryReaderThread;
        synchronized (thread) {
            this.entryReaderThread.notify();
        }
    }

    private void addPopupMenu() {
        this.popup = new JPopupMenu();
        this.popupNewUserMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_NEW_USER_MENU.get());
        this.popupNewUserMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BrowseEntriesPanel.this.newUser();
            }
        });
        this.popupNewUserMenuItem.setEnabled(false);
        this.popup.add(this.popupNewUserMenuItem);
        this.popupNewGroupMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_NEW_GROUP_MENU.get());
        this.popupNewGroupMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BrowseEntriesPanel.this.newGroup();
            }
        });
        this.popupNewGroupMenuItem.setEnabled(false);
        this.popup.add(this.popupNewGroupMenuItem);
        this.popupNewOUMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_NEW_ORGANIZATIONAL_UNIT_MENU.get());
        this.popupNewOUMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BrowseEntriesPanel.this.newOrganizationalUnit();
            }
        });
        this.popupNewOUMenuItem.setEnabled(false);
        this.popup.add(this.popupNewOUMenuItem);
        this.popupNewOrganizationMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_NEW_ORGANIZATION_MENU.get());
        this.popupNewOrganizationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BrowseEntriesPanel.this.newOrganization();
            }
        });
        this.popupNewOrganizationMenuItem.setEnabled(false);
        this.popup.add(this.popupNewOrganizationMenuItem);
        this.popupNewDomainMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_NEW_DOMAIN_MENU.get());
        this.popupNewDomainMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BrowseEntriesPanel.this.newDomain();
            }
        });
        this.popupNewDomainMenuItem.setEnabled(false);
        this.popup.add(this.popupNewDomainMenuItem);
        this.popupNewEntryFromLDIFMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_NEW_FROM_LDIF_MENU.get());
        this.popupNewEntryFromLDIFMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BrowseEntriesPanel.this.newEntryFromLDIF();
            }
        });
        this.popup.add(this.popupNewEntryFromLDIFMenuItem);
        this.popup.add(new JSeparator());
        this.popupResetUserPasswordMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_RESET_USER_PASSWORD_MENU.get());
        this.popupResetUserPasswordMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BrowseEntriesPanel.this.resetUserPassword();
            }
        });
        this.popup.add(this.popupResetUserPasswordMenuItem);
        this.popupResetUserPasswordMenuItem.setEnabled(false);
        this.popupAddToGroupMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_ADD_TO_GROUP_MENU.get());
        this.popupAddToGroupMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BrowseEntriesPanel.this.addToGroup();
            }
        });
        this.popup.add(this.popupAddToGroupMenuItem);
        this.popupAddToGroupMenuItem.setEnabled(false);
        this.popup.add(new JSeparator());
        this.popupDuplicateEntryMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_DUPLICATE_ENTRY_MENU.get());
        this.popupDuplicateEntryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BrowseEntriesPanel.this.duplicateEntry();
            }
        });
        this.popup.add(this.popupDuplicateEntryMenuItem);
        this.popupCopyDNMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_COPY_DN_MENU.get());
        this.popupCopyDNMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BrowseEntriesPanel.this.copyDN();
            }
        });
        this.popup.add(this.popupCopyDNMenuItem);
        this.popupCopyDNMenuItem.setEnabled(false);
        this.popup.add(new JSeparator());
        this.popupDeleteMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_DELETE_ENTRY_MENU.get());
        this.popupDeleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BrowseEntriesPanel.this.deleteClicked();
            }
        });
        this.popup.add(this.popupDeleteMenuItem);
        this.popupDeleteMenuItem.setEnabled(false);
        this.popup.setOpaque(true);
        ((CustomTree)this.treePane.getTree()).setPopupMenu(this.popup);
    }

    private void resetUserPassword() {
        TreePath[] paths;
        if (this.resetUserPasswordDlg == null) {
            this.resetUserPasswordPanel = new ResetUserPasswordPanel();
            this.resetUserPasswordPanel.setInfo(this.getInfo());
            this.resetUserPasswordDlg = new GenericDialog(Utilities.getFrame(this), this.resetUserPasswordPanel);
            Utilities.centerGoldenMean(this.resetUserPasswordDlg, Utilities.getParentDialog(this));
        }
        if ((paths = this.treePane.getTree().getSelectionPaths()) != null && paths.length == 1) {
            TreePath path = paths[0];
            BasicNode node = (BasicNode)path.getLastPathComponent();
            this.resetUserPasswordPanel.setValue(node, this.controller);
            this.resetUserPasswordDlg.setVisible(true);
        }
    }

    private void deleteBaseDN() {
        if (this.deleteBaseDNDlg == null) {
            DeleteBaseDNPanel panel = new DeleteBaseDNPanel();
            panel.setInfo(this.getInfo());
            this.deleteBaseDNDlg = new GenericDialog(Utilities.getFrame(this), panel);
            Utilities.centerGoldenMean(this.deleteBaseDNDlg, Utilities.getParentDialog(this));
        }
        this.deleteBaseDNDlg.setVisible(true);
    }

    private void deleteBackend() {
        if (this.deleteBackendDlg == null) {
            DeleteBackendPanel panel = new DeleteBackendPanel();
            panel.setInfo(this.getInfo());
            this.deleteBackendDlg = new GenericDialog(Utilities.getFrame(this), panel);
            Utilities.centerGoldenMean(this.deleteBackendDlg, Utilities.getParentDialog(this));
        }
        this.deleteBackendDlg.setVisible(true);
    }

    private void newUser() {
        if (this.newUserDlg == null) {
            this.newUserPanel = new NewUserPanel();
            this.newUserPanel.setInfo(this.getInfo());
            this.newUserDlg = new GenericDialog(Utilities.getFrame(this), this.newUserPanel);
            Utilities.centerGoldenMean(this.newUserDlg, Utilities.getParentDialog(this));
        }
        TreePath[] paths = this.treePane.getTree().getSelectionPaths();
        BasicNode parentNode = null;
        if (paths != null && paths.length == 1) {
            TreePath path = paths[0];
            parentNode = (BasicNode)path.getLastPathComponent();
        }
        this.newUserPanel.setParent(parentNode, this.controller);
        this.newUserDlg.setVisible(true);
    }

    private void newGroup() {
        if (this.newGroupDlg == null) {
            this.newGroupPanel = new NewGroupPanel();
            this.newGroupPanel.setInfo(this.getInfo());
            this.newGroupDlg = new GenericDialog(Utilities.getFrame(this), this.newGroupPanel);
            Utilities.centerGoldenMean(this.newGroupDlg, Utilities.getParentDialog(this));
        }
        TreePath[] paths = this.treePane.getTree().getSelectionPaths();
        BasicNode parentNode = null;
        if (paths != null && paths.length == 1) {
            TreePath path = paths[0];
            parentNode = (BasicNode)path.getLastPathComponent();
        }
        this.newGroupPanel.setParent(parentNode, this.controller);
        this.newGroupDlg.setVisible(true);
    }

    private void newOrganizationalUnit() {
        if (this.newOUDlg == null) {
            this.newOUPanel = new NewOrganizationalUnitPanel();
            this.newOUPanel.setInfo(this.getInfo());
            this.newOUDlg = new GenericDialog(Utilities.getFrame(this), this.newOUPanel);
            Utilities.centerGoldenMean(this.newOUDlg, Utilities.getParentDialog(this));
        }
        TreePath[] paths = this.treePane.getTree().getSelectionPaths();
        BasicNode parentNode = null;
        if (paths != null && paths.length == 1) {
            TreePath path = paths[0];
            parentNode = (BasicNode)path.getLastPathComponent();
        }
        this.newOUPanel.setParent(parentNode, this.controller);
        this.newOUDlg.setVisible(true);
    }

    private void newOrganization() {
        if (this.newOrganizationDlg == null) {
            this.newOrganizationPanel = new NewOrganizationPanel();
            this.newOrganizationPanel.setInfo(this.getInfo());
            this.newOrganizationDlg = new GenericDialog(Utilities.getFrame(this), this.newOrganizationPanel);
            Utilities.centerGoldenMean(this.newOrganizationDlg, Utilities.getParentDialog(this));
        }
        TreePath[] paths = this.treePane.getTree().getSelectionPaths();
        BasicNode parentNode = null;
        if (paths != null && paths.length == 1) {
            TreePath path = paths[0];
            parentNode = (BasicNode)path.getLastPathComponent();
        }
        this.newOrganizationPanel.setParent(parentNode, this.controller);
        this.newOrganizationDlg.setVisible(true);
    }

    private void newDomain() {
        if (this.newDomainDlg == null) {
            this.newDomainPanel = new NewDomainPanel();
            this.newDomainPanel.setInfo(this.getInfo());
            this.newDomainDlg = new GenericDialog(Utilities.getFrame(this), this.newDomainPanel);
            Utilities.centerGoldenMean(this.newDomainDlg, Utilities.getParentDialog(this));
        }
        TreePath[] paths = this.treePane.getTree().getSelectionPaths();
        BasicNode parentNode = null;
        if (paths != null && paths.length == 1) {
            TreePath path = paths[0];
            parentNode = (BasicNode)path.getLastPathComponent();
        }
        this.newDomainPanel.setParent(parentNode, this.controller);
        this.newDomainDlg.setVisible(true);
    }

    private void newEntryFromLDIF() {
        if (this.newEntryFromLDIFDlg == null) {
            this.newEntryFromLDIFPanel = new NewEntryFromLDIFPanel();
            this.newEntryFromLDIFPanel.setInfo(this.getInfo());
            this.newEntryFromLDIFDlg = new GenericDialog(Utilities.getFrame(this), this.newEntryFromLDIFPanel);
            Utilities.centerGoldenMean(this.newEntryFromLDIFDlg, Utilities.getParentDialog(this));
        }
        TreePath[] paths = this.treePane.getTree().getSelectionPaths();
        BasicNode parentNode = null;
        if (paths != null && paths.length == 1) {
            TreePath path = paths[0];
            parentNode = (BasicNode)path.getLastPathComponent();
        }
        this.newEntryFromLDIFPanel.setParent(parentNode, this.controller);
        this.newEntryFromLDIFDlg.setVisible(true);
    }

    private void duplicateEntry() {
        this.duplicateEntryDlg = null;
        if (this.duplicateEntryDlg == null) {
            if (this.duplicateEntryPanel == null) {
                this.duplicateEntryPanel = new DuplicateEntryPanel();
                this.duplicateEntryPanel.setInfo(this.getInfo());
            }
            this.duplicateEntryDlg = new GenericDialog(Utilities.getFrame(this), this.duplicateEntryPanel);
            Utilities.centerGoldenMean(this.duplicateEntryDlg, Utilities.getParentDialog(this));
        }
        TreePath[] paths = this.treePane.getTree().getSelectionPaths();
        BasicNode node = null;
        if (paths != null && paths.length == 1) {
            TreePath path = paths[0];
            node = (BasicNode)path.getLastPathComponent();
        }
        this.duplicateEntryPanel.setEntryToDuplicate(node, this.controller);
        this.duplicateEntryDlg.setVisible(true);
    }

    private void deleteClicked() {
        ArrayList<Message> errors = new ArrayList<Message>();
        TreePath[] paths = this.treePane.getTree().getSelectionPaths();
        if (paths != null && paths.length > 0) {
            ProgressDialog dlg = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_DELETE_SELECTED_ENTRIES_TITLE.get(), this.getInfo());
            DeleteEntryTask newTask = new DeleteEntryTask(this.getInfo(), dlg, paths, this.controller);
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(newTask, errors);
            }
            if (errors.size() == 0 && this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETE_ENTRIES_CONFIRMATION_DETAILS.get())) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_DELETING_ENTRIES_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_ENTRIES_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_ENTRIES_SUCCESSFUL.get(), AdminToolMessages.ERR_CTRL_PANEL_DELETING_ENTRIES_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_DELETING_ENTRIES_ERROR_DETAILS.get(), null, dlg);
                dlg.setVisible(true);
            }
        }
    }

    private void copyDN() {
        ClipboardOwner owner = new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard aClipboard, Transferable aContents) {
            }
        };
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        TreePath[] paths = this.treePane.getTree().getSelectionPaths();
        if (paths != null) {
            StringBuilder sb = new StringBuilder();
            for (TreePath path : paths) {
                BasicNode node = (BasicNode)path.getLastPathComponent();
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(node.getDN());
            }
            StringSelection stringSelection = new StringSelection(sb.toString());
            clipboard.setContents(stringSelection, owner);
        }
    }

    private void addToGroup() {
        TreePath[] paths = this.treePane.getTree().getSelectionPaths();
        if (paths != null) {
            LinkedHashSet<DN> dns = new LinkedHashSet<DN>();
            for (TreePath path : paths) {
                BasicNode node = (BasicNode)path.getLastPathComponent();
                try {
                    dns.add(DN.decode(node.getDN()));
                }
                catch (OpenDsException ode) {
                    throw new RuntimeException("Unexpected error decoding dn. Details: " + ode.getMessageObject(), ode);
                }
            }
            if (this.addToGroupDlg == null) {
                this.addToGroupPanel = new AddToGroupPanel();
                this.addToGroupPanel.setInfo(this.getInfo());
                this.addToGroupDlg = new GenericDialog(Utilities.getFrame(this), this.addToGroupPanel);
                Utilities.centerGoldenMean(this.addToGroupDlg, Utilities.getParentDialog(this));
            }
            this.addToGroupPanel.setEntriesToAdd(dns);
            this.addToGroupDlg.setVisible(true);
        }
    }

    private void newWindow() {
        BrowseEntriesPanel panel = new BrowseEntriesPanel();
        panel.setDisposeOnClose(true);
        panel.setInfo(this.getInfo());
        GenericFrame frame = new GenericFrame(panel);
        Utilities.centerGoldenMean(frame, Utilities.getFrame(this));
        frame.setVisible(true);
    }

    private boolean isInterruptedException(Throwable t) {
        boolean isInterruptedException = false;
        boolean bl = isInterruptedException = t instanceof InterruptedIOException || t instanceof InterruptedNamingException;
        while (t != null && !isInterruptedException) {
            isInterruptedException = (t = t.getCause()) instanceof InterruptedIOException || t instanceof InterruptedNamingException;
        }
        return isInterruptedException;
    }

    private void refreshClicked() {
        TreePath[] paths = this.treePane.getTree().getSelectionPaths();
        if (paths != null && paths.length == 1) {
            if (this.entryPane.mustCheckUnsavedChanges()) {
                switch (this.entryPane.checkUnsavedChanges()) {
                    case DO_NOT_SAVE: {
                        break;
                    }
                    case SAVE: {
                        break;
                    }
                    case CANCEL: {
                        return;
                    }
                }
            }
            this.updateRightPane(paths);
        }
        this.entryPane.getController().startRefresh(null);
    }

    class BrowseMenuBar
    extends GenericMenuBar {
        private static final long serialVersionUID = 505187832236882370L;
        JMenuItem deleteMenuItem;
        JMenuItem copyDNMenuItem;
        JMenuItem addToGroupMenuItem;
        JMenuItem resetPasswordMenuItem;
        JMenuItem newUserMenuItem;
        JMenuItem newGroupMenuItem;
        JMenuItem newOUMenuItem;
        JMenuItem newOrganizationMenuItem;
        JMenuItem newDomainMenuItem;
        JMenuItem newEntryFromLDIFMenuItem;
        JMenuItem duplicateEntryMenuItem;
        JMenuItem deleteBaseDNMenuItem;
        JMenuItem deleteBackendMenuItem;

        public BrowseMenuBar(ControlPanelInfo info) {
            super(info);
            this.add(this.createFileMenuBar());
            this.add(this.createEntriesMenuBar());
            this.add(this.createViewMenuBar());
            this.add(this.createHelpMenuBar());
        }

        private JMenu createFileMenuBar() {
            JMenu menu = Utilities.createMenu(AdminToolMessages.INFO_CTRL_PANEL_FILE_MENU.get(), AdminToolMessages.INFO_CTRL_PANEL_FILE_MENU_DESCRIPTION.get());
            menu.setMnemonic(70);
            JMenuItem newWindow = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_NEW_BROWSER_WINDOW_MENU.get());
            newWindow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    BrowseEntriesPanel.this.newWindow();
                }
            });
            menu.add(newWindow);
            menu.add(new JSeparator());
            JMenuItem close = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_CLOSE_MENU.get());
            close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    BrowseEntriesPanel.this.closeClicked();
                }
            });
            menu.add(close);
            return menu;
        }

        protected JMenu createViewMenuBar() {
            JMenu menu = Utilities.createMenu(AdminToolMessages.INFO_CTRL_PANEL_VIEW_MENU.get(), AdminToolMessages.INFO_CTRL_PANEL_VIEW_MENU_DESCRIPTION.get());
            menu.setMnemonic(86);
            Message[] labels = new Message[]{AdminToolMessages.INFO_CTRL_PANEL_SIMPLIFIED_VIEW_MENU.get(), AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_VIEW_MENU.get(), AdminToolMessages.INFO_CTRL_PANEL_LDIF_VIEW_MENU.get()};
            final LDAPEntryPanel.View[] views = new LDAPEntryPanel.View[]{LDAPEntryPanel.View.SIMPLIFIED_VIEW, LDAPEntryPanel.View.ATTRIBUTE_VIEW, LDAPEntryPanel.View.LDIF_VIEW};
            final JRadioButtonMenuItem[] menus = new JRadioButtonMenuItem[labels.length];
            ButtonGroup group = new ButtonGroup();
            for (int i = 0; i < labels.length; ++i) {
                menus[i] = new JRadioButtonMenuItem(labels[i].toString());
                menu.add(menus[i]);
                group.add(menus[i]);
            }
            ActionListener radioListener = new ActionListener(){
                private boolean ignoreEvents;
                private JRadioButtonMenuItem lastSelected;
                {
                    this.lastSelected = menus[0];
                }

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (this.ignoreEvents) {
                        return;
                    }
                    for (int i = 0; i < menus.length; ++i) {
                        if (!menus[i].isSelected()) continue;
                        this.ignoreEvents = true;
                        this.lastSelected.setSelected(true);
                        if (BrowseEntriesPanel.this.entryPane.mustCheckUnsavedChanges()) {
                            switch (BrowseEntriesPanel.this.entryPane.checkUnsavedChanges()) {
                                case DO_NOT_SAVE: {
                                    break;
                                }
                                case SAVE: {
                                    break;
                                }
                                case CANCEL: {
                                    this.ignoreEvents = false;
                                    return;
                                }
                            }
                        }
                        this.lastSelected = menus[i];
                        menus[i].setSelected(true);
                        BrowseEntriesPanel.this.entryPane.setView(views[i]);
                        this.ignoreEvents = false;
                        break;
                    }
                }
            };
            for (int i = 0; i < labels.length; ++i) {
                menus[i].addActionListener(radioListener);
            }
            menus[0].setSelected(true);
            menu.add(new JSeparator());
            final JCheckBoxMenuItem sortUserData = new JCheckBoxMenuItem(AdminToolMessages.INFO_CTRL_PANEL_SORT_USER_DATA.get().toString());
            final JCheckBoxMenuItem followReferrals = new JCheckBoxMenuItem(AdminToolMessages.INFO_CTRL_PANEL_FOLLOW_REFERRALS.get().toString());
            menu.add(sortUserData);
            menu.add(followReferrals);
            sortUserData.setSelected(BrowseEntriesPanel.this.entryPane.getController().isSorted());
            followReferrals.setSelected(BrowseEntriesPanel.this.entryPane.getController().getFollowReferrals());
            sortUserData.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    try {
                        BrowseEntriesPanel.this.entryPane.getController().setSorted(sortUserData.isSelected());
                    }
                    catch (NamingException ne) {
                        System.err.println("Unexpected error updating sorting.");
                        ne.printStackTrace();
                    }
                }
            });
            followReferrals.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    try {
                        BrowseEntriesPanel.this.entryPane.getController().setFollowReferrals(followReferrals.isSelected());
                    }
                    catch (NamingException ne) {
                        System.err.println("Unexpected error updating referral state.");
                        ne.printStackTrace();
                    }
                }
            });
            menu.add(new JSeparator());
            JMenuItem refresh = new JMenuItem(AdminToolMessages.INFO_CTRL_PANEL_REFRESH_DATA.get().toString());
            menu.add(refresh);
            refresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    BrowseEntriesPanel.this.refreshClicked();
                }
            });
            return menu;
        }

        protected JMenu createEntriesMenuBar() {
            JMenu menu = Utilities.createMenu(AdminToolMessages.INFO_CTRL_PANEL_ENTRIES_MENU.get(), AdminToolMessages.INFO_CTRL_PANEL_ENTRIES_MENU_DESCRIPTION.get());
            menu.setMnemonic(69);
            this.newUserMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_NEW_USER_MENU.get());
            this.newUserMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    BrowseEntriesPanel.this.newUser();
                }
            });
            this.newUserMenuItem.setEnabled(false);
            menu.add(this.newUserMenuItem);
            this.newGroupMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_NEW_GROUP_MENU.get());
            this.newGroupMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    BrowseEntriesPanel.this.newGroup();
                }
            });
            this.newGroupMenuItem.setEnabled(false);
            menu.add(this.newGroupMenuItem);
            this.newOUMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_NEW_ORGANIZATIONAL_UNIT_MENU.get());
            this.newOUMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    BrowseEntriesPanel.this.newOrganizationalUnit();
                }
            });
            this.newOUMenuItem.setEnabled(false);
            menu.add(this.newOUMenuItem);
            this.newOrganizationMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_NEW_ORGANIZATION_MENU.get());
            this.newOrganizationMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    BrowseEntriesPanel.this.newOrganization();
                }
            });
            this.newOrganizationMenuItem.setEnabled(false);
            menu.add(this.newOrganizationMenuItem);
            this.newDomainMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_NEW_DOMAIN_MENU.get());
            this.newDomainMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    BrowseEntriesPanel.this.newDomain();
                }
            });
            this.newDomainMenuItem.setEnabled(false);
            menu.add(this.newDomainMenuItem);
            this.newEntryFromLDIFMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_NEW_FROM_LDIF_MENU.get());
            this.newEntryFromLDIFMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    BrowseEntriesPanel.this.newEntryFromLDIF();
                }
            });
            menu.add(this.newEntryFromLDIFMenuItem);
            menu.add(new JSeparator());
            this.resetPasswordMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_RESET_USER_PASSWORD_MENU.get());
            this.resetPasswordMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    BrowseEntriesPanel.this.resetUserPassword();
                }
            });
            this.resetPasswordMenuItem.setEnabled(false);
            menu.add(this.resetPasswordMenuItem);
            this.addToGroupMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_ADD_TO_GROUP_MENU.get());
            this.addToGroupMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    BrowseEntriesPanel.this.addToGroup();
                }
            });
            this.addToGroupMenuItem.setEnabled(false);
            menu.add(this.addToGroupMenuItem);
            menu.add(new JSeparator());
            this.duplicateEntryMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_DUPLICATE_ENTRY_MENU.get());
            this.duplicateEntryMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    BrowseEntriesPanel.this.duplicateEntry();
                }
            });
            this.duplicateEntryMenuItem.setEnabled(false);
            menu.add(this.duplicateEntryMenuItem);
            this.copyDNMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_COPY_DN_MENU.get());
            this.copyDNMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    BrowseEntriesPanel.this.copyDN();
                }
            });
            this.copyDNMenuItem.setEnabled(false);
            menu.add(this.copyDNMenuItem);
            menu.add(new JSeparator());
            this.deleteMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_DELETE_ENTRY_MENU.get());
            this.deleteMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    BrowseEntriesPanel.this.deleteClicked();
                }
            });
            this.deleteMenuItem.setEnabled(false);
            menu.add(this.deleteMenuItem);
            menu.add(new JSeparator());
            this.deleteBaseDNMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_DELETE_BASE_DN_MENU.get());
            this.deleteBaseDNMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    BrowseEntriesPanel.this.deleteBaseDN();
                }
            });
            this.deleteBaseDNMenuItem.setEnabled(false);
            menu.add(this.deleteBaseDNMenuItem);
            this.deleteBackendMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_DELETE_BACKEND_MENU.get());
            this.deleteBackendMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    BrowseEntriesPanel.this.deleteBackend();
                }
            });
            this.deleteBackendMenuItem.setEnabled(false);
            menu.add(this.deleteBackendMenuItem);
            return menu;
        }
    }
}

