/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.ConfigurationElementCreatedListener;
import org.opends.guitools.controlpanel.event.ScrollPaneBorderListener;
import org.opends.guitools.controlpanel.task.DeleteSchemaElementsTask;
import org.opends.guitools.controlpanel.task.ModifyAttributeTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.NewAttributePanel;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.SchemaElementPanel;
import org.opends.guitools.controlpanel.ui.UnsavedChangesDialog;
import org.opends.guitools.controlpanel.ui.components.BasicExpander;
import org.opends.guitools.controlpanel.ui.components.TitlePanel;
import org.opends.guitools.controlpanel.ui.renderer.SchemaElementComboBoxCellRenderer;
import org.opends.guitools.controlpanel.util.LowerCaseComparator;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeUsage;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Schema;
import org.opends.server.util.StaticUtils;

public class CustomAttributePanel
extends SchemaElementPanel {
    private static final long serialVersionUID = 2850763193735843746L;
    private JButton delete;
    private JButton saveChanges;
    private AttributeType attribute;
    private String attrName;
    private ScrollPaneBorderListener scrollListener;
    private TitlePanel titlePanel = new TitlePanel(Message.EMPTY, Message.EMPTY);
    private JLabel lName = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_NAME_LABEL.get());
    private JLabel lSuperior = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_PARENT_LABEL.get());
    private JLabel lOID = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_OID_LABEL.get());
    private JLabel lAliases = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_ALIASES_LABEL.get());
    private JLabel lOrigin = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_ORIGIN_LABEL.get());
    private JLabel lFile = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_FILE_LABEL.get());
    private JLabel lDescription = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_DESCRIPTION_LABEL.get());
    private JLabel lUsage = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_USAGE_LABEL.get());
    private JLabel lSyntax = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_SYNTAX_LABEL.get());
    private JLabel lApproximate = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_APPROXIMATE_MATCHING_RULE_LABEL.get());
    private JLabel lEquality = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_EQUALITY_MATCHING_RULE_LABEL.get());
    private JLabel lOrdering = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_ORDERING_MATCHING_RULE_LABEL.get());
    private JLabel lSubstring = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_SUBSTRING_MATCHING_RULE_LABEL.get());
    private JLabel lType = Utilities.createPrimaryLabel();
    private JLabel[] labels = new JLabel[]{this.lName, this.lSuperior, this.lOID, this.lAliases, this.lOrigin, this.lFile, this.lDescription, this.lUsage, this.lSyntax, this.lApproximate, this.lEquality, this.lOrdering, this.lSubstring, this.lType};
    private JTextField name = Utilities.createMediumTextField();
    private JComboBox parent = Utilities.createComboBox();
    private JTextField oid = Utilities.createMediumTextField();
    private JTextField aliases = Utilities.createLongTextField();
    private JTextField description = Utilities.createLongTextField();
    private JTextField origin = Utilities.createLongTextField();
    private JTextField file = Utilities.createLongTextField();
    private JComboBox usage = Utilities.createComboBox();
    private JComboBox syntax = Utilities.createComboBox();
    private JComboBox approximate = Utilities.createComboBox();
    private JComboBox equality = Utilities.createComboBox();
    private JComboBox ordering = Utilities.createComboBox();
    private JComboBox substring = Utilities.createComboBox();
    private JCheckBox nonModifiable = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_NON_MODIFIABLE_LABEL.get());
    private JCheckBox singleValued = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_SINGLE_VALUED_LABEL.get());
    private JCheckBox collective = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_COLLECTIVE_LABEL.get());
    private JCheckBox obsolete = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_OBSOLETE_LABEL.get());
    private JList requiredBy = new JList(new DefaultListModel());
    private JList optionalBy = new JList(new DefaultListModel());
    private Set<String> lastAliases = new LinkedHashSet<String>();
    private Message NO_PARENT = AdminToolMessages.INFO_CTRL_PANEL_NO_PARENT_FOR_ATTRIBUTE.get();
    private Message NO_MATCHING_RULE = AdminToolMessages.INFO_CTRL_PANEL_NO_MATCHING_RULE_FOR_ATTRIBUTE.get();
    private Schema schema;
    private boolean ignoreChangeEvents;

    public CustomAttributePanel() {
        this.createLayout();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_CUSTOM_ATTRIBUTE_TITLE.get();
    }

    protected void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        p.setBorder(this.PANEL_BORDER);
        this.createBasicLayout(p, gbc);
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JScrollPane scroll = Utilities.createBorderLessScrollBar(p);
        this.scrollListener = ScrollPaneBorderListener.createBottomBorderListener(scroll);
        this.add((Component)scroll, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.gridwidth = 1;
        this.delete = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_DELETE_ATTRIBUTE_BUTTON.get());
        this.delete.setOpaque(false);
        this.add((Component)this.delete, gbc);
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                CustomAttributePanel.this.deleteAttribute();
            }
        });
        gbc.anchor = 13;
        ++gbc.gridx;
        this.saveChanges = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_SAVE_CHANGES_LABEL.get());
        this.saveChanges.setOpaque(false);
        this.add((Component)this.saveChanges, gbc);
        this.saveChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ArrayList errors = new ArrayList();
                CustomAttributePanel.this.saveChanges(false, errors);
            }
        });
    }

    protected void createBasicLayout(Container c, GridBagConstraints gbc) {
        JCheckBox[] checkBoxes;
        JComboBox[] combos;
        JTextField[] tfs;
        this.requiredBy.setVisibleRowCount(5);
        this.optionalBy.setVisibleRowCount(9);
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        this.addErrorPane(c, gbc);
        ++gbc.gridy;
        gbc.anchor = 17;
        this.titlePanel.setTitle(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_DETAILS.get());
        gbc.fill = 0;
        gbc.insets.top = 5;
        gbc.insets.bottom = 7;
        c.add((Component)this.titlePanel, gbc);
        gbc.insets.bottom = 0;
        gbc.insets.top = 8;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        JComboBox[] comboBoxes = new JComboBox[]{this.parent, this.syntax, this.approximate, this.equality, this.ordering, this.substring};
        Message[] defaultValues = new Message[]{this.NO_PARENT, Message.EMPTY, this.NO_MATCHING_RULE, this.NO_MATCHING_RULE, this.NO_MATCHING_RULE, this.NO_MATCHING_RULE};
        SchemaElementComboBoxCellRenderer renderer = new SchemaElementComboBoxCellRenderer(this.syntax);
        for (int i = 0; i < comboBoxes.length; ++i) {
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(new Object[]{defaultValues[i]});
            comboBoxes[i].setModel(model);
            comboBoxes[i].setRenderer(renderer);
        }
        DefaultComboBoxModel<AttributeUsage> model = new DefaultComboBoxModel<AttributeUsage>();
        for (AttributeUsage us : AttributeUsage.values()) {
            model.addElement(us);
        }
        this.usage.setModel(model);
        this.usage.setSelectedItem((Object)AttributeUsage.USER_APPLICATIONS);
        this.usage.setRenderer(renderer);
        Component[] basicComps = new Component[]{this.name, this.oid, this.description, this.syntax};
        JLabel[] basicLabels = new JLabel[]{this.lName, this.lOID, this.lDescription, this.lSyntax};
        JLabel[] basicInlineHelp = new JLabel[]{null, null, null, Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_SYNTAX_INLINE_HELP.get())};
        this.add(basicLabels, basicComps, basicInlineHelp, c, gbc);
        BasicExpander[] expanders = new BasicExpander[]{new BasicExpander(AdminToolMessages.INFO_CTRL_PANEL_EXTRA_OPTIONS_EXPANDER.get()), new BasicExpander(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_TYPE_OPTIONS_EXPANDER.get()), new BasicExpander(AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULE_OPTIONS_EXPANDER.get())};
        Component[][] comps = new Component[][]{{this.parent, this.aliases, this.origin, this.file}, {this.usage, this.singleValued, this.nonModifiable, this.collective, this.obsolete}, {this.approximate, this.equality, this.ordering, this.substring}};
        JLabel[][] someLabels = new JLabel[][]{{this.lSuperior, this.lAliases, this.lOrigin, this.lFile}, {this.lUsage, this.lType, null, null, null}, {this.lApproximate, this.lEquality, this.lOrdering, this.lSubstring}};
        JLabel[][] inlineHelps = new JLabel[][]{{null, Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_SEPARATED_WITH_COMMAS_HELP.get()), null, Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_SCHEMA_FILE_ATTRIBUTE_HELP.get(File.separator))}, {null, null, null, null, null, null}, {Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULE_APPROXIMATE_HELP.get()), Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULE_EQUALITY_HELP.get()), Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULE_ORDERING_HELP.get()), Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULE_SUBSTRING_HELP.get())}};
        for (int i = 0; i < expanders.length; ++i) {
            gbc.gridwidth = 2;
            gbc.gridx = 0;
            gbc.insets.left = 0;
            c.add((Component)expanders[i], gbc);
            final JPanel p = new JPanel(new GridBagLayout());
            gbc.insets.left = 15;
            ++gbc.gridy;
            c.add((Component)p, gbc);
            ++gbc.gridy;
            p.setOpaque(false);
            GridBagConstraints gbc1 = new GridBagConstraints();
            gbc1.fill = 2;
            gbc1.gridy = 0;
            this.add(someLabels[i], comps[i], inlineHelps[i], p, gbc1);
            final BasicExpander expander = expanders[i];
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    p.setVisible(expander.isSelected());
                }
            };
            expander.addChangeListener(changeListener);
            expander.setSelected(false);
            changeListener.stateChanged(null);
        }
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                if (ev.getStateChange() == 1) {
                    CustomAttributePanel.this.updateDefaultMatchingRuleNames();
                    CustomAttributePanel.this.approximate.setSelectedIndex(0);
                    CustomAttributePanel.this.substring.setSelectedIndex(0);
                    CustomAttributePanel.this.equality.setSelectedIndex(0);
                    CustomAttributePanel.this.ordering.setSelectedIndex(0);
                }
            }
        };
        this.syntax.addItemListener(itemListener);
        Message[] msgs = new Message[]{AdminToolMessages.INFO_CTRL_PANEL_REQUIRED_BY_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_ALLOWED_BY_LABEL.get()};
        JList[] lists = new JList[]{this.requiredBy, this.optionalBy};
        gbc.anchor = 18;
        for (int i = 0; i < msgs.length; ++i) {
            gbc.insets.left = 0;
            gbc.weightx = 0.0;
            gbc.gridx = 0;
            gbc.insets.top = i == 0 ? 15 : 10;
            c.add((Component)Utilities.createPrimaryLabel(msgs[i]), gbc);
            gbc.insets.left = 10;
            gbc.gridx = 1;
            gbc.weighty = i == 0 ? 0.35 : 0.65;
            gbc.weightx = 1.0;
            c.add((Component)Utilities.createScrollPane(lists[i]), gbc);
            ++gbc.gridy;
            final JList list = lists[i];
            MouseAdapter clickListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent ev) {
                    if (ev.getClickCount() == 1) {
                        CustomAttributePanel.this.objectClassSelected(list);
                    }
                }
            };
            list.addMouseListener(clickListener);
            KeyAdapter keyListener = new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent ev) {
                    if (ev.getKeyChar() == ' ' || ev.getKeyChar() == '\n') {
                        CustomAttributePanel.this.objectClassSelected(list);
                    }
                }
            };
            list.addKeyListener(keyListener);
        }
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent ev) {
                CustomAttributePanel.this.checkEnableSaveChanges();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                CustomAttributePanel.this.checkEnableSaveChanges();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                CustomAttributePanel.this.checkEnableSaveChanges();
            }
        };
        for (JTextField tf : tfs = new JTextField[]{this.name, this.description, this.oid, this.aliases, this.origin, this.file}) {
            tf.getDocument().addDocumentListener(docListener);
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                CustomAttributePanel.this.checkEnableSaveChanges();
            }
        };
        for (JComboBox combo : combos = new JComboBox[]{this.parent, this.usage, this.syntax, this.approximate, this.equality, this.ordering, this.substring}) {
            combo.addActionListener(actionListener);
        }
        for (JCheckBox cb : checkBoxes = new JCheckBox[]{this.nonModifiable, this.singleValued, this.collective, this.obsolete}) {
            cb.addActionListener(actionListener);
        }
    }

    @Override
    public boolean mustCheckUnsavedChanges() {
        return this.saveChanges.isEnabled();
    }

    @Override
    public UnsavedChangesDialog.Result checkUnsavedChanges() {
        UnsavedChangesDialog unsavedChangesDlg = new UnsavedChangesDialog((Component)Utilities.getParentDialog(this), this.getInfo());
        unsavedChangesDlg.setMessage(AdminToolMessages.INFO_CTRL_PANEL_UNSAVED_CHANGES_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_UNSAVED_ATTRIBUTE_CHANGES_DETAILS.get(this.attribute.getNameOrOID()));
        Utilities.centerGoldenMean(unsavedChangesDlg, Utilities.getParentDialog(this));
        unsavedChangesDlg.setVisible(true);
        UnsavedChangesDialog.Result result = unsavedChangesDlg.getResult();
        if (result == UnsavedChangesDialog.Result.SAVE) {
            ArrayList<Message> errors = new ArrayList<Message>();
            this.saveChanges(true, errors);
            if (!errors.isEmpty()) {
                result = UnsavedChangesDialog.Result.CANCEL;
            }
        }
        return result;
    }

    @Override
    public boolean requiresScroll() {
        return false;
    }

    public void update(AttributeType attr, Schema schema) {
        this.ignoreChangeEvents = true;
        String n = attr.getPrimaryName();
        if (n == null) {
            n = "";
        }
        this.titlePanel.setDetails(Message.raw(n, new Object[0]));
        this.name.setText(n);
        this.oid.setText(attr.getOID());
        n = attr.getDescription();
        if (n == null) {
            n = "";
        }
        this.description.setText(n);
        this.syntax.setSelectedItem(attr.getSyntax());
        AttributeType superior = attr.getSuperiorType();
        if (superior == null) {
            this.parent.setSelectedItem(this.NO_PARENT);
        } else {
            this.parent.setSelectedItem(superior);
        }
        Set<String> someAliases = this.getAliases(attr);
        this.lastAliases.clear();
        this.lastAliases.addAll(someAliases);
        this.aliases.setText(Utilities.getStringFromCollection(someAliases, ", "));
        String sOrigin = Utilities.getOrigin(attr);
        if (sOrigin == null) {
            sOrigin = "";
        }
        this.origin.setText(sOrigin);
        String sFile = attr.getSchemaFile();
        if (sFile == null) {
            sFile = "";
        }
        this.file.setText(sFile);
        this.usage.setSelectedItem((Object)attr.getUsage());
        this.singleValued.setSelected(attr.isSingleValue());
        this.nonModifiable.setSelected(attr.isNoUserModification());
        this.collective.setSelected(attr.isCollective());
        this.obsolete.setSelected(attr.isObsolete());
        JComboBox[] matchingRules = new JComboBox[]{this.approximate, this.equality, this.ordering, this.substring};
        MatchingRule[] rules = new MatchingRule[]{attr.getApproximateMatchingRule(), attr.getEqualityMatchingRule(), attr.getOrderingMatchingRule(), attr.getSubstringMatchingRule()};
        for (int i = 0; i < matchingRules.length; ++i) {
            if (rules[i] != null) {
                matchingRules[i].setSelectedItem(rules[i]);
                continue;
            }
            matchingRules[i].setSelectedItem(this.NO_MATCHING_RULE);
        }
        LowerCaseComparator lowerCaseComparator = new LowerCaseComparator();
        TreeSet<String> requiredByOcs = new TreeSet<String>(lowerCaseComparator);
        for (ObjectClass oc : schema.getObjectClasses().values()) {
            if (!oc.getRequiredAttributeChain().contains(attr)) continue;
            requiredByOcs.add(oc.getNameOrOID());
        }
        DefaultListModel model = (DefaultListModel)this.requiredBy.getModel();
        model.clear();
        for (String oc : requiredByOcs) {
            model.addElement(oc);
        }
        TreeSet<String> optionalByOcs = new TreeSet<String>(lowerCaseComparator);
        for (ObjectClass objectClass : schema.getObjectClasses().values()) {
            if (!objectClass.getOptionalAttributeChain().contains(attr)) continue;
            optionalByOcs.add(objectClass.getNameOrOID());
        }
        model = (DefaultListModel)this.optionalBy.getModel();
        model.clear();
        for (String string : optionalByOcs) {
            model.addElement(string);
        }
        this.attribute = attr;
        this.attrName = attr.getNameOrOID();
        this.scrollListener.updateBorder();
        for (JLabel label : this.labels) {
            this.setPrimaryValid(label);
        }
        this.saveChanges.setEnabled(false);
        this.ignoreChangeEvents = false;
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        ArrayList newSyntaxes = new ArrayList();
        final ServerDescriptor desc = ev.getNewDescriptor();
        Schema s = desc.getSchema();
        boolean schemaChanged = this.schema != null && s != null ? !ServerDescriptor.areSchemasEqual(s, this.schema) : (this.schema == null && s != null ? true : (s == null && this.schema != null ? false : false));
        if (schemaChanged) {
            this.schema = s;
            HashMap syntaxNameMap = new HashMap();
            for (String key : this.schema.getSyntaxes().keySet()) {
                AttributeSyntax<?> syntax = this.schema.getSyntax(key);
                String name = syntax.getSyntaxName();
                if (name == null) {
                    name = syntax.getOID();
                }
                syntaxNameMap.put(name, syntax);
            }
            TreeSet<String> orderedKeys = new TreeSet<String>(new LowerCaseComparator());
            orderedKeys.addAll(syntaxNameMap.keySet());
            for (String key : orderedKeys) {
                newSyntaxes.add(syntaxNameMap.get(key));
            }
            this.updateComboBoxModel(newSyntaxes, (DefaultComboBoxModel)this.syntax.getModel());
            HashMap<String, AttributeType> attributeNameMap = new HashMap<String, AttributeType>();
            for (String key : this.schema.getAttributeTypes().keySet()) {
                AttributeType attr = this.schema.getAttributeType(key);
                attributeNameMap.put(attr.getNameOrOID(), attr);
            }
            orderedKeys.clear();
            orderedKeys.addAll(attributeNameMap.keySet());
            ArrayList<Object> newParents = new ArrayList<Object>();
            for (String key : orderedKeys) {
                newParents.add(attributeNameMap.get(key));
            }
            newParents.add(0, this.NO_PARENT);
            this.updateComboBoxModel(newParents, (DefaultComboBoxModel)this.parent.getModel());
            ArrayList<MatchingRule> approximateElements = new ArrayList<MatchingRule>();
            ArrayList<MatchingRule> equalityElements = new ArrayList<MatchingRule>();
            ArrayList<MatchingRule> orderingElements = new ArrayList<MatchingRule>();
            ArrayList<MatchingRule> substringElements = new ArrayList<MatchingRule>();
            HashMap<String, MatchingRule> matchingRuleNameMap = new HashMap<String, MatchingRule>();
            for (String key : this.schema.getMatchingRules().keySet()) {
                MatchingRule rule = this.schema.getMatchingRule(key);
                matchingRuleNameMap.put(rule.getNameOrOID(), rule);
            }
            orderedKeys.clear();
            orderedKeys.addAll(matchingRuleNameMap.keySet());
            for (String key : orderedKeys) {
                MatchingRule matchingRule = (MatchingRule)matchingRuleNameMap.get(key);
                if (matchingRule instanceof ApproximateMatchingRule) {
                    approximateElements.add(matchingRule);
                    continue;
                }
                if (matchingRule instanceof EqualityMatchingRule) {
                    equalityElements.add(matchingRule);
                    continue;
                }
                if (matchingRule instanceof OrderingMatchingRule) {
                    orderingElements.add(matchingRule);
                    continue;
                }
                if (!(matchingRule instanceof SubstringMatchingRule)) continue;
                substringElements.add(matchingRule);
            }
            JComboBox[] combos = new JComboBox[]{this.approximate, this.equality, this.ordering, this.substring};
            ArrayList<ArrayList<MatchingRule>> ruleNames = new ArrayList<ArrayList<MatchingRule>>();
            ruleNames.add(approximateElements);
            ruleNames.add(equalityElements);
            ruleNames.add(orderingElements);
            ruleNames.add(substringElements);
            for (int i = 0; i < combos.length; ++i) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)combos[i].getModel();
                ArrayList<Message> el = new ArrayList<Message>();
                el.addAll((Collection)ruleNames.get(i));
                if (model.getSize() == 0) {
                    el.add(0, this.NO_MATCHING_RULE);
                } else {
                    el.add(0, (Message)model.getElementAt(0));
                }
                this.updateComboBoxModel(el, model);
            }
        } else if (this.schema == null) {
            this.updateErrorPane(this.errorPane, AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_SUMMARY.get(), ColorAndFontConstants.errorTitleFont, AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_DETAILS.get(), ColorAndFontConstants.defaultFont);
        }
        if (this.schema != null) {
            this.updateErrorPaneIfAuthRequired(desc, this.isLocal() ? AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_FOR_ATTRIBUTE_DELETE.get() : AdminToolMessages.INFO_CTRL_PANEL_CANNOT_CONNECT_TO_REMOTE_DETAILS.get(desc.getHostname()));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CustomAttributePanel.this.delete.setEnabled(!CustomAttributePanel.this.authenticationRequired(desc) && CustomAttributePanel.this.delete.isEnabled() && CustomAttributePanel.this.schema != null);
                CustomAttributePanel.this.checkEnableSaveChanges();
                CustomAttributePanel.this.saveChanges.setEnabled(CustomAttributePanel.this.saveChanges.isEnabled() && !CustomAttributePanel.this.authenticationRequired(desc) && CustomAttributePanel.this.schema != null);
            }
        });
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.name;
    }

    @Override
    public void okClicked() {
    }

    private void deleteAttribute() {
        ArrayList<Message> errors = new ArrayList<Message>();
        Schema schema = this.getInfo().getServerDescriptor().getSchema();
        ProgressDialog dlg = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_DELETE_ATTRIBUTE_TITLE.get(), this.getInfo());
        LinkedHashSet<AttributeType> attrsToDelete = new LinkedHashSet<AttributeType>(1);
        attrsToDelete.add(this.attribute);
        DeleteSchemaElementsTask newTask = new DeleteSchemaElementsTask(this.getInfo(), dlg, new LinkedHashSet<ObjectClass>(0), attrsToDelete);
        for (Task task : this.getInfo().getTasks()) {
            task.canLaunch(newTask, errors);
        }
        TreeSet<String> childAttributes = new TreeSet<String>();
        TreeSet<String> dependentClasses = new TreeSet<String>();
        if (schema != null) {
            for (AttributeType attr : schema.getAttributeTypes().values()) {
                if (!this.attribute.equals(attr.getSuperiorType())) continue;
                childAttributes.add(attr.getNameOrOID());
            }
            for (ObjectClass o : schema.getObjectClasses().values()) {
                if (o.getRequiredAttributeChain().contains(this.attribute)) {
                    dependentClasses.add(o.getNameOrOID());
                    continue;
                }
                if (!o.getOptionalAttributeChain().contains(this.attribute)) continue;
                dependentClasses.add(o.getNameOrOID());
            }
        } else {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_DETAILS.get());
        }
        if (errors.isEmpty()) {
            MessageBuilder mb = new MessageBuilder();
            if (!childAttributes.isEmpty()) {
                mb.append(AdminToolMessages.INFO_ATTRIBUTE_IS_SUPERIOR.get(this.attrName, Utilities.getStringFromCollection(childAttributes, ", ")));
                mb.append("<br>");
            }
            if (!dependentClasses.isEmpty()) {
                mb.append(AdminToolMessages.INFO_ATTRIBUTE_WITH_DEPENDENCIES.get(this.attrName, Utilities.getStringFromCollection(dependentClasses, ", ")));
                mb.append("<br>");
            }
            Message confirmationMessage = AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_DELETE_ATTRIBUTE_DETAILS.get(this.attribute.getNameOrOID());
            mb.append(confirmationMessage);
            if (this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), mb.toMessage())) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_DELETING_ATTRIBUTE_SUMMARY.get(this.attrName), AdminToolMessages.INFO_CTRL_PANEL_DELETING_ATTRIBUTE_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_ATTRIBUTE_SUCCESSFUL.get(this.attrName), AdminToolMessages.ERR_CTRL_PANEL_DELETING_ATTRIBUTE_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_DELETING_ATTRIBUTE_ERROR_DETAILS.get(this.attrName), null, dlg);
                dlg.setVisible(true);
            }
        } else {
            this.displayErrorDialog(errors);
        }
    }

    private void saveChanges(boolean modal, ArrayList<Message> errors) {
        AttributeType superior;
        Set<String> oldAliases;
        ArrayList<String> someAliases;
        for (JLabel label : this.labels) {
            this.setPrimaryValid(label);
        }
        String n = this.getAttributeName();
        MessageBuilder err = new MessageBuilder();
        if (n.length() == 0) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_ATTRIBUTE_NAME_REQUIRED.get());
            this.setPrimaryInvalid(this.lName);
        } else if (!n.equalsIgnoreCase(this.attribute.getNameOrOID())) {
            if (!StaticUtils.isValidSchemaElement(n, 0, n.length(), err)) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_ATTRIBUTE_NAME.get(err.toString()));
                this.setPrimaryInvalid(this.lName);
                err = new MessageBuilder();
            } else {
                Message elementType = NewAttributePanel.getSchemaElementType(n, this.schema);
                if (elementType != null) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_ATTRIBUTE_NAME_ALREADY_IN_USE.get(n, elementType.toString()));
                    this.setPrimaryInvalid(this.lName);
                }
            }
        }
        n = this.oid.getText().trim();
        if (n.length() > 0 && !n.equalsIgnoreCase(this.attribute.getOID())) {
            if (!StaticUtils.isValidSchemaElement(n, 0, n.length(), err)) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_OID_NOT_VALID.get(err.toString()));
                this.setPrimaryInvalid(this.lOID);
                err = new MessageBuilder();
            } else {
                Message elementType = NewAttributePanel.getSchemaElementType(n, this.schema);
                if (elementType != null) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_OID_ALREADY_IN_USE.get(n, elementType.toString()));
                    this.setPrimaryInvalid(this.lOID);
                }
            }
        }
        if (!((Object)(someAliases = this.getAliases())).equals(oldAliases = this.getAliases(this.attribute))) {
            for (String alias : someAliases) {
                Message elementType;
                if (alias.trim().length() == 0) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_EMPTY_ALIAS.get());
                    this.setPrimaryInvalid(this.lAliases);
                    continue;
                }
                boolean notPreviouslyDefined = true;
                for (String oldAlias : oldAliases) {
                    if (!oldAlias.equalsIgnoreCase(alias)) continue;
                    notPreviouslyDefined = false;
                    break;
                }
                if (!notPreviouslyDefined || (elementType = NewAttributePanel.getSchemaElementType(alias, this.schema)) == null) continue;
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_ALIAS_ALREADY_IN_USE.get(n, elementType.toString()));
                this.setPrimaryInvalid(this.lAliases);
            }
        }
        if ((superior = this.getSuperior()) != null) {
            if (superior.getNameOrOID().equalsIgnoreCase(this.attribute.getNameOrOID())) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_ATTRIBUTE_CANNOT_BE_ITS_SUPERIOR.get());
                this.setPrimaryInvalid(this.lSuperior);
            } else {
                for (superior = superior.getSuperiorType(); superior != null; superior = superior.getSuperiorType()) {
                    if (!superior.getNameOrOID().equalsIgnoreCase(this.attribute.getNameOrOID())) continue;
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_ATTRIBUTE_IS_SUPERIOR_OF_SUPERIOR.get(this.getSuperior().getNameOrOID()));
                    this.setPrimaryInvalid(this.lSuperior);
                    break;
                }
            }
        }
        this.setPrimaryValid(this.lUsage);
        if (this.nonModifiable.isSelected() && AttributeUsage.USER_APPLICATIONS.equals(this.usage.getSelectedItem())) {
            errors.add(AdminToolMessages.ERR_NON_MODIFIABLE_CANNOT_BE_USER_APPLICATIONS.get());
            this.setPrimaryInvalid(this.lUsage);
        }
        if (errors.isEmpty()) {
            ProgressDialog dlg = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_MODIFY_ATTRIBUTE_TITLE.get(), this.getInfo());
            ModifyAttributeTask newTask = new ModifyAttributeTask(this.getInfo(), dlg, this.attribute, this.getNewAttribute());
            for (ConfigurationElementCreatedListener listener : this.getConfigurationElementCreatedListeners()) {
                newTask.addConfigurationElementCreatedListener(listener);
            }
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(newTask, errors);
            }
            if (errors.isEmpty()) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_ATTRIBUTE_SUMMARY.get(this.attrName), AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_ATTRIBUTE_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_ATTRIBUTE_SUCCESSFUL.get(this.attrName), AdminToolMessages.ERR_CTRL_PANEL_MODIFYING_ATTRIBUTE_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_MODIFYING_ATTRIBUTE_ERROR_DETAILS.get(this.attrName), null, dlg);
                dlg.setVisible(true);
            }
        }
        if (!errors.isEmpty()) {
            this.displayErrorDialog(errors);
        }
    }

    private void checkEnableSaveChanges() {
        boolean changed;
        if (this.ignoreChangeEvents) {
            return;
        }
        if (this.attribute != null) {
            try {
                changed = !this.attribute.toString().equals(this.getNewAttribute().toString());
            }
            catch (Throwable t) {
                changed = true;
            }
        } else {
            changed = false;
        }
        this.saveChanges.setEnabled(changed);
    }

    private String getAttributeName() {
        return this.name.getText().trim();
    }

    private String getOID() {
        String o = this.oid.getText().trim();
        if (o.length() == 0) {
            o = this.getAttributeName() + "-oid";
        }
        return o;
    }

    private ArrayList<String> getAliases() {
        ArrayList<String> al = new ArrayList<String>();
        String s = this.aliases.getText().trim();
        if (s.length() > 0) {
            String[] a;
            for (String alias : a = s.split(",")) {
                al.add(alias.trim());
            }
        }
        return al;
    }

    private ArrayList<String> getAllNames() {
        ArrayList<String> al = new ArrayList<String>();
        al.add(this.getAttributeName());
        al.addAll(this.getAliases());
        return al;
    }

    private AttributeType getSuperior() {
        Object o = this.parent.getSelectedItem();
        if (this.NO_PARENT.equals(o)) {
            return null;
        }
        return (AttributeType)o;
    }

    private ApproximateMatchingRule getApproximateMatchingRule() {
        if (this.approximate.getSelectedIndex() == 0) {
            return null;
        }
        return (ApproximateMatchingRule)this.approximate.getSelectedItem();
    }

    private EqualityMatchingRule getEqualityMatchingRule() {
        if (this.equality.getSelectedIndex() == 0) {
            return null;
        }
        return (EqualityMatchingRule)this.equality.getSelectedItem();
    }

    private SubstringMatchingRule getSubstringMatchingRule() {
        if (this.substring.getSelectedIndex() == 0) {
            return null;
        }
        return (SubstringMatchingRule)this.substring.getSelectedItem();
    }

    private OrderingMatchingRule getOrderingMatchingRule() {
        if (this.ordering.getSelectedIndex() == 0) {
            return null;
        }
        return (OrderingMatchingRule)this.ordering.getSelectedItem();
    }

    private Map<String, List<String>> getExtraProperties() {
        String or;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        String f = this.file.getText().trim();
        if (f.length() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(f);
            map.put("X-SCHEMA-FILE", list);
        }
        if ((or = this.origin.getText().trim()).length() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(or);
            map.put("X-ORIGIN", list);
        }
        return map;
    }

    private String getDescription() {
        return this.description.getText().trim();
    }

    private AttributeType getNewAttribute() {
        AttributeType attr = new AttributeType("", this.getAttributeName(), this.getAllNames(), this.getOID(), this.getDescription(), this.getSuperior(), (AttributeSyntax)this.syntax.getSelectedItem(), this.getApproximateMatchingRule(), this.getEqualityMatchingRule(), this.getOrderingMatchingRule(), this.getSubstringMatchingRule(), (AttributeUsage)((Object)this.usage.getSelectedItem()), this.collective.isSelected(), this.nonModifiable.isSelected(), this.obsolete.isSelected(), this.singleValued.isSelected(), this.getExtraProperties());
        return attr;
    }

    private void updateDefaultMatchingRuleNames() {
        AttributeSyntax syn = (AttributeSyntax)this.syntax.getSelectedItem();
        if (syn != null) {
            MatchingRule[] rules = new MatchingRule[]{syn.getApproximateMatchingRule(), syn.getSubstringMatchingRule(), syn.getEqualityMatchingRule(), syn.getOrderingMatchingRule()};
            JComboBox[] combos = new JComboBox[]{this.approximate, this.substring, this.equality, this.ordering};
            for (int i = 0; i < rules.length; ++i) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)combos[i].getModel();
                int index = combos[i].getSelectedIndex();
                if (rules[i] != null) {
                    if (model.getSize() > 0) {
                        model.removeElementAt(0);
                    }
                    model.insertElementAt(AdminToolMessages.INFO_CTRL_PANEL_DEFAULT_DEFINED_IN_SYNTAX.get(rules[i].getNameOrOID()), 0);
                } else {
                    if (model.getSize() > 0) {
                        model.removeElementAt(0);
                    }
                    model.insertElementAt(this.NO_MATCHING_RULE, 0);
                }
                combos[i].setSelectedIndex(index);
            }
        }
    }
}

