/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import org.opends.guitools.controlpanel.datamodel.BasicMonitoringAttributes;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.MonitoringAttributes;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.ui.GeneralMonitoringPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;

public class EntryCachesMonitoringPanel
extends GeneralMonitoringPanel {
    private static final long serialVersionUID = 9031734563700069830L;
    static List<MonitoringAttributes> ngOperations = new ArrayList<MonitoringAttributes>();
    private ArrayList<JLabel> monitoringLabels;
    private ArrayList<JLabel> labels;

    public EntryCachesMonitoringPanel() {
        int i;
        ngOperations.add(BasicMonitoringAttributes.ENTRY_CACHE_TRIES);
        ngOperations.add(BasicMonitoringAttributes.ENTRY_CACHE_HITS);
        ngOperations.add(BasicMonitoringAttributes.ENTRY_CACHE_HIT_RATIO);
        ngOperations.add(BasicMonitoringAttributes.CURRENT_ENTRY_CACHE_SIZE);
        ngOperations.add(BasicMonitoringAttributes.MAX_ENTRY_CACHE_SIZE);
        ngOperations.add(BasicMonitoringAttributes.CURRENT_ENTRY_CACHE_COUNT);
        ngOperations.add(BasicMonitoringAttributes.MAX_ENTRY_CACHE_COUNT);
        this.monitoringLabels = new ArrayList();
        for (i = 0; i < ngOperations.size(); ++i) {
            this.monitoringLabels.add(Utilities.createDefaultLabel());
        }
        this.labels = new ArrayList();
        for (i = 0; i < ngOperations.size(); ++i) {
            this.labels.add(Utilities.createPrimaryLabel(EntryCachesMonitoringPanel.getLabel(ngOperations.get(i))));
        }
        this.createLayout();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.monitoringLabels.get(0);
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel lTitle = Utilities.createTitleLabel(AdminToolMessages.INFO_CTRL_PANEL_ENTRY_CACHES.get());
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets.top = 5;
        gbc.insets.bottom = 7;
        this.add((Component)lTitle, gbc);
        gbc.insets.bottom = 0;
        gbc.insets.top = 10;
        ++gbc.gridy;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        for (int i = 0; i < ngOperations.size(); ++i) {
            ++gbc.gridy;
            gbc.insets.left = 0;
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            gbc.gridwidth = 1;
            this.add((Component)this.labels.get(i), gbc);
            gbc.insets.left = 10;
            gbc.gridx = 1;
            gbc.gridwidth = 2;
            this.add((Component)this.monitoringLabels.get(i), gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 3;
        this.add(Box.createGlue(), gbc);
        this.setBorder(this.PANEL_BORDER);
    }

    public void updateContents() {
        ServerDescriptor server = null;
        if (this.getInfo() != null) {
            server = this.getInfo().getServerDescriptor();
        }
        CustomSearchResult csr = null;
        if (server != null) {
            csr = server.getEntryCachesMonitor();
        }
        if (csr != null) {
            this.updateMonitoringInfo(ngOperations, this.monitoringLabels, csr);
            int index = 0;
            for (MonitoringAttributes attr : ngOperations) {
                if (Utilities.getFirstMonitoringValue(csr, attr.getAttributeName()) == null) {
                    this.monitoringLabels.get(index).setVisible(false);
                    this.labels.get(index).setVisible(false);
                }
                ++index;
            }
            this.revalidate();
            this.repaint();
        } else {
            for (JLabel l : this.monitoringLabels) {
                l.setText(NO_VALUE_SET.toString());
            }
        }
    }
}

