/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.JPanel;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.IndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVIndexDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.IndexSelectionListener;
import org.opends.guitools.controlpanel.ui.BackendIndexesPanel;
import org.opends.guitools.controlpanel.ui.BackendVLVIndexesPanel;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.IndexPanel;
import org.opends.guitools.controlpanel.ui.NoItemSelectedPanel;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.UnsavedChangesDialog;
import org.opends.guitools.controlpanel.ui.VLVIndexPanel;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public class IndexBrowserRightPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = -6904674789074101772L;
    private JPanel mainPanel;
    private IndexPanel standardIndexPanel = new IndexPanel();
    private VLVIndexPanel vlvIndexPanel = new VLVIndexPanel();
    private BackendIndexesPanel backendIndexesPanel = new BackendIndexesPanel();
    private BackendVLVIndexesPanel backendVLVIndexesPanel = new BackendVLVIndexesPanel();
    private static final String NOTHING_SELECTED = "Nothing Selected";
    private static final String MULTIPLE_SELECTED = "Multiple Selected";

    public IndexBrowserRightPanel() {
        this.createLayout();
    }

    public void displayVoid() {
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, NOTHING_SELECTED);
    }

    public void displayMultiple() {
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, MULTIPLE_SELECTED);
    }

    public void addIndexSelectionListener(IndexSelectionListener listener) {
        this.backendIndexesPanel.addIndexSelectionListener(listener);
        this.backendVLVIndexesPanel.addIndexSelectionListener(listener);
    }

    public void removeIndexSelectionListener(IndexSelectionListener listener) {
        this.backendIndexesPanel.removeIndexSelectionListener(listener);
        this.backendVLVIndexesPanel.removeIndexSelectionListener(listener);
    }

    @Override
    public void setInfo(ControlPanelInfo info) {
        super.setInfo(info);
        this.standardIndexPanel.setInfo(info);
        this.vlvIndexPanel.setInfo(info);
        this.backendIndexesPanel.setInfo(info);
        this.backendVLVIndexesPanel.setInfo(info);
    }

    public void updateStandardIndex(IndexDescriptor index) {
        this.standardIndexPanel.update(index);
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.standardIndexPanel.getTitle().toString());
    }

    public void updateVLVIndex(VLVIndexDescriptor index) {
        this.vlvIndexPanel.update(index);
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.vlvIndexPanel.getTitle().toString());
    }

    public void updateBackendIndexes(String backendName) {
        this.backendIndexesPanel.update(backendName);
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.backendIndexesPanel.getTitle().toString());
    }

    public void updateBackendVLVIndexes(String backendName) {
        this.backendVLVIndexesPanel.update(backendName);
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.backendVLVIndexesPanel.getTitle().toString());
    }

    private void createLayout() {
        StatusGenericPanel[] panels;
        GridBagConstraints gbc = new GridBagConstraints();
        CardLayout cardLayout = new CardLayout();
        this.mainPanel = new JPanel(cardLayout);
        this.mainPanel.setOpaque(false);
        NoItemSelectedPanel noEntryPanel = new NoItemSelectedPanel();
        this.mainPanel.add((Component)noEntryPanel, NOTHING_SELECTED);
        NoItemSelectedPanel multipleEntryPanel = new NoItemSelectedPanel();
        multipleEntryPanel.setMessage(AdminToolMessages.INFO_CTRL_PANEL_MULTIPLE_ITEMS_SELECTED_LABEL.get());
        this.mainPanel.add((Component)multipleEntryPanel, MULTIPLE_SELECTED);
        for (StatusGenericPanel panel : panels = new StatusGenericPanel[]{this.standardIndexPanel, this.backendIndexesPanel, this.backendVLVIndexesPanel, this.vlvIndexPanel}) {
            this.mainPanel.add((Component)panel, panel.getTitle().toString());
        }
        cardLayout.show(this.mainPanel, NOTHING_SELECTED);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.mainPanel, gbc);
    }

    @Override
    public void okClicked() {
    }

    @Override
    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.NO_BUTTON;
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_INDEX_BROWSER_RIGHT_PANEL_TITLE.get();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return null;
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    public boolean mustCheckUnsavedChanges() {
        boolean mustCheckUnsavedChanges = this.vlvIndexPanel.isVisible() ? this.vlvIndexPanel.mustCheckUnsavedChanges() : (this.standardIndexPanel.isVisible() ? this.standardIndexPanel.mustCheckUnsavedChanges() : false);
        return mustCheckUnsavedChanges;
    }

    public UnsavedChangesDialog.Result checkUnsavedChanges() {
        UnsavedChangesDialog.Result result = this.vlvIndexPanel.isVisible() ? this.vlvIndexPanel.checkUnsavedChanges() : (this.standardIndexPanel.isVisible() ? this.standardIndexPanel.checkUnsavedChanges() : UnsavedChangesDialog.Result.DO_NOT_SAVE);
        return result;
    }
}

