/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.ConfigurationElementCreatedListener;
import org.opends.guitools.controlpanel.task.NewSchemaElementsTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.components.BasicExpander;
import org.opends.guitools.controlpanel.ui.renderer.SchemaElementComboBoxCellRenderer;
import org.opends.guitools.controlpanel.util.LowerCaseComparator;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeUsage;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Schema;
import org.opends.server.util.StaticUtils;

public class NewAttributePanel
extends StatusGenericPanel {
    private static final long serialVersionUID = 2340170241535771321L;
    private JLabel lName = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_NAME_LABEL.get());
    private JLabel lParent = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_PARENT_LABEL.get());
    private JLabel lOID = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_OID_LABEL.get());
    private JLabel lAliases = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_ALIASES_LABEL.get());
    private JLabel lOrigin = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_ORIGIN_LABEL.get());
    private JLabel lFile = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_FILE_LABEL.get());
    private JLabel lDescription = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_DESCRIPTION_LABEL.get());
    private JLabel lUsage = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_USAGE_LABEL.get());
    private JLabel lSyntax = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_SYNTAX_LABEL.get());
    private JLabel lApproximate = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_APPROXIMATE_MATCHING_RULE_LABEL.get());
    private JLabel lEquality = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_EQUALITY_MATCHING_RULE_LABEL.get());
    private JLabel lOrdering = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_ORDERING_MATCHING_RULE_LABEL.get());
    private JLabel lSubstring = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_SUBSTRING_MATCHING_RULE_LABEL.get());
    private JLabel lType = Utilities.createPrimaryLabel();
    private JLabel[] labels = new JLabel[]{this.lName, this.lParent, this.lOID, this.lAliases, this.lOrigin, this.lFile, this.lDescription, this.lUsage, this.lSyntax, this.lApproximate, this.lEquality, this.lOrdering, this.lSubstring, this.lType};
    private JTextField name = Utilities.createMediumTextField();
    private JComboBox parent = Utilities.createComboBox();
    private JTextField oid = Utilities.createMediumTextField();
    private JTextField aliases = Utilities.createLongTextField();
    private JTextField description = Utilities.createLongTextField();
    private JTextField origin = Utilities.createLongTextField();
    private JTextField file = Utilities.createLongTextField();
    private JComboBox usage = Utilities.createComboBox();
    private JComboBox syntax = Utilities.createComboBox();
    private JComboBox approximate = Utilities.createComboBox();
    private JComboBox equality = Utilities.createComboBox();
    private JComboBox ordering = Utilities.createComboBox();
    private JComboBox substring = Utilities.createComboBox();
    private JCheckBox nonModifiable = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_NON_MODIFIABLE_LABEL.get());
    private JCheckBox singleValued = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_SINGLE_VALUED_LABEL.get());
    private JCheckBox collective = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_COLLECTIVE_LABEL.get());
    private JCheckBox obsolete = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_OBSOLETE_LABEL.get());
    private Schema schema;
    private Component relativeComponent;
    private Message NO_PARENT = AdminToolMessages.INFO_CTRL_PANEL_NO_PARENT_FOR_ATTRIBUTE.get();
    private Message NO_MATCHING_RULE = AdminToolMessages.INFO_CTRL_PANEL_NO_MATCHING_RULE_FOR_ATTRIBUTE.get();

    public NewAttributePanel(Component relativeComponent) {
        this.relativeComponent = relativeComponent;
        this.createLayout();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_ATTRIBUTE_PANEL_TITLE.get();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.name;
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        ArrayList newSyntaxes = new ArrayList();
        ServerDescriptor desc = ev.getNewDescriptor();
        Schema s = desc.getSchema();
        final boolean firstSchema = this.schema == null;
        final boolean[] repack = new boolean[]{firstSchema};
        final boolean[] error = new boolean[]{false};
        boolean schemaChanged = this.schema != null && s != null ? !ServerDescriptor.areSchemasEqual(s, this.schema) : (this.schema == null && s != null ? true : (s == null && this.schema != null ? false : false));
        if (schemaChanged) {
            this.schema = s;
            HashMap syntaxNameMap = new HashMap();
            for (String key : this.schema.getSyntaxes().keySet()) {
                AttributeSyntax<?> syntax = this.schema.getSyntax(key);
                String name = syntax.getSyntaxName();
                if (name == null) {
                    name = syntax.getOID();
                }
                syntaxNameMap.put(name, syntax);
            }
            TreeSet<String> orderedKeys = new TreeSet<String>(new LowerCaseComparator());
            orderedKeys.addAll(syntaxNameMap.keySet());
            for (String key : orderedKeys) {
                newSyntaxes.add(syntaxNameMap.get(key));
            }
            this.updateComboBoxModel(newSyntaxes, (DefaultComboBoxModel)this.syntax.getModel());
            HashMap<String, AttributeType> attributeNameMap = new HashMap<String, AttributeType>();
            for (String key : this.schema.getAttributeTypes().keySet()) {
                AttributeType attr = this.schema.getAttributeType(key);
                attributeNameMap.put(attr.getNameOrOID(), attr);
            }
            orderedKeys.clear();
            orderedKeys.addAll(attributeNameMap.keySet());
            ArrayList<Object> newParents = new ArrayList<Object>();
            for (String key : orderedKeys) {
                newParents.add(attributeNameMap.get(key));
            }
            newParents.add(0, this.NO_PARENT);
            this.updateComboBoxModel(newParents, (DefaultComboBoxModel)this.parent.getModel());
            ArrayList<MatchingRule> approximateElements = new ArrayList<MatchingRule>();
            ArrayList<MatchingRule> equalityElements = new ArrayList<MatchingRule>();
            ArrayList<MatchingRule> orderingElements = new ArrayList<MatchingRule>();
            ArrayList<MatchingRule> substringElements = new ArrayList<MatchingRule>();
            HashMap<String, MatchingRule> matchingRuleNameMap = new HashMap<String, MatchingRule>();
            for (String key : this.schema.getMatchingRules().keySet()) {
                MatchingRule rule = this.schema.getMatchingRule(key);
                matchingRuleNameMap.put(rule.getNameOrOID(), rule);
            }
            orderedKeys.clear();
            orderedKeys.addAll(matchingRuleNameMap.keySet());
            for (String key : orderedKeys) {
                MatchingRule matchingRule = (MatchingRule)matchingRuleNameMap.get(key);
                if (matchingRule instanceof ApproximateMatchingRule) {
                    approximateElements.add(matchingRule);
                    continue;
                }
                if (matchingRule instanceof EqualityMatchingRule) {
                    equalityElements.add(matchingRule);
                    continue;
                }
                if (matchingRule instanceof OrderingMatchingRule) {
                    orderingElements.add(matchingRule);
                    continue;
                }
                if (!(matchingRule instanceof SubstringMatchingRule)) continue;
                substringElements.add(matchingRule);
            }
            JComboBox[] combos = new JComboBox[]{this.approximate, this.equality, this.ordering, this.substring};
            ArrayList<ArrayList<MatchingRule>> ruleNames = new ArrayList<ArrayList<MatchingRule>>();
            ruleNames.add(approximateElements);
            ruleNames.add(equalityElements);
            ruleNames.add(orderingElements);
            ruleNames.add(substringElements);
            for (int i = 0; i < combos.length; ++i) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)combos[i].getModel();
                ArrayList<Message> el = new ArrayList<Message>();
                el.addAll((Collection)ruleNames.get(i));
                if (model.getSize() == 0) {
                    el.add(0, this.NO_MATCHING_RULE);
                } else {
                    el.add(0, (Message)model.getElementAt(0));
                }
                this.updateComboBoxModel(el, model);
            }
        } else if (this.schema == null) {
            this.updateErrorPane(this.errorPane, AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_SUMMARY.get(), ColorAndFontConstants.errorTitleFont, AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_DETAILS.get(), ColorAndFontConstants.defaultFont);
            repack[0] = true;
            error[0] = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewAttributePanel.this.setEnabledOK(!error[0]);
                NewAttributePanel.this.errorPane.setVisible(error[0]);
                if (firstSchema) {
                    for (int i = 0; i < NewAttributePanel.this.syntax.getModel().getSize(); ++i) {
                        AttributeSyntax syn = (AttributeSyntax)NewAttributePanel.this.syntax.getModel().getElementAt(i);
                        if (!"DirectoryString".equals(syn.getSyntaxName())) continue;
                        NewAttributePanel.this.syntax.setSelectedIndex(i);
                        break;
                    }
                } else {
                    NewAttributePanel.this.updateDefaultMatchingRuleNames();
                }
                if (repack[0]) {
                    NewAttributePanel.this.packParentDialog();
                    if (NewAttributePanel.this.relativeComponent != null) {
                        Utilities.centerGoldenMean(Utilities.getParentDialog(NewAttributePanel.this), NewAttributePanel.this.relativeComponent);
                    }
                }
            }
        });
        if (!error[0]) {
            this.updateErrorPaneAndOKButtonIfAuthRequired(desc, this.isLocal() ? AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_TO_CREATE_ATTRIBUTE_SUMMARY.get() : AdminToolMessages.INFO_CTRL_PANEL_CANNOT_CONNECT_TO_REMOTE_DETAILS.get(desc.getHostname()));
        }
    }

    @Override
    public void okClicked() {
        String[] al;
        ArrayList<Message> errors = new ArrayList<Message>();
        for (JLabel label : this.labels) {
            this.setPrimaryValid(label);
        }
        String n = this.getAttributeName();
        MessageBuilder err = new MessageBuilder();
        if (n.length() == 0) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_ATTRIBUTE_NAME_REQUIRED.get());
            this.setPrimaryInvalid(this.lName);
        } else if (!StaticUtils.isValidSchemaElement(n, 0, n.length(), err)) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_ATTRIBUTE_NAME.get(err.toString()));
            this.setPrimaryInvalid(this.lName);
            err = new MessageBuilder();
        } else {
            Message elementType = NewAttributePanel.getSchemaElementType(n, this.schema);
            if (elementType != null) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_ATTRIBUTE_NAME_ALREADY_IN_USE.get(n, elementType.toString()));
                this.setPrimaryInvalid(this.lName);
            }
        }
        n = this.oid.getText().trim();
        if (n.length() > 0) {
            if (!StaticUtils.isValidSchemaElement(n, 0, n.length(), err)) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_OID_NOT_VALID.get(err.toString()));
                this.setPrimaryInvalid(this.lOID);
                err = new MessageBuilder();
            } else {
                Message elementType = NewAttributePanel.getSchemaElementType(n, this.schema);
                if (elementType != null) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_OID_ALREADY_IN_USE.get(n, elementType.toString()));
                    this.setPrimaryInvalid(this.lOID);
                }
            }
        }
        if (this.aliases.getText().trim().length() > 0 && (al = this.aliases.getText().split(",")).length > 0) {
            for (String alias : al) {
                if (alias.trim().length() == 0) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_EMPTY_ALIAS.get());
                    this.setPrimaryInvalid(this.lAliases);
                    continue;
                }
                Message elementType = NewAttributePanel.getSchemaElementType(alias, this.schema);
                if (elementType == null) continue;
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_ALIAS_ALREADY_IN_USE.get(n, elementType.toString()));
                this.setPrimaryInvalid(this.lAliases);
            }
        }
        this.setPrimaryValid(this.lUsage);
        if (this.nonModifiable.isSelected() && AttributeUsage.USER_APPLICATIONS.equals(this.usage.getSelectedItem())) {
            errors.add(AdminToolMessages.ERR_NON_MODIFIABLE_CANNOT_BE_USER_APPLICATIONS.get());
            this.setPrimaryInvalid(this.lUsage);
        }
        ProgressDialog dlg = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_NEW_ATTRIBUTE_PANEL_TITLE.get(), this.getInfo());
        NewSchemaElementsTask newTask = null;
        if (errors.size() == 0) {
            LinkedHashSet<AttributeType> attributes = new LinkedHashSet<AttributeType>();
            attributes.add(this.getAttribute());
            LinkedHashSet<ObjectClass> ocs = new LinkedHashSet<ObjectClass>(0);
            newTask = new NewSchemaElementsTask(this.getInfo(), dlg, ocs, attributes);
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(newTask, errors);
            }
            for (ConfigurationElementCreatedListener listener : this.getConfigurationElementCreatedListeners()) {
                newTask.addConfigurationElementCreatedListener(listener);
            }
        }
        if (errors.size() == 0) {
            String attrName = this.getAttributeName();
            this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_CREATING_ATTRIBUTE_SUMMARY.get(attrName), AdminToolMessages.INFO_CTRL_PANEL_CREATING_ATTRIBUTE_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_CREATING_ATTRIBUTE_SUCCESSFUL.get(attrName), AdminToolMessages.ERR_CTRL_PANEL_CREATING_ATTRIBUTE_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_CREATING_ATTRIBUTE_ERROR_DETAILS.get(attrName), null, dlg);
            dlg.setVisible(true);
            this.name.setText("");
            this.oid.setText("");
            this.description.setText("");
            this.aliases.setText("");
            this.name.grabFocus();
            Utilities.getParentDialog(this).setVisible(false);
        } else {
            this.displayErrorDialog(errors);
        }
    }

    static Message getSchemaElementType(String name, Schema schema) {
        String n;
        if (schema.getAttributeType(name.toLowerCase()) != null) {
            return AdminToolMessages.INFO_CTRL_PANEL_TYPE_ATTRIBUTE.get();
        }
        if (schema.getObjectClass(name.toLowerCase()) != null) {
            return AdminToolMessages.INFO_CTRL_PANEL_TYPE_OBJECT_CLASS.get();
        }
        if (schema.getSyntax(name.toLowerCase()) != null) {
            return AdminToolMessages.INFO_CTRL_PANEL_TYPE_ATTRIBUTE_SYNTAX.get();
        }
        if (schema.getMatchingRule(name.toLowerCase()) != null) {
            return AdminToolMessages.INFO_CTRL_PANEL_TYPE_MATCHING_RULE.get();
        }
        for (AttributeSyntax<?> attr : schema.getSyntaxes().values()) {
            n = attr.getSyntaxName();
            if (n == null || !n.equalsIgnoreCase(name)) continue;
            return AdminToolMessages.INFO_CTRL_PANEL_TYPE_ATTRIBUTE_SYNTAX.get();
        }
        for (MatchingRule rule : schema.getMatchingRules().values()) {
            n = rule.getName();
            if (n == null || !n.equalsIgnoreCase(name)) continue;
            return AdminToolMessages.INFO_CTRL_PANEL_TYPE_MATCHING_RULE.get();
        }
        return null;
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        Utilities.setRequiredIcon(this.lName);
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        this.addErrorPane(gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weighty = 0.0;
        gbc.gridx = 1;
        gbc.anchor = 13;
        gbc.fill = 0;
        JLabel requiredLabel = this.createRequiredLabel();
        gbc.insets.bottom = 10;
        this.add((Component)requiredLabel, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets.bottom = 0;
        JComboBox[] comboBoxes = new JComboBox[]{this.parent, this.syntax, this.approximate, this.equality, this.ordering, this.substring};
        Message[] defaultValues = new Message[]{this.NO_PARENT, Message.EMPTY, this.NO_MATCHING_RULE, this.NO_MATCHING_RULE, this.NO_MATCHING_RULE, this.NO_MATCHING_RULE};
        SchemaElementComboBoxCellRenderer renderer = new SchemaElementComboBoxCellRenderer(this.syntax);
        for (int i = 0; i < comboBoxes.length; ++i) {
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(new Object[]{defaultValues[i]});
            comboBoxes[i].setModel(model);
            comboBoxes[i].setRenderer(renderer);
        }
        DefaultComboBoxModel<AttributeUsage> model = new DefaultComboBoxModel<AttributeUsage>();
        for (AttributeUsage us : AttributeUsage.values()) {
            model.addElement(us);
        }
        this.usage.setModel(model);
        this.usage.setSelectedItem((Object)AttributeUsage.USER_APPLICATIONS);
        this.usage.setRenderer(renderer);
        Component[] basicComps = new Component[]{this.name, this.oid, this.description, this.syntax};
        JLabel[] basicLabels = new JLabel[]{this.lName, this.lOID, this.lDescription, this.lSyntax};
        JLabel[] basicInlineHelp = new JLabel[]{null, null, null, Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_SYNTAX_INLINE_HELP.get())};
        this.add(basicLabels, basicComps, basicInlineHelp, this, gbc);
        BasicExpander[] expanders = new BasicExpander[]{new BasicExpander(AdminToolMessages.INFO_CTRL_PANEL_EXTRA_OPTIONS_EXPANDER.get()), new BasicExpander(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_TYPE_OPTIONS_EXPANDER.get()), new BasicExpander(AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULE_OPTIONS_EXPANDER.get())};
        Component[][] comps = new Component[][]{{this.parent, this.aliases, this.origin, this.file}, {this.usage, this.singleValued, this.nonModifiable, this.collective, this.obsolete}, {this.approximate, this.equality, this.ordering, this.substring}};
        JLabel[][] labels = new JLabel[][]{{this.lParent, this.lAliases, this.lOrigin, this.lFile}, {this.lUsage, this.lType, null, null, null}, {this.lApproximate, this.lEquality, this.lOrdering, this.lSubstring}};
        JLabel[][] inlineHelps = new JLabel[][]{{null, Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_SEPARATED_WITH_COMMAS_HELP.get()), null, Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_SCHEMA_FILE_ATTRIBUTE_HELP.get(File.separator))}, {null, null, null, null, null, null}, {Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULE_APPROXIMATE_HELP.get()), Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULE_EQUALITY_HELP.get()), Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULE_ORDERING_HELP.get()), Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULE_SUBSTRING_HELP.get())}};
        for (int i = 0; i < expanders.length; ++i) {
            gbc.gridwidth = 2;
            gbc.gridx = 0;
            gbc.insets.left = 0;
            this.add((Component)expanders[i], gbc);
            final JPanel p = new JPanel(new GridBagLayout());
            gbc.insets.left = 15;
            ++gbc.gridy;
            this.add((Component)p, gbc);
            ++gbc.gridy;
            p.setOpaque(false);
            GridBagConstraints gbc1 = new GridBagConstraints();
            gbc1.fill = 2;
            gbc1.gridy = 0;
            this.add(labels[i], comps[i], inlineHelps[i], p, gbc1);
            final BasicExpander expander = expanders[i];
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    p.setVisible(expander.isSelected());
                }
            };
            expander.addChangeListener(changeListener);
            expander.setSelected(false);
            changeListener.stateChanged(null);
        }
        this.addBottomGlue(gbc);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                if (ev.getStateChange() == 1) {
                    NewAttributePanel.this.updateDefaultMatchingRuleNames();
                    NewAttributePanel.this.approximate.setSelectedIndex(0);
                    NewAttributePanel.this.substring.setSelectedIndex(0);
                    NewAttributePanel.this.equality.setSelectedIndex(0);
                    NewAttributePanel.this.ordering.setSelectedIndex(0);
                }
            }
        };
        this.syntax.addItemListener(itemListener);
        this.file.setText("99-user.ldif");
    }

    private void updateDefaultMatchingRuleNames() {
        AttributeSyntax syn = (AttributeSyntax)this.syntax.getSelectedItem();
        if (syn != null) {
            MatchingRule[] rules = new MatchingRule[]{syn.getApproximateMatchingRule(), syn.getSubstringMatchingRule(), syn.getEqualityMatchingRule(), syn.getOrderingMatchingRule()};
            JComboBox[] combos = new JComboBox[]{this.approximate, this.substring, this.equality, this.ordering};
            for (int i = 0; i < rules.length; ++i) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)combos[i].getModel();
                int index = combos[i].getSelectedIndex();
                if (rules[i] != null) {
                    if (model.getSize() > 0) {
                        model.removeElementAt(0);
                    }
                    model.insertElementAt(AdminToolMessages.INFO_CTRL_PANEL_DEFAULT_DEFINED_IN_SYNTAX.get(rules[i].getNameOrOID()), 0);
                } else {
                    if (model.getSize() > 0) {
                        model.removeElementAt(0);
                    }
                    model.insertElementAt(this.NO_MATCHING_RULE, 0);
                }
                combos[i].setSelectedIndex(index);
            }
        }
    }

    private String getAttributeName() {
        return this.name.getText().trim();
    }

    private String getOID() {
        String o = this.oid.getText().trim();
        if (o.length() == 0) {
            o = this.getAttributeName() + "-oid";
        }
        return o;
    }

    private ArrayList<String> getAliases() {
        ArrayList<String> al = new ArrayList<String>();
        String s = this.aliases.getText().trim();
        if (s.length() > 0) {
            String[] a;
            for (String alias : a = s.split(",")) {
                al.add(alias.trim());
            }
        }
        return al;
    }

    private ArrayList<String> getAllNames() {
        ArrayList<String> al = new ArrayList<String>();
        al.add(this.getAttributeName());
        al.addAll(this.getAliases());
        return al;
    }

    private AttributeType getSuperior() {
        Object o = this.parent.getSelectedItem();
        if (this.NO_PARENT.equals(o)) {
            return null;
        }
        return (AttributeType)o;
    }

    private ApproximateMatchingRule getApproximateMatchingRule() {
        if (this.approximate.getSelectedIndex() == 0) {
            return null;
        }
        return (ApproximateMatchingRule)this.approximate.getSelectedItem();
    }

    private EqualityMatchingRule getEqualityMatchingRule() {
        if (this.equality.getSelectedIndex() == 0) {
            return null;
        }
        return (EqualityMatchingRule)this.equality.getSelectedItem();
    }

    private SubstringMatchingRule getSubstringMatchingRule() {
        if (this.substring.getSelectedIndex() == 0) {
            return null;
        }
        return (SubstringMatchingRule)this.substring.getSelectedItem();
    }

    private OrderingMatchingRule getOrderingMatchingRule() {
        if (this.ordering.getSelectedIndex() == 0) {
            return null;
        }
        return (OrderingMatchingRule)this.ordering.getSelectedItem();
    }

    private Map<String, List<String>> getExtraProperties() {
        String or;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        String f = this.file.getText().trim();
        if (f.length() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(f);
            map.put("X-SCHEMA-FILE", list);
        }
        if ((or = this.origin.getText().trim()).length() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(or);
            map.put("X-ORIGIN", list);
        }
        return map;
    }

    private String getDescription() {
        return this.description.getText().trim();
    }

    private AttributeType getAttribute() {
        AttributeType attr = new AttributeType("", this.getAttributeName(), this.getAllNames(), this.getOID(), this.getDescription(), this.getSuperior(), (AttributeSyntax)this.syntax.getSelectedItem(), this.getApproximateMatchingRule(), this.getEqualityMatchingRule(), this.getOrderingMatchingRule(), this.getSubstringMatchingRule(), (AttributeUsage)((Object)this.usage.getSelectedItem()), this.collective.isSelected(), this.nonModifiable.isSelected(), this.obsolete.isSelected(), this.singleValued.isSelected(), this.getExtraProperties());
        return attr;
    }
}

