/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.ui.AbstractNewEntryPanel;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.util.LDIFException;

public class NewEntryFromLDIFPanel
extends AbstractNewEntryPanel {
    private static final long serialVersionUID = -3923907357481784964L;
    private JTextArea ldif;
    private JButton checkSyntax;
    private JLabel lSyntaxCorrect;

    public NewEntryFromLDIFPanel() {
        this.createLayout();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.ldif;
    }

    @Override
    public boolean requiresScroll() {
        return false;
    }

    @Override
    public void setParent(BasicNode parentNode, BrowserController controller) {
        super.setParent(parentNode, controller);
        StringBuilder sb = new StringBuilder();
        String emptyDn = "dn: ";
        sb.append("dn: ");
        if (parentNode != null) {
            sb.append("," + parentNode.getDN());
        }
        sb.append("\nobjectClass: top");
        this.ldif.setText(sb.toString());
        this.ldif.setCaretPosition("dn: ".length());
    }

    @Override
    protected Message getProgressDialogTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_ENTRY_FROM_LDIF_TITLE.get();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_ENTRY_FROM_LDIF_TITLE.get();
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridy = 0;
        this.addErrorPane(gbc);
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.insets.left = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        JLabel label = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_LDIF_SYNTAX_LABEL.get());
        this.add((Component)label, gbc);
        this.lSyntaxCorrect = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_SYNTAX_CORRECT_LABEL.get());
        this.lSyntaxCorrect.setIcon(Utilities.createImageIcon("org/opends/quicksetup/images/info_small.gif"));
        this.ldif = Utilities.createTextArea(Message.EMPTY, 20, 50);
        this.ldif.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent ev) {
                NewEntryFromLDIFPanel.this.lSyntaxCorrect.setVisible(false);
            }

            @Override
            public void changedUpdate(DocumentEvent ev) {
                this.removeUpdate(ev);
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                this.removeUpdate(ev);
            }
        });
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JScrollPane scroll = Utilities.createScrollPane(this.ldif);
        ++gbc.gridy;
        gbc.insets.top = 5;
        gbc.fill = 1;
        this.add((Component)scroll, gbc);
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.checkSyntax = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_CHECK_SYNTAX_BUTTON.get());
        this.checkSyntax.setOpaque(false);
        this.checkSyntax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ArrayList<Message> errors = new ArrayList<Message>();
                NewEntryFromLDIFPanel.this.checkSyntax(errors);
                if (errors.size() > 0) {
                    NewEntryFromLDIFPanel.this.displayErrorDialog(errors);
                } else {
                    NewEntryFromLDIFPanel.this.lSyntaxCorrect.setVisible(true);
                }
            }
        });
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.gridx = 0;
        this.add((Component)this.lSyntaxCorrect, gbc);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 1;
        this.add(Box.createHorizontalGlue(), gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        gbc.gridx = 2;
        this.add((Component)this.checkSyntax, gbc);
    }

    @Override
    public void toBeDisplayed(boolean visible) {
        this.lSyntaxCorrect.setVisible(false);
    }

    @Override
    protected void checkSyntax(ArrayList<Message> errors) {
        try {
            this.getEntry();
        }
        catch (IOException ioe) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_ERROR_CHECKING_ENTRY.get(ioe.toString()));
        }
        catch (LDIFException le) {
            errors.add(le.getMessageObject());
        }
    }

    @Override
    protected String getLDIF() {
        return this.ldif.getText();
    }
}

