/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.ConfigurationElementCreatedListener;
import org.opends.guitools.controlpanel.event.SuperiorObjectClassesChangedEvent;
import org.opends.guitools.controlpanel.event.SuperiorObjectClassesChangedListener;
import org.opends.guitools.controlpanel.task.NewSchemaElementsTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.NewAttributePanel;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.components.BasicExpander;
import org.opends.guitools.controlpanel.ui.components.DoubleAddRemovePanel;
import org.opends.guitools.controlpanel.ui.components.SuperiorObjectClassesEditor;
import org.opends.guitools.controlpanel.ui.renderer.SchemaElementComboBoxCellRenderer;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ObjectClassType;
import org.opends.server.types.Schema;
import org.opends.server.util.StaticUtils;

public class NewObjectClassPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = -4956885827963184571L;
    private JLabel lName = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_NAME_LABEL.get());
    private JLabel lSuperior = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_PARENT_LABEL.get());
    private JLabel lOID = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_OID_LABEL.get());
    private JLabel lAliases = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_ALIASES_LABEL.get());
    private JLabel lOrigin = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_ORIGIN_LABEL.get());
    private JLabel lFile = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_FILE_LABEL.get());
    private JTextField aliases = Utilities.createLongTextField();
    private JLabel lDescription = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_DESCRIPTION_LABEL.get());
    private JLabel lType = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_TYPE_LABEL.get());
    private JLabel lAttributes = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_ATTRIBUTES_LABEL.get());
    private Set<AttributeType> inheritedOptionalAttributes = new HashSet<AttributeType>();
    private Set<AttributeType> inheritedRequiredAttributes = new HashSet<AttributeType>();
    private JLabel[] labels = new JLabel[]{this.lName, this.lSuperior, this.lOID, this.lAliases, this.lOrigin, this.lFile, this.lDescription, this.lType, this.lAttributes};
    private JTextField name = Utilities.createMediumTextField();
    private SuperiorObjectClassesEditor superiors = new SuperiorObjectClassesEditor();
    private JComboBox type = Utilities.createComboBox();
    private JTextField oid = Utilities.createMediumTextField();
    private JTextField description = Utilities.createLongTextField();
    private JTextField origin = Utilities.createLongTextField();
    private JTextField file = Utilities.createLongTextField();
    private JCheckBox obsolete = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_OBSOLETE_LABEL.get());
    private DoubleAddRemovePanel<AttributeType> attributes;
    private Schema schema;
    private Component relativeComponent;

    public NewObjectClassPanel(Component relativeComponent) {
        this.relativeComponent = relativeComponent;
        this.createLayout();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_OBJECTCLASS_PANEL_TITLE.get();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.name;
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        ServerDescriptor desc = ev.getNewDescriptor();
        Schema s = desc.getSchema();
        final boolean[] repack = new boolean[]{this.schema == null};
        final boolean[] error = new boolean[]{false};
        final boolean schemaChanged = this.schema != null && s != null ? !ServerDescriptor.areSchemasEqual(s, this.schema) : (this.schema == null && s != null ? true : (s == null && this.schema != null ? false : false));
        if (schemaChanged) {
            this.schema = s;
        } else if (this.schema == null) {
            this.updateErrorPane(this.errorPane, AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_SUMMARY.get(), ColorAndFontConstants.errorTitleFont, AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_DETAILS.get(), ColorAndFontConstants.defaultFont);
            repack[0] = true;
            error[0] = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewObjectClassPanel.this.setEnabledOK(!error[0]);
                NewObjectClassPanel.this.errorPane.setVisible(error[0]);
                if (NewObjectClassPanel.this.schema != null && schemaChanged) {
                    NewObjectClassPanel.this.superiors.setSchema(NewObjectClassPanel.this.schema);
                    NewObjectClassPanel.this.updateAttributes();
                }
                if (repack[0]) {
                    NewObjectClassPanel.this.packParentDialog();
                    if (NewObjectClassPanel.this.relativeComponent != null) {
                        Utilities.centerGoldenMean(Utilities.getParentDialog(NewObjectClassPanel.this), NewObjectClassPanel.this.relativeComponent);
                    }
                }
            }
        });
        if (!error[0]) {
            this.updateErrorPaneAndOKButtonIfAuthRequired(desc, this.isLocal() ? AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_TO_CREATE_OBJECTCLASS_SUMMARY.get() : AdminToolMessages.INFO_CTRL_PANEL_CANNOT_CONNECT_TO_REMOTE_DETAILS.get(desc.getHostname()));
        }
    }

    @Override
    public void okClicked() {
        String[] al;
        ArrayList<Message> errors = new ArrayList<Message>();
        for (JLabel label : this.labels) {
            this.setPrimaryValid(label);
        }
        String n = this.getObjectClassName();
        MessageBuilder err = new MessageBuilder();
        if (n.length() == 0) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_OBJECTCLASS_NAME_REQUIRED.get());
        } else if (!StaticUtils.isValidSchemaElement(n, 0, n.length(), err)) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_OBJECTCLASS_NAME.get(err.toString()));
            err = new MessageBuilder();
        } else {
            Message elementType = NewAttributePanel.getSchemaElementType(n, this.schema);
            if (elementType != null) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_OBJECTCLASS_NAME_ALREADY_IN_USE.get(n, elementType.toString()));
            }
        }
        n = this.oid.getText().trim();
        if (n.length() > 0) {
            if (!StaticUtils.isValidSchemaElement(n, 0, n.length(), err)) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_OID_NOT_VALID.get(err.toString()));
                err = new MessageBuilder();
            } else {
                Message elementType = NewAttributePanel.getSchemaElementType(n, this.schema);
                if (elementType != null) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_OID_ALREADY_IN_USE.get(n, elementType.toString()));
                }
            }
        }
        if (this.aliases.getText().trim().length() > 0 && (al = this.aliases.getText().split(",")).length > 0) {
            for (String alias : al) {
                if (alias.trim().length() == 0) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_EMPTY_ALIAS.get());
                    continue;
                }
                Message elementType = NewAttributePanel.getSchemaElementType(alias, this.schema);
                if (elementType == null) continue;
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_ALIAS_ALREADY_IN_USE.get(n, elementType.toString()));
            }
        }
        this.checkCompatibleSuperiors(this.getObjectClassSuperiors(), this.getObjectClassType(), errors);
        ProgressDialog dlg = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_NEW_OBJECTCLASS_PANEL_TITLE.get(), this.getInfo());
        NewSchemaElementsTask newTask = null;
        if (errors.size() == 0) {
            LinkedHashSet<AttributeType> attributes = new LinkedHashSet<AttributeType>(1);
            LinkedHashSet<ObjectClass> ocs = new LinkedHashSet<ObjectClass>();
            ocs.add(this.getObjectClass());
            newTask = new NewSchemaElementsTask(this.getInfo(), dlg, ocs, attributes);
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(newTask, errors);
            }
            for (ConfigurationElementCreatedListener listener : this.getConfigurationElementCreatedListeners()) {
                newTask.addConfigurationElementCreatedListener(listener);
            }
        }
        if (errors.size() == 0) {
            String ocName = this.getObjectClassName();
            this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_CREATING_OBJECTCLASS_SUMMARY.get(ocName), AdminToolMessages.INFO_CTRL_PANEL_CREATING_OBJECTCLASS_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_CREATING_OBJECTCLASS_SUCCESSFUL.get(ocName), AdminToolMessages.ERR_CTRL_PANEL_CREATING_OBJECTCLASS_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_CREATING_OBJECTCLASS_ERROR_DETAILS.get(ocName), null, dlg);
            dlg.setVisible(true);
            this.name.setText("");
            this.oid.setText("");
            this.description.setText("");
            this.aliases.setText("");
            this.superiors.setSelectedSuperiors(Collections.singleton(this.schema.getObjectClass("top")));
            this.attributes.getAvailableListModel().addAll(this.attributes.getSelectedListModel1().getData());
            this.attributes.getAvailableListModel().addAll(this.attributes.getSelectedListModel2().getData());
            this.attributes.getSelectedListModel1().clear();
            this.attributes.getSelectedListModel2().clear();
            this.name.grabFocus();
            Utilities.getParentDialog(this).setVisible(false);
        } else {
            this.displayErrorDialog(errors);
        }
    }

    private void updateAttributes() {
        int[][] selected = new int[][]{this.attributes.getAvailableList().getSelectedIndices(), this.attributes.getSelectedList1().getSelectedIndices(), this.attributes.getSelectedList2().getSelectedIndices()};
        JList[] lists = new JList[]{this.attributes.getAvailableList(), this.attributes.getSelectedList1(), this.attributes.getSelectedList2()};
        this.attributes.getAvailableListModel().clear();
        Collection<AttributeType> allAttrs = this.schema.getAttributeTypes().values();
        this.attributes.getAvailableListModel().addAll(allAttrs);
        HashSet<AttributeType> toDelete = new HashSet<AttributeType>();
        for (AttributeType attr : this.attributes.getSelectedListModel1().getData()) {
            if (!allAttrs.contains(attr)) {
                toDelete.add(attr);
                continue;
            }
            this.attributes.getAvailableListModel().remove(attr);
        }
        for (AttributeType attr : toDelete) {
            this.attributes.getSelectedListModel1().remove(attr);
        }
        toDelete = new HashSet();
        for (AttributeType attr : this.attributes.getSelectedListModel2().getData()) {
            if (!allAttrs.contains(attr)) {
                toDelete.add(attr);
                continue;
            }
            this.attributes.getAvailableListModel().remove(attr);
        }
        for (AttributeType attr : toDelete) {
            this.attributes.getSelectedListModel1().remove(attr);
        }
        int i = 0;
        for (int[] sel : selected) {
            if (sel != null) {
                ArrayList<Integer> indexes = new ArrayList<Integer>();
                for (int j = 0; j < sel.length; ++j) {
                    if (sel[j] >= lists[i].getModel().getSize()) continue;
                    indexes.add(sel[j]);
                }
                int[] newSelection = new int[indexes.size()];
                for (int j = 0; j < newSelection.length; ++j) {
                    newSelection[j] = (Integer)indexes.get(j);
                }
                lists[i].setSelectedIndices(newSelection);
            }
            ++i;
        }
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        Utilities.setRequiredIcon(this.lName);
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        this.addErrorPane(gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weighty = 0.0;
        gbc.gridx = 1;
        gbc.anchor = 13;
        gbc.fill = 0;
        JLabel requiredLabel = this.createRequiredLabel();
        gbc.insets.bottom = 10;
        this.add((Component)requiredLabel, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets.bottom = 0;
        SuperiorObjectClassesChangedListener listener = new SuperiorObjectClassesChangedListener(){

            @Override
            public void parentObjectClassesChanged(SuperiorObjectClassesChangedEvent ev) {
                for (AttributeType attr : NewObjectClassPanel.this.inheritedRequiredAttributes) {
                    NewObjectClassPanel.this.attributes.getAvailableListModel().add(attr);
                    NewObjectClassPanel.this.attributes.getSelectedListModel1().remove(attr);
                }
                for (AttributeType attr : NewObjectClassPanel.this.inheritedOptionalAttributes) {
                    NewObjectClassPanel.this.attributes.getAvailableListModel().add(attr);
                    NewObjectClassPanel.this.attributes.getSelectedListModel2().remove(attr);
                }
                NewObjectClassPanel.this.inheritedOptionalAttributes.clear();
                NewObjectClassPanel.this.inheritedRequiredAttributes.clear();
                for (ObjectClass oc : NewObjectClassPanel.this.superiors.getSelectedSuperiors()) {
                    for (AttributeType attr : oc.getRequiredAttributeChain()) {
                        NewObjectClassPanel.this.inheritedRequiredAttributes.add(attr);
                    }
                    for (AttributeType attr : oc.getOptionalAttributeChain()) {
                        NewObjectClassPanel.this.inheritedOptionalAttributes.add(attr);
                    }
                }
                for (AttributeType attr : NewObjectClassPanel.this.inheritedRequiredAttributes) {
                    NewObjectClassPanel.this.attributes.getAvailableListModel().remove(attr);
                    NewObjectClassPanel.this.attributes.getSelectedListModel1().add(attr);
                }
                for (AttributeType attr : NewObjectClassPanel.this.inheritedOptionalAttributes) {
                    NewObjectClassPanel.this.attributes.getAvailableListModel().remove(attr);
                    NewObjectClassPanel.this.attributes.getSelectedListModel2().add(attr);
                }
                NewObjectClassPanel.this.attributes.getAvailableListModel().fireContentsChanged(NewObjectClassPanel.this.attributes.getAvailableList(), 0, NewObjectClassPanel.this.attributes.getAvailableList().getModel().getSize() - 1);
                NewObjectClassPanel.this.attributes.getSelectedListModel1().fireContentsChanged(NewObjectClassPanel.this.attributes.getSelectedList1(), 0, NewObjectClassPanel.this.attributes.getSelectedList1().getModel().getSize() - 1);
                NewObjectClassPanel.this.attributes.getSelectedListModel2().fireContentsChanged(NewObjectClassPanel.this.attributes.getSelectedList2(), 0, NewObjectClassPanel.this.attributes.getSelectedList2().getModel().getSize() - 1);
                ArrayList unmovableItems = new ArrayList(NewObjectClassPanel.this.inheritedRequiredAttributes);
                unmovableItems.addAll(NewObjectClassPanel.this.inheritedOptionalAttributes);
                NewObjectClassPanel.this.attributes.setUnmovableItems(unmovableItems);
                if (ev.getNewObjectClasses().size() > 1) {
                    NewObjectClassPanel.this.lSuperior.setText(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_PARENTS_LABEL.get().toString());
                } else {
                    NewObjectClassPanel.this.lSuperior.setText(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_PARENT_LABEL.get().toString());
                }
            }
        };
        this.superiors.addParentObjectClassesChangedListener(listener);
        DefaultComboBoxModel<ObjectClassType> model = new DefaultComboBoxModel<ObjectClassType>();
        for (ObjectClassType t : ObjectClassType.values()) {
            model.addElement(t);
        }
        this.type.setModel(model);
        this.type.setSelectedItem((Object)ObjectClassType.STRUCTURAL);
        SchemaElementComboBoxCellRenderer renderer = new SchemaElementComboBoxCellRenderer(this.type);
        this.type.setRenderer(renderer);
        this.attributes = new DoubleAddRemovePanel<AttributeType>(0, AttributeType.class);
        Comparator<AttributeType> comparator = new Comparator<AttributeType>(){

            @Override
            public int compare(AttributeType attr1, AttributeType attr2) {
                return attr1.getNameOrOID().toLowerCase().compareTo(attr2.getNameOrOID().toLowerCase());
            }
        };
        this.attributes.getAvailableListModel().setComparator(comparator);
        this.attributes.getSelectedListModel1().setComparator(comparator);
        this.attributes.getSelectedListModel2().setComparator(comparator);
        Component[] basicComps = new Component[]{this.name, this.oid, this.description, this.superiors};
        JLabel[] basicLabels = new JLabel[]{this.lName, this.lOID, this.lDescription, this.lSuperior};
        JLabel[] basicInlineHelp = new JLabel[]{null, null, null, null};
        this.add(basicLabels, basicComps, basicInlineHelp, this, gbc);
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        gbc.fill = 2;
        gbc.anchor = 18;
        this.add((Component)this.lAttributes, gbc);
        ++gbc.gridx;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets.left = 10;
        this.add(this.attributes, gbc);
        this.attributes.getAvailableLabel().setText(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_AVAILABLE_ATTRIBUTES.get().toString());
        this.attributes.getSelectedLabel1().setText(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_REQUIRED_ATTRIBUTES.get().toString());
        this.attributes.getSelectedLabel2().setText(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_OPTIONAL_ATTRIBUTES.get().toString());
        AttributeTypeCellRenderer listRenderer = new AttributeTypeCellRenderer();
        this.attributes.getAvailableList().setCellRenderer(listRenderer);
        this.attributes.getSelectedList1().setCellRenderer(listRenderer);
        this.attributes.getSelectedList2().setCellRenderer(listRenderer);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.insets.top = 3;
        JLabel explanation = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_INHERITED_ATTRIBUTES_HELP.get());
        gbc.insets.top = 3;
        this.add((Component)explanation, gbc);
        final BasicExpander expander = new BasicExpander(AdminToolMessages.INFO_CTRL_PANEL_EXTRA_OPTIONS_EXPANDER.get());
        this.obsolete.setText("Obsolete");
        Component[] comps = new Component[]{this.aliases, this.origin, this.file, this.type, this.obsolete};
        JLabel[] labels = new JLabel[]{this.lAliases, this.lOrigin, this.lFile, this.lType, null};
        JLabel[] inlineHelps = new JLabel[]{Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_SEPARATED_WITH_COMMAS_HELP.get()), null, Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_SCHEMA_FILE_OBJECTCLASS_HELP.get(File.separator)), null, null};
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.weighty = 0.0;
        gbc.insets.left = 0;
        ++gbc.gridy;
        this.add((Component)expander, gbc);
        final JPanel p = new JPanel(new GridBagLayout());
        gbc.insets.left = 15;
        ++gbc.gridy;
        this.add((Component)p, gbc);
        ++gbc.gridy;
        p.setOpaque(false);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.fill = 2;
        gbc1.gridy = 0;
        this.add(labels, comps, inlineHelps, p, gbc1);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                p.setVisible(expander.isSelected());
            }
        };
        expander.addChangeListener(changeListener);
        expander.setSelected(false);
        changeListener.stateChanged(null);
        this.file.setText("99-user.ldif");
    }

    private String getObjectClassName() {
        return this.name.getText().trim();
    }

    private String getOID() {
        String o = this.oid.getText().trim();
        if (o.length() == 0) {
            o = this.getObjectClassName() + "-oid";
        }
        return o;
    }

    private Set<ObjectClass> getObjectClassSuperiors() {
        return this.superiors.getSelectedSuperiors();
    }

    private Map<String, List<String>> getExtraProperties() {
        String or;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        String f = this.file.getText().trim();
        if (f.length() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(f);
            map.put("X-SCHEMA-FILE", list);
        }
        if ((or = this.origin.getText().trim()).length() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(or);
            map.put("X-ORIGIN", list);
        }
        return map;
    }

    private ArrayList<String> getAliases() {
        ArrayList<String> al = new ArrayList<String>();
        String s = this.aliases.getText().trim();
        if (s.length() > 0) {
            String[] a;
            for (String alias : a = s.split(",")) {
                al.add(alias.trim());
            }
        }
        return al;
    }

    private ArrayList<String> getAllNames() {
        ArrayList<String> al = new ArrayList<String>();
        al.add(this.getObjectClassName());
        al.addAll(this.getAliases());
        return al;
    }

    private String getDescription() {
        return this.description.getText().trim();
    }

    private ObjectClass getObjectClass() {
        ObjectClass oc = new ObjectClass("", this.getObjectClassName(), this.getAllNames(), this.getOID(), this.getDescription(), this.getObjectClassSuperiors(), this.getRequiredAttributes(), this.getOptionalAttributes(), this.getObjectClassType(), this.obsolete.isSelected(), this.getExtraProperties());
        return oc;
    }

    private ObjectClassType getObjectClassType() {
        return (ObjectClassType)((Object)this.type.getSelectedItem());
    }

    private Set<AttributeType> getRequiredAttributes() {
        HashSet<AttributeType> attrs = new HashSet<AttributeType>();
        attrs.addAll(this.attributes.getSelectedListModel1().getData());
        attrs.removeAll(this.inheritedRequiredAttributes);
        return attrs;
    }

    private Set<AttributeType> getOptionalAttributes() {
        HashSet<AttributeType> attrs = new HashSet<AttributeType>();
        attrs.addAll(this.attributes.getSelectedListModel2().getData());
        attrs.removeAll(this.inheritedOptionalAttributes);
        return attrs;
    }

    private class AttributeTypeCellRenderer
    implements ListCellRenderer {
        private ListCellRenderer defaultRenderer;

        public AttributeTypeCellRenderer() {
            this.defaultRenderer = NewObjectClassPanel.this.attributes.getAvailableList().getCellRenderer();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof AttributeType) {
                AttributeType attr = (AttributeType)value;
                value = NewObjectClassPanel.this.inheritedOptionalAttributes.contains(value) || NewObjectClassPanel.this.inheritedRequiredAttributes.contains(value) ? attr.getNameOrOID() + " (*)" : attr.getNameOrOID();
            }
            return this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

