/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JLabel;
import org.opends.guitools.controlpanel.datamodel.BasicMonitoringAttributes;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.ui.GeneralMonitoringPanel;
import org.opends.guitools.controlpanel.util.ConfigFromDirContext;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.BackendMessages;
import org.opends.messages.Message;

public class RootMonitoringPanel
extends GeneralMonitoringPanel {
    private static final long serialVersionUID = 9031734563746269830L;
    private JLabel openConnections = Utilities.createDefaultLabel();
    private JLabel maxConnections = Utilities.createDefaultLabel();
    private JLabel totalConnections = Utilities.createDefaultLabel();
    private JLabel startTime = Utilities.createDefaultLabel();
    private JLabel upTime = Utilities.createDefaultLabel();
    private JLabel version = Utilities.createDefaultLabel();

    public RootMonitoringPanel() {
        this.createLayout();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.openConnections;
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        ++gbc.gridy;
        JLabel lTitle = Utilities.createTitleLabel(AdminToolMessages.INFO_CTRL_PANEL_GENERAL_MONITORING_ROOT.get());
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        gbc.insets.top = 5;
        gbc.insets.bottom = 7;
        this.add((Component)lTitle, gbc);
        gbc.insets.bottom = 0;
        gbc.insets.top = 10;
        Message[] labels = new Message[]{AdminToolMessages.INFO_CTRL_PANEL_OPEN_CONNECTIONS_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_MAX_CONNECTIONS_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_TOTAL_CONNECTIONS_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_START_TIME_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_UP_TIME_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_OPENDS_VERSION_LABEL.get()};
        JLabel[] values = new JLabel[]{this.openConnections, this.maxConnections, this.totalConnections, this.startTime, this.upTime, this.version};
        ++gbc.gridy;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        for (int i = 0; i < labels.length; ++i) {
            gbc.insets.left = 0;
            gbc.gridx = 0;
            JLabel l = Utilities.createPrimaryLabel(labels[i]);
            this.add((Component)l, gbc);
            gbc.insets.left = 10;
            gbc.gridx = 1;
            this.add((Component)values[i], gbc);
            ++gbc.gridy;
        }
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(Box.createGlue(), gbc);
        this.setBorder(this.PANEL_BORDER);
    }

    public void updateContents() {
        ServerDescriptor server = null;
        if (this.getInfo() != null) {
            server = this.getInfo().getServerDescriptor();
        }
        CustomSearchResult csr = null;
        if (server != null) {
            csr = server.getRootMonitor();
        }
        if (csr != null) {
            JLabel[] ls = new JLabel[]{this.openConnections, this.maxConnections, this.totalConnections, this.startTime};
            BasicMonitoringAttributes[] attrs = new BasicMonitoringAttributes[]{BasicMonitoringAttributes.CURRENT_CONNECTIONS, BasicMonitoringAttributes.MAX_CONNECTIONS, BasicMonitoringAttributes.TOTAL_CONNECTIONS, BasicMonitoringAttributes.START_DATE};
            for (int i = 0; i < ls.length; ++i) {
                ls[i].setText(RootMonitoringPanel.getMonitoringValue(attrs[i], csr));
            }
            this.version.setText(server.getOpenDSVersion());
            try {
                String start = (String)this.getFirstMonitoringValue(csr, BasicMonitoringAttributes.START_DATE.getAttributeName());
                String current = (String)this.getFirstMonitoringValue(csr, BasicMonitoringAttributes.CURRENT_DATE.getAttributeName());
                Date startTime = ConfigFromDirContext.utcParser.parse(start);
                Date currentTime = ConfigFromDirContext.utcParser.parse(current);
                long upSeconds = (currentTime.getTime() - startTime.getTime()) / 1000L;
                long upDays = upSeconds / 86400L;
                long upHours = (upSeconds %= 86400L) / 3600L;
                long upMinutes = (upSeconds %= 3600L) / 60L;
                Message upTimeStr = BackendMessages.INFO_MONITOR_UPTIME.get(upDays, upHours, upMinutes, upSeconds %= 60L);
                this.upTime.setText(upTimeStr.toString());
            }
            catch (Throwable t) {
                this.upTime.setText(NO_VALUE_SET.toString());
            }
        } else {
            this.openConnections.setText(NO_VALUE_SET.toString());
            this.maxConnections.setText(NO_VALUE_SET.toString());
            this.totalConnections.setText(NO_VALUE_SET.toString());
            this.startTime.setText(NO_VALUE_SET.toString());
            this.upTime.setText(NO_VALUE_SET.toString());
            this.version.setText(NO_VALUE_SET.toString());
        }
    }
}

