/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.JPanel;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.ConfigurationElementCreatedListener;
import org.opends.guitools.controlpanel.event.SchemaElementSelectionListener;
import org.opends.guitools.controlpanel.ui.AttributeSyntaxPanel;
import org.opends.guitools.controlpanel.ui.ConfigurationAttributePanel;
import org.opends.guitools.controlpanel.ui.ConfigurationObjectClassPanel;
import org.opends.guitools.controlpanel.ui.CustomAttributePanel;
import org.opends.guitools.controlpanel.ui.CustomObjectClassPanel;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.MatchingRulePanel;
import org.opends.guitools.controlpanel.ui.NoItemSelectedPanel;
import org.opends.guitools.controlpanel.ui.SchemaElementPanel;
import org.opends.guitools.controlpanel.ui.StandardAttributePanel;
import org.opends.guitools.controlpanel.ui.StandardObjectClassPanel;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.UnsavedChangesDialog;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.MatchingRule;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Schema;

public class SchemaBrowserRightPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = 5294502011852239497L;
    private JPanel mainPanel;
    private StandardObjectClassPanel standardObjectClassPanel = new StandardObjectClassPanel();
    private ConfigurationObjectClassPanel configurationObjectClassPanel = new ConfigurationObjectClassPanel();
    private CustomObjectClassPanel customObjectClassPanel = new CustomObjectClassPanel();
    private StandardAttributePanel standardAttributePanel = new StandardAttributePanel();
    private ConfigurationAttributePanel configurationAttributePanel = new ConfigurationAttributePanel();
    private CustomAttributePanel customAttributePanel = new CustomAttributePanel();
    private MatchingRulePanel matchingRulePanel = new MatchingRulePanel();
    private AttributeSyntaxPanel attributeSyntaxPanel = new AttributeSyntaxPanel();
    private NoItemSelectedPanel noEntryPanel = new NoItemSelectedPanel();
    private final SchemaElementPanel[] panels = new SchemaElementPanel[]{this.standardObjectClassPanel, this.configurationObjectClassPanel, this.customObjectClassPanel, this.standardAttributePanel, this.configurationAttributePanel, this.customAttributePanel, this.matchingRulePanel, this.attributeSyntaxPanel};
    private final String NOTHING_SELECTED = "Nothing Selected";
    private SchemaElementPanel schemaElementPanel;

    public SchemaBrowserRightPanel() {
        this.createLayout();
    }

    @Override
    public void displayMessage(Message msg) {
        this.schemaElementPanel = null;
        this.noEntryPanel.setMessage(msg);
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, "Nothing Selected");
    }

    @Override
    public void setInfo(ControlPanelInfo info) {
        super.setInfo(info);
        for (SchemaElementPanel panel : this.panels) {
            panel.setInfo(info);
        }
    }

    public void addSchemaElementSelectionListener(SchemaElementSelectionListener listener) {
        for (SchemaElementPanel panel : this.panels) {
            panel.addSchemaElementSelectionListener(listener);
        }
    }

    public void removeSchemaElementSelectionListener(SchemaElementSelectionListener listener) {
        for (SchemaElementPanel panel : this.panels) {
            panel.removeSchemaElementSelectionListener(listener);
        }
    }

    @Override
    public void addConfigurationElementCreatedListener(ConfigurationElementCreatedListener listener) {
        super.addConfigurationElementCreatedListener(listener);
        for (SchemaElementPanel panel : this.panels) {
            panel.addConfigurationElementCreatedListener(listener);
        }
    }

    @Override
    public void removeConfigurationElementCreatedListener(ConfigurationElementCreatedListener listener) {
        super.removeConfigurationElementCreatedListener(listener);
        for (SchemaElementPanel panel : this.panels) {
            panel.removeConfigurationElementCreatedListener(listener);
        }
    }

    public void updateStandardObjectClass(ObjectClass oc, Schema schema) {
        this.standardObjectClassPanel.update(oc, schema);
        this.schemaElementPanel = this.standardObjectClassPanel;
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.standardObjectClassPanel.getTitle().toString());
    }

    public void updateConfigurationObjectClass(ObjectClass oc, Schema schema) {
        this.configurationObjectClassPanel.update(oc, schema);
        this.schemaElementPanel = this.configurationObjectClassPanel;
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.configurationObjectClassPanel.getTitle().toString());
    }

    public void updateCustomObjectClass(ObjectClass oc, Schema schema) {
        this.customObjectClassPanel.update(oc, schema);
        this.schemaElementPanel = this.customObjectClassPanel;
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.customObjectClassPanel.getTitle().toString());
    }

    public void updateStandardAttribute(AttributeType attr, Schema schema) {
        this.standardAttributePanel.update(attr, schema);
        this.schemaElementPanel = this.standardAttributePanel;
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.standardAttributePanel.getTitle().toString());
    }

    public void updateConfigurationAttribute(AttributeType attr, Schema schema) {
        this.configurationAttributePanel.update(attr, schema);
        this.schemaElementPanel = this.configurationAttributePanel;
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.configurationAttributePanel.getTitle().toString());
    }

    public void updateCustomAttribute(AttributeType attr, Schema schema) {
        this.customAttributePanel.update(attr, schema);
        this.schemaElementPanel = this.customAttributePanel;
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.customAttributePanel.getTitle().toString());
    }

    public void updateMatchingRule(MatchingRule matchingRule, Schema schema) {
        this.matchingRulePanel.update(matchingRule, schema);
        this.schemaElementPanel = this.matchingRulePanel;
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.matchingRulePanel.getTitle().toString());
    }

    public void updateAttributeSyntax(AttributeSyntax<?> syntax, Schema schema) {
        this.attributeSyntaxPanel.update(syntax, schema);
        this.schemaElementPanel = this.attributeSyntaxPanel;
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.attributeSyntaxPanel.getTitle().toString());
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        CardLayout cardLayout = new CardLayout();
        this.mainPanel = new JPanel(cardLayout);
        this.mainPanel.setOpaque(false);
        this.noEntryPanel.setMessage(AdminToolMessages.INFO_CTRL_PANEL_NO_SCHEMA_ITEM_SELECTED_LABEL.get());
        this.mainPanel.add((Component)this.noEntryPanel, "Nothing Selected");
        StatusGenericPanel[] panelsWithScroll = new StatusGenericPanel[]{this.standardObjectClassPanel, this.configurationObjectClassPanel, this.standardAttributePanel, this.configurationAttributePanel, this.matchingRulePanel, this.attributeSyntaxPanel};
        StatusGenericPanel[] panelsWithNoScroll = new StatusGenericPanel[]{this.customObjectClassPanel, this.customAttributePanel};
        for (StatusGenericPanel panel : panelsWithScroll) {
            this.mainPanel.add((Component)Utilities.createBorderLessScrollBar(panel), panel.getTitle().toString());
        }
        for (StatusGenericPanel panel : panelsWithNoScroll) {
            this.mainPanel.add((Component)panel, panel.getTitle().toString());
        }
        cardLayout.show(this.mainPanel, "Nothing Selected");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.mainPanel, gbc);
    }

    @Override
    public void okClicked() {
    }

    @Override
    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.NO_BUTTON;
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_SCHEMA_BROWSER_RIGHT_PANEL_TITLE.get();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return null;
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    public boolean mustCheckUnsavedChanges() {
        return this.schemaElementPanel != null && this.schemaElementPanel.mustCheckUnsavedChanges();
    }

    public UnsavedChangesDialog.Result checkUnsavedChanges() {
        if (this.schemaElementPanel == null) {
            return UnsavedChangesDialog.Result.DO_NOT_SAVE;
        }
        return this.schemaElementPanel.checkUnsavedChanges();
    }
}

