/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.renderer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;

public class TreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 4045260951231311206L;
    public static final Color nonselectionBackground = ColorAndFontConstants.background;
    private static final Color nonselectionForeground = ColorAndFontConstants.foreground;
    public static final Color selectionBackground = ColorAndFontConstants.mouseOverBackground;
    private static final Color selectionForeground = ColorAndFontConstants.mouseOverForeground;
    private Border rootBorder = BorderFactory.createEmptyBorder(0, 5, 0, 0);
    private Border normalBorder = BorderFactory.createEmptyBorder(0, 0, 0, 0);

    public TreeCellRenderer() {
        this.backgroundNonSelectionColor = nonselectionBackground;
        this.backgroundSelectionColor = selectionBackground;
        this.textNonSelectionColor = nonselectionForeground;
        this.textSelectionColor = selectionForeground;
        this.setFont(ColorAndFontConstants.treeFont);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
        this.setIcon(null);
        if (row == 0 && tree.isRootVisible()) {
            this.setBorder(this.rootBorder);
        } else {
            this.setBorder(this.normalBorder);
        }
        return this;
    }
}

