/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.util;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.ConnectionHandlerDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVSortOrder;
import org.opends.guitools.controlpanel.task.OfflineUpdateException;
import org.opends.guitools.controlpanel.util.ReadOnlyConfigFileHandler;
import org.opends.guitools.controlpanel.util.SchemaLoader;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.server.admin.std.meta.AdministrationConnectorCfgDefn;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.tools.tasks.TaskEntry;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryEnvironmentConfig;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.Schema;

public abstract class ConfigReader {
    private static final Logger LOG = Logger.getLogger(ConfigReader.class.getName());
    public static String configClassName;
    public static String configFile;
    protected static OpenDsException environmentSettingException;
    protected List<OpenDsException> exceptions = Collections.emptyList();
    protected boolean configRead = false;
    protected Set<ConnectionHandlerDescriptor> listeners = Collections.emptySet();
    protected ConnectionHandlerDescriptor adminConnector;
    protected Set<BackendDescriptor> backends = Collections.emptySet();
    protected Set<DN> administrativeUsers = Collections.emptySet();
    protected int replicationPort = -1;
    protected String javaVersion;
    protected int numberConnections;
    protected boolean isSchemaEnabled;
    protected Schema schema;
    protected Set<TaskEntry> taskEntries = Collections.emptySet();

    public Set<DN> getAdministrativeUsers() {
        return this.administrativeUsers;
    }

    public Set<BackendDescriptor> getBackends() {
        return this.backends;
    }

    public Set<ConnectionHandlerDescriptor> getConnectionHandlers() {
        return this.listeners;
    }

    public ConnectionHandlerDescriptor getAdminConnector() {
        return this.adminConnector;
    }

    public List<OpenDsException> getExceptions() {
        return this.exceptions;
    }

    public boolean isConfigRead() {
        return this.configRead;
    }

    public int getReplicationPort() {
        return this.replicationPort;
    }

    public boolean isSchemaEnabled() {
        return this.isSchemaEnabled;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public int getOpenConnections() {
        return this.numberConnections;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Set<TaskEntry> getTaskEntries() {
        return this.taskEntries;
    }

    protected void readSchema() throws ConfigException, InitializationException, DirectoryException {
        SchemaLoader loader = new SchemaLoader();
        loader.readSchema();
        this.schema = loader.getSchema();
    }

    protected List<VLVSortOrder> getVLVSortOrder(String s) {
        ArrayList<VLVSortOrder> sortOrder = new ArrayList<VLVSortOrder>();
        if (s != null) {
            String[] attrNames = s.split(" ");
            for (int i = 0; i < attrNames.length; ++i) {
                if (attrNames[i].startsWith("+")) {
                    sortOrder.add(new VLVSortOrder(attrNames[i].substring(1), true));
                    continue;
                }
                if (attrNames[i].startsWith("-")) {
                    sortOrder.add(new VLVSortOrder(attrNames[i].substring(1), false));
                    continue;
                }
                sortOrder.add(new VLVSortOrder(attrNames[i], true));
            }
        }
        return sortOrder;
    }

    protected Comparator<InetAddress> getInetAddressComparator() {
        return AdministrationConnectorCfgDefn.getInstance().getListenAddressPropertyDefinition();
    }

    protected boolean mustReadSchema() {
        return true;
    }

    static {
        String installRoot = System.getProperty("org.opends.quicksetup.Root");
        if (installRoot == null) {
            installRoot = Utilities.getServerRootDirectory().getAbsolutePath();
        }
        String instanceRoot = Utilities.getInstanceRootDirectory(installRoot).getAbsolutePath();
        configFile = instanceRoot + File.separator + "config" + File.separator + "config.ldif";
        configClassName = ReadOnlyConfigFileHandler.class.getName();
        try {
            DirectoryEnvironmentConfig env = DirectoryServer.getEnvironmentConfig();
            env.setServerRoot(new File(installRoot));
            DirectoryServer instance = DirectoryServer.getInstance();
            DirectoryServer.bootstrapClient();
            DirectoryServer.initializeJMX();
            instance.initializeConfiguration(configClassName, configFile);
            instance.initializeSchema();
        }
        catch (Throwable t) {
            environmentSettingException = new OfflineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_SETTING_ENVIRONMENT.get(t.getMessage().toString()), t);
        }
        LOG.log(Level.INFO, "Environment initialized.");
    }
}

