/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.quicksetup.util.Utils;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.MatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SchemaConfigManager;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Schema;

public class SchemaLoader {
    private Schema schema;
    private final String[] attrsToKeep = new String[]{"attributetypes", "objectclasses", "nameforms", "ditcontentrules", "ditstructurerules", "matchingruleuse"};
    private final String[] ocsToKeep = new String[]{"top"};
    private final ArrayList<ObjectClass> objectclassesToKeep = new ArrayList();
    private final ArrayList<AttributeType> attributesToKeep = new ArrayList();
    private final ArrayList<MatchingRule> matchingRulesToKeep = new ArrayList();
    private final ArrayList<AttributeSyntax<?>> syntaxesToKeep = new ArrayList();

    public SchemaLoader() {
        Schema sc = DirectoryServer.getSchema();
        for (String name : this.ocsToKeep) {
            ObjectClass oc = sc.getObjectClass(name.toLowerCase());
            if (oc == null) continue;
            this.objectclassesToKeep.add(oc);
        }
        for (String name : this.attrsToKeep) {
            AttributeType attr = sc.getAttributeType(name.toLowerCase());
            if (attr == null) continue;
            this.attributesToKeep.add(attr);
        }
        for (MatchingRule matchingRule : sc.getMatchingRules().values()) {
            this.matchingRulesToKeep.add(matchingRule);
        }
        for (AttributeSyntax attributeSyntax : sc.getSyntaxes().values()) {
            this.syntaxesToKeep.add(attributeSyntax);
        }
    }

    private static String getSchemaDirectoryPath() {
        File schemaDir = DirectoryServer.getEnvironmentConfig().getSchemaDirectory();
        if (schemaDir != null) {
            return schemaDir.getAbsolutePath();
        }
        return null;
    }

    public void readSchema() throws DirectoryException, ConfigException, InitializationException {
        Object[] fileNames;
        this.schema = this.getBaseSchema();
        String schemaDirPath = SchemaLoader.getSchemaDirectoryPath();
        try {
            File schemaDir = new File(schemaDirPath);
            if (schemaDirPath == null || !schemaDir.exists()) {
                Message message = ConfigMessages.ERR_CONFIG_SCHEMA_NO_SCHEMA_DIR.get(schemaDirPath);
                throw new InitializationException(message);
            }
            if (!schemaDir.isDirectory()) {
                Message message = ConfigMessages.ERR_CONFIG_SCHEMA_DIR_NOT_DIRECTORY.get(schemaDirPath);
                throw new InitializationException(message);
            }
            FileFilter ldifFiles = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    boolean accept = false;
                    if (f != null) {
                        accept = f.isDirectory() ? true : (Utils.isWindows() ? f.getName().toLowerCase().endsWith(".ldif") : f.getName().endsWith(".ldif"));
                    }
                    return accept;
                }
            };
            File[] schemaFiles = schemaDir.listFiles(ldifFiles);
            int size = schemaFiles.length;
            ArrayList<String> fileList = new ArrayList<String>(size);
            for (File f : schemaFiles) {
                if (!f.isFile()) continue;
                fileList.add(f.getName());
            }
            fileNames = new String[fileList.size()];
            fileList.toArray(fileNames);
            Arrays.sort(fileNames);
        }
        catch (InitializationException ie) {
            throw ie;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_SCHEMA_CANNOT_LIST_FILES.get(schemaDirPath, e.getMessage());
            throw new InitializationException(message, (Throwable)e);
        }
        for (Object schemaFile : fileNames) {
            SchemaConfigManager.loadSchemaFile(this.schema, (String)schemaFile);
        }
    }

    protected Schema getBaseSchema() throws DirectoryException {
        Schema schema = new Schema();
        for (MatchingRule matchingRule : this.matchingRulesToKeep) {
            schema.registerMatchingRule(matchingRule, true);
        }
        for (AttributeSyntax attributeSyntax : this.syntaxesToKeep) {
            schema.registerSyntax(attributeSyntax, true);
        }
        for (AttributeType attributeType : this.attributesToKeep) {
            schema.registerAttributeType(attributeType, true);
        }
        for (ObjectClass objectClass : this.objectclassesToKeep) {
            schema.registerObjectClass(objectClass, true);
        }
        return schema;
    }

    public Schema getSchema() {
        return this.schema;
    }
}

