/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.awt.Font;
import java.util.ArrayList;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.Utils;

public class JavaArguments {
    private int maxMemory = -1;
    private int initialMemory = -1;
    private String[] additionalArguments = new String[0];

    public int getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(int maxMemory) {
        this.maxMemory = maxMemory;
    }

    public int getInitialMemory() {
        return this.initialMemory;
    }

    public void setInitialMemory(int initialMemory) {
        this.initialMemory = initialMemory;
    }

    public String[] getAdditionalArguments() {
        return this.additionalArguments;
    }

    public void setAdditionalArguments(String[] additionalArguments) {
        if (additionalArguments == null) {
            throw new IllegalArgumentException("additionalArguments cannot be null.");
        }
        this.additionalArguments = additionalArguments;
    }

    public boolean equals(Object o) {
        boolean equals;
        boolean bl = equals = o == this;
        if (!equals) {
            equals = o instanceof JavaArguments;
            if (equals) {
                boolean bl2 = equals = this.initialMemory == ((JavaArguments)o).initialMemory;
            }
            if (equals) {
                boolean bl3 = equals = this.maxMemory == ((JavaArguments)o).maxMemory;
            }
            if (equals) {
                boolean bl4 = equals = this.additionalArguments.length == ((JavaArguments)o).additionalArguments.length;
            }
            if (equals) {
                String[] args = ((JavaArguments)o).additionalArguments;
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].equals(this.additionalArguments[i])) continue;
                    equals = false;
                    break;
                }
            }
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = 44 + this.initialMemory + this.maxMemory;
        for (String arg : this.additionalArguments) {
            hashCode += arg.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Initial Memory: ").append(this.initialMemory).append("  Max Memory: ").append(this.maxMemory);
        int i = 1;
        for (String arg : this.additionalArguments) {
            sb.append(" arg ").append(i).append(": ").append(arg);
            ++i;
        }
        return sb.toString();
    }

    public static Message getMessageForJLabel(JavaArguments javaArguments, JavaArguments defaultJavaArguments, Font font) {
        Message msg = JavaArguments.getMessage(javaArguments, defaultJavaArguments);
        String s = msg.toString();
        if (s.contains("<br>")) {
            msg = Message.raw("<html>" + UIFactory.applyFontToHtml(s, font), new Object[0]);
        }
        return msg;
    }

    public static Message getMessage(JavaArguments javaArguments, JavaArguments defaultJavaArguments) {
        Message msg;
        if (javaArguments.equals(defaultJavaArguments)) {
            msg = QuickSetupMessages.INFO_DEFAULT_JAVA_ARGUMENTS.get();
        } else {
            StringBuilder sb;
            ArrayList<Message> lines = new ArrayList<Message>();
            if (javaArguments.getInitialMemory() != -1) {
                lines.add(QuickSetupMessages.INFO_INITIAL_MEMORY.get(javaArguments.getInitialMemory()));
            }
            if (javaArguments.getMaxMemory() != -1) {
                lines.add(QuickSetupMessages.INFO_MAXIMUM_MEMORY.get(javaArguments.getMaxMemory()));
            }
            if (javaArguments.getAdditionalArguments().length > 0) {
                sb = new StringBuilder();
                for (String arg : javaArguments.getAdditionalArguments()) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(arg);
                }
                lines.add(QuickSetupMessages.INFO_ADDITIONAL_ARGUMENTS.get(sb.toString()));
            }
            if (lines.isEmpty()) {
                msg = QuickSetupMessages.INFO_USE_JVM_DEFAULT_SETTINGS.get();
            } else if (lines.size() == 1) {
                msg = (Message)lines.get(0);
            } else {
                sb = new StringBuilder();
                for (Message line : lines) {
                    if (sb.length() > 0) {
                        sb.append("<br>");
                    }
                    sb.append(line);
                }
                msg = Message.raw(sb.toString(), new Object[0]);
            }
        }
        return msg;
    }

    public String getStringArguments() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.initialMemory != -1) {
            l.add(Utils.escapeCommandLineValue(JavaArguments.getInitialMemoryArgument(this.initialMemory)));
        }
        if (this.maxMemory != -1) {
            l.add(Utils.escapeCommandLineValue(JavaArguments.getMaxMemoryArgument(this.maxMemory)));
        }
        for (String arg : this.additionalArguments) {
            l.add(Utils.escapeCommandLineValue(arg));
        }
        return Utils.getStringFromCollection(l, " ");
    }

    public static String getInitialMemoryArgument(int value) {
        return "-Xms" + value + "m";
    }

    public static String getInitialMemoryGenericArgument() {
        return "-Xms<" + QuickSetupMessages.INFO_MEMORY_PLACEHOLDER.get() + ">";
    }

    public static String getMaxMemoryArgument(int value) {
        return "-Xmx" + value + "m";
    }

    public static String getMaxMemoryGenericArgument() {
        return "-Xms<" + QuickSetupMessages.INFO_MEMORY_PLACEHOLDER.get() + ">";
    }
}

