/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jnlp.ServiceManager;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NamingSecurityException;
import javax.naming.NoPermissionException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.TrustManager;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ReplicaDescriptor;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.SuffixDescriptor;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.MessageDescriptor;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.SecurityOptions;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.installer.AuthenticationData;
import org.opends.quicksetup.installer.DataReplicationOptions;
import org.opends.quicksetup.installer.NewSuffixOptions;
import org.opends.quicksetup.installer.SuffixesToReplicateOptions;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.CompatibleJava;
import org.opends.quicksetup.util.EmptyPrintStream;
import org.opends.quicksetup.util.IncompatibleVersionException;
import org.opends.quicksetup.util.ProgressMessageFormatter;
import org.opends.server.util.DynamicConstants;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.StaticUtils;

public class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());
    private static final int BUFFER_SIZE = 1024;
    private static final int MAX_LINE_WIDTH = 80;
    private static final String CUSTOMIZATION_CLASS_NAME = "org.opends.server.util.ReleaseDefinition";
    public static String JNLP_SERVICE_NAME = "javax.jnlp.DownloadService";
    private static EmptyPrintStream emptyStream = new EmptyPrintStream();
    private static final char[] charsToEscape = new char[]{' ', '\t', '\n', '|', ';', '<', '>', '(', ')', '$', '`', '\\', '\"', '\''};
    private static final String OBFUSCATED_VALUE = "******";
    private static String installDir;

    private Utils() {
    }

    public static boolean canUseAsPort(int port) {
        return SetupUtils.canUseAsPort(port);
    }

    public static boolean isPriviledgedPort(int port) {
        return SetupUtils.isPriviledgedPort(port);
    }

    public static boolean supportsOption(String option, String javaHome, String installPath) {
        boolean supported = false;
        LOG.log(Level.INFO, "Checking if options " + option + " are supported with java home: " + javaHome);
        try {
            String line;
            ArrayList<String> args = new ArrayList<String>();
            String libPath = Utils.getPath(installPath, "lib");
            String script = Utils.isWindows() ? Utils.getScriptPath(Utils.getPath(libPath, "_script-util.bat")) : Utils.getScriptPath(Utils.getPath(libPath, "_script-util.sh"));
            args.add(script);
            ProcessBuilder pb = new ProcessBuilder(args);
            Map<String, String> env = pb.environment();
            env.put("OPENDJ_JAVA_HOME", javaHome);
            env.put("OPENDJ_JAVA_ARGS", option);
            env.put("SCRIPT_UTIL_CMD", "set-full-environment-and-test-java");
            env.remove("OPENDJ_JAVA_BIN");
            if (Utils.isWindows()) {
                env.put("DO_NOT_PAUSE", "true");
            }
            final Process process = pb.start();
            LOG.log(Level.INFO, "launching " + args + " with env: " + env);
            InputStream is = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            boolean errorDetected = false;
            while (null != (line = reader.readLine())) {
                LOG.log(Level.INFO, "The output: " + line);
                if (!line.contains("ERROR:  The detected Java version")) continue;
                if (Utils.isWindows()) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(3000L);
                                process.exitValue();
                            }
                            catch (Throwable t) {
                                process.destroy();
                            }
                        }
                    });
                    t.start();
                }
                errorDetected = true;
            }
            process.waitFor();
            int returnCode = process.exitValue();
            LOG.log(Level.INFO, "returnCode: " + returnCode);
            supported = returnCode == 0 && !errorDetected;
            LOG.log(Level.INFO, "supported: " + supported);
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error testing option " + option + " on " + javaHome, t);
        }
        return supported;
    }

    public static boolean createFile(File f) throws IOException {
        boolean success = false;
        if (f != null) {
            File parent = f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            success = f.createNewFile();
        }
        return success;
    }

    public static String getPath(String parentPath, String relativePath) {
        return Utils.getPath(new File(new File(parentPath), relativePath));
    }

    public static String getScriptPath(String script) {
        return SetupUtils.getScriptPath(script);
    }

    public static String getPath(File f) {
        String path = null;
        if (f != null) {
            try {
                f = f.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            path = f.toString();
        }
        return path;
    }

    public static boolean isDescendant(File descendant, File path) {
        boolean isDescendant = false;
        if (descendant != null && path != null) {
            File parent = descendant.getParentFile();
            while (parent != null && !isDescendant) {
                isDescendant = path.equals(parent);
                if (isDescendant) continue;
                parent = parent.getParentFile();
            }
        }
        return isDescendant;
    }

    public static boolean isWindows() {
        return SetupUtils.isWindows();
    }

    public static boolean isMacOS() {
        return SetupUtils.isMacOS();
    }

    public static boolean isUnix() {
        return SetupUtils.isUnix();
    }

    public static String getOSString() {
        return SetupUtils.getOSString();
    }

    public static boolean parentDirectoryExists(String path) {
        boolean parentExists = false;
        File f = new File(path);
        File parentFile = f.getParentFile();
        if (parentFile != null) {
            parentExists = parentFile.isDirectory();
        }
        return parentExists;
    }

    public static boolean fileExists(String path) {
        File f = new File(path);
        return f.isFile();
    }

    public static boolean directoryExistsAndIsNotEmpty(String path) {
        boolean directoryExistsAndIsNotEmpty = false;
        File f = new File(path);
        if (f.isDirectory()) {
            String[] ch = f.list();
            directoryExistsAndIsNotEmpty = ch != null && ch.length > 0;
        }
        return directoryExistsAndIsNotEmpty;
    }

    public static boolean isDn(String dn) {
        boolean isDn = true;
        try {
            new LdapName(dn);
        }
        catch (Exception ex) {
            isDn = false;
        }
        return isDn;
    }

    public static boolean isConfigurationDn(String dn) {
        boolean isConfigurationDn = false;
        String[] configDns = new String[]{"cn=config", "cn=schema"};
        for (int i = 0; i < configDns.length && !isConfigurationDn; ++i) {
            isConfigurationDn = Utils.areDnsEqual(dn, configDns[i]);
        }
        return isConfigurationDn;
    }

    public static boolean areDnsEqual(String dn1, String dn2) {
        boolean areDnsEqual = false;
        try {
            LdapName name1 = new LdapName(dn1);
            LdapName name2 = new LdapName(dn2);
            areDnsEqual = name1.equals(name2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return areDnsEqual;
    }

    public static boolean insureParentsExist(File f) {
        File parent = f.getParentFile();
        boolean b = parent.exists();
        if (!b) {
            b = parent.mkdirs();
        }
        return b;
    }

    public static boolean canWrite(String path) {
        File parentFile;
        File file = new File(path);
        boolean canWrite = file.exists() ? file.canWrite() : (parentFile = file.getParentFile()) != null && parentFile.canWrite();
        return canWrite;
    }

    public static boolean createDirectory(String path) throws IOException {
        return Utils.createDirectory(new File(path));
    }

    public static boolean createDirectory(File f) throws IOException {
        boolean directoryCreated = !f.exists() ? f.mkdirs() : f.isDirectory();
        return directoryCreated;
    }

    public static void createFile(File path, InputStream is) throws IOException {
        int count;
        byte[] data = new byte[1024];
        FileOutputStream out = new FileOutputStream(path);
        BufferedOutputStream dest = new BufferedOutputStream(out);
        while ((count = is.read(data, 0, 1024)) != -1) {
            dest.write(data, 0, count);
        }
        dest.flush();
        dest.close();
    }

    public static void createProtectedFile(String path, String content) throws IOException, InterruptedException {
        FileWriter file = new FileWriter(path);
        PrintWriter out = new PrintWriter(file);
        out.println(content);
        out.flush();
        out.close();
        if (!Utils.isWindows()) {
            Utils.setPermissionsUnix(path, "600");
        }
    }

    public static String getStringFromCollection(Collection<String> col, String separator) {
        StringBuilder msg = new StringBuilder();
        for (String m : col) {
            if (msg.length() > 0) {
                msg.append(separator);
            }
            msg.append(m);
        }
        return msg.toString();
    }

    public static Message getMessageFromCollection(Collection<Message> col, String separator) {
        Message message = null;
        if (col != null) {
            MessageBuilder mb = null;
            for (Message m : col) {
                if (mb == null) {
                    mb = new MessageBuilder(m);
                    continue;
                }
                mb.append(separator).append(m);
            }
            if (mb == null) {
                mb = new MessageBuilder();
            }
            message = mb.toMessage();
        }
        return message;
    }

    public static String getDefaultServerLocation() {
        String firstLocation;
        String userDir = System.getProperty("user.home");
        String serverLocation = firstLocation = userDir + File.separator + DynamicConstants.SHORT_NAME.toLowerCase(Locale.ENGLISH);
        int i = 1;
        while (Utils.fileExists(serverLocation) || Utils.directoryExistsAndIsNotEmpty(serverLocation)) {
            serverLocation = firstLocation + "-" + i;
            ++i;
        }
        return serverLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean hasEnoughSpace(String directoryPath, long bytes) {
        boolean hasEnoughSpace = false;
        File file = null;
        RandomAccessFile raf = null;
        File directory = new File(directoryPath);
        boolean deleteDirectory = false;
        if (!directory.exists()) {
            deleteDirectory = directory.mkdir();
        }
        try {
            file = File.createTempFile("temp" + System.nanoTime(), ".tmp", directory);
            raf = new RandomAccessFile(file, "rw");
            raf.setLength(bytes);
            hasEnoughSpace = true;
        }
        catch (IOException ex) {
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException ex2) {}
            }
            if (file != null) {
                file.delete();
            }
        }
        if (deleteDirectory) {
            directory.delete();
        }
        return hasEnoughSpace;
    }

    public static Message getThrowableMsg(Message message, Throwable t) {
        MessageBuilder mb = new MessageBuilder(message);
        MessageDescriptor.Arg1<CharSequence> tag = Utils.isOutOfMemory(t) ? QuickSetupMessages.INFO_EXCEPTION_OUT_OF_MEMORY_DETAILS : QuickSetupMessages.INFO_EXCEPTION_DETAILS;
        String detail = t.toString();
        if (detail != null) {
            mb.append("  ").append(tag.get(detail));
        }
        return mb.toMessage();
    }

    public static Message getMessage(TopologyCacheException te) {
        MessageBuilder buf = new MessageBuilder();
        String ldapUrl = te.getLdapUrl();
        if (ldapUrl != null) {
            String hostName = ldapUrl.substring(ldapUrl.indexOf("://") + 3);
            buf.append(QuickSetupMessages.INFO_SERVER_ERROR.get(hostName));
            buf.append(" ");
        }
        if (te.getType() == TopologyCacheException.Type.TIMEOUT) {
            buf.append(QuickSetupMessages.INFO_ERROR_CONNECTING_TIMEOUT.get());
        } else if (te.getCause() instanceof NamingException) {
            buf.append(Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONNECTING_TO_LOCAL.get(), te.getCause()));
        } else {
            LOG.log(Level.WARNING, "Unexpected error: " + te, te);
            if (te.getCause() != null) {
                buf.append(Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), te.getCause()));
            } else {
                buf.append(Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), te));
            }
        }
        return buf.toMessage();
    }

    public static int setPermissionsUnix(ArrayList<String> paths, String permissions) throws IOException, InterruptedException {
        String[] args = new String[paths.size() + 2];
        args[0] = "chmod";
        args[1] = permissions;
        for (int i = 2; i < args.length; ++i) {
            args[i] = paths.get(i - 2);
        }
        Process p = Runtime.getRuntime().exec(args);
        return p.waitFor();
    }

    public static int setPermissionsUnix(String path, String permissions) throws IOException, InterruptedException {
        String[] args = new String[]{"chmod", permissions, path};
        Process p = Runtime.getRuntime().exec(args);
        return p.waitFor();
    }

    public static String getHostNameForLdapUrl(String host) {
        return ConnectionUtils.getHostNameForLdapUrl(host);
    }

    public static boolean isWebStart() {
        return SetupUtils.isWebStart();
    }

    public static boolean isCli() {
        return "true".equals(System.getProperty("org.opends.quicksetup.cli"));
    }

    public static InitialLdapContext createLdapContext(String ldapURL, String dn, String pwd, int timeout, Hashtable<String, String> env) throws NamingException {
        return ConnectionUtils.createLdapContext(ldapURL, dn, pwd, timeout, env);
    }

    public static InitialLdapContext createLdapsContext(String ldapsURL, String dn, String pwd, int timeout, Hashtable<String, String> env, TrustManager trustManager) throws NamingException {
        return ConnectionUtils.createLdapsContext(ldapsURL, dn, pwd, timeout, env, trustManager, null);
    }

    public static InitialLdapContext createStartTLSContext(String ldapsURL, String dn, String pwd, int timeout, Hashtable<String, String> env, TrustManager trustManager, HostnameVerifier verifier) throws NamingException {
        return ConnectionUtils.createStartTLSContext(ldapsURL, dn, pwd, timeout, env, trustManager, null, verifier);
    }

    public static boolean isCertificateException(Throwable t) {
        return ConnectionUtils.isCertificateException(t);
    }

    public static Message getMessageForException(NamingException ne, String hostPort) {
        String arg = ne.getLocalizedMessage() != null ? ne.getLocalizedMessage() : (ne.getExplanation() != null ? ne.getExplanation() : ne.toString(true));
        Message msg = Utils.isCertificateException(ne) ? QuickSetupMessages.INFO_ERROR_READING_CONFIG_LDAP_CERTIFICATE_SERVER.get(hostPort, arg) : (ne instanceof AuthenticationException ? QuickSetupMessages.INFO_CANNOT_CONNECT_TO_REMOTE_AUTHENTICATION.get(hostPort, arg) : (ne instanceof NoPermissionException ? QuickSetupMessages.INFO_CANNOT_CONNECT_TO_REMOTE_PERMISSIONS.get(hostPort, arg) : (ne instanceof NamingSecurityException ? QuickSetupMessages.INFO_CANNOT_CONNECT_TO_REMOTE_PERMISSIONS.get(hostPort, arg) : (ne instanceof CommunicationException ? QuickSetupMessages.ERR_CANNOT_CONNECT_TO_REMOTE_COMMUNICATION.get(hostPort, arg) : QuickSetupMessages.INFO_CANNOT_CONNECT_TO_REMOTE_GENERIC.get(hostPort, arg)))));
        return msg;
    }

    public static Message getMessageForException(NamingException ne) {
        Message msg = Utils.isCertificateException(ne) ? QuickSetupMessages.INFO_ERROR_READING_CONFIG_LDAP_CERTIFICATE.get(ne.toString(true)) : (ne instanceof AuthenticationException ? QuickSetupMessages.ERR_CANNOT_CONNECT_TO_LOCAL_AUTHENTICATION.get(ne.toString(true)) : (ne instanceof NoPermissionException ? QuickSetupMessages.ERR_CANNOT_CONNECT_TO_LOCAL_PERMISSIONS.get(ne.toString(true)) : (ne instanceof NamingSecurityException ? QuickSetupMessages.ERR_CANNOT_CONNECT_TO_LOCAL_PERMISSIONS.get(ne.toString(true)) : (ne instanceof CommunicationException ? QuickSetupMessages.ERR_CANNOT_CONNECT_TO_LOCAL_COMMUNICATION.get(ne.toString(true)) : QuickSetupMessages.ERR_CANNOT_CONNECT_TO_LOCAL_GENERIC.get(ne.toString(true))))));
        return msg;
    }

    public static String getInstallPathFromClasspath() {
        String installPath = System.getProperty("org.opends.quicksetup.Root");
        if (installPath != null) {
            return installPath;
        }
        String sep = System.getProperty("path.separator");
        String[] classPaths = System.getProperty("java.class.path").split(sep);
        String path = Utils.getInstallPath(classPaths);
        if (path != null) {
            File f = new File(path).getAbsoluteFile();
            File librariesDir = f.getParentFile();
            try {
                installPath = librariesDir.getParentFile().getCanonicalPath();
            }
            catch (IOException ioe) {
                installPath = librariesDir.getParent();
            }
        }
        return installPath;
    }

    private static String getInstallPath(String[] classPaths) {
        for (String classPath : classPaths) {
            String normPath = classPath.replace(File.separatorChar, '/');
            if (!normPath.endsWith("lib/bootstrap.jar")) continue;
            return classPath;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInstancePathFromInstallPath(String installPath) {
        String string;
        File instanceLoc;
        BufferedReader reader;
        block8: {
            String instancePathFileName = "/etc/opendj/instance.loc";
            File _svcScriptPathName = new File(installPath + File.separator + "lib" + File.separator + "_svc-opendj.sh");
            File f = new File(instancePathFileName);
            if (!(_svcScriptPathName.exists() && f.exists() || (f = new File(instancePathFileName = installPath + File.separator + "instance.loc")).exists())) {
                return installPath;
            }
            try {
                reader = new BufferedReader(new FileReader(instancePathFileName));
            }
            catch (Exception e) {
                return installPath;
            }
            String line = reader.readLine();
            instanceLoc = new File(line.trim());
            if (!instanceLoc.isAbsolute()) break block8;
            String string2 = instanceLoc.getAbsolutePath();
            StaticUtils.close(reader);
            return string2;
        }
        try {
            string = new File(installPath + File.separator + instanceLoc.getPath()).getAbsolutePath();
        }
        catch (Exception e) {
            String string3;
            try {
                string3 = installPath;
            }
            catch (Throwable throwable) {
                StaticUtils.close(reader);
                throw throwable;
            }
            StaticUtils.close(reader);
            return string3;
        }
        StaticUtils.close(reader);
        return string;
    }

    public static int getCommandLineMaxLineWidth() {
        return 80;
    }

    public static void setMacOSXMenuBar(Message appName) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", String.valueOf(appName));
    }

    private static boolean isOutOfMemory(Throwable t) {
        boolean isOutOfMemory = false;
        while (!isOutOfMemory && t != null) {
            String msg;
            if (t instanceof OutOfMemoryError) {
                isOutOfMemory = true;
            } else if (t instanceof IOException && (msg = t.toString()) != null) {
                isOutOfMemory = msg.contains("Not enough space");
            }
            t = t.getCause();
        }
        return isOutOfMemory;
    }

    public static int getNumberZipEntries() {
        return 165;
    }

    public static String listToString(List<?> list, String separator) {
        return Utils.listToString(list, separator, null, null);
    }

    public static String listToString(List<?> list, String separator, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append(list.get(i));
            if (suffix != null) {
                sb.append(suffix);
            }
            if (i >= list.size() - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String getFileSystemPermissions(File file) {
        String name = file.getName();
        String perm = file.getParent().endsWith(File.separator + "bat") || file.getParent().endsWith(File.separator + "bin") ? (name.endsWith(".bat") ? "644" : "755") : (name.endsWith(".sh") ? "755" : (name.endsWith("setup") || name.endsWith("uninstall") || name.endsWith("upgrade") ? "755" : (name.endsWith("JavaApplicationStub") ? "755" : "644")));
        return perm;
    }

    public static String getFirstValue(SearchResult entry, String attrName) throws NamingException {
        return ConnectionUtils.getFirstValue(entry, attrName);
    }

    public static String breakHtmlString(CharSequence cs, int maxll) {
        if (cs != null) {
            String d = ((Object)cs).toString();
            int len = d.length();
            if (len <= 0) {
                return d;
            }
            if (len > maxll) {
                for (String tag : Constants.BREAKING_TAGS) {
                    int p = d.lastIndexOf(tag, maxll);
                    if (p <= 0 || p >= len) continue;
                    return d.substring(0, p + tag.length()) + Utils.breakHtmlString(d.substring(p + tag.length()), maxll);
                }
                int p = d.lastIndexOf(32, maxll);
                if (p <= 0) {
                    p = d.indexOf(32, maxll);
                }
                if (p > 0 && p < len) {
                    return d.substring(0, p) + "<br>" + Utils.breakHtmlString(d.substring(p + 1), maxll);
                }
                return d;
            }
            return d;
        }
        return null;
    }

    public static String convertHtmlBreakToLineSeparator(String s) {
        return s.replaceAll("<br>", Constants.LINE_SEPARATOR);
    }

    public static String stripHtml(String s) {
        String o = null;
        if (s != null) {
            o = s.replaceAll("<.*?>", "");
        }
        return o;
    }

    public static boolean containsHtml(String text) {
        return text != null && text.indexOf(60) != -1 && text.indexOf(62) != -1;
    }

    public static EmptyPrintStream getEmptyPrintStream() {
        if (emptyStream == null) {
            emptyStream = new EmptyPrintStream();
        }
        return emptyStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getServerClock(InitialLdapContext ctx) {
        long time = -1L;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(0);
        ctls.setReturningAttributes(new String[]{"currentTime"});
        String filter = "(objectclass=*)";
        try {
            LdapName jndiName = new LdapName("cn=monitor");
            NamingEnumeration<SearchResult> listeners = ctx.search((Name)jndiName, filter, ctls);
            try {
                while (listeners.hasMore()) {
                    SearchResult sr = listeners.next();
                    String v = Utils.getFirstValue(sr, "currentTime");
                    TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
                    formatter.setTimeZone(utcTimeZone);
                    time = formatter.parse(v).getTime();
                }
            }
            finally {
                listeners.close();
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error retrieving server current time: " + t, t);
        }
        return time;
    }

    public static void checkJavaVersion() throws IncompatibleVersionException {
        String vendor = System.getProperty("java.vendor");
        String version = System.getProperty("java.version");
        for (CompatibleJava i : CompatibleJava.values()) {
            boolean versionCompatible;
            if (!i.getVendor().equalsIgnoreCase(vendor)) continue;
            boolean bl = versionCompatible = i.getVersion().compareToIgnoreCase(version) <= 0;
            if (versionCompatible) continue;
            String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            throw new IncompatibleVersionException(QuickSetupMessages.ERR_INCOMPATIBLE_VERSION.get(i.getVersion(), version, javaBin), null);
        }
        if (Utils.isWebStart()) {
            try {
                ServiceManager.lookup((String)JNLP_SERVICE_NAME);
            }
            catch (Throwable t) {
                String setupFile = Utils.isWindows() ? "setup.bat" : "setup";
                throw new IncompatibleVersionException(QuickSetupMessages.INFO_DOWNLOADING_ERROR_NO_SERVICE_FOUND.get(JNLP_SERVICE_NAME, setupFile), t);
            }
        }
    }

    public static boolean isLocalHost(String host) {
        boolean isLocalHost = false;
        if (!"localhost".equalsIgnoreCase(host)) {
            try {
                InetAddress localAddress = InetAddress.getLocalHost();
                InetAddress[] addresses = InetAddress.getAllByName(host);
                for (int i = 0; i < addresses.length && !isLocalHost; ++i) {
                    isLocalHost = localAddress.equals(addresses[i]);
                }
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Failing checking host names: " + t, t);
            }
        } else {
            isLocalHost = true;
        }
        return isLocalHost;
    }

    static String escapeHtml(String rawString) {
        StringBuilder buffer = new StringBuilder();
        block6: for (int i = 0; i < rawString.length(); ++i) {
            char c = rawString.charAt(i);
            switch (c) {
                case '<': {
                    buffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buffer.append("&quot;");
                    continue block6;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public static String getHtml(String text) {
        StringBuilder buffer = new StringBuilder();
        if (text != null) {
            text = text.replaceAll("\r\n", "\n");
            String[] lines = text.split("[\n\r\u0085\u2028\u2029]");
            for (int i = 0; i < lines.length; ++i) {
                if (i != 0) {
                    buffer.append("<br>");
                }
                buffer.append(Utils.escapeHtml(lines[i]));
            }
        }
        return buffer.toString();
    }

    public static <T> T getCustomizedObject(String fieldName, T defaultValue, Class<T> valueClass) {
        T value = defaultValue;
        if (!Utils.isWebStart()) {
            try {
                Class<?> c = Class.forName(CUSTOMIZATION_CLASS_NAME);
                Object obj = c.newInstance();
                value = valueClass.cast(c.getField(fieldName).get(obj));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return value;
    }

    public static String addWordBreaks(String htmlString, int from, int spacing) {
        StringBuilder sb = new StringBuilder();
        boolean insideTag = false;
        int totalAddedChars = 0;
        int addedChars = 0;
        for (int i = 0; i < htmlString.length(); ++i) {
            char c = htmlString.charAt(i);
            sb.append(c);
            if (c == '<') {
                insideTag = true;
            } else if (c == '>' && insideTag) {
                insideTag = false;
            }
            if (!insideTag && c != '>') {
                ++addedChars;
                ++totalAddedChars;
            }
            if (addedChars <= spacing || totalAddedChars <= from || insideTag) continue;
            sb.append("<wbr>");
            addedChars = 0;
        }
        return sb.toString();
    }

    public static String getDataDisplayString(UserData userInstallData) {
        Message msg;
        boolean createSuffix;
        DataReplicationOptions repl = userInstallData.getReplicationOptions();
        SuffixesToReplicateOptions suf = userInstallData.getSuffixesToReplicateOptions();
        boolean bl = createSuffix = repl.getType() == DataReplicationOptions.Type.FIRST_IN_TOPOLOGY || repl.getType() == DataReplicationOptions.Type.STANDALONE || suf.getType() == SuffixesToReplicateOptions.Type.NEW_SUFFIX_IN_TOPOLOGY;
        if (createSuffix) {
            Message arg2;
            NewSuffixOptions options = userInstallData.getNewSuffixOptions();
            switch (options.getType()) {
                case CREATE_BASE_ENTRY: {
                    arg2 = QuickSetupMessages.INFO_REVIEW_CREATE_BASE_ENTRY_LABEL.get(options.getBaseDns().getFirst());
                    break;
                }
                case LEAVE_DATABASE_EMPTY: {
                    arg2 = QuickSetupMessages.INFO_REVIEW_LEAVE_DATABASE_EMPTY_LABEL.get();
                    break;
                }
                case IMPORT_FROM_LDIF_FILE: {
                    arg2 = QuickSetupMessages.INFO_REVIEW_IMPORT_LDIF.get(options.getLDIFPaths().getFirst());
                    break;
                }
                case IMPORT_AUTOMATICALLY_GENERATED_DATA: {
                    arg2 = QuickSetupMessages.INFO_REVIEW_IMPORT_AUTOMATICALLY_GENERATED.get(String.valueOf(options.getNumberEntries()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: " + (Object)((Object)options.getType()));
                }
            }
            msg = options.getBaseDns().isEmpty() ? QuickSetupMessages.INFO_REVIEW_CREATE_NO_SUFFIX.get() : (options.getBaseDns().size() > 1 ? QuickSetupMessages.INFO_REVIEW_CREATE_SUFFIX.get(Utils.listToString(options.getBaseDns(), Constants.LINE_SEPARATOR), arg2) : QuickSetupMessages.INFO_REVIEW_CREATE_SUFFIX.get(options.getBaseDns().getFirst(), arg2));
        } else {
            StringBuilder buf = new StringBuilder();
            Set<SuffixDescriptor> suffixes = suf.getSuffixes();
            for (SuffixDescriptor suffix : suffixes) {
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(suffix.getDN());
            }
            msg = QuickSetupMessages.INFO_REVIEW_REPLICATE_SUFFIX.get(buf.toString());
        }
        return msg.toString();
    }

    public static String getSecurityOptionsString(SecurityOptions ops, boolean html) {
        StringBuilder buf = new StringBuilder();
        if (ops.getCertificateType() == SecurityOptions.CertificateType.NO_CERTIFICATE) {
            buf.append(QuickSetupMessages.INFO_NO_SECURITY.get());
        } else {
            Message certMsg;
            if (ops.getEnableStartTLS()) {
                buf.append(QuickSetupMessages.INFO_ENABLE_STARTTLS.get());
            }
            if (ops.getEnableSSL()) {
                if (buf.length() > 0) {
                    if (html) {
                        buf.append("<br>");
                    } else {
                        buf.append("\n");
                    }
                }
                buf.append(QuickSetupMessages.INFO_ENABLE_SSL.get(String.valueOf(ops.getSslPort())));
            }
            if (html) {
                buf.append("<br>");
            } else {
                buf.append("\n");
            }
            switch (ops.getCertificateType()) {
                case SELF_SIGNED_CERTIFICATE: {
                    certMsg = QuickSetupMessages.INFO_SELF_SIGNED_CERTIFICATE.get();
                    break;
                }
                case JKS: {
                    certMsg = QuickSetupMessages.INFO_JKS_CERTIFICATE.get();
                    break;
                }
                case JCEKS: {
                    certMsg = QuickSetupMessages.INFO_JCEKS_CERTIFICATE.get();
                    break;
                }
                case PKCS11: {
                    certMsg = QuickSetupMessages.INFO_PKCS11_CERTIFICATE.get();
                    break;
                }
                case PKCS12: {
                    certMsg = QuickSetupMessages.INFO_PKCS12_CERTIFICATE.get();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown certificate options type: " + (Object)((Object)ops.getCertificateType()));
                }
            }
            buf.append(certMsg);
        }
        if (html) {
            return "<html>" + UIFactory.applyFontToHtml(buf.toString(), UIFactory.SECONDARY_FIELD_VALID_FONT);
        }
        return buf.toString();
    }

    public static String getFormattedEquivalentCommandLine(ArrayList<String> cmd, ProgressMessageFormatter formatter) {
        StringBuilder builder = new StringBuilder();
        builder.append(formatter.getFormattedProgress(Message.raw(cmd.get(0), new Object[0])));
        int initialIndex = 1;
        StringBuilder sbSeparator = new StringBuilder();
        sbSeparator.append(formatter.getSpace());
        if (!Utils.isWindows()) {
            sbSeparator.append("\\");
            sbSeparator.append(formatter.getLineBreak());
            for (int i = 0; i < 10; ++i) {
                sbSeparator.append(formatter.getSpace());
            }
        }
        String lineSeparator = sbSeparator.toString();
        for (int i = initialIndex; i < cmd.size(); ++i) {
            String s = cmd.get(i);
            if (s.startsWith("-")) {
                builder.append(lineSeparator);
                builder.append(formatter.getFormattedProgress(Message.raw(s, new Object[0])));
                continue;
            }
            builder.append(formatter.getSpace());
            builder.append(formatter.getFormattedProgress(Message.raw(Utils.escapeCommandLineValue(s), new Object[0])));
        }
        return builder.toString();
    }

    public static String escapeCommandLineValue(String value) {
        StringBuilder b = new StringBuilder();
        if (Utils.isUnix()) {
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                boolean charToEscapeFound = false;
                for (int j = 0; j < charsToEscape.length && !charToEscapeFound; ++j) {
                    charToEscapeFound = c == charsToEscape[j];
                }
                if (charToEscapeFound) {
                    b.append('\\');
                }
                b.append(c);
            }
        } else {
            b.append('\"').append(value).append('\"');
        }
        return b.toString();
    }

    public static ArrayList<String> getSetupEquivalentCommandLine(UserData userData) {
        ArrayList<String> cmdLine = new ArrayList<String>();
        String setupFile = Utils.isWindows() ? "setup.bat" : "setup";
        cmdLine.add(Utils.getInstallDir(userData) + setupFile);
        cmdLine.add("--cli");
        for (String baseDN : Utils.getBaseDNs(userData)) {
            cmdLine.add("--baseDN");
            cmdLine.add(baseDN);
        }
        switch (userData.getNewSuffixOptions().getType()) {
            case CREATE_BASE_ENTRY: {
                cmdLine.add("--addBaseEntry");
                break;
            }
            case IMPORT_AUTOMATICALLY_GENERATED_DATA: {
                cmdLine.add("--sampleData");
                cmdLine.add(String.valueOf(userData.getNewSuffixOptions().getNumberEntries()));
                break;
            }
            case IMPORT_FROM_LDIF_FILE: {
                String skipFile;
                for (String ldifFile : userData.getNewSuffixOptions().getLDIFPaths()) {
                    cmdLine.add("--ldifFile");
                    cmdLine.add(ldifFile);
                }
                String rejectFile = userData.getNewSuffixOptions().getRejectedFile();
                if (rejectFile != null) {
                    cmdLine.add("--rejectFile");
                    cmdLine.add(rejectFile);
                }
                if ((skipFile = userData.getNewSuffixOptions().getSkippedFile()) == null) break;
                cmdLine.add("--skipFile");
                cmdLine.add(skipFile);
            }
        }
        cmdLine.add("--ldapPort");
        cmdLine.add(String.valueOf(userData.getServerPort()));
        cmdLine.add("--adminConnectorPort");
        cmdLine.add(String.valueOf(userData.getAdminConnectorPort()));
        if (userData.getServerJMXPort() != -1) {
            cmdLine.add("--jmxPort");
            cmdLine.add(String.valueOf(userData.getServerJMXPort()));
        }
        cmdLine.add("--rootUserDN");
        cmdLine.add(userData.getDirectoryManagerDn());
        cmdLine.add("--rootUserPassword");
        cmdLine.add(OBFUSCATED_VALUE);
        if (Utils.isWindows() && userData.getEnableWindowsService()) {
            cmdLine.add("--enableWindowsService");
        }
        if (userData.getReplicationOptions().getType() == DataReplicationOptions.Type.STANDALONE && !userData.getStartServer()) {
            cmdLine.add("--doNotStart");
        }
        if (userData.getSecurityOptions().getEnableStartTLS()) {
            cmdLine.add("--enableStartTLS");
        }
        if (userData.getSecurityOptions().getEnableSSL()) {
            cmdLine.add("--ldapsPort");
            cmdLine.add(String.valueOf(userData.getSecurityOptions().getSslPort()));
        }
        switch (userData.getSecurityOptions().getCertificateType()) {
            case SELF_SIGNED_CERTIFICATE: {
                cmdLine.add("--generateSelfSignedCertificate");
                cmdLine.add("--hostName");
                cmdLine.add(userData.getHostName());
                break;
            }
            case JKS: {
                cmdLine.add("--useJavaKeystore");
                cmdLine.add(userData.getSecurityOptions().getKeystorePath());
                if (userData.getSecurityOptions().getKeystorePassword() != null) {
                    cmdLine.add("--keyStorePassword");
                    cmdLine.add(OBFUSCATED_VALUE);
                }
                if (userData.getSecurityOptions().getAliasToUse() == null) break;
                cmdLine.add("--certNickname");
                cmdLine.add(userData.getSecurityOptions().getAliasToUse());
                break;
            }
            case JCEKS: {
                cmdLine.add("--useJCEKS");
                cmdLine.add(userData.getSecurityOptions().getKeystorePath());
                if (userData.getSecurityOptions().getKeystorePassword() != null) {
                    cmdLine.add("--keyStorePassword");
                    cmdLine.add(OBFUSCATED_VALUE);
                }
                if (userData.getSecurityOptions().getAliasToUse() == null) break;
                cmdLine.add("--certNickname");
                cmdLine.add(userData.getSecurityOptions().getAliasToUse());
                break;
            }
            case PKCS12: {
                cmdLine.add("--usePkcs12keyStore");
                cmdLine.add(userData.getSecurityOptions().getKeystorePath());
                if (userData.getSecurityOptions().getKeystorePassword() != null) {
                    cmdLine.add("--keyStorePassword");
                    cmdLine.add(OBFUSCATED_VALUE);
                }
                if (userData.getSecurityOptions().getAliasToUse() == null) break;
                cmdLine.add("--certNickname");
                cmdLine.add(userData.getSecurityOptions().getAliasToUse());
                break;
            }
            case PKCS11: {
                cmdLine.add("--usePkcs11Keystore");
                if (userData.getSecurityOptions().getKeystorePassword() != null) {
                    cmdLine.add("--keyStorePassword");
                    cmdLine.add(OBFUSCATED_VALUE);
                }
                if (userData.getSecurityOptions().getAliasToUse() == null) break;
                cmdLine.add("--certNickname");
                cmdLine.add(userData.getSecurityOptions().getAliasToUse());
            }
        }
        cmdLine.add("--no-prompt");
        cmdLine.add("--noPropertiesFile");
        return cmdLine;
    }

    public static ArrayList<ArrayList<String>> getDsReplicationEnableEquivalentCommandLines(UserData userData) {
        ArrayList<ArrayList<String>> cmdLines = new ArrayList<ArrayList<String>>();
        Map<ServerDescriptor, Set<String>> hmServerBaseDNs = Utils.getServerDescriptorBaseDNMap(userData);
        for (ServerDescriptor server : hmServerBaseDNs.keySet()) {
            cmdLines.add(Utils.getDsReplicationEnableEquivalentCommandLine(userData, hmServerBaseDNs.get(server), server));
        }
        return cmdLines;
    }

    public static ArrayList<ArrayList<String>> getDsReplicationInitializeEquivalentCommandLines(UserData userData) {
        ArrayList<ArrayList<String>> cmdLines = new ArrayList<ArrayList<String>>();
        Map<ServerDescriptor, Set<String>> hmServerBaseDNs = Utils.getServerDescriptorBaseDNMap(userData);
        for (ServerDescriptor server : hmServerBaseDNs.keySet()) {
            cmdLines.add(Utils.getDsReplicationInitializeEquivalentCommandLine(userData, hmServerBaseDNs.get(server), server));
        }
        return cmdLines;
    }

    private static ArrayList<String> getDsReplicationEnableEquivalentCommandLine(UserData userData, Set<String> baseDNs, ServerDescriptor server) {
        ArrayList<String> cmdLine = new ArrayList<String>();
        String cmdName = Utils.getCommandLinePath(userData, "dsreplication");
        cmdLine.add(cmdName);
        cmdLine.add("enable");
        DataReplicationOptions replOptions = userData.getReplicationOptions();
        cmdLine.add("--host1");
        cmdLine.add(server.getHostName());
        cmdLine.add("--port1");
        cmdLine.add(String.valueOf(server.getEnabledAdministrationPorts().get(0)));
        AuthenticationData authData = userData.getReplicationOptions().getAuthenticationData();
        if (!Utils.areDnsEqual(authData.getDn(), ADSContext.getAdministratorDN(userData.getGlobalAdministratorUID()))) {
            cmdLine.add("--bindDN1");
            cmdLine.add(authData.getDn());
            cmdLine.add("--bindPassword1");
            cmdLine.add(OBFUSCATED_VALUE);
        }
        for (ServerDescriptor s : userData.getRemoteWithNoReplicationPort().keySet()) {
            if (!s.getAdminConnectorURL().equals(server.getAdminConnectorURL())) continue;
            AuthenticationData remoteRepl = userData.getRemoteWithNoReplicationPort().get(server);
            int remoteReplicationPort = remoteRepl.getPort();
            cmdLine.add("--replicationPort1");
            cmdLine.add(String.valueOf(remoteReplicationPort));
            if (!remoteRepl.useSecureConnection()) continue;
            cmdLine.add("--secureReplication1");
        }
        cmdLine.add("--host2");
        cmdLine.add(userData.getHostName());
        cmdLine.add("--port2");
        cmdLine.add(String.valueOf(userData.getAdminConnectorPort()));
        cmdLine.add("--bindDN2");
        cmdLine.add(userData.getDirectoryManagerDn());
        cmdLine.add("--bindPassword2");
        cmdLine.add(OBFUSCATED_VALUE);
        if (replOptions.getReplicationPort() != -1) {
            cmdLine.add("--replicationPort2");
            cmdLine.add(String.valueOf(replOptions.getReplicationPort()));
            if (replOptions.useSecureReplication()) {
                cmdLine.add("--secureReplication2");
            }
        }
        for (String baseDN : baseDNs) {
            cmdLine.add("--baseDN");
            cmdLine.add(baseDN);
        }
        cmdLine.add("--adminUID");
        cmdLine.add(userData.getGlobalAdministratorUID());
        cmdLine.add("--adminPassword");
        cmdLine.add(OBFUSCATED_VALUE);
        cmdLine.add("--trustAll");
        cmdLine.add("--no-prompt");
        cmdLine.add("--noPropertiesFile");
        return cmdLine;
    }

    private static String getCommandLinePath(UserData userData, String scriptBasicName) {
        String cmdLineName = Utils.isWindows() ? Utils.getInstallDir(userData) + "bat" + File.separatorChar + scriptBasicName + ".bat" : Utils.getInstallDir(userData) + "bin" + File.separatorChar + scriptBasicName;
        return cmdLineName;
    }

    private static String getInstallDir(UserData userData) {
        if (Utils.isWebStart() || installDir == null) {
            File f = Utils.isWebStart() ? new File(userData.getServerLocation()) : Installation.getLocal().getRootDirectory();
            try {
                installDir = f.getCanonicalPath();
            }
            catch (Throwable t) {
                installDir = f.getAbsolutePath();
            }
            if (installDir.lastIndexOf(File.separatorChar) != installDir.length() - 1) {
                installDir = installDir + File.separatorChar;
            }
        }
        return installDir;
    }

    private static ArrayList<String> getDsReplicationInitializeEquivalentCommandLine(UserData userData, Set<String> baseDNs, ServerDescriptor server) {
        ArrayList<String> cmdLine = new ArrayList<String>();
        String cmdName = Utils.getCommandLinePath(userData, "dsreplication");
        cmdLine.add(cmdName);
        cmdLine.add("initialize");
        cmdLine.add("--hostSource");
        cmdLine.add(server.getHostName());
        cmdLine.add("--portSource");
        cmdLine.add(String.valueOf(server.getEnabledAdministrationPorts().get(0)));
        cmdLine.add("--hostDestination");
        cmdLine.add(userData.getHostName());
        cmdLine.add("--portDestination");
        cmdLine.add(String.valueOf(userData.getAdminConnectorPort()));
        for (String baseDN : baseDNs) {
            cmdLine.add("--baseDN");
            cmdLine.add(baseDN);
        }
        cmdLine.add("--adminUID");
        cmdLine.add(userData.getGlobalAdministratorUID());
        cmdLine.add("--adminPassword");
        cmdLine.add(OBFUSCATED_VALUE);
        cmdLine.add("--trustAll");
        cmdLine.add("--no-prompt");
        cmdLine.add("--noPropertiesFile");
        return cmdLine;
    }

    private static ArrayList<String> getBaseDNs(UserData userData) {
        boolean createSuffix;
        ArrayList<String> baseDNs = new ArrayList<String>();
        DataReplicationOptions repl = userData.getReplicationOptions();
        SuffixesToReplicateOptions suf = userData.getSuffixesToReplicateOptions();
        boolean bl = createSuffix = repl.getType() == DataReplicationOptions.Type.FIRST_IN_TOPOLOGY || repl.getType() == DataReplicationOptions.Type.STANDALONE || suf.getType() == SuffixesToReplicateOptions.Type.NEW_SUFFIX_IN_TOPOLOGY;
        if (createSuffix) {
            NewSuffixOptions options = userData.getNewSuffixOptions();
            baseDNs.addAll(options.getBaseDns());
        } else {
            Set<SuffixDescriptor> suffixes = suf.getSuffixes();
            for (SuffixDescriptor suffix : suffixes) {
                baseDNs.add(suffix.getDN());
            }
        }
        return baseDNs;
    }

    private static Map<ServerDescriptor, Set<String>> getServerDescriptorBaseDNMap(UserData userData) {
        HashMap<ServerDescriptor, Set<String>> hm = new HashMap<ServerDescriptor, Set<String>>();
        Set<SuffixDescriptor> suffixes = userData.getSuffixesToReplicateOptions().getSuffixes();
        AuthenticationData authData = userData.getReplicationOptions().getAuthenticationData();
        String ldapURL = ConnectionUtils.getLDAPUrl(authData.getHostName(), authData.getPort(), authData.useSecureConnection());
        for (SuffixDescriptor suffix : suffixes) {
            ReplicaDescriptor replica;
            boolean found = false;
            for (ReplicaDescriptor replica2 : suffix.getReplicas()) {
                if (!ldapURL.equalsIgnoreCase(replica2.getServer().getAdminConnectorURL())) continue;
                found = true;
                LinkedHashSet<String> baseDNs = (LinkedHashSet<String>)hm.get(replica2.getServer());
                if (baseDNs == null) {
                    baseDNs = new LinkedHashSet<String>();
                    hm.put(replica2.getServer(), baseDNs);
                }
                baseDNs.add(suffix.getDN());
                break;
            }
            if (!found) {
                for (ReplicaDescriptor replica2 : suffix.getReplicas()) {
                    if (!hm.keySet().contains(replica2.getServer())) continue;
                    ((Set)hm.get(replica2.getServer())).add(suffix.getDN());
                    found = true;
                    break;
                }
            }
            if (found || (replica = suffix.getReplicas().iterator().next()) == null) continue;
            LinkedHashSet<String> baseDNs = new LinkedHashSet<String>();
            hm.put(replica.getServer(), baseDNs);
            baseDNs.add(suffix.getDN());
        }
        return hm;
    }

    public static ArrayList<ArrayList<String>> getDsConfigReplicationEnableEquivalentCommandLines(UserData userData) {
        ArrayList<ArrayList<String>> cmdLines = new ArrayList<ArrayList<String>>();
        String cmdName = Utils.getCommandLinePath(userData, "dsconfig");
        ArrayList<String> connectionArgs = new ArrayList<String>();
        connectionArgs.add("--hostName");
        connectionArgs.add(userData.getHostName());
        connectionArgs.add("--port");
        connectionArgs.add(String.valueOf(userData.getAdminConnectorPort()));
        connectionArgs.add("--bindDN");
        connectionArgs.add(userData.getDirectoryManagerDn());
        connectionArgs.add("--bindPassword");
        connectionArgs.add(OBFUSCATED_VALUE);
        connectionArgs.add("--trustAll");
        connectionArgs.add("--no-prompt");
        connectionArgs.add("--noPropertiesFile");
        ArrayList<String> cmdReplicationServer = new ArrayList<String>();
        cmdReplicationServer.add(cmdName);
        cmdReplicationServer.add("create-replication-server");
        cmdReplicationServer.add("--provider-name");
        cmdReplicationServer.add("Multimaster Synchronization");
        cmdReplicationServer.add("--set");
        cmdReplicationServer.add("replication-port:" + userData.getReplicationOptions().getReplicationPort());
        cmdReplicationServer.add("--set");
        cmdReplicationServer.add("replication-server-id:1");
        cmdReplicationServer.add("--type");
        cmdReplicationServer.add("generic");
        cmdReplicationServer.addAll(connectionArgs);
        cmdLines.add(cmdReplicationServer);
        for (String baseDN : Utils.getBaseDNs(userData)) {
            ArrayList<String> cmdDomain = new ArrayList<String>();
            cmdDomain.add(cmdName);
            cmdDomain.add("create-replication-domain");
            cmdDomain.add("--provider-name");
            cmdDomain.add("Multimaster Synchronization");
            cmdDomain.add("--set");
            cmdDomain.add("base-dn:" + baseDN);
            cmdDomain.add("--set");
            cmdDomain.add("replication-server:" + userData.getHostName() + ":" + userData.getReplicationOptions().getReplicationPort());
            cmdDomain.add("--set");
            cmdDomain.add("server-id:1");
            cmdDomain.add("--type");
            cmdDomain.add("generic");
            cmdDomain.add("--domain-name");
            cmdDomain.add(baseDN);
            cmdDomain.addAll(connectionArgs);
            cmdLines.add(cmdDomain);
        }
        return cmdLines;
    }
}

