/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.ClassLoaderProvider;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyValueVisitor;
import org.opends.server.util.Validator;

public final class ClassPropertyDefinition
extends PropertyDefinition<String> {
    private static final String CLASS_RE = "^([A-Za-z][A-Za-z0-9_]*\\.)*[A-Za-z][A-Za-z0-9_]*(\\$[A-Za-z0-9_]+)*$";
    private static boolean allowClassValidation = true;
    private final List<String> instanceOfInterfaces;

    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    public static boolean isAllowClassValidation() {
        return allowClassValidation;
    }

    public static void setAllowClassValidation(boolean value) {
        allowClassValidation = value;
    }

    private static Class<?> loadClass(String className, boolean initialize) throws ClassNotFoundException, LinkageError {
        return Class.forName(className, initialize, ClassLoaderProvider.getInstance().getClassLoader());
    }

    private ClassPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<String> defaultBehavior, List<String> instanceOfInterfaces) {
        super(d, String.class, propertyName, options, adminAction, defaultBehavior);
        this.instanceOfInterfaces = Collections.unmodifiableList(new LinkedList<String>(instanceOfInterfaces));
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitClass(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, String value, P p) {
        return v.visitClass(this, value, p);
    }

    @Override
    public String decodeValue(String value) throws IllegalPropertyValueStringException {
        Validator.ensureNotNull(value);
        try {
            this.validateValue(value);
        }
        catch (IllegalPropertyValueException e) {
            throw new IllegalPropertyValueStringException(this, value, e.getCause());
        }
        return value;
    }

    public List<String> getInstanceOfInterface() {
        return this.instanceOfInterfaces;
    }

    public <T> Class<? extends T> loadClass(String className, Class<T> instanceOf) throws IllegalPropertyValueException, ClassCastException {
        Validator.ensureNotNull(className, instanceOf);
        this.validateClassName(className);
        Class<?> theClass = this.validateClassInterfaces(className, true);
        return theClass.asSubclass(instanceOf);
    }

    @Override
    public String normalizeValue(String value) throws IllegalPropertyValueException {
        Validator.ensureNotNull(value);
        return value.trim();
    }

    @Override
    public void validateValue(String value) throws IllegalPropertyValueException {
        Validator.ensureNotNull(value);
        this.validateClassName(value);
        if (allowClassValidation) {
            this.validateClassInterfaces(value, false);
        }
    }

    private Class<?> validateClassInterfaces(String className, boolean initialize) throws IllegalPropertyValueException {
        Class<?> theClass = this.loadClassForValidation(className, className, initialize);
        for (String i : this.instanceOfInterfaces) {
            Class<?> instanceOfClass = this.loadClassForValidation(className, i, initialize);
            if (instanceOfClass.isAssignableFrom(theClass)) continue;
            throw new IllegalPropertyValueException(this, className);
        }
        return theClass;
    }

    private Class<?> loadClassForValidation(String componentClassName, String classToBeLoaded, boolean initialize) {
        try {
            return ClassPropertyDefinition.loadClass(classToBeLoaded.trim(), initialize);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalPropertyValueException(this, componentClassName, (Throwable)e);
        }
        catch (LinkageError e) {
            throw new IllegalPropertyValueException(this, componentClassName, (Throwable)e);
        }
    }

    private void validateClassName(String className) throws IllegalPropertyValueException {
        String nvalue = className.trim();
        if (!nvalue.matches(CLASS_RE)) {
            throw new IllegalPropertyValueException(this, className);
        }
    }

    public static class Builder
    extends PropertyDefinition.AbstractBuilder<String, ClassPropertyDefinition> {
        private List<String> instanceOfInterfaces = new LinkedList<String>();

        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        public final void addInstanceOf(String className) {
            Validator.ensureNotNull(className);
            String value = className.trim();
            if (!value.matches(ClassPropertyDefinition.CLASS_RE)) {
                throw new IllegalArgumentException("\"" + value + "\" is not a valid Java class name");
            }
            if (ClassPropertyDefinition.isAllowClassValidation()) {
                try {
                    ClassPropertyDefinition.loadClass(value, true);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            this.instanceOfInterfaces.add(value);
        }

        @Override
        protected ClassPropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<String> defaultBehavior) {
            return new ClassPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior, this.instanceOfInterfaces);
        }
    }
}

