/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum DurationUnit {
    DAYS(86400000L, "d", "days"),
    HOURS(3600000L, "h", "hours"),
    MILLI_SECONDS(1L, "ms", "milliseconds"),
    MINUTES(60000L, "m", "minutes"),
    SECONDS(1000L, "s", "seconds"),
    WEEKS(604800000L, "w", "weeks");

    private static final Map<String, DurationUnit> nameToUnit;
    private final String longName;
    private final String shortName;
    private final long sz;

    public static DurationUnit getUnit(String s) throws IllegalArgumentException {
        DurationUnit unit = nameToUnit.get(s.trim().toLowerCase());
        if (unit == null) {
            throw new IllegalArgumentException("Illegal duration unit \"" + s + "\"");
        }
        return unit;
    }

    public static long parseValue(String s) throws NumberFormatException {
        return DurationUnit.parseValue(s, null);
    }

    public static long parseValue(String s, DurationUnit defaultUnit) throws NumberFormatException {
        DurationUnit unit;
        double d;
        String ns = s.trim();
        if (ns.length() == 0) {
            throw new NumberFormatException("Empty duration value \"" + s + "\"");
        }
        Pattern p1 = Pattern.compile("^\\s*((\\d+)\\s*w)?\\s*((\\d+)\\s*d)?\\s*((\\d+)\\s*h)?\\s*((\\d+)\\s*m)?\\s*((\\d+)\\s*s)?\\s*((\\d+)\\s*ms)?\\s*$", 2);
        Matcher m1 = p1.matcher(ns);
        if (m1.matches()) {
            String weeks = m1.group(2);
            String days = m1.group(4);
            String hours = m1.group(6);
            String minutes = m1.group(8);
            String seconds = m1.group(10);
            String ms = m1.group(12);
            long duration = 0L;
            try {
                if (weeks != null) {
                    duration += Long.valueOf(weeks) * WEEKS.getDuration();
                }
                if (days != null) {
                    duration += Long.valueOf(days) * DAYS.getDuration();
                }
                if (hours != null) {
                    duration += Long.valueOf(hours) * HOURS.getDuration();
                }
                if (minutes != null) {
                    duration += Long.valueOf(minutes) * MINUTES.getDuration();
                }
                if (seconds != null) {
                    duration += Long.valueOf(seconds) * SECONDS.getDuration();
                }
                if (ms != null) {
                    duration += Long.valueOf(ms) * MILLI_SECONDS.getDuration();
                }
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Invalid duration value \"" + s + "\"");
            }
            return duration;
        }
        Pattern p2 = Pattern.compile("^\\s*(\\d+(\\.\\d+)?)\\s*(\\w+)?\\s*$");
        Matcher m2 = p2.matcher(ns);
        if (!m2.matches()) {
            throw new NumberFormatException("Invalid duration value \"" + s + "\"");
        }
        try {
            d = Double.valueOf(m2.group(1));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Invalid duration value \"" + s + "\"");
        }
        String unitString = m2.group(3);
        if (unitString == null) {
            if (defaultUnit == null) {
                throw new NumberFormatException("Invalid duration value \"" + s + "\"");
            }
            unit = defaultUnit;
        } else {
            try {
                unit = DurationUnit.getUnit(unitString);
            }
            catch (IllegalArgumentException e) {
                throw new NumberFormatException("Invalid duration value \"" + s + "\"");
            }
        }
        return unit.toMilliSeconds(d);
    }

    public static String toString(long duration) throws IllegalArgumentException {
        if (duration < 0L) {
            throw new IllegalArgumentException("Negative duration " + duration);
        }
        if (duration == 0L) {
            return "0 ms";
        }
        DurationUnit[] units = new DurationUnit[]{WEEKS, DAYS, HOURS, MINUTES, SECONDS, MILLI_SECONDS};
        long remainder = duration;
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (DurationUnit unit : units) {
            long count = remainder / unit.getDuration();
            if (count <= 0L) continue;
            if (!isFirst) {
                builder.append(' ');
            }
            builder.append(count);
            builder.append(' ');
            builder.append(unit.getShortName());
            remainder -= count * unit.getDuration();
            isFirst = false;
        }
        return builder.toString();
    }

    private DurationUnit(long sz, String shortName, String longName) {
        this.sz = sz;
        this.shortName = shortName;
        this.longName = longName;
    }

    public double fromMilliSeconds(long duration) {
        return (double)duration / (double)this.sz;
    }

    public long getDuration() {
        return this.sz;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public long toMilliSeconds(double duration) {
        return (long)((double)this.sz * duration);
    }

    public String toString() {
        return this.shortName;
    }

    static {
        nameToUnit = new HashMap<String, DurationUnit>();
        for (DurationUnit unit : DurationUnit.values()) {
            nameToUnit.put(unit.shortName, unit);
            nameToUnit.put(unit.longName, unit);
        }
    }
}

