/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.DefaultManagedObject;
import org.opends.server.admin.ManagedObjectDefinitionI18NResource;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.RelationDefinitionVisitor;
import org.opends.server.util.Validator;

public final class InstantiableRelationDefinition<C extends ConfigurationClient, S extends Configuration>
extends RelationDefinition<C, S> {
    private final PropertyDefinition<?> namingPropertyDefinition;
    private final String pluralName;
    private final Map<String, DefaultManagedObject<? extends C, ? extends S>> defaultManagedObjects;

    private InstantiableRelationDefinition(RelationDefinition.Common<C, S> common, String pluralName, PropertyDefinition<?> namingPropertyDefinition, Map<String, DefaultManagedObject<? extends C, ? extends S>> defaultManagedObjects) {
        super(common);
        this.pluralName = pluralName;
        this.namingPropertyDefinition = namingPropertyDefinition;
        this.defaultManagedObjects = defaultManagedObjects;
    }

    @Override
    public <R, P> R accept(RelationDefinitionVisitor<R, P> v, P p) {
        return v.visitInstantiable(this, p);
    }

    public DefaultManagedObject<? extends C, ? extends S> getDefaultManagedObject(String name) throws IllegalArgumentException {
        if (!this.defaultManagedObjects.containsKey(name)) {
            throw new IllegalArgumentException("unrecognized default managed object \"" + name + "\"");
        }
        return this.defaultManagedObjects.get(name);
    }

    public Set<String> getDefaultManagedObjectNames() {
        return Collections.unmodifiableSet(this.defaultManagedObjects.keySet());
    }

    public PropertyDefinition<?> getNamingPropertyDefinition() {
        return this.namingPropertyDefinition;
    }

    public String getPluralName() {
        return this.pluralName;
    }

    public Message getUserFriendlyPluralName() {
        return this.getUserFriendlyPluralName(Locale.getDefault());
    }

    public Message getUserFriendlyPluralName(Locale locale) {
        String property = "relation." + this.getName() + ".user-friendly-plural-name";
        return ManagedObjectDefinitionI18NResource.getInstance().getMessage(this.getParentDefinition(), property, locale);
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append("name=");
        builder.append(this.getName());
        builder.append(" type=collection parent=");
        builder.append(this.getParentDefinition().getName());
        builder.append(" child=");
        builder.append(this.getChildDefinition().getName());
    }

    @Override
    protected void initialize() throws Exception {
        for (DefaultManagedObject<C, S> dmo : this.defaultManagedObjects.values()) {
            dmo.initialize();
        }
    }

    public static final class Builder<C extends ConfigurationClient, S extends Configuration>
    extends RelationDefinition.AbstractBuilder<C, S, InstantiableRelationDefinition<C, S>> {
        private PropertyDefinition<?> namingPropertyDefinition = null;
        private final String pluralName;
        private final Map<String, DefaultManagedObject<? extends C, ? extends S>> defaultManagedObjects = new HashMap<String, DefaultManagedObject<? extends C, ? extends S>>();

        public Builder(AbstractManagedObjectDefinition<?, ?> pd, String name, String pluralName, AbstractManagedObjectDefinition<C, S> cd) {
            super(pd, name, cd);
            this.pluralName = pluralName;
        }

        public void setDefaultManagedObject(String name, DefaultManagedObject<? extends C, ? extends S> defaultManagedObject) {
            this.defaultManagedObjects.put(name, defaultManagedObject);
        }

        public void setNamingProperty(PropertyDefinition<?> namingPropertyDefinition) {
            Validator.ensureNotNull(namingPropertyDefinition);
            this.namingPropertyDefinition = namingPropertyDefinition;
        }

        @Override
        protected InstantiableRelationDefinition<C, S> buildInstance(RelationDefinition.Common<C, S> common) {
            return new InstantiableRelationDefinition(common, this.pluralName, this.namingPropertyDefinition, this.defaultManagedObjects);
        }
    }
}

