/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.cli;

import java.io.OutputStream;
import java.io.PrintStream;
import org.opends.admin.ads.ADSContextException;
import org.opends.messages.AdminMessages;
import org.opends.messages.DSConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.ClassLoaderProvider;
import org.opends.server.admin.client.cli.DsFrameworkCliParser;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.BuildVersion;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;

public class DsFrameworkCliMain {
    private static final String CLASS_NAME = "org.opends.server.admin.client.cli.DsFrameworkCliMain";
    private PrintStream err;
    private PrintStream out;

    public DsFrameworkCliMain(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
    }

    public static void main(String[] args) {
        int retCode = DsFrameworkCliMain.mainCLI(args, true, System.out, System.err);
        if (retCode != 0) {
            System.exit(retCode);
        }
    }

    public static int mainCLI(String[] args) {
        return DsFrameworkCliMain.mainCLI(args, true, System.out, System.err);
    }

    public static int mainCLI(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        DsFrameworkCliMain dsFrameworkCli = new DsFrameworkCliMain(out, err);
        return dsFrameworkCli.execute(args, initializeServer);
    }

    public int execute(String[] args, boolean initializeServer) {
        DsFrameworkCliParser argParser;
        try {
            Message toolDescription = AdminMessages.INFO_ADMIN_TOOL_DESCRIPTION.get();
            argParser = new DsFrameworkCliParser(CLASS_NAME, toolDescription, false);
            argParser.initializeParser(this.out);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            this.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return DsFrameworkCliReturnCode.CANNOT_INITIALIZE_ARGS.getReturnCode();
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            this.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            this.err.println(argParser.getUsage());
            return DsFrameworkCliReturnCode.ERROR_PARSING_ARGS.getReturnCode();
        }
        if (argParser.usageOrVersionDisplayed()) {
            return DsFrameworkCliReturnCode.SUCCESSFUL.getReturnCode();
        }
        try {
            BuildVersion.checkVersionMismatch();
        }
        catch (InitializationException e) {
            this.err.println(StaticUtils.wrapText(e.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (argParser.getSubCommand() == null) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(DSConfigMessages.ERR_DSCFG_ERROR_MISSING_SUBCOMMAND.get());
            this.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            this.err.println();
            this.err.println(argParser.getHelpUsageReference());
            return DsFrameworkCliReturnCode.ERROR_PARSING_ARGS.getReturnCode();
        }
        int ret = argParser.validateGlobalOptions(this.err);
        if (ret != DsFrameworkCliReturnCode.SUCCESSFUL_NOP.getReturnCode()) {
            return ret;
        }
        DsFrameworkCliReturnCode returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
        if (initializeServer) {
            DirectoryServer.bootstrapClient();
            try {
                ClassLoaderProvider.getInstance().enable();
            }
            catch (InitializationException e) {
                this.err.println(StaticUtils.wrapText(e.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                return DsFrameworkCliReturnCode.ERROR_UNEXPECTED.getReturnCode();
            }
            catch (IllegalStateException e) {
                this.err.println(StaticUtils.wrapText(e.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                return DsFrameworkCliReturnCode.ERROR_UNEXPECTED.getReturnCode();
            }
        }
        ADSContextException adsException = null;
        try {
            returnCode = argParser.performSubCommand(this.out, this.err);
        }
        catch (ADSContextException e) {
            adsException = e;
            returnCode = DsFrameworkCliReturnCode.getReturncodeFromAdsError(e.getError());
            if (returnCode == null) {
                returnCode = DsFrameworkCliReturnCode.ERROR_UNEXPECTED;
            }
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            this.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return DsFrameworkCliReturnCode.CANNOT_INITIALIZE_ARGS.getReturnCode();
        }
        Message msg = returnCode.getMessage();
        if (returnCode == DsFrameworkCliReturnCode.SUCCESSFUL || returnCode == DsFrameworkCliReturnCode.SUCCESSFUL_NOP) {
            if (argParser.isVerbose()) {
                this.out.println(StaticUtils.wrapText(msg.toString(), ServerConstants.MAX_LINE_WIDTH));
            }
        } else if (msg != null && msg.getDescriptor().getId() != AdminMessages.ERR_ADMIN_NO_MESSAGE.getId()) {
            MessageBuilder mb = new MessageBuilder(AdminMessages.INFO_ADMIN_ERROR.get());
            mb.append(msg);
            this.err.println(StaticUtils.wrapText(mb.toString(), ServerConstants.MAX_LINE_WIDTH));
            if (argParser.isVerbose() && adsException != null) {
                adsException.printStackTrace();
            }
        }
        return returnCode.getReturnCode();
    }
}

