/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.ldap;

import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.opends.messages.Message;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyValueVisitor;
import org.opends.server.admin.Reference;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.SetRelationDefinition;
import org.opends.server.admin.UnknownPropertyDefinitionException;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.client.ldap.LDAPDriver;
import org.opends.server.admin.client.ldap.LDAPNameBuilder;
import org.opends.server.admin.client.spi.AbstractManagedObject;
import org.opends.server.admin.client.spi.Driver;
import org.opends.server.admin.client.spi.Property;
import org.opends.server.admin.client.spi.PropertySet;

final class LDAPManagedObject<T extends ConfigurationClient>
extends AbstractManagedObject<T> {
    private final LDAPDriver driver;

    LDAPManagedObject(LDAPDriver driver, ManagedObjectDefinition<T, ? extends Configuration> d, ManagedObjectPath<T, ? extends Configuration> path, PropertySet properties, boolean existsOnServer, PropertyDefinition<?> namingPropertyDefinition) {
        super(d, path, properties, existsOnServer, namingPropertyDefinition);
        this.driver = driver;
    }

    @Override
    protected void addNewManagedObject() throws AuthorizationException, CommunicationException, OperationRejectedException, ConcurrentModificationException, ManagedObjectAlreadyExistsException {
        BasicAttribute oc;
        BasicAttributes attributes;
        LdapName dn;
        ManagedObjectDefinition d = this.getManagedObjectDefinition();
        ManagedObjectPath path = this.getManagedObjectPath();
        ManagedObjectPath<?, ?> parent = path.parent();
        try {
            if (!this.driver.managedObjectExists(parent)) {
                throw new ConcurrentModificationException();
            }
        }
        catch (ManagedObjectNotFoundException e) {
            throw new ConcurrentModificationException();
        }
        RelationDefinition r = path.getRelationDefinition();
        if ((r instanceof InstantiableRelationDefinition || r instanceof SetRelationDefinition) && !this.driver.entryExists(dn = r instanceof InstantiableRelationDefinition ? LDAPNameBuilder.create(parent, (InstantiableRelationDefinition)r, this.driver.getLDAPProfile()) : LDAPNameBuilder.create(parent, (SetRelationDefinition)r, this.driver.getLDAPProfile()))) {
            attributes = new BasicAttributes();
            oc = new BasicAttribute("objectClass");
            for (String objectClass : this.driver.getLDAPProfile().getRelationObjectClasses(r)) {
                oc.add(objectClass);
            }
            attributes.put(oc);
            Rdn rdn = dn.getRdn(dn.size() - 1);
            attributes.put(rdn.getType(), rdn.getValue().toString());
            try {
                this.driver.getLDAPConnection().createEntry(dn, attributes);
            }
            catch (OperationNotSupportedException e) {
                if (e.getMessage() == null) {
                    throw new OperationRejectedException(OperationRejectedException.OperationType.CREATE, d.getUserFriendlyName());
                }
                Message m = Message.raw("%s", e.getMessage());
                throw new OperationRejectedException(OperationRejectedException.OperationType.CREATE, d.getUserFriendlyName(), m);
            }
            catch (NamingException e) {
                this.driver.adaptNamingException(e);
            }
        }
        dn = LDAPNameBuilder.create(path, this.driver.getLDAPProfile());
        attributes = new BasicAttributes(true);
        oc = new BasicAttribute("objectclass");
        ManagedObjectDefinition definition = this.getManagedObjectDefinition();
        for (String objectClass : this.driver.getLDAPProfile().getObjectClasses(definition)) {
            oc.add(objectClass);
        }
        attributes.put(oc);
        PropertyDefinition<?> npd = this.getNamingPropertyDefinition();
        if (npd == null) {
            Rdn rdn = dn.getRdn(dn.size() - 1);
            attributes.put(rdn.getType(), rdn.getValue().toString());
        }
        for (PropertyDefinition<?> pd : definition.getAllPropertyDefinitions()) {
            String attrID = this.driver.getLDAPProfile().getAttributeName(definition, pd);
            BasicAttribute attribute = new BasicAttribute(attrID);
            this.encodeProperty(attribute, pd);
            if (attribute.size() == 0) continue;
            attributes.put(attribute);
        }
        try {
            this.driver.getLDAPConnection().createEntry(dn, attributes);
        }
        catch (NameAlreadyBoundException e) {
            throw new ManagedObjectAlreadyExistsException();
        }
        catch (OperationNotSupportedException e) {
            if (e.getMessage() == null) {
                throw new OperationRejectedException(OperationRejectedException.OperationType.CREATE, d.getUserFriendlyName());
            }
            Message m = Message.raw("%s", e.getMessage());
            throw new OperationRejectedException(OperationRejectedException.OperationType.CREATE, d.getUserFriendlyName(), m);
        }
        catch (NamingException e) {
            this.driver.adaptNamingException(e);
        }
    }

    @Override
    protected Driver getDriver() {
        return this.driver;
    }

    @Override
    protected void modifyExistingManagedObject() throws ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
        BasicAttributes mods = new BasicAttributes();
        ManagedObjectDefinition d = this.getManagedObjectDefinition();
        for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
            Property<?> p = this.getProperty(pd);
            if (!p.isModified()) continue;
            String attrID = this.driver.getLDAPProfile().getAttributeName(d, pd);
            BasicAttribute attribute = new BasicAttribute(attrID);
            this.encodeProperty(attribute, pd);
            mods.put(attribute);
        }
        if (mods.size() > 0) {
            try {
                ManagedObjectPath path = this.getManagedObjectPath();
                LdapName dn = LDAPNameBuilder.create(path, this.driver.getLDAPProfile());
                this.driver.getLDAPConnection().modifyEntry(dn, mods);
            }
            catch (NoPermissionException e) {
                throw new AuthorizationException(e);
            }
            catch (OperationNotSupportedException e) {
                if (e.getMessage() == null) {
                    throw new OperationRejectedException(OperationRejectedException.OperationType.MODIFY, d.getUserFriendlyName());
                }
                Message m = Message.raw("%s", e.getMessage());
                throw new OperationRejectedException(OperationRejectedException.OperationType.MODIFY, d.getUserFriendlyName(), m);
            }
            catch (NamingException e) {
                throw new CommunicationException(e);
            }
        }
    }

    @Override
    protected <M extends ConfigurationClient> ManagedObject<M> newInstance(ManagedObjectDefinition<M, ?> d, ManagedObjectPath<M, ?> path, PropertySet properties, boolean existsOnServer, PropertyDefinition<?> namingPropertyDefinition) {
        return new LDAPManagedObject<M>(this.driver, d, path, properties, existsOnServer, namingPropertyDefinition);
    }

    private <PD> void encodeProperty(Attribute attribute, PropertyDefinition<PD> pd) {
        ValueEncoder visitor = new ValueEncoder();
        Property<PD> p = this.getProperty(pd);
        if (pd.hasOption(PropertyOption.MANDATORY)) {
            for (Object value : p.getEffectiveValues()) {
                attribute.add(pd.accept(visitor, value, null));
            }
        } else {
            for (Object value : p.getPendingValues()) {
                attribute.add(pd.accept(visitor, value, null));
            }
        }
    }

    @Override
    public boolean isModified() {
        ManagedObjectDefinition d = this.getManagedObjectDefinition();
        for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
            Property<?> p = this.getProperty(pd);
            if (!p.isModified()) continue;
            return true;
        }
        return false;
    }

    private static final class ValueEncoder
    extends PropertyValueVisitor<Object, Void> {
        private ValueEncoder() {
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Object visitAggregation(AggregationPropertyDefinition<C, S> pd, String v, Void p) {
            Reference<C, S> reference = Reference.parseName(pd.getParentPath(), pd.getRelationDefinition(), v);
            return reference.toDN().toString();
        }

        @Override
        public <PD> Object visitUnknown(PropertyDefinition<PD> pd, PD v, Void p) throws UnknownPropertyDefinitionException {
            return pd.encodeValue(v);
        }
    }
}

