/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.IPAddressMaskPropertyDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.SetRelationDefinition;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.TopCfgDefn;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.condition.Conditions;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.NetworkGroupCfgClient;
import org.opends.server.admin.std.client.QOSPolicyCfgClient;
import org.opends.server.admin.std.client.WorkflowCfgClient;
import org.opends.server.admin.std.meta.QOSPolicyCfgDefn;
import org.opends.server.admin.std.server.NetworkGroupCfg;
import org.opends.server.admin.std.server.QOSPolicyCfg;
import org.opends.server.admin.std.server.WorkflowCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.types.AddressMask;
import org.opends.server.types.DN;

public final class NetworkGroupCfgDefn
extends ManagedObjectDefinition<NetworkGroupCfgClient, NetworkGroupCfg> {
    private static final NetworkGroupCfgDefn INSTANCE = new NetworkGroupCfgDefn();
    private static final EnumPropertyDefinition<AllowedAuthMethod> PD_ALLOWED_AUTH_METHOD;
    private static final StringPropertyDefinition PD_ALLOWED_BIND_DN;
    private static final IPAddressMaskPropertyDefinition PD_ALLOWED_CLIENT;
    private static final EnumPropertyDefinition<AllowedProtocol> PD_ALLOWED_PROTOCOL;
    private static final IPAddressMaskPropertyDefinition PD_DENIED_CLIENT;
    private static final BooleanPropertyDefinition PD_ENABLED;
    private static final BooleanPropertyDefinition PD_IS_SECURITY_MANDATORY;
    private static final IntegerPropertyDefinition PD_PRIORITY;
    private static final AggregationPropertyDefinition<WorkflowCfgClient, WorkflowCfg> PD_WORKFLOW;
    private static final SetRelationDefinition<QOSPolicyCfgClient, QOSPolicyCfg> RD_NETWORK_GROUP_QOS_POLICIES;

    public static NetworkGroupCfgDefn getInstance() {
        return INSTANCE;
    }

    private NetworkGroupCfgDefn() {
        super("network-group", TopCfgDefn.getInstance());
    }

    @Override
    public NetworkGroupCfgClient createClientConfiguration(ManagedObject<? extends NetworkGroupCfgClient> impl) {
        return new NetworkGroupCfgClientImpl(impl);
    }

    @Override
    public NetworkGroupCfg createServerConfiguration(ServerManagedObject<? extends NetworkGroupCfg> impl) {
        return new NetworkGroupCfgServerImpl(impl);
    }

    @Override
    public Class<NetworkGroupCfg> getServerConfigurationClass() {
        return NetworkGroupCfg.class;
    }

    public EnumPropertyDefinition<AllowedAuthMethod> getAllowedAuthMethodPropertyDefinition() {
        return PD_ALLOWED_AUTH_METHOD;
    }

    public StringPropertyDefinition getAllowedBindDNPropertyDefinition() {
        return PD_ALLOWED_BIND_DN;
    }

    public IPAddressMaskPropertyDefinition getAllowedClientPropertyDefinition() {
        return PD_ALLOWED_CLIENT;
    }

    public EnumPropertyDefinition<AllowedProtocol> getAllowedProtocolPropertyDefinition() {
        return PD_ALLOWED_PROTOCOL;
    }

    public IPAddressMaskPropertyDefinition getDeniedClientPropertyDefinition() {
        return PD_DENIED_CLIENT;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PD_ENABLED;
    }

    public BooleanPropertyDefinition getIsSecurityMandatoryPropertyDefinition() {
        return PD_IS_SECURITY_MANDATORY;
    }

    public IntegerPropertyDefinition getPriorityPropertyDefinition() {
        return PD_PRIORITY;
    }

    public AggregationPropertyDefinition<WorkflowCfgClient, WorkflowCfg> getWorkflowPropertyDefinition() {
        return PD_WORKFLOW;
    }

    public SetRelationDefinition<QOSPolicyCfgClient, QOSPolicyCfg> getNetworkGroupQOSPoliciesRelationDefinition() {
        return RD_NETWORK_GROUP_QOS_POLICIES;
    }

    static {
        Object builder = EnumPropertyDefinition.createBuilder(INSTANCE, "allowed-auth-method");
        ((PropertyDefinition.AbstractBuilder)builder).setOption(PropertyOption.MULTI_VALUED);
        ((PropertyDefinition.AbstractBuilder)builder).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allowed-auth-method"));
        ((PropertyDefinition.AbstractBuilder)builder).setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "allowed-auth-method"));
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(AllowedAuthMethod.class);
        PD_ALLOWED_AUTH_METHOD = (EnumPropertyDefinition)((PropertyDefinition.AbstractBuilder)builder).getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOWED_AUTH_METHOD);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "allowed-bind-dn");
        ((PropertyDefinition.AbstractBuilder)builder).setOption(PropertyOption.MULTI_VALUED);
        ((PropertyDefinition.AbstractBuilder)builder).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allowed-bind-dn"));
        ((PropertyDefinition.AbstractBuilder)builder).setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "allowed-bind-dn"));
        PD_ALLOWED_BIND_DN = (StringPropertyDefinition)((PropertyDefinition.AbstractBuilder)builder).getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOWED_BIND_DN);
        builder = IPAddressMaskPropertyDefinition.createBuilder(INSTANCE, "allowed-client");
        ((PropertyDefinition.AbstractBuilder)builder).setOption(PropertyOption.MULTI_VALUED);
        ((PropertyDefinition.AbstractBuilder)builder).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allowed-client"));
        ((PropertyDefinition.AbstractBuilder)builder).setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "allowed-client"));
        PD_ALLOWED_CLIENT = (IPAddressMaskPropertyDefinition)((PropertyDefinition.AbstractBuilder)builder).getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOWED_CLIENT);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "allowed-protocol");
        ((PropertyDefinition.AbstractBuilder)builder).setOption(PropertyOption.MULTI_VALUED);
        ((PropertyDefinition.AbstractBuilder)builder).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allowed-protocol"));
        ((PropertyDefinition.AbstractBuilder)builder).setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "allowed-protocol"));
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(AllowedProtocol.class);
        PD_ALLOWED_PROTOCOL = (EnumPropertyDefinition)((PropertyDefinition.AbstractBuilder)builder).getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOWED_PROTOCOL);
        builder = IPAddressMaskPropertyDefinition.createBuilder(INSTANCE, "denied-client");
        ((PropertyDefinition.AbstractBuilder)builder).setOption(PropertyOption.MULTI_VALUED);
        ((PropertyDefinition.AbstractBuilder)builder).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "denied-client"));
        ((PropertyDefinition.AbstractBuilder)builder).setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "denied-client"));
        PD_DENIED_CLIENT = (IPAddressMaskPropertyDefinition)((PropertyDefinition.AbstractBuilder)builder).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DENIED_CLIENT);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "enabled");
        ((PropertyDefinition.AbstractBuilder)builder).setOption(PropertyOption.MANDATORY);
        ((PropertyDefinition.AbstractBuilder)builder).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "enabled"));
        ((PropertyDefinition.AbstractBuilder)builder).setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_ENABLED = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)builder).getInstance();
        INSTANCE.registerPropertyDefinition(PD_ENABLED);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "is-security-mandatory");
        ((PropertyDefinition.AbstractBuilder)builder).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "is-security-mandatory"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("false");
        ((PropertyDefinition.AbstractBuilder)builder).setDefaultBehaviorProvider(provider);
        PD_IS_SECURITY_MANDATORY = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)builder).getInstance();
        INSTANCE.registerPropertyDefinition(PD_IS_SECURITY_MANDATORY);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "priority");
        ((PropertyDefinition.AbstractBuilder)builder).setOption(PropertyOption.MANDATORY);
        ((PropertyDefinition.AbstractBuilder)builder).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "priority"));
        ((PropertyDefinition.AbstractBuilder)builder).setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_PRIORITY = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)builder).getInstance();
        INSTANCE.registerPropertyDefinition(PD_PRIORITY);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "workflow");
        ((PropertyDefinition.AbstractBuilder)builder).setOption(PropertyOption.MULTI_VALUED);
        ((PropertyDefinition.AbstractBuilder)builder).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "workflow"));
        ((PropertyDefinition.AbstractBuilder)builder).setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "workflow"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("workflow");
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_WORKFLOW = (AggregationPropertyDefinition)((PropertyDefinition.AbstractBuilder)builder).getInstance();
        INSTANCE.registerPropertyDefinition(PD_WORKFLOW);
        INSTANCE.registerConstraint(PD_WORKFLOW.getSourceConstraint());
        builder = new SetRelationDefinition.Builder<QOSPolicyCfgClient, QOSPolicyCfg>(INSTANCE, "network-group-qos-policy", "network-group-qos-policies", QOSPolicyCfgDefn.getInstance());
        RD_NETWORK_GROUP_QOS_POLICIES = (SetRelationDefinition)((RelationDefinition.AbstractBuilder)builder).getInstance();
        INSTANCE.registerRelationDefinition(RD_NETWORK_GROUP_QOS_POLICIES);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class NetworkGroupCfgServerImpl
    implements NetworkGroupCfg {
        private ServerManagedObject<? extends NetworkGroupCfg> impl;
        private final SortedSet<AllowedAuthMethod> pAllowedAuthMethod;
        private final SortedSet<String> pAllowedBindDN;
        private final SortedSet<AddressMask> pAllowedClient;
        private final SortedSet<AllowedProtocol> pAllowedProtocol;
        private final SortedSet<AddressMask> pDeniedClient;
        private final boolean pEnabled;
        private final boolean pIsSecurityMandatory;
        private final int pPriority;
        private final SortedSet<String> pWorkflow;

        private NetworkGroupCfgServerImpl(ServerManagedObject<? extends NetworkGroupCfg> impl) {
            this.impl = impl;
            this.pAllowedAuthMethod = impl.getPropertyValues(INSTANCE.getAllowedAuthMethodPropertyDefinition());
            this.pAllowedBindDN = impl.getPropertyValues((PropertyDefinition)INSTANCE.getAllowedBindDNPropertyDefinition());
            this.pAllowedClient = impl.getPropertyValues((PropertyDefinition)INSTANCE.getAllowedClientPropertyDefinition());
            this.pAllowedProtocol = impl.getPropertyValues(INSTANCE.getAllowedProtocolPropertyDefinition());
            this.pDeniedClient = impl.getPropertyValues((PropertyDefinition)INSTANCE.getDeniedClientPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pIsSecurityMandatory = impl.getPropertyValue(INSTANCE.getIsSecurityMandatoryPropertyDefinition());
            this.pPriority = impl.getPropertyValue(INSTANCE.getPriorityPropertyDefinition());
            this.pWorkflow = impl.getPropertyValues(INSTANCE.getWorkflowPropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<NetworkGroupCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<NetworkGroupCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<AllowedAuthMethod> getAllowedAuthMethod() {
            return this.pAllowedAuthMethod;
        }

        @Override
        public SortedSet<String> getAllowedBindDN() {
            return this.pAllowedBindDN;
        }

        @Override
        public SortedSet<AddressMask> getAllowedClient() {
            return this.pAllowedClient;
        }

        @Override
        public SortedSet<AllowedProtocol> getAllowedProtocol() {
            return this.pAllowedProtocol;
        }

        @Override
        public SortedSet<AddressMask> getDeniedClient() {
            return this.pDeniedClient;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public boolean isIsSecurityMandatory() {
            return this.pIsSecurityMandatory;
        }

        @Override
        public int getPriority() {
            return this.pPriority;
        }

        @Override
        public SortedSet<String> getWorkflow() {
            return this.pWorkflow;
        }

        @Override
        public SortedSet<DN> getWorkflowDNs() {
            SortedSet<String> values = this.getWorkflow();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getWorkflowPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public String[] listNetworkGroupQOSPolicies() {
            return this.impl.listChildren(INSTANCE.getNetworkGroupQOSPoliciesRelationDefinition());
        }

        @Override
        public QOSPolicyCfg getNetworkGroupQOSPolicy(String name) throws ConfigException {
            return this.impl.getChild(INSTANCE.getNetworkGroupQOSPoliciesRelationDefinition(), name).getConfiguration();
        }

        @Override
        public void addNetworkGroupQOSPolicyAddListener(ConfigurationAddListener<QOSPolicyCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getNetworkGroupQOSPoliciesRelationDefinition(), listener);
        }

        @Override
        public void removeNetworkGroupQOSPolicyAddListener(ConfigurationAddListener<QOSPolicyCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getNetworkGroupQOSPoliciesRelationDefinition(), listener);
        }

        @Override
        public void addNetworkGroupQOSPolicyDeleteListener(ConfigurationDeleteListener<QOSPolicyCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getNetworkGroupQOSPoliciesRelationDefinition(), listener);
        }

        @Override
        public void removeNetworkGroupQOSPolicyDeleteListener(ConfigurationDeleteListener<QOSPolicyCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getNetworkGroupQOSPoliciesRelationDefinition(), listener);
        }

        @Override
        public Class<? extends NetworkGroupCfg> configurationClass() {
            return NetworkGroupCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class NetworkGroupCfgClientImpl
    implements NetworkGroupCfgClient {
        private ManagedObject<? extends NetworkGroupCfgClient> impl;

        private NetworkGroupCfgClientImpl(ManagedObject<? extends NetworkGroupCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<AllowedAuthMethod> getAllowedAuthMethod() {
            return this.impl.getPropertyValues(INSTANCE.getAllowedAuthMethodPropertyDefinition());
        }

        @Override
        public void setAllowedAuthMethod(Collection<AllowedAuthMethod> values) {
            this.impl.setPropertyValues(INSTANCE.getAllowedAuthMethodPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getAllowedBindDN() {
            return this.impl.getPropertyValues(INSTANCE.getAllowedBindDNPropertyDefinition());
        }

        @Override
        public void setAllowedBindDN(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getAllowedBindDNPropertyDefinition(), values);
        }

        @Override
        public SortedSet<AddressMask> getAllowedClient() {
            return this.impl.getPropertyValues(INSTANCE.getAllowedClientPropertyDefinition());
        }

        @Override
        public void setAllowedClient(Collection<AddressMask> values) {
            this.impl.setPropertyValues(INSTANCE.getAllowedClientPropertyDefinition(), values);
        }

        @Override
        public SortedSet<AllowedProtocol> getAllowedProtocol() {
            return this.impl.getPropertyValues(INSTANCE.getAllowedProtocolPropertyDefinition());
        }

        @Override
        public void setAllowedProtocol(Collection<AllowedProtocol> values) {
            this.impl.setPropertyValues(INSTANCE.getAllowedProtocolPropertyDefinition(), values);
        }

        @Override
        public SortedSet<AddressMask> getDeniedClient() {
            return this.impl.getPropertyValues(INSTANCE.getDeniedClientPropertyDefinition());
        }

        @Override
        public void setDeniedClient(Collection<AddressMask> values) {
            this.impl.setPropertyValues(INSTANCE.getDeniedClientPropertyDefinition(), values);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public boolean isIsSecurityMandatory() {
            return this.impl.getPropertyValue(INSTANCE.getIsSecurityMandatoryPropertyDefinition());
        }

        @Override
        public void setIsSecurityMandatory(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getIsSecurityMandatoryPropertyDefinition(), value);
        }

        @Override
        public Integer getPriority() {
            return this.impl.getPropertyValue(INSTANCE.getPriorityPropertyDefinition());
        }

        @Override
        public void setPriority(int value) {
            this.impl.setPropertyValue(INSTANCE.getPriorityPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getWorkflow() {
            return this.impl.getPropertyValues(INSTANCE.getWorkflowPropertyDefinition());
        }

        @Override
        public void setWorkflow(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getWorkflowPropertyDefinition(), values);
        }

        @Override
        public String[] listNetworkGroupQOSPolicies() throws ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.listChildren(INSTANCE.getNetworkGroupQOSPoliciesRelationDefinition());
        }

        @Override
        public QOSPolicyCfgClient getNetworkGroupQOSPolicy(String name) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.getChild(INSTANCE.getNetworkGroupQOSPoliciesRelationDefinition(), name).getConfiguration();
        }

        public <M extends QOSPolicyCfgClient> M createNetworkGroupQOSPolicy(ManagedObjectDefinition<M, ? extends QOSPolicyCfg> d, Collection<DefaultBehaviorException> exceptions) {
            return (M)((QOSPolicyCfgClient)this.impl.createChild(INSTANCE.getNetworkGroupQOSPoliciesRelationDefinition(), d, exceptions).getConfiguration());
        }

        @Override
        public void removeNetworkGroupQOSPolicy(String name) throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.removeChild(INSTANCE.getNetworkGroupQOSPoliciesRelationDefinition(), name);
        }

        @Override
        public ManagedObjectDefinition<? extends NetworkGroupCfgClient, ? extends NetworkGroupCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }

    public static enum AllowedProtocol {
        LDAP("ldap"),
        LDAPS("ldaps");

        private final String name;

        private AllowedProtocol(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum AllowedAuthMethod {
        ANONYMOUS("anonymous"),
        SASL("sasl"),
        SIMPLE("simple");

        private final String name;

        private AllowedAuthMethod(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

