/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.HashSet;
import java.util.regex.Pattern;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.authorization.dseecompat.AciBody;
import org.opends.server.authorization.dseecompat.AciEvalContext;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.AciTargetMatchContext;
import org.opends.server.authorization.dseecompat.AciTargets;
import org.opends.server.authorization.dseecompat.EnumAccessType;
import org.opends.server.authorization.dseecompat.EnumEvalResult;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.DN;
import org.opends.server.util.StaticUtils;

public class Aci
implements Comparable<Aci> {
    private AciBody body;
    private AciTargets targets = null;
    public static final String supportedVersion = "3.0";
    private String aciString;
    private final DN dn;
    public static final String WORD_GROUP = "(\\w+)";
    public static final String WORD_GROUP_START_PATTERN = "^(\\w+)";
    public static final String ZERO_OR_MORE_WHITESPACE = "\\s*";
    public static final String ZERO_OR_MORE_WHITESPACE_START_PATTERN = "^\\s*";
    private static final String ZERO_OR_MORE_WHITESPACE_END_PATTERN = "\\s*$";
    public static final String ACI_STATEMENT_SEPARATOR = "\\s*;\\s*";
    private static final String aciRegex = "^\\s*(\\(\\s*(\\w+)\\s*(!?=)\\s*\"([^\"]+)\"\\s*\\)\\s*)*\\s*\\(\\s*(?i)version(?-i)\\s*(\\d\\.\\d)\\s*;\\s*(?i)acl(?-i)\\s*\"([^\"]*)\"\\s*;\\s*\\s*(\\w+)\\s*\\(([^()]+)\\)\\s*(.+?\"[)]*)\\s*;\\s*\\s*\\)\\s*$";
    public static final String ATTR_NAME = "((?i)[a-z\\d]{1}[[a-z]\\d-_.]*(?-i)|\\*{1}|\\+{1})";
    public static final String LDAP_URL = "\\s*(ldap:///[^\\|]+)";
    public static final String NULL_LDAP_URL = "ldap:///";
    public static final String LOGICAL_OR = "\\|\\|";
    public static final String OPEN_PAREN = "\\(";
    public static final String CLOSED_PAREN = "\\)";
    public static final String EQUAL_SIGN = "={1}";
    public static final String ALL_USER_ATTRS_WILD_CARD = "\\s*\\*\\s*";
    public static final String ALL_OP_ATTRS_WILD_CARD = "\\s*\\+\\s*";
    private static final String OID_NAME = "[\\d.\\*]*";
    private static final String oidListRegex = "\\s*[\\d.\\*]*\\s*(\\|\\|\\s*[\\d.\\*]*\\s*)*";
    public static final int ACI_ADD = 32;
    public static final int ACI_DELETE = 16;
    public static final int ACI_READ = 4;
    public static final int ACI_WRITE = 8;
    public static final int ACI_COMPARE = 1;
    public static final int ACI_SEARCH = 2;
    public static final int ACI_SELF = 64;
    public static final int ACI_ALL = 127;
    public static final int ACI_PROXY = 128;
    public static final int ACI_IMPORT = 256;
    public static final int ACI_EXPORT = 512;
    public static final int ACI_WRITE_ADD = 2048;
    public static final int ACI_WRITE_DELETE = 1024;
    public static final int ACI_SKIP_PROXY_CHECK = 0x400000;
    public static final int TARGATTRFILTERS_ADD = 4096;
    public static final int TARGATTRFILTERS_DELETE = 8192;
    public static final int ACI_CONTROL = 16384;
    public static final int ACI_EXT_OP = 32768;
    public static final int ACI_USER_ATTR_STAR_MATCHED = 8;
    public static final int ACI_FOUND_USER_ATTR_RULE = 16;
    public static final int ACI_OP_ATTR_PLUS_MATCHED = 4;
    public static final int ACI_FOUND_OP_ATTR_RULE = 32;
    public static final int ACI_NULL = 0;

    private Aci(String input, DN dn, AciBody body, AciTargets targets) {
        this.aciString = input;
        this.dn = dn;
        this.body = body;
        this.targets = targets;
    }

    public static Aci decode(ByteSequence byteString, DN dn) throws AciException {
        String input = ((Object)byteString).toString();
        if (!Pattern.matches(aciRegex, input)) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_GENERAL_PARSE_FAILED.get(input);
            throw new AciException(message);
        }
        AciBody body = AciBody.decode(input);
        String targetStr = input.substring(0, body.getMatcherStartPos());
        AciTargets targets = AciTargets.decode(targetStr, dn);
        return new Aci(input, dn, body, targets);
    }

    public String toString() {
        return this.aciString;
    }

    public AciTargets getTargets() {
        return this.targets;
    }

    public DN getDN() {
        return this.dn;
    }

    public static boolean isApplicable(Aci aci, AciTargetMatchContext matchCtx) {
        if (matchCtx.hasRights(32768)) {
            return AciTargets.isTargetApplicable(aci, matchCtx) && AciTargets.isExtOpApplicable(aci, matchCtx);
        }
        if (matchCtx.hasRights(16384)) {
            return AciTargets.isTargetApplicable(aci, matchCtx) && AciTargets.isTargetControlApplicable(aci, matchCtx);
        }
        if (aci.getTargets().getExtOp() != null || aci.getTargets().getTargetControl() != null) {
            return false;
        }
        int ctxRights = matchCtx.getRights();
        if (!(aci.hasRights(ctxRights) || aci.hasRights(6) && matchCtx.hasRights(6))) {
            return false;
        }
        return AciTargets.isTargetApplicable(aci, matchCtx) && AciTargets.isTargetFilterApplicable(aci, matchCtx) && AciTargets.isTargAttrFiltersApplicable(aci, matchCtx) && AciTargets.isTargetAttrApplicable(aci, matchCtx);
    }

    public boolean hasRights(int rights) {
        return this.body.hasRights(rights);
    }

    public boolean hasAccessType(EnumAccessType accessType) {
        return this.body.hasAccessType(accessType);
    }

    private EnumEvalResult evaluate(AciEvalContext evalCtx) {
        return this.body.evaluate(evalCtx);
    }

    public static EnumEvalResult evaluate(AciEvalContext evalCtx, Aci aci) {
        return aci.evaluate(evalCtx);
    }

    public String getName() {
        return this.body.getName();
    }

    public static HashSet<String> decodeOID(String expr, Message msg) throws AciException {
        HashSet<String> OIDs = new HashSet<String>();
        if (Pattern.matches(oidListRegex, expr)) {
            String[] oidArray;
            Pattern separatorPattern = Pattern.compile(LOGICAL_OR);
            String oidString = expr.replaceAll(ZERO_OR_MORE_WHITESPACE, "");
            for (String oid : oidArray = separatorPattern.split(oidString)) {
                Aci.verifyOid(oid);
                OIDs.add(oid);
            }
        } else {
            throw new AciException(msg);
        }
        return OIDs;
    }

    private static void verifyOid(String oidStr) throws AciException {
        char c;
        int pos = 0;
        int length = oidStr.length();
        if (oidStr.equals("*")) {
            return;
        }
        boolean lastWasPeriod = false;
        while (pos < length && (c = oidStr.charAt(pos++)) != ' ') {
            if (c == '.') {
                if (lastWasPeriod) {
                    Message message = AccessControlMessages.WARN_ACI_SYNTAX_DOUBLE_PERIOD_IN_NUMERIC_OID.get(oidStr, pos - 1);
                    throw new AciException(message);
                }
                lastWasPeriod = true;
                continue;
            }
            if (!StaticUtils.isDigit(c)) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_ILLEGAL_CHAR_IN_NUMERIC_OID.get(oidStr, Character.valueOf(c), pos - 1);
                throw new AciException(message);
            }
            lastWasPeriod = false;
        }
    }

    @Override
    public int compareTo(Aci aci) {
        return this.aciString.compareTo(aci.toString());
    }
}

