/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.regex.Pattern;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.authorization.dseecompat.AciEvalContext;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.EnumBindRuleType;
import org.opends.server.authorization.dseecompat.EnumEvalResult;
import org.opends.server.authorization.dseecompat.KeywordBindRule;
import org.opends.server.util.TimeThread;

public class TimeOfDay
implements KeywordBindRule {
    private static final String timeofdayRegex = "[0-2]\\d[0-5]\\d";
    private EnumBindRuleType type = null;
    private int timeRef;

    private TimeOfDay(int timeVal, EnumBindRuleType type) {
        this.timeRef = timeVal;
        this.type = type;
    }

    public static TimeOfDay decode(String expr, EnumBindRuleType type) throws AciException {
        int valueAsInt = 0;
        if (!Pattern.matches(timeofdayRegex, expr)) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TIMEOFDAY.get(expr);
            throw new AciException(message);
        }
        try {
            valueAsInt = Integer.parseInt(expr);
        }
        catch (NumberFormatException nfe) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TIMEOFDAY_FORMAT.get(expr, nfe.getMessage());
            throw new AciException(message);
        }
        if (valueAsInt < 0 || valueAsInt > 2359) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TIMEOFDAY_RANGE.get(expr);
            throw new AciException(message);
        }
        return new TimeOfDay(valueAsInt, type);
    }

    @Override
    public EnumEvalResult evaluate(AciEvalContext evalCtx) {
        EnumEvalResult matched = EnumEvalResult.FALSE;
        int currentTime = TimeThread.getHourAndMinute();
        switch (this.type) {
            case EQUAL_BINDRULE_TYPE: 
            case NOT_EQUAL_BINDRULE_TYPE: {
                if (currentTime == this.timeRef) break;
                matched = EnumEvalResult.TRUE;
                break;
            }
            case LESS_OR_EQUAL_BINDRULE_TYPE: {
                if (currentTime > this.timeRef) break;
                matched = EnumEvalResult.TRUE;
                break;
            }
            case LESS_BINDRULE_TYPE: {
                if (currentTime >= this.timeRef) break;
                matched = EnumEvalResult.TRUE;
                break;
            }
            case GREATER_OR_EQUAL_BINDRULE_TYPE: {
                if (currentTime < this.timeRef) break;
                matched = EnumEvalResult.TRUE;
                break;
            }
            case GREATER_BINDRULE_TYPE: {
                if (currentTime <= this.timeRef) break;
                matched = EnumEvalResult.TRUE;
            }
        }
        return matched.getRet(this.type, false);
    }
}

