/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import org.opends.messages.BackendMessages;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.LocalDBIndexCfgDefn;
import org.opends.server.admin.std.server.LocalDBBackendCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.Backend;
import org.opends.server.api.DiskSpaceMonitorHandler;
import org.opends.server.api.MonitorProvider;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.BackupManager;
import org.opends.server.backends.jeb.ConfigurableEnvironment;
import org.opends.server.backends.jeb.EntryCachePreloader;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EnvManager;
import org.opends.server.backends.jeb.ExportJob;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.RebuildConfig;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.VerifyConfig;
import org.opends.server.backends.jeb.VerifyJob;
import org.opends.server.backends.jeb.importLDIF.Importer;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.extensions.DiskSpaceMonitor;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.IndexType;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.util.LDIFException;
import org.opends.server.util.RuntimeInformation;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

public class BackendImpl
extends Backend
implements ConfigurationChangeListener<LocalDBBackendCfg>,
AlertGenerator,
DiskSpaceMonitorHandler {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.BackendImpl";
    private LocalDBBackendCfg cfg;
    private RootContainer rootContainer;
    private final AtomicInteger threadTotalCount = new AtomicInteger(0);
    private final AtomicInteger threadWriteCount = new AtomicInteger(0);
    private DN[] baseDNs;
    private MonitorProvider<?> rootContainerMonitor;
    private DiskSpaceMonitor diskMonitor;
    private static HashSet<String> supportedControls = new HashSet();
    private static HashSet<String> supportedFeatures;

    private void readerBegin() {
        this.threadTotalCount.getAndIncrement();
    }

    private void readerEnd() {
        this.threadTotalCount.getAndDecrement();
    }

    private void writerBegin() {
        this.threadTotalCount.getAndIncrement();
        this.threadWriteCount.getAndIncrement();
    }

    private void writerEnd() {
        this.threadWriteCount.getAndDecrement();
        this.threadTotalCount.getAndDecrement();
    }

    private void waitUntilQuiescent() {
        while (this.threadTotalCount.get() > 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checksumDbEnv() {
        File parentDirectory = StaticUtils.getFileForPath(this.cfg.getDBDirectory());
        File backendDirectory = new File(parentDirectory, this.cfg.getBackendId());
        List<Object> jdbFiles = new ArrayList();
        if (backendDirectory.isDirectory()) {
            jdbFiles = Arrays.asList(backendDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jdb");
                }
            }));
        }
        if (!jdbFiles.isEmpty()) {
            Collections.sort(jdbFiles, Collections.reverseOrder());
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(((File)jdbFiles.get(0)).toString());
                CheckedInputStream cis = new CheckedInputStream(fis, new Adler32());
                byte[] tempBuf = new byte[8192];
                while (cis.read(tempBuf) >= 0) {
                }
                long l = cis.getChecksum().getValue();
                return l;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            finally {
                block17: {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) break block17;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
            }
        }
        return 0L;
    }

    @Override
    public void configureBackend(Configuration cfg) throws ConfigException {
        Validator.ensureNotNull(cfg);
        Validator.ensureTrue(cfg instanceof LocalDBBackendCfg);
        this.cfg = (LocalDBBackendCfg)cfg;
        SortedSet<DN> dnSet = this.cfg.getBaseDN();
        this.baseDNs = new DN[dnSet.size()];
        dnSet.toArray(this.baseDNs);
    }

    @Override
    public void initializeBackend() throws ConfigException, InitializationException {
        DirectoryServer.registerOfflineBackendStateID(this.getBackendID(), this.checksumDbEnv());
        if (this.rootContainer == null) {
            EnvironmentConfig envConfig = ConfigurableEnvironment.parseConfigEntry(this.cfg);
            this.rootContainer = this.initializeRootContainer(envConfig);
        }
        this.rootContainer.preload(this.cfg.getPreloadTimeLimit());
        try {
            Message message = JebMessages.NOTE_JEB_BACKEND_STARTED.get(this.cfg.getBackendId(), this.rootContainer.getEntryCount());
            ErrorLogger.logError(message);
        }
        catch (DatabaseException databaseException) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, databaseException);
            }
            Message message = JebMessages.WARN_JEB_GET_ENTRY_COUNT_FAILED.get(databaseException.getMessage());
            throw new InitializationException(message, (Throwable)databaseException);
        }
        for (DN dn : this.cfg.getBaseDN()) {
            try {
                DirectoryServer.registerBaseDN(dn, this, false);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = BackendMessages.ERR_BACKEND_CANNOT_REGISTER_BASEDN.get(String.valueOf(dn), String.valueOf(e));
                throw new InitializationException(message, (Throwable)e);
            }
        }
        this.rootContainerMonitor = this.rootContainer.getMonitorProvider();
        DirectoryServer.registerMonitorProvider(this.rootContainerMonitor);
        File parentDirectory = StaticUtils.getFileForPath(this.cfg.getDBDirectory());
        File backendDirectory = new File(parentDirectory, this.cfg.getBackendId());
        this.diskMonitor = new DiskSpaceMonitor(this.getBackendID() + " backend", backendDirectory, this.cfg.getDiskLowThreshold(), this.cfg.getDiskFullThreshold(), 5, TimeUnit.SECONDS, this);
        this.diskMonitor.initializeMonitorProvider(null);
        DirectoryServer.registerMonitorProvider(this.diskMonitor);
        DirectoryServer.registerAlertGenerator(this);
        this.cfg.addLocalDBChangeListener(this);
    }

    @Override
    public void finalizeBackend() {
        this.cfg.removeLocalDBChangeListener(this);
        for (DN dn : this.rootContainer.getBaseDNs()) {
            try {
                DirectoryServer.deregisterBaseDN(dn);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        DirectoryServer.deregisterMonitorProvider(this.rootContainerMonitor);
        DirectoryServer.deregisterMonitorProvider(this.diskMonitor);
        this.waitUntilQuiescent();
        try {
            this.rootContainer.close();
            this.rootContainer = null;
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = JebMessages.ERR_JEB_DATABASE_EXCEPTION.get(e.getMessage());
            ErrorLogger.logError(message);
        }
        DirectoryServer.registerOfflineBackendStateID(this.getBackendID(), this.checksumDbEnv());
        DirectoryServer.deregisterAlertGenerator(this);
        this.threadTotalCount.set(0);
        this.threadWriteCount.set(0);
        Message message = BackendMessages.NOTE_BACKEND_OFFLINE.get(this.cfg.getBackendId());
        ErrorLogger.logError(message);
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isIndexed(AttributeType attributeType, IndexType indexType) {
        try {
            EntryContainer ec = this.rootContainer.getEntryContainer(this.baseDNs[0]);
            AttributeIndex ai = ec.getAttributeIndex(attributeType);
            if (ai == null) {
                return false;
            }
            SortedSet<LocalDBIndexCfgDefn.IndexType> indexTypes = ai.getConfiguration().getIndexType();
            switch (indexType) {
                case PRESENCE: {
                    return indexTypes.contains((Object)LocalDBIndexCfgDefn.IndexType.PRESENCE);
                }
                case EQUALITY: {
                    return indexTypes.contains((Object)LocalDBIndexCfgDefn.IndexType.EQUALITY);
                }
                case SUBSTRING: 
                case SUBINITIAL: 
                case SUBANY: 
                case SUBFINAL: {
                    return indexTypes.contains((Object)LocalDBIndexCfgDefn.IndexType.SUBSTRING);
                }
                case GREATER_OR_EQUAL: 
                case LESS_OR_EQUAL: {
                    return indexTypes.contains((Object)LocalDBIndexCfgDefn.IndexType.ORDERING);
                }
                case APPROXIMATE: {
                    return indexTypes.contains((Object)LocalDBIndexCfgDefn.IndexType.APPROXIMATE);
                }
            }
            return false;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
    }

    @Override
    public boolean supportsLDIFExport() {
        return true;
    }

    @Override
    public boolean supportsLDIFImport() {
        return true;
    }

    @Override
    public boolean supportsBackup() {
        return true;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder unsupportedReason) {
        return true;
    }

    @Override
    public boolean supportsRestore() {
        return true;
    }

    public HashSet<String> getSupportedFeatures() {
        return supportedFeatures;
    }

    public HashSet<String> getSupportedControls() {
        return supportedControls;
    }

    @Override
    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public long getEntryCount() {
        block3: {
            if (this.rootContainer != null) {
                try {
                    return this.rootContainer.getEntryCount();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block3;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        return -1L;
    }

    @Override
    public ConditionResult hasSubordinates(DN entryDN) throws DirectoryException {
        long ret = this.numSubordinates(entryDN, false);
        if (ret < 0L) {
            return ConditionResult.UNDEFINED;
        }
        if (ret == 0L) {
            return ConditionResult.FALSE;
        }
        return ConditionResult.TRUE;
    }

    @Override
    public long numSubordinates(DN entryDN, boolean subtree) throws DirectoryException {
        if (this.rootContainer == null) {
            Message message = BackendMessages.ERR_ROOT_CONTAINER_NOT_INITIALIZED.get(this.getBackendID());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        EntryContainer ec = this.rootContainer.getEntryContainer(entryDN);
        if (ec == null) {
            return -1L;
        }
        this.readerBegin();
        ec.sharedLock.lock();
        try {
            long count = ec.getNumSubordinates(entryDN, subtree);
            if (count == Long.MAX_VALUE) {
                long l = -1L;
                return l;
            }
            long l = count;
            return l;
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw this.createDirectoryException(e);
        }
        finally {
            ec.sharedLock.unlock();
            this.readerEnd();
        }
    }

    @Override
    public Entry getEntry(DN entryDN) throws DirectoryException {
        Entry entry;
        this.readerBegin();
        if (this.rootContainer == null) {
            Message message = BackendMessages.ERR_ROOT_CONTAINER_NOT_INITIALIZED.get(this.getBackendID());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        EntryContainer ec = this.rootContainer.getEntryContainer(entryDN);
        ec.sharedLock.lock();
        try {
            entry = ec.getEntry(entryDN);
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw this.createDirectoryException(e);
        }
        finally {
            ec.sharedLock.unlock();
            this.readerEnd();
        }
        return entry;
    }

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException, CanceledOperationException {
        this.checkDiskSpace(addOperation);
        this.writerBegin();
        DN entryDN = entry.getDN();
        if (this.rootContainer == null) {
            Message message = BackendMessages.ERR_ROOT_CONTAINER_NOT_INITIALIZED.get(this.getBackendID());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        EntryContainer ec = this.rootContainer.getEntryContainer(entryDN);
        ec.sharedLock.lock();
        try {
            ec.addEntry(entry, addOperation);
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw this.createDirectoryException(e);
        }
        finally {
            ec.sharedLock.unlock();
            this.writerEnd();
        }
    }

    @Override
    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException, CanceledOperationException {
        this.checkDiskSpace(deleteOperation);
        this.writerBegin();
        if (this.rootContainer == null) {
            Message message = BackendMessages.ERR_ROOT_CONTAINER_NOT_INITIALIZED.get(this.getBackendID());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        EntryContainer ec = this.rootContainer.getEntryContainer(entryDN);
        ec.sharedLock.lock();
        try {
            ec.deleteEntry(entryDN, deleteOperation);
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw this.createDirectoryException(e);
        }
        finally {
            ec.sharedLock.unlock();
            this.writerEnd();
        }
    }

    @Override
    public void replaceEntry(Entry oldEntry, Entry newEntry, ModifyOperation modifyOperation) throws DirectoryException, CanceledOperationException {
        this.checkDiskSpace(modifyOperation);
        this.writerBegin();
        DN entryDN = newEntry.getDN();
        if (this.rootContainer == null) {
            Message message = BackendMessages.ERR_ROOT_CONTAINER_NOT_INITIALIZED.get(this.getBackendID());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        EntryContainer ec = this.rootContainer.getEntryContainer(entryDN);
        ec.sharedLock.lock();
        try {
            ec.replaceEntry(oldEntry, newEntry, modifyOperation);
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw this.createDirectoryException(e);
        }
        finally {
            ec.sharedLock.unlock();
            this.writerEnd();
        }
    }

    @Override
    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException, CanceledOperationException {
        this.checkDiskSpace(modifyDNOperation);
        this.writerBegin();
        if (this.rootContainer == null) {
            Message message = BackendMessages.ERR_ROOT_CONTAINER_NOT_INITIALIZED.get(this.getBackendID());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        EntryContainer currentContainer = this.rootContainer.getEntryContainer(currentDN);
        EntryContainer container = this.rootContainer.getEntryContainer(entry.getDN());
        if (currentContainer != container) {
            Message msg = JebMessages.WARN_JEB_FUNCTION_NOT_SUPPORTED.get();
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, msg);
        }
        currentContainer.sharedLock.lock();
        try {
            currentContainer.renameEntry(currentDN, entry, modifyDNOperation);
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw this.createDirectoryException(e);
        }
        finally {
            currentContainer.sharedLock.unlock();
            this.writerEnd();
        }
    }

    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException, CanceledOperationException {
        this.readerBegin();
        if (this.rootContainer == null) {
            Message message = BackendMessages.ERR_ROOT_CONTAINER_NOT_INITIALIZED.get(this.getBackendID());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        EntryContainer ec = this.rootContainer.getEntryContainer(searchOperation.getBaseDN());
        ec.sharedLock.lock();
        try {
            ec.search(searchOperation);
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw this.createDirectoryException(e);
        }
        finally {
            ec.sharedLock.unlock();
            this.readerEnd();
        }
    }

    @Override
    public void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        boolean openRootContainer = this.rootContainer == null;
        try {
            if (openRootContainer) {
                EnvironmentConfig envConfig = ConfigurableEnvironment.parseConfigEntry(this.cfg);
                envConfig.setReadOnly(true);
                envConfig.setAllowCreate(false);
                envConfig.setTransactional(false);
                envConfig.setConfigParam("je.env.isLocking", "true");
                envConfig.setConfigParam("je.env.runCheckpointer", "true");
                this.rootContainer = this.initializeRootContainer(envConfig);
            }
            ExportJob exportJob = new ExportJob(exportConfig);
            exportJob.exportLDIF(this.rootContainer);
        }
        catch (IOException ioe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
            }
            Message message = JebMessages.ERR_JEB_EXPORT_IO_ERROR.get(ioe.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        catch (JebException je) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, je);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), je.getMessageObject());
        }
        catch (DatabaseException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            throw this.createDirectoryException(de);
        }
        catch (LDIFException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), e.getMessageObject());
        }
        catch (InitializationException ie) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ie);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), ie.getMessageObject());
        }
        catch (ConfigException ce) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), ce.getMessageObject());
        }
        finally {
            block23: {
                if (openRootContainer && this.rootContainer != null) {
                    try {
                        this.rootContainer.close();
                        this.rootContainer = null;
                    }
                    catch (DatabaseException e) {
                        if (!DebugLogger.debugEnabled()) break block23;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
    }

    @Override
    public LDIFImportResult importLDIF(LDIFImportConfig importConfig) throws DirectoryException {
        boolean openRootContainer;
        RuntimeInformation.logInfo();
        boolean bl = openRootContainer = this.rootContainer == null;
        if (!openRootContainer) {
            Message message = JebMessages.ERR_JEB_IMPORT_BACKEND_ONLINE.get();
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        try {
            File parentDirectory;
            File backendDirectory;
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setAllowCreate(true);
            envConfig.setTransactional(false);
            envConfig.setDurability(Durability.COMMIT_NO_SYNC);
            envConfig.setLockTimeout(0L, TimeUnit.SECONDS);
            envConfig.setTxnTimeout(0L, TimeUnit.SECONDS);
            envConfig.setConfigParam("je.cleaner.minFileUtilization", String.valueOf(this.cfg.getDBCleanerMinUtilization()));
            envConfig.setConfigParam("je.log.fileMax", String.valueOf(this.cfg.getDBLogFileMax()));
            if (!importConfig.appendToExistingData() && (importConfig.clearBackend() || this.cfg.getBaseDN().size() <= 1) && (backendDirectory = new File(parentDirectory = StaticUtils.getFileForPath(this.cfg.getDBDirectory()), this.cfg.getBackendId())).exists()) {
                EnvManager.removeFiles(backendDirectory.getPath());
            }
            Importer importer = new Importer(importConfig, this.cfg, envConfig);
            this.rootContainer = this.initializeRootContainer(envConfig);
            LDIFImportResult lDIFImportResult = importer.processImport(this.rootContainer);
            return lDIFImportResult;
        }
        catch (ExecutionException execEx) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, execEx);
            }
            if (execEx.getCause() instanceof DirectoryException) {
                throw (DirectoryException)execEx.getCause();
            }
            Message message = JebMessages.ERR_EXECUTION_ERROR.get(execEx.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        catch (InterruptedException intEx) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, intEx);
            }
            Message message = JebMessages.ERR_INTERRUPTED_ERROR.get(intEx.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        catch (JebException je) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, je);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), je.getMessageObject());
        }
        catch (InitializationException ie) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ie);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), ie.getMessageObject());
        }
        catch (ConfigException ce) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), ce.getMessageObject());
        }
        finally {
            block23: {
                try {
                    if (this.rootContainer != null) {
                        long startTime = System.currentTimeMillis();
                        this.rootContainer.close();
                        long finishTime = System.currentTimeMillis();
                        long closeTime = (finishTime - startTime) / 1000L;
                        Message msg = JebMessages.NOTE_JEB_IMPORT_LDIF_ROOTCONTAINER_CLOSE.get(closeTime);
                        ErrorLogger.logError(msg);
                        this.rootContainer = null;
                    }
                    if (DebugLogger.debugEnabled()) {
                        Message message = JebMessages.NOTE_JEB_IMPORT_CLOSING_DATABASE.get();
                        TRACER.debugInfo(message.toString());
                    }
                }
                catch (DatabaseException de) {
                    if (!DebugLogger.debugEnabled()) break block23;
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
            }
        }
    }

    public long verifyBackend(VerifyConfig verifyConfig, Entry statEntry) throws InitializationException, ConfigException, DirectoryException {
        boolean openRootContainer = this.rootContainer == null;
        long errorCount = 0L;
        try {
            if (openRootContainer) {
                EnvironmentConfig envConfig = ConfigurableEnvironment.parseConfigEntry(this.cfg);
                envConfig.setReadOnly(true);
                envConfig.setAllowCreate(false);
                envConfig.setTransactional(false);
                envConfig.setConfigParam("je.env.isLocking", "true");
                envConfig.setConfigParam("je.env.runCheckpointer", "true");
                this.rootContainer = this.initializeRootContainer(envConfig);
            }
            VerifyJob verifyJob = new VerifyJob(verifyConfig);
            errorCount = verifyJob.verifyBackend(this.rootContainer, statEntry);
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw this.createDirectoryException(e);
        }
        catch (JebException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), e.getMessageObject());
        }
        finally {
            block15: {
                if (openRootContainer && this.rootContainer != null) {
                    try {
                        this.rootContainer.close();
                        this.rootContainer = null;
                    }
                    catch (DatabaseException e) {
                        if (!DebugLogger.debugEnabled()) break block15;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
        return errorCount;
    }

    public void rebuildBackend(RebuildConfig rebuildConfig) throws InitializationException, ConfigException, DirectoryException {
        boolean openRootContainer;
        boolean bl = openRootContainer = this.rootContainer == null;
        if (!openRootContainer && rebuildConfig.includesSystemIndex()) {
            Message message = JebMessages.ERR_JEB_REBUILD_BACKEND_ONLINE.get();
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        try {
            EnvironmentConfig envConfig;
            if (openRootContainer) {
                envConfig = new EnvironmentConfig();
                envConfig.setAllowCreate(true);
                envConfig.setTransactional(false);
                envConfig.setDurability(Durability.COMMIT_NO_SYNC);
                envConfig.setLockTimeout(0L, TimeUnit.SECONDS);
                envConfig.setTxnTimeout(0L, TimeUnit.SECONDS);
                envConfig.setConfigParam("je.cleaner.minFileUtilization", String.valueOf(this.cfg.getDBCleanerMinUtilization()));
                envConfig.setConfigParam("je.log.fileMax", String.valueOf(this.cfg.getDBLogFileMax()));
                Importer importer = new Importer(rebuildConfig, this.cfg, envConfig);
                this.rootContainer = this.initializeRootContainer(envConfig);
                importer.rebuildIndexes(this.rootContainer);
            } else {
                envConfig = ConfigurableEnvironment.parseConfigEntry(this.cfg);
                Importer importer = new Importer(rebuildConfig, this.cfg, envConfig);
                importer.rebuildIndexes(this.rootContainer);
            }
        }
        catch (ExecutionException execEx) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, execEx);
            }
            Message message = JebMessages.ERR_EXECUTION_ERROR.get(execEx.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        catch (InterruptedException intEx) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, intEx);
            }
            Message message = JebMessages.ERR_INTERRUPTED_ERROR.get(intEx.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        catch (ConfigException ce) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), ce.getMessageObject());
        }
        catch (JebException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), e.getMessageObject());
        }
        catch (InitializationException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new InitializationException(e.getMessageObject());
        }
        finally {
            block23: {
                if (openRootContainer && this.rootContainer != null) {
                    try {
                        this.rootContainer.close();
                        this.rootContainer = null;
                    }
                    catch (DatabaseException e) {
                        if (!DebugLogger.debugEnabled()) break block23;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
    }

    @Override
    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
        BackupManager backupManager = new BackupManager(this.getBackendID());
        File parentDir = StaticUtils.getFileForPath(this.cfg.getDBDirectory());
        File backendDir = new File(parentDir, this.cfg.getBackendId());
        backupManager.createBackup(backendDir, backupConfig);
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
        BackupManager backupManager = new BackupManager(this.getBackendID());
        backupManager.removeBackup(backupDirectory, backupID);
    }

    @Override
    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
        BackupManager backupManager = new BackupManager(this.getBackendID());
        File parentDir = StaticUtils.getFileForPath(this.cfg.getDBDirectory());
        File backendDir = new File(parentDir, this.cfg.getBackendId());
        backupManager.restoreBackup(backendDir, restoreConfig);
    }

    @Override
    public boolean isConfigurationAcceptable(Configuration configuration, List<Message> unacceptableReasons) {
        LocalDBBackendCfg config = (LocalDBBackendCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(LocalDBBackendCfg cfg, List<Message> unacceptableReasons) {
        try {
            Level.parse(cfg.getDBLoggingLevel());
        }
        catch (Exception e) {
            Message message = JebMessages.ERR_JEB_INVALID_LOGGING_LEVEL.get(String.valueOf(cfg.getDBLoggingLevel()), String.valueOf(cfg.dn()));
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(LocalDBBackendCfg newCfg) {
        ResultCode resultCode = ResultCode.SUCCESS;
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            if (this.rootContainer != null) {
                DN[] newBaseDNs = new DN[newCfg.getBaseDN().size()];
                newBaseDNs = newCfg.getBaseDN().toArray(newBaseDNs);
                for (DN baseDN : this.cfg.getBaseDN()) {
                    boolean found = false;
                    for (DN dn : newBaseDNs) {
                        if (!dn.equals(baseDN)) continue;
                        found = true;
                    }
                    if (found) continue;
                    DirectoryServer.deregisterBaseDN(baseDN);
                    EntryContainer ec = this.rootContainer.unregisterEntryContainer(baseDN);
                    ec.close();
                    ec.delete();
                }
                for (DN baseDN : newBaseDNs) {
                    if (this.rootContainer.getBaseDNs().contains(baseDN)) continue;
                    try {
                        EntryContainer ec = this.rootContainer.openEntryContainer(baseDN, null);
                        this.rootContainer.registerEntryContainer(baseDN, ec);
                        DirectoryServer.registerBaseDN(baseDN, this, false);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        resultCode = DirectoryServer.getServerErrorResultCode();
                        messages.add(BackendMessages.ERR_BACKEND_CANNOT_REGISTER_BASEDN.get(String.valueOf(baseDN), String.valueOf(e)));
                        ConfigChangeResult ccr = new ConfigChangeResult(resultCode, false, messages);
                        return ccr;
                    }
                }
                this.baseDNs = newBaseDNs;
            }
            if (this.cfg.getDiskFullThreshold() != newCfg.getDiskFullThreshold() || this.cfg.getDiskLowThreshold() != newCfg.getDiskLowThreshold()) {
                this.diskMonitor.setFullThreshold(newCfg.getDiskFullThreshold());
                this.diskMonitor.setLowThreshold(newCfg.getDiskLowThreshold());
            }
            this.cfg = newCfg;
        }
        catch (Exception e) {
            messages.add(Message.raw(StaticUtils.stackTraceToSingleLineString(e), new Object[0]));
            ConfigChangeResult ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, messages);
            return ccr;
        }
        ConfigChangeResult ccr = new ConfigChangeResult(resultCode, false, messages);
        return ccr;
    }

    public RootContainer getRootContainer() {
        return this.rootContainer;
    }

    public RootContainer getReadOnlyRootContainer() throws ConfigException, InitializationException {
        EnvironmentConfig envConfig = ConfigurableEnvironment.parseConfigEntry(this.cfg);
        envConfig.setReadOnly(true);
        envConfig.setAllowCreate(false);
        envConfig.setTransactional(false);
        envConfig.setConfigParam("je.env.isLocking", "true");
        envConfig.setConfigParam("je.env.runCheckpointer", "true");
        return this.initializeRootContainer(envConfig);
    }

    public void clearBackend() throws ConfigException, JebException {
        File parentDirectory = StaticUtils.getFileForPath(this.cfg.getDBDirectory());
        File backendDirectory = new File(parentDirectory, this.cfg.getBackendId());
        EnvManager.removeFiles(backendDirectory.getPath());
    }

    DirectoryException createDirectoryException(DatabaseException e) {
        String jeMessage;
        Message message;
        ResultCode resultCode = DirectoryServer.getServerErrorResultCode();
        if (e instanceof EnvironmentFailureException && !this.rootContainer.isValid()) {
            message = BackendMessages.NOTE_BACKEND_ENVIRONMENT_UNUSABLE.get(this.getBackendID());
            ErrorLogger.logError(message);
            DirectoryServer.sendAlertNotification(DirectoryServer.getInstance(), "org.opends.server.BackendRunRecovery", message);
        }
        if ((jeMessage = e.getMessage()) == null) {
            jeMessage = StaticUtils.stackTraceToSingleLineString(e);
        }
        message = JebMessages.ERR_JEB_DATABASE_EXCEPTION.get(jeMessage);
        return new DirectoryException(resultCode, message, e);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public Map<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.BackendRunRecovery", "This alert type will be used to provide notification that the JE backend throws a RunRecoveryException and Directory Server needs to be restarted.");
        alerts.put("org.opends.server.DiskSpaceLow", "This alert type will be used to provide notification that the free disk space has reached the low threshold.");
        alerts.put("org.opends.server.DiskFull", "This alert type will be used to provide notification that the free disk space has reached the full threshold.");
        return alerts;
    }

    @Override
    public DN getComponentEntryDN() {
        return this.cfg.dn();
    }

    private RootContainer initializeRootContainer(EnvironmentConfig envConfig) throws ConfigException, InitializationException {
        try {
            RootContainer rc = new RootContainer(this, this.cfg);
            rc.open(envConfig);
            return rc;
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = JebMessages.ERR_JEB_OPEN_ENV_FAIL.get(e.getMessage());
            throw new InitializationException(message, (Throwable)e);
        }
    }

    @Override
    public void preloadEntryCache() throws UnsupportedOperationException {
        EntryCachePreloader preloader = new EntryCachePreloader(this);
        preloader.preload();
    }

    @Override
    public void diskLowThresholdReached(DiskSpaceMonitor monitor) {
        Message msg = JebMessages.ERR_JEB_DISK_LOW_THRESHOLD_REACHED.get(monitor.getDirectory().getPath(), this.cfg.getBackendId(), monitor.getFreeSpace(), Math.max(monitor.getLowThreshold(), monitor.getFullThreshold()));
        DirectoryServer.sendAlertNotification(this, "org.opends.server.DiskSpaceLow", msg);
    }

    @Override
    public void diskFullThresholdReached(DiskSpaceMonitor monitor) {
        Message msg = JebMessages.ERR_JEB_DISK_FULL_THRESHOLD_REACHED.get(monitor.getDirectory().getPath(), this.cfg.getBackendId(), monitor.getFreeSpace(), Math.max(monitor.getLowThreshold(), monitor.getFullThreshold()));
        DirectoryServer.sendAlertNotification(this, "org.opends.server.DiskFull", msg);
    }

    @Override
    public void diskSpaceRestored(DiskSpaceMonitor monitor) {
        Message msg = JebMessages.NOTE_JEB_DISK_SPACE_RESTORED.get(monitor.getFreeSpace(), monitor.getDirectory().getPath(), this.cfg.getBackendId(), Math.max(monitor.getLowThreshold(), monitor.getFullThreshold()));
        ErrorLogger.logError(msg);
    }

    private void checkDiskSpace(Operation operation) throws DirectoryException {
        if (this.diskMonitor.isFullThresholdReached() || this.diskMonitor.isLowThresholdReached() && operation != null && !operation.getClientConnection().hasPrivilege(Privilege.BYPASS_LOCKDOWN, operation)) {
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, JebMessages.WARN_JEB_OUT_OF_DISK_SPACE.get());
        }
    }

    static {
        supportedControls.add("1.2.840.113556.1.4.805");
        supportedControls.add("1.2.840.113556.1.4.319");
        supportedControls.add("2.16.840.1.113730.3.4.2");
        supportedControls.add("1.2.840.113556.1.4.473");
        supportedControls.add("2.16.840.1.113730.3.4.9");
        supportedFeatures = new HashSet();
    }
}

