/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.Arrays;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.util.StaticUtils;

public class State
extends DatabaseContainer {
    private static final byte[] falseBytes = new byte[]{0};
    private static final byte[] trueBytes = new byte[]{1};

    State(String name, Environment env, EntryContainer entryContainer) throws DatabaseException {
        super(name, env, entryContainer);
        DatabaseConfig dbNodupsConfig = new DatabaseConfig();
        if (env.getConfig().getReadOnly()) {
            dbNodupsConfig.setReadOnly(true);
            dbNodupsConfig.setAllowCreate(false);
            dbNodupsConfig.setTransactional(false);
        } else if (!env.getConfig().getTransactional()) {
            dbNodupsConfig.setAllowCreate(true);
            dbNodupsConfig.setTransactional(false);
            dbNodupsConfig.setDeferredWrite(true);
        } else {
            dbNodupsConfig.setAllowCreate(true);
            dbNodupsConfig.setTransactional(true);
        }
        this.dbConfig = dbNodupsConfig;
    }

    private DatabaseEntry keyForIndex(DatabaseContainer index) throws DatabaseException {
        String shortName = index.getName().replace(this.entryContainer.getDatabasePrefix(), "");
        DatabaseEntry key = new DatabaseEntry(StaticUtils.getBytes(shortName));
        return key;
    }

    public boolean removeIndexTrustState(Transaction txn, DatabaseContainer index) throws DatabaseException {
        DatabaseEntry key = this.keyForIndex(index);
        OperationStatus status = this.delete(txn, key);
        return status == OperationStatus.SUCCESS;
    }

    public boolean getIndexTrustState(Transaction txn, DatabaseContainer index) throws DatabaseException {
        DatabaseEntry data;
        DatabaseEntry key = this.keyForIndex(index);
        OperationStatus status = this.read(txn, key, data = new DatabaseEntry(), LockMode.DEFAULT);
        if (status != OperationStatus.SUCCESS) {
            return false;
        }
        byte[] bytes = data.getData();
        return Arrays.equals(bytes, trueBytes);
    }

    public boolean putIndexTrustState(Transaction txn, DatabaseContainer index, boolean trusted) throws DatabaseException {
        DatabaseEntry key = this.keyForIndex(index);
        DatabaseEntry data = new DatabaseEntry();
        if (trusted) {
            data.setData(trueBytes);
        } else {
            data.setData(falseBytes);
        }
        OperationStatus status = this.put(txn, key, data);
        return status == OperationStatus.SUCCESS;
    }
}

