/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb.importLDIF;

import java.nio.ByteBuffer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.JebFormat;

public class ImportIDSet {
    private long[] array = null;
    private int count = 0;
    private boolean isDefined = true;
    private long undefinedSize = 0L;
    private ByteBuffer key;
    private int limit = -1;
    private boolean doCount = false;

    public ImportIDSet(int size, int limit, boolean doCount) {
        this.array = new long[size + 128];
        this.limit = limit == 0 ? Integer.MAX_VALUE : limit;
        this.doCount = doCount;
    }

    public ImportIDSet() {
    }

    public void clear(boolean indexParams) {
        this.undefinedSize = 0L;
        this.isDefined = true;
        this.count = 0;
        if (indexParams) {
            this.doCount = false;
            this.limit = -1;
        }
    }

    public boolean isDefined() {
        return this.isDefined;
    }

    long getUndefinedSize() {
        return this.undefinedSize;
    }

    void setUndefined() {
        this.array = null;
        this.isDefined = false;
    }

    public void merge(ImportIDSet importIDSet) {
        if (this.limit == -1) {
            this.doCount = importIDSet.doCount;
            this.limit = importIDSet.limit;
        }
        if (!this.isDefined() && !importIDSet.isDefined()) {
            if (this.doCount) {
                this.undefinedSize += importIDSet.getUndefinedSize();
            }
        } else if (!this.isDefined()) {
            if (this.doCount) {
                this.undefinedSize += (long)importIDSet.size();
            }
        } else if (!importIDSet.isDefined()) {
            this.isDefined = false;
            this.undefinedSize = this.doCount ? (long)this.size() + importIDSet.getUndefinedSize() : Long.MAX_VALUE;
            this.array = null;
            this.count = 0;
        } else if (this.count + importIDSet.size() > this.limit) {
            this.isDefined = false;
            this.undefinedSize = this.doCount ? (long)(this.size() + importIDSet.size()) : Long.MAX_VALUE;
            this.array = null;
            this.count = 0;
        } else {
            this.addAll(importIDSet);
        }
    }

    public void addEntryID(EntryID entryID) {
        this.addEntryID(entryID.longValue());
    }

    public void addEntryID(long l) {
        if (!this.isDefined()) {
            if (this.doCount) {
                ++this.undefinedSize;
            }
            return;
        }
        if (l < 0L || this.isDefined() && this.count + 1 > this.limit) {
            this.isDefined = false;
            this.array = null;
            this.undefinedSize = this.doCount ? (long)(this.count + 1) : Long.MAX_VALUE;
            this.count = 0;
        } else {
            this.add(l);
        }
    }

    private boolean mergeCount(byte[] dBbytes, ImportIDSet importIdSet) {
        boolean dbUndefined;
        boolean incrementLimitCount = false;
        boolean bl = dbUndefined = (dBbytes[0] & 0x80) == 128;
        if (dbUndefined && !importIdSet.isDefined()) {
            this.undefinedSize = JebFormat.entryIDUndefinedSizeFromDatabase(dBbytes) + importIdSet.getUndefinedSize();
            this.isDefined = false;
        } else if (dbUndefined && importIdSet.isDefined()) {
            this.undefinedSize = JebFormat.entryIDUndefinedSizeFromDatabase(dBbytes) + (long)importIdSet.size();
            this.isDefined = false;
        } else if (!importIdSet.isDefined()) {
            int dbSize = JebFormat.entryIDListFromDatabase(dBbytes).length;
            this.undefinedSize = (long)dbSize + importIdSet.getUndefinedSize();
            this.isDefined = false;
            incrementLimitCount = true;
        } else {
            this.array = JebFormat.entryIDListFromDatabase(dBbytes);
            if (this.array.length + importIdSet.size() > this.limit) {
                this.undefinedSize = this.array.length + importIdSet.size();
                this.isDefined = false;
                incrementLimitCount = true;
            } else {
                this.count = this.array.length;
                this.addAll(importIdSet);
            }
        }
        return incrementLimitCount;
    }

    public void remove(byte[] bytes, ImportIDSet importIdSet) {
        boolean dbUndefined;
        boolean bl = dbUndefined = (bytes[0] & 0x80) == 128;
        if (dbUndefined) {
            this.isDefined = false;
            importIdSet.setUndefined();
            this.undefinedSize = Long.MAX_VALUE;
        } else if (!importIdSet.isDefined()) {
            this.isDefined = false;
            this.undefinedSize = Long.MAX_VALUE;
        } else {
            this.array = JebFormat.entryIDListFromDatabase(bytes);
            if (this.array.length - importIdSet.size() > this.limit) {
                this.isDefined = false;
                this.count = 0;
                importIdSet.setUndefined();
                this.undefinedSize = Long.MAX_VALUE;
            } else {
                this.count = this.array.length;
                this.removeAll(importIdSet);
            }
        }
    }

    public boolean merge(byte[] bytes, ImportIDSet importIdSet) {
        boolean incrementLimitCount = false;
        if (this.doCount) {
            incrementLimitCount = this.mergeCount(bytes, importIdSet);
        } else {
            boolean dbUndefined;
            boolean bl = dbUndefined = (bytes[0] & 0x80) == 128;
            if (dbUndefined) {
                this.isDefined = false;
                importIdSet.setUndefined();
                this.undefinedSize = Long.MAX_VALUE;
                this.count = 0;
            } else if (!importIdSet.isDefined()) {
                this.isDefined = false;
                incrementLimitCount = true;
                this.undefinedSize = Long.MAX_VALUE;
                this.count = 0;
            } else {
                this.array = JebFormat.entryIDListFromDatabase(bytes);
                if (this.array.length + importIdSet.size() > this.limit) {
                    this.isDefined = false;
                    incrementLimitCount = true;
                    this.count = 0;
                    importIdSet.setUndefined();
                    this.undefinedSize = Long.MAX_VALUE;
                } else {
                    this.count = this.array.length;
                    this.addAll(importIdSet);
                }
            }
        }
        return incrementLimitCount;
    }

    private void removeAll(ImportIDSet that) {
        long[] newArray = new long[this.array.length];
        int c = 0;
        for (int i = 0; i < this.count; ++i) {
            if (ImportIDSet.binarySearch(that.array, that.count, this.array[i]) >= 0) continue;
            newArray[c++] = this.array[i];
        }
        this.array = newArray;
        this.count = c;
    }

    private void addAll(ImportIDSet that) {
        int bRemain;
        this.resize(this.count + that.count);
        if (that.count == 0) {
            return;
        }
        if (this.count == 0 || that.array[0] > this.array[this.count - 1]) {
            System.arraycopy(that.array, 0, this.array, this.count, that.count);
            this.count += that.count;
            return;
        }
        if (this.array[0] > that.array[that.count - 1]) {
            System.arraycopy(this.array, 0, this.array, that.count, this.count);
            System.arraycopy(that.array, 0, this.array, 0, that.count);
            this.count += that.count;
            return;
        }
        int destPos = ImportIDSet.binarySearch(this.array, this.count, that.array[0]);
        if (destPos < 0) {
            destPos = -(destPos + 1);
        }
        int aCount = this.count - destPos;
        int aPos = destPos + that.count;
        int aEnd = aPos + aCount;
        System.arraycopy(this.array, destPos, this.array, aPos, aCount);
        if (this.array[aPos] > that.array[that.count - 1]) {
            System.arraycopy(that.array, 0, this.array, destPos, that.count);
            this.count += that.count;
            return;
        }
        int bPos = 0;
        while (aPos < aEnd && bPos < that.count) {
            if (this.array[aPos] < that.array[bPos]) {
                this.array[destPos++] = this.array[aPos++];
                continue;
            }
            if (this.array[aPos] > that.array[bPos]) {
                this.array[destPos++] = that.array[bPos++];
                continue;
            }
            this.array[destPos++] = this.array[aPos++];
            ++bPos;
        }
        int aRemain = aEnd - aPos;
        if (aRemain > 0) {
            System.arraycopy(this.array, aPos, this.array, destPos, aRemain);
            destPos += aRemain;
        }
        if ((bRemain = that.count - bPos) > 0) {
            System.arraycopy(that.array, bPos, this.array, destPos, bRemain);
            destPos += bRemain;
        }
        this.count = destPos;
    }

    public int size() {
        return this.count;
    }

    private boolean add(long v) {
        this.resize(this.count + 1);
        if (this.count == 0 || v > this.array[this.count - 1]) {
            this.array[this.count++] = v;
            return true;
        }
        int pos = ImportIDSet.binarySearch(this.array, this.count, v);
        if (pos >= 0) {
            return false;
        }
        pos = -(pos + 1);
        System.arraycopy(this.array, pos, this.array, pos + 1, this.count - pos);
        this.array[pos] = v;
        ++this.count;
        return true;
    }

    private static int binarySearch(long[] a, int count, long key) {
        int low = 0;
        int high = count - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            long midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private void resize(int size) {
        if (this.array == null) {
            this.array = new long[size];
        } else if (this.array.length < size) {
            int newSize;
            int n = newSize = this.array.length == 0 ? 1 : this.array.length;
            while ((newSize *= 2) < size) {
            }
            long[] newBytes = new long[newSize];
            System.arraycopy(this.array, 0, newBytes, 0, this.count);
            this.array = newBytes;
        }
    }

    public byte[] toDatabase() {
        if (this.isDefined) {
            return this.encode(null);
        }
        return JebFormat.entryIDUndefinedSizeToDatabase(this.undefinedSize);
    }

    private byte[] encode(byte[] bytes) {
        int encodedSize = this.count * 8;
        if (bytes == null || bytes.length < encodedSize) {
            bytes = new byte[encodedSize];
        }
        int pos = 0;
        for (int i = 0; i < this.count; ++i) {
            long v = this.array[i] & 0xFFFFFFFFL;
            bytes[pos++] = (byte)(v >>> 56 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 48 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 40 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 32 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 24 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 16 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 8 & 0xFFL);
            bytes[pos++] = (byte)(v & 0xFFL);
        }
        return bytes;
    }

    public void setKey(ByteBuffer key) {
        this.key = key;
    }

    public ByteBuffer getKey() {
        return this.key;
    }
}

