/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class ConfigEntry {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ConcurrentHashMap<DN, ConfigEntry> children;
    private ConfigEntry parent;
    private CopyOnWriteArrayList<ConfigAddListener> addListeners;
    private CopyOnWriteArrayList<ConfigChangeListener> changeListeners;
    private CopyOnWriteArrayList<ConfigDeleteListener> deleteListeners;
    private Entry entry;
    private Object entryLock;

    public ConfigEntry(Entry entry, ConfigEntry parent) {
        this.entry = entry;
        this.parent = parent;
        this.children = new ConcurrentHashMap();
        this.addListeners = new CopyOnWriteArrayList();
        this.changeListeners = new CopyOnWriteArrayList();
        this.deleteListeners = new CopyOnWriteArrayList();
        this.entryLock = new Object();
    }

    public Entry getEntry() {
        return this.entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntry(Entry entry) {
        Object object = this.entryLock;
        synchronized (object) {
            this.entry = entry;
        }
    }

    public DN getDN() {
        return this.entry.getDN();
    }

    public boolean hasObjectClass(String name) {
        ObjectClass oc = DirectoryServer.getObjectClass(name.toLowerCase());
        if (oc == null) {
            oc = DirectoryServer.getDefaultObjectClass(name);
        }
        return this.entry.hasObjectClass(oc);
    }

    public ConfigAttribute getConfigAttribute(ConfigAttribute stub) throws ConfigException {
        List<Attribute> attrList;
        String attrName = stub.getName();
        AttributeType attrType = DirectoryServer.getAttributeType(attrName.toLowerCase());
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType(attrName);
        }
        if ((attrList = this.entry.getAttribute(attrType)) == null || attrList.isEmpty()) {
            return null;
        }
        return stub.getConfigAttribute(attrList);
    }

    public void putConfigAttribute(ConfigAttribute attribute) {
        String name = attribute.getName();
        AttributeType attrType = DirectoryServer.getAttributeType(name.toLowerCase());
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType(name, attribute.getSyntax());
        }
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(2);
        AttributeBuilder builder = new AttributeBuilder(attrType, name);
        builder.addAll(attribute.getActiveValues());
        attrs.add(builder.toAttribute());
        if (attribute.hasPendingValues()) {
            builder = new AttributeBuilder(attrType, name);
            builder.setOption("pending");
            builder.addAll(attribute.getPendingValues());
            attrs.add(builder.toAttribute());
        }
        this.entry.putAttribute(attrType, attrs);
    }

    public boolean removeConfigAttribute(String lowerName) {
        for (AttributeType t : this.entry.getUserAttributes().keySet()) {
            if (!t.hasNameOrOID(lowerName)) continue;
            this.entry.getUserAttributes().remove(t);
            return true;
        }
        for (AttributeType t : this.entry.getOperationalAttributes().keySet()) {
            if (!t.hasNameOrOID(lowerName)) continue;
            this.entry.getOperationalAttributes().remove(t);
            return true;
        }
        return false;
    }

    public ConfigEntry getParent() {
        return this.parent;
    }

    public ConcurrentHashMap<DN, ConfigEntry> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(ConfigEntry childEntry) throws ConfigException {
        ConfigEntry conflictingChild;
        Object object = this.entryLock;
        synchronized (object) {
            conflictingChild = this.children.putIfAbsent(childEntry.getDN(), childEntry);
        }
        if (conflictingChild != null) {
            Message message = ConfigMessages.ERR_CONFIG_ENTRY_CONFLICTING_CHILD.get(conflictingChild.getDN().toString(), this.entry.getDN().toString());
            throw new ConfigException(message);
        }
    }

    public ConfigEntry removeChild(DN childDN) throws ConfigException {
        Object object = this.entryLock;
        synchronized (object) {
            try {
                ConfigEntry childEntry = this.children.get(childDN);
                if (childEntry == null) {
                    Message message = ConfigMessages.ERR_CONFIG_ENTRY_NO_SUCH_CHILD.get(childDN.toString(), this.entry.getDN().toString());
                    throw new ConfigException(message);
                }
                if (childEntry.hasChildren()) {
                    Message message = ConfigMessages.ERR_CONFIG_ENTRY_CANNOT_REMOVE_NONLEAF.get(childDN.toString(), this.entry.getDN().toString());
                    throw new ConfigException(message);
                }
                this.children.remove(childDN);
                return childEntry;
            }
            catch (ConfigException ce) {
                throw ce;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ConfigMessages.ERR_CONFIG_ENTRY_CANNOT_REMOVE_CHILD.get(String.valueOf(childDN), String.valueOf(this.entry.getDN()), StaticUtils.stackTraceToSingleLineString(e));
                throw new ConfigException(message, (Throwable)e);
            }
        }
    }

    public ConfigEntry duplicate() {
        return new ConfigEntry(this.entry.duplicate(false), this.parent);
    }

    public CopyOnWriteArrayList<ConfigChangeListener> getChangeListeners() {
        return this.changeListeners;
    }

    public void registerChangeListener(ConfigChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public boolean deregisterChangeListener(ConfigChangeListener listener) {
        return this.changeListeners.remove(listener);
    }

    public CopyOnWriteArrayList<ConfigAddListener> getAddListeners() {
        return this.addListeners;
    }

    public void registerAddListener(ConfigAddListener listener) {
        this.addListeners.addIfAbsent(listener);
    }

    public void deregisterAddListener(ConfigAddListener listener) {
        this.addListeners.remove(listener);
    }

    public CopyOnWriteArrayList<ConfigDeleteListener> getDeleteListeners() {
        return this.deleteListeners;
    }

    public void registerDeleteListener(ConfigDeleteListener listener) {
        this.deleteListeners.addIfAbsent(listener);
    }

    public void deregisterDeleteListener(ConfigDeleteListener listener) {
        this.deleteListeners.remove(listener);
    }
}

