/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

public class AuthorizationIdentityResponseControl
extends Control {
    public static final ControlDecoder<AuthorizationIdentityResponseControl> DECODER = new Decoder();
    private String authorizationID;

    public AuthorizationIdentityResponseControl() {
        this(false);
    }

    public AuthorizationIdentityResponseControl(boolean isCritical) {
        super("2.16.840.1.113730.3.4.15", isCritical);
    }

    public AuthorizationIdentityResponseControl(String authorizationID) {
        this(false, authorizationID);
    }

    public AuthorizationIdentityResponseControl(boolean isCritical, String authorizationID) {
        super("2.16.840.1.113730.3.4.15", isCritical);
        this.authorizationID = authorizationID;
    }

    public AuthorizationIdentityResponseControl(DN authorizationDN) {
        super("2.16.840.1.113730.3.4.15", false);
        this.authorizationID = authorizationDN == null ? "dn:" : "dn:" + authorizationDN.toString();
    }

    @Override
    public void writeValue(ASN1Writer writer) throws IOException {
        writer.writeOctetString(this.authorizationID);
    }

    public String getAuthorizationID() {
        return this.authorizationID;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("AuthorizationIdentityResponseControl(authzID=\"");
        buffer.append(this.authorizationID);
        buffer.append("\")");
    }

    private static final class Decoder
    implements ControlDecoder<AuthorizationIdentityResponseControl> {
        private Decoder() {
        }

        @Override
        public AuthorizationIdentityResponseControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            if (value == null) {
                Message message = ProtocolMessages.ERR_AUTHZIDRESP_NO_CONTROL_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            try {
                String authID = value.toString();
                return new AuthorizationIdentityResponseControl(isCritical, authID);
            }
            catch (Exception e) {
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, Message.EMPTY);
            }
        }

        @Override
        public String getOID() {
            return "2.16.840.1.113730.3.4.15";
        }
    }
}

