/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class SubentriesControl
extends Control {
    public static final ControlDecoder<SubentriesControl> DECODER = new Decoder();
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean visibility = false;

    public SubentriesControl(boolean isCritical, boolean visibility) {
        super("1.3.6.1.4.1.4203.1.10.1", isCritical);
        this.visibility = visibility;
    }

    @Override
    protected void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        writer.writeBoolean(this.visibility);
        writer.writeEndSequence();
    }

    public boolean getVisibility() {
        return this.visibility;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("SubentriesControl(visibility=\"");
        buffer.append(Boolean.toString(this.visibility));
        buffer.append("\")");
    }

    private static final class Decoder
    implements ControlDecoder<SubentriesControl> {
        private Decoder() {
        }

        @Override
        public SubentriesControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            boolean visibility;
            if (value == null) {
                Message message = ProtocolMessages.ERR_SUBENTRIES_NO_CONTROL_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            ASN1Reader reader = ASN1.getReader(value);
            try {
                visibility = reader.readBoolean();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_SUBENTRIES_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, e);
            }
            return new SubentriesControl(isCritical, visibility);
        }

        @Override
        public String getOID() {
            return "1.3.6.1.4.1.4203.1.10.1";
        }
    }
}

