/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.api.ChangeNotificationListener;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.DITCacheMap;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.operation.PostResponseAddOperation;
import org.opends.server.types.operation.PostResponseDeleteOperation;
import org.opends.server.types.operation.PostResponseModifyDNOperation;
import org.opends.server.types.operation.PostResponseModifyOperation;

public class AuthenticatedUsers
implements ChangeNotificationListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DITCacheMap<CopyOnWriteArraySet<ClientConnection>> userMap = new DITCacheMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public AuthenticatedUsers() {
        DirectoryServer.registerChangeNotificationListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(DN userDN, ClientConnection clientConnection) {
        this.lock.writeLock().lock();
        try {
            CopyOnWriteArraySet<ClientConnection> connectionSet = this.userMap.get(userDN);
            if (connectionSet == null) {
                connectionSet = new CopyOnWriteArraySet();
                connectionSet.add(clientConnection);
                this.userMap.put(userDN, connectionSet);
            } else {
                connectionSet.add(clientConnection);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DN userDN, ClientConnection clientConnection) {
        this.lock.writeLock().lock();
        try {
            CopyOnWriteArraySet<ClientConnection> connectionSet = this.userMap.get(userDN);
            if (connectionSet != null) {
                connectionSet.remove(clientConnection);
                if (connectionSet.isEmpty()) {
                    this.userMap.remove(userDN);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopyOnWriteArraySet<ClientConnection> get(DN userDN) {
        this.lock.readLock().lock();
        try {
            CopyOnWriteArraySet<ClientConnection> copyOnWriteArraySet = this.userMap.get(userDN);
            return copyOnWriteArraySet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void handleAddOperation(PostResponseAddOperation addOperation, Entry entry) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDeleteOperation(PostResponseDeleteOperation deleteOperation, Entry entry) {
        HashSet arraySet = new HashSet();
        this.lock.writeLock().lock();
        try {
            this.userMap.removeSubtree(entry.getDN(), arraySet);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        for (CopyOnWriteArraySet connectionSet : arraySet) {
            for (ClientConnection conn : connectionSet) {
                Message message = CoreMessages.WARN_CLIENTCONNECTION_DISCONNECT_DUE_TO_DELETE.get(String.valueOf(entry.getDN()));
                conn.disconnect(DisconnectReason.INVALID_CREDENTIALS, true, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleModifyOperation(PostResponseModifyOperation modifyOperation, Entry oldEntry, Entry newEntry) {
        this.lock.writeLock().lock();
        try {
            CopyOnWriteArraySet<ClientConnection> connectionSet = this.userMap.get(oldEntry.getDN());
            if (connectionSet != null) {
                for (ClientConnection conn : connectionSet) {
                    conn.updateAuthenticationInfo(oldEntry, newEntry);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleModifyDNOperation(PostResponseModifyDNOperation modifyDNOperation, Entry oldEntry, Entry newEntry) {
        String oldDNString = oldEntry.getDN().toNormalizedString();
        String newDNString = newEntry.getDN().toNormalizedString();
        this.lock.writeLock().lock();
        try {
            HashSet arraySet = new HashSet();
            this.userMap.removeSubtree(oldEntry.getDN(), arraySet);
            for (CopyOnWriteArraySet connectionSet : arraySet) {
                DN authNDN = null;
                DN authZDN = null;
                DN newAuthNDN = null;
                DN newAuthZDN = null;
                CopyOnWriteArraySet<ClientConnection> newAuthNSet = null;
                CopyOnWriteArraySet<ClientConnection> newAuthZSet = null;
                for (ClientConnection conn : connectionSet) {
                    block16: {
                        int oldDNIndex;
                        StringBuilder builder;
                        block15: {
                            if (authNDN == null) {
                                authNDN = conn.getAuthenticationInfo().getAuthenticationDN();
                                try {
                                    builder = new StringBuilder(authNDN.toNormalizedString());
                                    oldDNIndex = builder.lastIndexOf(oldDNString);
                                    builder.replace(oldDNIndex, builder.length(), newDNString);
                                    String newAuthNDNString = builder.toString();
                                    newAuthNDN = DN.decode(newAuthNDNString);
                                }
                                catch (Exception e) {
                                    if (!DebugLogger.debugEnabled()) break block15;
                                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                }
                            }
                        }
                        if (authZDN == null) {
                            authZDN = conn.getAuthenticationInfo().getAuthorizationDN();
                            try {
                                builder = new StringBuilder(authZDN.toNormalizedString());
                                oldDNIndex = builder.lastIndexOf(oldDNString);
                                builder.replace(oldDNIndex, builder.length(), newDNString);
                                String newAuthZDNString = builder.toString();
                                newAuthZDN = DN.decode(newAuthZDNString);
                            }
                            catch (Exception e) {
                                if (!DebugLogger.debugEnabled()) break block16;
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                        }
                    }
                    if (newAuthNDN != null && authNDN != null && authNDN.isDescendantOf(oldEntry.getDN())) {
                        if (newAuthNSet == null) {
                            newAuthNSet = new CopyOnWriteArraySet<ClientConnection>();
                        }
                        conn.getAuthenticationInfo().setAuthenticationDN(newAuthNDN);
                        newAuthNSet.add(conn);
                    }
                    if (newAuthZDN == null || authZDN == null || !authZDN.isDescendantOf(oldEntry.getDN())) continue;
                    if (newAuthZSet == null) {
                        newAuthZSet = new CopyOnWriteArraySet<ClientConnection>();
                    }
                    conn.getAuthenticationInfo().setAuthorizationDN(newAuthZDN);
                    newAuthZSet.add(conn);
                }
                if (newAuthNDN != null && newAuthNSet != null) {
                    this.userMap.put(newAuthNDN, newAuthNSet);
                }
                if (newAuthZDN == null || newAuthZSet == null) continue;
                this.userMap.put(newAuthZDN, newAuthZSet);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

