/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.api.Backend;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Validator;

public class BaseDnRegistry {
    private TreeMap<DN, Backend> baseDNs;
    private TreeMap<DN, Backend> privateNamingContexts;
    private TreeMap<DN, Backend> publicNamingContexts;
    private boolean testOnly;

    public List<Message> registerBaseDN(DN baseDN, Backend backend, boolean isPrivate) throws DirectoryException {
        DN parentDN;
        LinkedList<Message> errors = new LinkedList<Message>();
        Backend existingBackend = this.baseDNs.get(baseDN);
        if (existingBackend != null) {
            Message message = CoreMessages.ERR_REGISTER_BASEDN_ALREADY_EXISTS.get(String.valueOf(baseDN), backend.getBackendID(), existingBackend.getBackendID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        LinkedList<DN> otherBaseDNs = new LinkedList<DN>();
        for (DN dn : this.baseDNs.keySet()) {
            Backend b = this.baseDNs.get(dn);
            if (!b.equals(backend)) continue;
            otherBaseDNs.add(dn);
            if (!baseDN.isAncestorOf(dn) && !baseDN.isDescendantOf(dn)) continue;
            Message message = CoreMessages.ERR_REGISTER_BASEDN_HIERARCHY_CONFLICT.get(String.valueOf(baseDN), backend.getBackendID(), String.valueOf(dn));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        Backend superiorBackend = null;
        for (parentDN = baseDN.getParent(); parentDN != null; parentDN = parentDN.getParent()) {
            if (!this.baseDNs.containsKey(parentDN)) continue;
            DN superiorBaseDN = parentDN;
            superiorBackend = this.baseDNs.get(parentDN);
            for (DN dn : otherBaseDNs) {
                if (dn.isDescendantOf(superiorBaseDN)) continue;
                Message message = CoreMessages.ERR_REGISTER_BASEDN_DIFFERENT_PARENT_BASES.get(String.valueOf(baseDN), backend.getBackendID(), String.valueOf(dn));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            break;
        }
        if (superiorBackend == null && backend.getParentBackend() != null) {
            Message message = CoreMessages.ERR_REGISTER_BASEDN_NEW_BASE_NOT_SUBORDINATE.get(String.valueOf(baseDN), backend.getBackendID(), backend.getParentBackend().getBackendID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        LinkedList<Backend> subordinateBackends = new LinkedList<Backend>();
        LinkedList<DN> subordinateBaseDNs = new LinkedList<DN>();
        block3: for (DN dn : this.baseDNs.keySet()) {
            Backend b = this.baseDNs.get(dn);
            for (parentDN = dn.getParent(); parentDN != null; parentDN = parentDN.getParent()) {
                if (parentDN.equals(baseDN)) {
                    subordinateBaseDNs.add(dn);
                    subordinateBackends.add(b);
                    continue block3;
                }
                if (this.baseDNs.containsKey(parentDN)) continue block3;
            }
        }
        if (superiorBackend != null && superiorBackend.entryExists(baseDN)) {
            Message message = CoreMessages.WARN_REGISTER_BASEDN_ENTRIES_IN_MULTIPLE_BACKENDS.get(superiorBackend.getBackendID(), String.valueOf(baseDN), backend.getBackendID());
            errors.add(message);
        }
        this.baseDNs.put(baseDN, backend);
        if (superiorBackend == null) {
            if (isPrivate) {
                if (!this.testOnly) {
                    backend.setPrivateBackend(true);
                }
                this.privateNamingContexts.put(baseDN, backend);
            } else {
                if (!this.testOnly) {
                    backend.setPrivateBackend(false);
                }
                this.publicNamingContexts.put(baseDN, backend);
            }
        } else if (otherBaseDNs.isEmpty() && !this.testOnly) {
            backend.setParentBackend(superiorBackend);
            superiorBackend.addSubordinateBackend(backend);
        }
        if (!this.testOnly) {
            for (Backend b : subordinateBackends) {
                Backend oldParentBackend = b.getParentBackend();
                if (oldParentBackend != null) {
                    oldParentBackend.removeSubordinateBackend(b);
                }
                b.setParentBackend(backend);
                backend.addSubordinateBackend(b);
            }
        }
        for (DN dn : subordinateBaseDNs) {
            this.publicNamingContexts.remove(dn);
            this.privateNamingContexts.remove(dn);
        }
        return errors;
    }

    public List<Message> deregisterBaseDN(DN baseDN) throws DirectoryException {
        LinkedList<Message> errors;
        block14: {
            LinkedList<DN> otherBaseDNs;
            LinkedList<Backend> subordinateBackends;
            Backend superiorBackend;
            Backend backend;
            block13: {
                errors = new LinkedList<Message>();
                Validator.ensureNotNull(baseDN);
                backend = this.baseDNs.get(baseDN);
                if (backend == null) {
                    Message message = CoreMessages.ERR_DEREGISTER_BASEDN_NOT_REGISTERED.get(String.valueOf(baseDN));
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                }
                superiorBackend = backend.getParentBackend();
                subordinateBackends = new LinkedList<Backend>();
                if (backend.getSubordinateBackends() != null) {
                    block0: for (Backend b : backend.getSubordinateBackends()) {
                        for (DN dn : b.getBaseDNs()) {
                            if (!dn.isDescendantOf(baseDN)) continue;
                            subordinateBackends.add(b);
                            continue block0;
                        }
                    }
                }
                otherBaseDNs = new LinkedList<DN>();
                for (DN dn : this.baseDNs.keySet()) {
                    Backend b;
                    if (dn.equals(baseDN) || !backend.equals(b = this.baseDNs.get(dn))) continue;
                    otherBaseDNs.add(dn);
                }
                this.baseDNs.remove(baseDN);
                this.publicNamingContexts.remove(baseDN);
                this.privateNamingContexts.remove(baseDN);
                if (superiorBackend != null) break block13;
                for (Backend b : subordinateBackends) {
                    if (!this.testOnly) {
                        b.setParentBackend(null);
                        backend.removeSubordinateBackend(b);
                    }
                    for (DN dn : b.getBaseDNs()) {
                        if (b.isPrivateBackend()) {
                            this.privateNamingContexts.put(dn, b);
                            continue;
                        }
                        this.publicNamingContexts.put(dn, b);
                    }
                }
                break block14;
            }
            if (otherBaseDNs.isEmpty() && !this.testOnly) {
                superiorBackend.removeSubordinateBackend(backend);
            }
            if (subordinateBackends.isEmpty()) break block14;
            if (!DirectoryServer.getInstance().isShuttingDown()) {
                Message message = CoreMessages.WARN_DEREGISTER_BASEDN_MISSING_HIERARCHY.get(String.valueOf(baseDN), backend.getBackendID());
                errors.add(message);
            }
            if (!this.testOnly) {
                for (Backend b : subordinateBackends) {
                    backend.removeSubordinateBackend(b);
                    superiorBackend.addSubordinateBackend(b);
                    b.setParentBackend(superiorBackend);
                }
            }
        }
        return errors;
    }

    BaseDnRegistry() {
        this(new TreeMap<DN, Backend>(), new TreeMap<DN, Backend>(), new TreeMap<DN, Backend>(), false);
    }

    BaseDnRegistry copy() {
        return new BaseDnRegistry(new TreeMap<DN, Backend>((SortedMap<DN, Backend>)this.baseDNs), new TreeMap<DN, Backend>((SortedMap<DN, Backend>)this.publicNamingContexts), new TreeMap<DN, Backend>((SortedMap<DN, Backend>)this.privateNamingContexts), true);
    }

    private BaseDnRegistry(TreeMap<DN, Backend> baseDNs, TreeMap<DN, Backend> publicNamingContexts, TreeMap<DN, Backend> privateNamingContexts, boolean testOnly) {
        this.baseDNs = baseDNs;
        this.publicNamingContexts = publicNamingContexts;
        this.privateNamingContexts = privateNamingContexts;
        this.testOnly = testOnly;
    }

    Map<DN, Backend> getBaseDnMap() {
        return this.baseDNs;
    }

    Map<DN, Backend> getPublicNamingContextsMap() {
        return this.publicNamingContexts;
    }

    Map<DN, Backend> getPrivateNamingContextsMap() {
        return this.privateNamingContexts;
    }

    boolean containsNamingContext(DN dn) {
        return this.privateNamingContexts.containsKey(dn) || this.publicNamingContexts.containsKey(dn);
    }

    void clear() {
        if (this.baseDNs != null) {
            this.baseDNs.clear();
        }
        if (this.privateNamingContexts != null) {
            this.privateNamingContexts.clear();
        }
        if (this.publicNamingContexts != null) {
            this.publicNamingContexts.clear();
        }
    }
}

