/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.EntryCacheCfgDefn;
import org.opends.server.admin.std.server.EntryCacheCfg;
import org.opends.server.admin.std.server.EntryCacheMonitorProviderCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.EntryCache;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.DefaultEntryCache;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.monitors.EntryCacheMonitorProvider;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class EntryCacheConfigManager
implements ConfigurationChangeListener<EntryCacheCfg>,
ConfigurationAddListener<EntryCacheCfg>,
ConfigurationDeleteListener<EntryCacheCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DefaultEntryCache _defaultEntryCache = null;
    private SortedMap<Integer, EntryCache<? extends EntryCacheCfg>> cacheOrderMap = new TreeMap<Integer, EntryCache<? extends EntryCacheCfg>>();
    private HashMap<String, Integer> cacheNameToLevelMap = new HashMap();
    private static final String DEFAULT_ENTRY_CACHE_MONITOR_PROVIDER = "Entry Caches";

    public void initializeDefaultEntryCache() throws InitializationException {
        try {
            DefaultEntryCache defaultCache = new DefaultEntryCache();
            defaultCache.initializeEntryCache(null);
            DirectoryServer.setEntryCache(defaultCache);
            this._defaultEntryCache = defaultCache;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_ENTRYCACHE_CANNOT_INSTALL_DEFAULT_CACHE.get(StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    public void initializeEntryCache() throws ConfigException {
        ConfigEntry entryCacheBase;
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addEntryCacheAddListener(this);
        rootConfiguration.addEntryCacheDeleteListener(this);
        try {
            DN configEntryDN = DN.decode("cn=Entry Caches,cn=config");
            entryCacheBase = DirectoryServer.getConfigEntry(configEntryDN);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            ErrorLogger.logError(ConfigMessages.WARN_CONFIG_ENTRYCACHE_NO_CONFIG_ENTRY.get());
            return;
        }
        if (entryCacheBase == null) {
            ErrorLogger.logError(ConfigMessages.WARN_CONFIG_ENTRYCACHE_NO_CONFIG_ENTRY.get());
            return;
        }
        for (String cacheName : rootConfiguration.listEntryCaches()) {
            EntryCacheCfg configuration = rootConfiguration.getEntryCache(cacheName);
            configuration.addChangeListener(this);
            if (!this.cacheOrderMap.isEmpty() && this.cacheOrderMap.containsKey(configuration.getCacheLevel())) {
                ErrorLogger.logError(ConfigMessages.ERR_CONFIG_ENTRYCACHE_CONFIG_LEVEL_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), configuration.getCacheLevel()));
                continue;
            }
            if (!configuration.isEnabled()) continue;
            String className = configuration.getJavaClass();
            try {
                this.loadAndInstallEntryCache(className, configuration);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ie.getMessageObject());
            }
        }
        if (rootConfiguration.getGlobalConfiguration().isEntryCachePreload() && !this.cacheOrderMap.isEmpty()) {
            Map<DN, Backend> baseDNMap = DirectoryServer.getPublicNamingContexts();
            HashSet<Backend> proccessedBackends = new HashSet<Backend>();
            for (Backend backend : baseDNMap.values()) {
                if (proccessedBackends.contains(backend)) continue;
                proccessedBackends.add(backend);
                try {
                    backend.preloadEntryCache();
                }
                catch (UnsupportedOperationException ex) {
                    Message message = ExtensionMessages.WARN_CACHE_PRELOAD_BACKEND_FAILED.get(backend.getBackendID());
                    ErrorLogger.logError(message);
                }
            }
        }
    }

    @Override
    public boolean isConfigurationChangeAcceptable(EntryCacheCfg configuration, List<Message> unacceptableReasons) {
        int currentCacheLevel;
        boolean status = true;
        String className = configuration.getJavaClass();
        try {
            this.loadEntryCache(className, configuration, false);
        }
        catch (InitializationException ie) {
            unacceptableReasons.add(ie.getMessageObject());
            status = false;
        }
        if (!this.cacheOrderMap.isEmpty() && !this.cacheNameToLevelMap.isEmpty() && this.cacheNameToLevelMap.get(configuration.dn().toNormalizedString()) != null && (currentCacheLevel = this.cacheNameToLevelMap.get(configuration.dn().toNormalizedString()).intValue()) != configuration.getCacheLevel() && this.cacheOrderMap.containsKey(configuration.getCacheLevel())) {
            unacceptableReasons.add(ConfigMessages.ERR_CONFIG_ENTRYCACHE_CONFIG_LEVEL_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), configuration.getCacheLevel()));
            status = false;
        }
        return status;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(EntryCacheCfg configuration) {
        EntryCache entryCache = null;
        if (!this.cacheOrderMap.isEmpty() && !this.cacheNameToLevelMap.isEmpty() && this.cacheNameToLevelMap.get(configuration.dn().toNormalizedString()) != null) {
            int currentCacheLevel = this.cacheNameToLevelMap.get(configuration.dn().toNormalizedString());
            entryCache = (EntryCache)this.cacheOrderMap.get(currentCacheLevel);
            if (currentCacheLevel != configuration.getCacheLevel()) {
                this.cacheOrderMap.remove(currentCacheLevel);
                this.cacheOrderMap.put(configuration.getCacheLevel(), entryCache);
                this.cacheNameToLevelMap.put(configuration.dn().toNormalizedString(), configuration.getCacheLevel());
            }
        }
        ConfigChangeResult changeResult = new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
        if (!configuration.isEnabled()) {
            configuration.getCacheLevel();
            if (entryCache != null) {
                EntryCacheMonitorProvider monitor = entryCache.getEntryCacheMonitor();
                if (monitor != null) {
                    DirectoryServer.deregisterMonitorProvider(monitor);
                    monitor.finalizeMonitorProvider();
                    entryCache.setEntryCacheMonitor(null);
                }
                entryCache.finalizeEntryCache();
                this.cacheOrderMap.remove(configuration.getCacheLevel());
                entryCache = null;
            }
            return changeResult;
        }
        this._defaultEntryCache.setCacheOrder(this.cacheOrderMap);
        String newClassName = configuration.getJavaClass();
        if (entryCache != null) {
            boolean classIsNew;
            String curClassName = entryCache.getClass().getName();
            boolean bl = classIsNew = !newClassName.equals(curClassName);
            if (classIsNew) {
                changeResult.setAdminActionRequired(true);
            }
            return changeResult;
        }
        try {
            this.loadAndInstallEntryCache(newClassName, configuration);
        }
        catch (InitializationException ie) {
            changeResult.addMessage(ie.getMessageObject());
            changeResult.setResultCode(DirectoryServer.getServerErrorResultCode());
            return changeResult;
        }
        return changeResult;
    }

    @Override
    public boolean isConfigurationAddAcceptable(EntryCacheCfg configuration, List<Message> unacceptableReasons) {
        boolean status = true;
        if (!this.cacheOrderMap.isEmpty() && this.cacheOrderMap.containsKey(configuration.getCacheLevel())) {
            unacceptableReasons.add(ConfigMessages.ERR_CONFIG_ENTRYCACHE_CONFIG_LEVEL_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), configuration.getCacheLevel()));
            status = false;
            return status;
        }
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadEntryCache(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                status = false;
            }
        }
        return status;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(EntryCacheCfg configuration) {
        ConfigChangeResult changeResult = new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
        configuration.addChangeListener(this);
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadAndInstallEntryCache(className, configuration);
            }
            catch (InitializationException ie) {
                changeResult.addMessage(ie.getMessageObject());
                changeResult.setResultCode(DirectoryServer.getServerErrorResultCode());
                return changeResult;
            }
        }
        return changeResult;
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(EntryCacheCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(EntryCacheCfg configuration) {
        EntryCache entryCache = null;
        if (!this.cacheOrderMap.isEmpty()) {
            entryCache = (EntryCache)this.cacheOrderMap.get(configuration.getCacheLevel());
        }
        ConfigChangeResult changeResult = new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
        if (entryCache != null) {
            EntryCacheMonitorProvider monitor = entryCache.getEntryCacheMonitor();
            if (monitor != null) {
                DirectoryServer.deregisterMonitorProvider(monitor);
                monitor.finalizeMonitorProvider();
                entryCache.setEntryCacheMonitor(null);
            }
            entryCache.finalizeEntryCache();
            this.cacheOrderMap.remove(configuration.getCacheLevel());
            this.cacheNameToLevelMap.remove(configuration.dn().toNormalizedString());
            this._defaultEntryCache.setCacheOrder(this.cacheOrderMap);
            entryCache = null;
        }
        return changeResult;
    }

    private void loadAndInstallEntryCache(String className, EntryCacheCfg configuration) throws InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        EntryCache<? extends EntryCacheCfg> entryCache = this.loadEntryCache(className, configuration, true);
        this.cacheOrderMap.put(configuration.getCacheLevel(), entryCache);
        this.cacheNameToLevelMap.put(configuration.dn().toNormalizedString(), configuration.getCacheLevel());
        this._defaultEntryCache.setCacheOrder(this.cacheOrderMap);
        EntryCacheMonitorProvider monitor = new EntryCacheMonitorProvider(((Object)configuration.dn().getRDN().getAttributeValue(0)).toString(), entryCache);
        try {
            monitor.initializeMonitorProvider((EntryCacheMonitorProviderCfg)rootConfiguration.getMonitorProvider(DEFAULT_ENTRY_CACHE_MONITOR_PROVIDER));
        }
        catch (ConfigException ce) {
            return;
        }
        entryCache.setEntryCacheMonitor(monitor);
        DirectoryServer.registerMonitorProvider(monitor);
    }

    private EntryCache<? extends EntryCacheCfg> loadEntryCache(String className, EntryCacheCfg configuration, boolean initialize) throws InitializationException {
        EntryCache entryCache = null;
        if (!this.cacheOrderMap.isEmpty()) {
            entryCache = (EntryCache)this.cacheOrderMap.get(configuration.getCacheLevel());
        }
        try {
            ArrayList unacceptableReasons;
            Method method;
            Boolean acceptable;
            EntryCacheCfgDefn definition = EntryCacheCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
            Class<EntryCache> cacheClass = propertyDefinition.loadClass(className, EntryCache.class);
            EntryCache cache = initialize || entryCache == null ? cacheClass.newInstance() : entryCache;
            if (initialize) {
                Method method2 = cache.getClass().getMethod("initializeEntryCache", configuration.configurationClass());
                method2.invoke((Object)cache, configuration);
            } else if (!configuration.isEnabled() && !(acceptable = (Boolean)(method = cache.getClass().getMethod("isConfigurationAcceptable", EntryCacheCfg.class, List.class)).invoke((Object)cache, configuration, unacceptableReasons = new ArrayList())).booleanValue()) {
                MessageBuilder buffer = new MessageBuilder();
                if (!unacceptableReasons.isEmpty()) {
                    Iterator iterator = unacceptableReasons.iterator();
                    buffer.append((Message)iterator.next());
                    while (iterator.hasNext()) {
                        buffer.append(".  ");
                        buffer.append((Message)iterator.next());
                    }
                }
                Message message = ConfigMessages.ERR_CONFIG_ENTRYCACHE_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                throw new InitializationException(message);
            }
            return cache;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            if (!initialize) {
                if (e instanceof InitializationException) {
                    throw (InitializationException)e;
                }
                Message message = ConfigMessages.ERR_CONFIG_ENTRYCACHE_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), e.getCause() != null ? e.getCause().getMessage() : StaticUtils.stackTraceToSingleLineString(e));
                throw new InitializationException(message);
            }
            Message message = ConfigMessages.ERR_CONFIG_ENTRYCACHE_CANNOT_INITIALIZE_CACHE.get(className, e.getCause() != null ? e.getCause().getMessage() : StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }
}

