/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.KeyManagerProviderCfgDefn;
import org.opends.server.admin.std.server.KeyManagerProviderCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class KeyManagerProviderConfigManager
implements ConfigurationChangeListener<KeyManagerProviderCfg>,
ConfigurationAddListener<KeyManagerProviderCfg>,
ConfigurationDeleteListener<KeyManagerProviderCfg> {
    private ConcurrentHashMap<DN, KeyManagerProvider> providers = new ConcurrentHashMap();

    public void initializeKeyManagerProviders() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addKeyManagerProviderAddListener(this);
        rootConfiguration.addKeyManagerProviderDeleteListener(this);
        for (String name : rootConfiguration.listKeyManagerProviders()) {
            KeyManagerProviderCfg providerConfig = rootConfiguration.getKeyManagerProvider(name);
            providerConfig.addChangeListener(this);
            if (!providerConfig.isEnabled()) continue;
            String className = providerConfig.getJavaClass();
            try {
                KeyManagerProvider provider = this.loadProvider(className, providerConfig, true);
                this.providers.put(providerConfig.dn(), provider);
                DirectoryServer.registerKeyManagerProvider(providerConfig.dn(), provider);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ie.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(KeyManagerProviderCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadProvider(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(KeyManagerProviderCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        KeyManagerProvider provider = null;
        String className = configuration.getJavaClass();
        try {
            provider = this.loadProvider(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.providers.put(configuration.dn(), provider);
            DirectoryServer.registerKeyManagerProvider(configuration.dn(), provider);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(KeyManagerProviderCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(KeyManagerProviderCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        DirectoryServer.deregisterKeyManagerProvider(configuration.dn());
        KeyManagerProvider provider = this.providers.remove(configuration.dn());
        if (provider != null) {
            provider.finalizeKeyManagerProvider();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(KeyManagerProviderCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadProvider(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(KeyManagerProviderCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        KeyManagerProvider existingProvider = this.providers.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingProvider != null) {
                DirectoryServer.deregisterKeyManagerProvider(configuration.dn());
                KeyManagerProvider provider = this.providers.remove(configuration.dn());
                if (provider != null) {
                    provider.finalizeKeyManagerProvider();
                }
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getJavaClass();
        if (existingProvider != null) {
            if (!className.equals(existingProvider.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        KeyManagerProvider provider = null;
        try {
            provider = this.loadProvider(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.providers.put(configuration.dn(), provider);
            DirectoryServer.registerKeyManagerProvider(configuration.dn(), provider);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private KeyManagerProvider loadProvider(String className, KeyManagerProviderCfg configuration, boolean initialize) throws InitializationException {
        try {
            KeyManagerProviderCfgDefn definition = KeyManagerProviderCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
            Class<KeyManagerProvider> providerClass = propertyDefinition.loadClass(className, KeyManagerProvider.class);
            KeyManagerProvider provider = providerClass.newInstance();
            if (initialize) {
                Method method = provider.getClass().getMethod("initializeKeyManagerProvider", configuration.configurationClass());
                method.invoke((Object)provider, configuration);
            } else {
                Method method = provider.getClass().getMethod("isConfigurationAcceptable", KeyManagerProviderCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)provider, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((CharSequence)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((CharSequence)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_KEYMANAGER_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return provider;
        }
        catch (InitializationException ie) {
            throw ie;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_KEYMANAGER_INITIALIZATION_FAILED.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }
}

