/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.List;
import java.util.Map;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.ClientConnection;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.types.AdditionalLogItem;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.Operation;
import org.opends.server.types.OperationType;
import org.opends.server.types.ResultCode;

public class OperationWrapper<W extends Operation>
implements Operation {
    private W operation;

    public OperationWrapper(W operation) {
        this.operation = operation;
    }

    @Override
    public void addRequestControl(Control control) {
        this.operation.addRequestControl(control);
    }

    @Override
    public void addResponseControl(Control control) {
        this.operation.addResponseControl(control);
    }

    @Override
    public void appendErrorMessage(Message message) {
        this.operation.appendErrorMessage(message);
    }

    @Override
    public CancelResult cancel(CancelRequest cancelRequest) {
        return this.operation.cancel(cancelRequest);
    }

    @Override
    public void abort(CancelRequest cancelRequest) {
        this.operation.abort(cancelRequest);
    }

    @Override
    public void disconnectClient(DisconnectReason disconnectReason, boolean sendNotification, Message message) {
        this.operation.disconnectClient(disconnectReason, sendNotification, message);
    }

    @Override
    public boolean dontSynchronize() {
        return this.operation.dontSynchronize();
    }

    @Override
    public Object getAttachment(String name) {
        return this.operation.getAttachment(name);
    }

    @Override
    public Map<String, Object> getAttachments() {
        return this.operation.getAttachments();
    }

    @Override
    public DN getAuthorizationDN() {
        return this.operation.getAuthorizationDN();
    }

    @Override
    public Entry getAuthorizationEntry() {
        return this.operation.getAuthorizationEntry();
    }

    @Override
    public CancelRequest getCancelRequest() {
        return this.operation.getCancelRequest();
    }

    @Override
    public CancelResult getCancelResult() {
        return this.operation.getCancelResult();
    }

    @Override
    public ClientConnection getClientConnection() {
        return this.operation.getClientConnection();
    }

    @Override
    public String[][] getCommonLogElements() {
        return this.operation.getCommonLogElements();
    }

    @Override
    public long getConnectionID() {
        return this.operation.getConnectionID();
    }

    @Override
    public MessageBuilder getErrorMessage() {
        return this.operation.getErrorMessage();
    }

    @Override
    public DN getMatchedDN() {
        return this.operation.getMatchedDN();
    }

    @Override
    public int getMessageID() {
        return this.operation.getMessageID();
    }

    protected W getOperation() {
        return this.operation;
    }

    @Override
    public long getOperationID() {
        return this.operation.getOperationID();
    }

    @Override
    public OperationType getOperationType() {
        return this.operation.getOperationType();
    }

    @Override
    public long getProcessingStartTime() {
        return this.operation.getProcessingStartTime();
    }

    @Override
    public long getProcessingStopTime() {
        return this.operation.getProcessingStopTime();
    }

    @Override
    public long getProcessingTime() {
        return this.operation.getProcessingTime();
    }

    @Override
    public long getProcessingNanoTime() {
        return this.operation.getProcessingNanoTime();
    }

    @Override
    public List<String> getReferralURLs() {
        return this.operation.getReferralURLs();
    }

    @Override
    public List<Control> getRequestControls() {
        return this.operation.getRequestControls();
    }

    @Override
    public <T extends Control> T getRequestControl(ControlDecoder<T> d) throws DirectoryException {
        return this.operation.getRequestControl(d);
    }

    @Override
    public String[][] getRequestLogElements() {
        return this.operation.getRequestLogElements();
    }

    @Override
    public List<Control> getResponseControls() {
        return this.operation.getResponseControls();
    }

    @Override
    public String[][] getResponseLogElements() {
        return this.operation.getResponseLogElements();
    }

    @Override
    public ResultCode getResultCode() {
        return this.operation.getResultCode();
    }

    @Override
    public boolean isInnerOperation() {
        return this.operation.isInnerOperation();
    }

    @Override
    public boolean isInternalOperation() {
        return this.operation.isInternalOperation();
    }

    @Override
    public boolean isSynchronizationOperation() {
        return this.operation.isSynchronizationOperation();
    }

    @Override
    public void operationCompleted() {
        this.operation.operationCompleted();
    }

    @Override
    public Object removeAttachment(String name) {
        return this.operation.removeAttachment(name);
    }

    @Override
    public void removeResponseControl(Control control) {
        this.operation.removeResponseControl(control);
    }

    @Override
    public Object setAttachment(String name, Object value) {
        return this.operation.setAttachment(name, value);
    }

    @Override
    public void setAttachments(Map<String, Object> attachments) {
        this.operation.setAttachments(attachments);
    }

    @Override
    public void setAuthorizationEntry(Entry authorizationEntry) {
        this.operation.setAuthorizationEntry(authorizationEntry);
    }

    @Override
    public void setDontSynchronize(boolean dontSynchronize) {
        this.operation.setDontSynchronize(dontSynchronize);
    }

    @Override
    public void setErrorMessage(MessageBuilder errorMessage) {
        this.operation.setErrorMessage(errorMessage);
    }

    @Override
    public void setInnerOperation(boolean isInnerOperation) {
        this.operation.setInnerOperation(isInnerOperation);
    }

    @Override
    public void setInternalOperation(boolean isInternalOperation) {
        this.operation.setInternalOperation(isInternalOperation);
    }

    @Override
    public void setMatchedDN(DN matchedDN) {
        this.operation.setMatchedDN(matchedDN);
    }

    @Override
    public void setReferralURLs(List<String> referralURLs) {
        this.operation.setReferralURLs(referralURLs);
    }

    @Override
    public void setResponseData(DirectoryException directoryException) {
        this.operation.setResponseData(directoryException);
    }

    @Override
    public void setResultCode(ResultCode resultCode) {
        this.operation.setResultCode(resultCode);
    }

    @Override
    public void setSynchronizationOperation(boolean isSynchronizationOperation) {
        this.operation.setSynchronizationOperation(isSynchronizationOperation);
    }

    public final int hashCode() {
        return this.getClientConnection().hashCode() * (int)this.getOperationID();
    }

    public final boolean equals(Object obj) {
        Operation other;
        if (this == obj) {
            return true;
        }
        if (obj instanceof Operation && (other = (Operation)obj).getClientConnection().equals(this.getClientConnection())) {
            return other.getOperationID() == this.getOperationID();
        }
        return false;
    }

    @Override
    public void toString(StringBuilder buffer) {
        this.operation.toString(buffer);
    }

    @Override
    public final synchronized void checkIfCanceled(boolean signalTooLate) throws CanceledOperationException {
        this.operation.checkIfCanceled(signalTooLate);
    }

    @Override
    public void registerPostResponseCallback(Runnable callback) {
        this.operation.registerPostResponseCallback(callback);
    }

    @Override
    public void run() {
        this.operation.run();
    }

    @Override
    public List<AdditionalLogItem> getAdditionalLogItems() {
        return this.operation.getAdditionalLogItems();
    }

    @Override
    public void addAdditionalLogItem(AdditionalLogItem item) {
        this.operation.addAdditionalLogItem(item);
    }
}

