/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import org.opends.messages.ConfigMessages;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.PasswordPolicyCfgDefn;
import org.opends.server.admin.std.server.PasswordPolicyCfg;
import org.opends.server.api.AccountStatusNotificationHandler;
import org.opends.server.api.AuthenticationPolicyFactory;
import org.opends.server.api.PasswordGenerator;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.PasswordValidator;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public final class PasswordPolicyFactory
implements AuthenticationPolicyFactory<PasswordPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public PasswordPolicy createAuthenticationPolicy(PasswordPolicyCfg configuration) throws ConfigException, InitializationException {
        PasswordPolicyImpl policy = new PasswordPolicyImpl(configuration);
        configuration.addPasswordPolicyChangeListener(policy);
        return policy;
    }

    @Override
    public boolean isConfigurationAcceptable(PasswordPolicyCfg configuration, List<Message> unacceptableReasons) {
        try {
            new PasswordPolicyImpl(configuration);
        }
        catch (ConfigException ce) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            }
            unacceptableReasons.add(ce.getMessageObject());
            return false;
        }
        catch (InitializationException ie) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ie);
            }
            unacceptableReasons.add(ie.getMessageObject());
            return false;
        }
        return true;
    }

    private static final class PasswordPolicyImpl
    extends PasswordPolicy
    implements ConfigurationChangeListener<PasswordPolicyCfg> {
        private static final DebugTracer TRACER = DebugLogger.getTracer();
        private PasswordPolicyCfg configuration;
        private boolean authPasswordSyntax;
        private Map<DN, AccountStatusNotificationHandler<?>> notificationHandlers;
        private Map<DN, PasswordValidator<?>> passwordValidators;
        private List<PasswordStorageScheme<?>> defaultStorageSchemes;
        private Set<String> deprecatedStorageSchemes;
        private PasswordGenerator<?> passwordGenerator;
        private long requireChangeByTime;

        @Override
        public void finalizeAuthenticationPolicy() {
            this.configuration.removePasswordPolicyChangeListener(this);
        }

        @Override
        public ConfigChangeResult applyConfigurationChange(PasswordPolicyCfg configuration) {
            ArrayList<Message> messages = new ArrayList<Message>();
            try {
                PasswordPolicyImpl.updateConfiguration(configuration, this);
                return new ConfigChangeResult(ResultCode.SUCCESS, false, messages);
            }
            catch (ConfigException ce) {
                messages.add(ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(configuration.dn()), ce.getMessage()));
                return new ConfigChangeResult(ResultCode.CONSTRAINT_VIOLATION, false, messages);
            }
            catch (InitializationException ie) {
                messages.add(ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(configuration.dn()), ie.getMessage()));
                return new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, messages);
            }
            catch (Exception e) {
                messages.add(ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e)));
                return new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, messages);
            }
        }

        @Override
        public boolean isConfigurationChangeAcceptable(PasswordPolicyCfg configuration, List<Message> unacceptableReasons) {
            try {
                PasswordPolicyImpl.updateConfiguration(configuration, null);
            }
            catch (ConfigException ce) {
                Message message = ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(configuration.dn()), ce.getMessage());
                unacceptableReasons.add(message);
                return false;
            }
            catch (InitializationException ie) {
                Message message = ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(configuration.dn()), ie.getMessage());
                unacceptableReasons.add(message);
                return false;
            }
            catch (Exception e) {
                Message message = ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
                unacceptableReasons.add(message);
                return false;
            }
            return true;
        }

        private PasswordPolicyImpl(PasswordPolicyCfg configuration) throws ConfigException, InitializationException {
            PasswordPolicyImpl.updateConfiguration(configuration, this);
        }

        private static void updateConfiguration(PasswordPolicyCfg configuration, PasswordPolicyImpl policy) throws ConfigException, InitializationException {
            SortedSet<String> formatStrings;
            boolean authPasswordSyntax;
            DN configEntryDN = configuration.dn();
            AttributeType passwordAttribute = configuration.getPasswordAttribute();
            String syntaxOID = passwordAttribute.getSyntaxOID();
            if (syntaxOID.equals("1.3.6.1.4.1.4203.1.1.2")) {
                authPasswordSyntax = true;
            } else if (syntaxOID.equals("1.3.6.1.4.1.26027.1.3.1")) {
                authPasswordSyntax = false;
            } else {
                String syntax = passwordAttribute.getSyntax().getSyntaxName();
                if (syntax == null || syntax.length() == 0) {
                    syntax = syntaxOID;
                }
                Message message = CoreMessages.ERR_PWPOLICY_INVALID_PASSWORD_ATTRIBUTE_SYNTAX.get(String.valueOf(configEntryDN), passwordAttribute.getNameOrOID(), String.valueOf(syntax));
                throw new ConfigException(message);
            }
            LinkedList defaultStorageSchemes = new LinkedList();
            for (DN schemeDN : configuration.getDefaultPasswordStorageSchemeDNs()) {
                PasswordStorageScheme scheme = DirectoryServer.getPasswordStorageScheme(schemeDN);
                if (authPasswordSyntax && !scheme.supportsAuthPasswordSyntax()) {
                    Message message = CoreMessages.ERR_PWPOLICY_SCHEME_DOESNT_SUPPORT_AUTH.get(String.valueOf(schemeDN), passwordAttribute.getNameOrOID());
                    throw new ConfigException(message);
                }
                defaultStorageSchemes.add(scheme);
            }
            LinkedHashSet<String> deprecatedStorageSchemes = new LinkedHashSet<String>();
            for (DN schemeDN : configuration.getDeprecatedPasswordStorageSchemeDNs()) {
                PasswordStorageScheme scheme = DirectoryServer.getPasswordStorageScheme(schemeDN);
                if (authPasswordSyntax) {
                    if (scheme.supportsAuthPasswordSyntax()) {
                        deprecatedStorageSchemes.add(StaticUtils.toLowerCase(scheme.getAuthPasswordSchemeName()));
                        continue;
                    }
                    Message message = CoreMessages.ERR_PWPOLICY_DEPRECATED_SCHEME_NOT_AUTH.get(String.valueOf(configEntryDN), String.valueOf(schemeDN));
                    throw new ConfigException(message);
                }
                deprecatedStorageSchemes.add(StaticUtils.toLowerCase(scheme.getStorageSchemeName()));
            }
            HashMap passwordValidators = new HashMap();
            for (DN validatorDN : configuration.getPasswordValidatorDNs()) {
                passwordValidators.put(validatorDN, DirectoryServer.getPasswordValidator(validatorDN));
            }
            HashMap notificationHandlers = new HashMap();
            for (DN handlerDN : configuration.getAccountStatusNotificationHandlerDNs()) {
                AccountStatusNotificationHandler handler = DirectoryServer.getAccountStatusNotificationHandler(handlerDN);
                notificationHandlers.put(handlerDN, handler);
            }
            PasswordGenerator passwordGenerator = null;
            DN passGenDN = configuration.getPasswordGeneratorDN();
            if (passGenDN != null) {
                passwordGenerator = DirectoryServer.getPasswordGenerator(passGenDN);
            }
            if (!configuration.isExpirePasswordsWithoutWarning() && configuration.getPasswordExpirationWarningInterval() <= 0L) {
                Message message = CoreMessages.ERR_PWPOLICY_MUST_HAVE_WARNING_IF_NOT_EXPIRE_WITHOUT_WARNING.get(String.valueOf(configEntryDN));
                throw new ConfigException(message);
            }
            String requireChangeBy = configuration.getRequireChangeByTime();
            long requireChangeByTime = 0L;
            try {
                if (requireChangeBy != null) {
                    ByteString valueString = ByteString.valueOf(requireChangeBy);
                    GeneralizedTimeSyntax syntax = (GeneralizedTimeSyntax)DirectoryServer.getAttributeSyntax("1.3.6.1.4.1.1466.115.121.1.24", false);
                    if (syntax == null) {
                        requireChangeByTime = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(valueString);
                    } else {
                        valueString = syntax.getEqualityMatchingRule().normalizeValue(valueString);
                        requireChangeByTime = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(valueString);
                    }
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = CoreMessages.ERR_PWPOLICY_CANNOT_DETERMINE_REQUIRE_CHANGE_BY_TIME.get(String.valueOf(configEntryDN), StaticUtils.getExceptionMessage(e));
                throw new InitializationException(message, (Throwable)e);
            }
            String formatString = configuration.getLastLoginTimeFormat();
            if (formatString != null) {
                try {
                    new SimpleDateFormat(formatString);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = CoreMessages.ERR_PWPOLICY_INVALID_LAST_LOGIN_TIME_FORMAT.get(String.valueOf(configEntryDN), String.valueOf(formatString));
                    throw new ConfigException(message);
                }
            }
            if ((formatStrings = configuration.getPreviousLastLoginTimeFormat()) != null) {
                for (String s : formatStrings) {
                    try {
                        new SimpleDateFormat(s);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        Message message = CoreMessages.ERR_PWPOLICY_INVALID_PREVIOUS_LAST_LOGIN_TIME_FORMAT.get(String.valueOf(configEntryDN), String.valueOf(s));
                        throw new ConfigException(message);
                    }
                }
            }
            if (configuration.getMaxPasswordAge() > 0L) {
                long warnInterval = Math.max(0L, configuration.getPasswordExpirationWarningInterval());
                if (configuration.getMinPasswordAge() > 0L) {
                    if (warnInterval + configuration.getMinPasswordAge() >= configuration.getMaxPasswordAge()) {
                        Message message = CoreMessages.ERR_PWPOLICY_MIN_AGE_PLUS_WARNING_GREATER_THAN_MAX_AGE.get(String.valueOf(configEntryDN));
                        throw new ConfigException(message);
                    }
                } else if (warnInterval >= configuration.getMaxPasswordAge()) {
                    Message message = CoreMessages.ERR_PWPOLICY_WARNING_INTERVAL_LARGER_THAN_MAX_AGE.get(String.valueOf(configEntryDN));
                    throw new ConfigException(message);
                }
            }
            if (policy != null) {
                policy.configuration = configuration;
                policy.authPasswordSyntax = authPasswordSyntax;
                policy.defaultStorageSchemes = defaultStorageSchemes;
                policy.deprecatedStorageSchemes = deprecatedStorageSchemes;
                policy.notificationHandlers = notificationHandlers;
                policy.passwordGenerator = passwordGenerator;
                policy.passwordValidators = passwordValidators;
                policy.requireChangeByTime = requireChangeByTime;
            }
        }

        @Override
        public boolean isAuthPasswordSyntax() {
            return this.authPasswordSyntax;
        }

        @Override
        public List<PasswordStorageScheme<?>> getDefaultPasswordStorageSchemes() {
            return this.defaultStorageSchemes;
        }

        @Override
        public Set<String> getDeprecatedPasswordStorageSchemes() {
            return this.deprecatedStorageSchemes;
        }

        @Override
        public DN getDN() {
            return this.configuration.dn();
        }

        @Override
        public boolean isDefaultPasswordStorageScheme(String name) {
            for (PasswordStorageScheme<?> s : this.defaultStorageSchemes) {
                if (!(this.authPasswordSyntax ? s.getAuthPasswordSchemeName().equalsIgnoreCase(name) : s.getStorageSchemeName().equalsIgnoreCase(name))) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isDeprecatedPasswordStorageScheme(String name) {
            return this.deprecatedStorageSchemes.contains(StaticUtils.toLowerCase(name));
        }

        @Override
        public Collection<PasswordValidator<?>> getPasswordValidators() {
            return this.passwordValidators.values();
        }

        @Override
        public Collection<AccountStatusNotificationHandler<?>> getAccountStatusNotificationHandlers() {
            return this.notificationHandlers.values();
        }

        @Override
        public PasswordGenerator<?> getPasswordGenerator() {
            return this.passwordGenerator;
        }

        @Override
        public long getRequireChangeByTime() {
            return this.requireChangeByTime;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            this.toString(buffer);
            return buffer.toString();
        }

        public void toString(StringBuilder buffer) {
            Iterator<Object> iterator;
            buffer.append("Password Attribute:                    ");
            buffer.append(this.configuration.getPasswordAttribute().getNameOrOID());
            buffer.append(ServerConstants.EOL);
            buffer.append("Default Password Storage Schemes:      ");
            if (this.defaultStorageSchemes == null || this.defaultStorageSchemes.isEmpty()) {
                buffer.append("{none specified}");
                buffer.append(ServerConstants.EOL);
            } else {
                iterator = this.defaultStorageSchemes.iterator();
                buffer.append(iterator.next().getStorageSchemeName());
                buffer.append(ServerConstants.EOL);
                while (iterator.hasNext()) {
                    buffer.append("                                       ");
                    buffer.append(((PasswordStorageScheme)iterator.next()).getStorageSchemeName());
                    buffer.append(ServerConstants.EOL);
                }
            }
            buffer.append("Deprecated Password Storage Schemes:   ");
            if (this.deprecatedStorageSchemes == null || this.deprecatedStorageSchemes.isEmpty()) {
                buffer.append("{none specified}");
                buffer.append(ServerConstants.EOL);
            } else {
                iterator = this.deprecatedStorageSchemes.iterator();
                buffer.append((String)iterator.next());
                buffer.append(ServerConstants.EOL);
                while (iterator.hasNext()) {
                    buffer.append("                                       ");
                    buffer.append((String)iterator.next());
                    buffer.append(ServerConstants.EOL);
                }
            }
            buffer.append("Allow Multiple Password Values:        ");
            buffer.append(this.configuration.isAllowMultiplePasswordValues());
            buffer.append(ServerConstants.EOL);
            buffer.append("Allow Pre-Encoded Passwords:           ");
            buffer.append(this.configuration.isAllowPreEncodedPasswords());
            buffer.append(ServerConstants.EOL);
            buffer.append("Allow User Password Changes:           ");
            buffer.append(this.configuration.isAllowUserPasswordChanges());
            buffer.append(ServerConstants.EOL);
            buffer.append("Force Password Change on Add:          ");
            buffer.append(this.configuration.isForceChangeOnAdd());
            buffer.append(ServerConstants.EOL);
            buffer.append("Force Password Change on Admin Reset:  ");
            buffer.append(this.configuration.isForceChangeOnReset());
            buffer.append(ServerConstants.EOL);
            buffer.append("Require Current Password:              ");
            buffer.append(this.configuration.isPasswordChangeRequiresCurrentPassword());
            buffer.append(ServerConstants.EOL);
            buffer.append("Require Secure Authentication:         ");
            buffer.append(this.configuration.isRequireSecureAuthentication());
            buffer.append(ServerConstants.EOL);
            buffer.append("Require Secure Password Changes:       ");
            buffer.append(this.configuration.isRequireSecurePasswordChanges());
            buffer.append(ServerConstants.EOL);
            buffer.append("Lockout Failure Expiration Interval:   ");
            buffer.append(this.configuration.getLockoutFailureExpirationInterval());
            buffer.append(" seconds");
            buffer.append(ServerConstants.EOL);
            buffer.append("Password Validators:                   ");
            if (this.passwordValidators == null || this.passwordValidators.isEmpty()) {
                buffer.append("{none specified}");
                buffer.append(ServerConstants.EOL);
            } else {
                iterator = this.passwordValidators.keySet().iterator();
                ((DN)iterator.next()).toString(buffer);
                buffer.append(ServerConstants.EOL);
                while (iterator.hasNext()) {
                    buffer.append("                                       ");
                    ((DN)iterator.next()).toString(buffer);
                    buffer.append(ServerConstants.EOL);
                }
            }
            buffer.append("Skip Validation for Administrators:    ");
            buffer.append(this.configuration.isSkipValidationForAdministrators());
            buffer.append(ServerConstants.EOL);
            buffer.append("Password Generator:                    ");
            if (this.passwordGenerator == null) {
                buffer.append("{none specified}");
            } else {
                this.configuration.getPasswordGeneratorDN().toString(buffer);
            }
            buffer.append(ServerConstants.EOL);
            buffer.append("Account Status Notification Handlers:  ");
            if (this.notificationHandlers == null || this.notificationHandlers.isEmpty()) {
                buffer.append("{none specified}");
                buffer.append(ServerConstants.EOL);
            } else {
                iterator = this.notificationHandlers.keySet().iterator();
                ((DN)iterator.next()).toString(buffer);
                buffer.append(ServerConstants.EOL);
                while (iterator.hasNext()) {
                    buffer.append("                                       ");
                    ((DN)iterator.next()).toString(buffer);
                    buffer.append(ServerConstants.EOL);
                }
            }
            buffer.append("Minimum Password Age:                  ");
            buffer.append(this.configuration.getMinPasswordAge());
            buffer.append(" seconds");
            buffer.append(ServerConstants.EOL);
            buffer.append("Maximum Password Age:                  ");
            buffer.append(this.configuration.getMaxPasswordAge());
            buffer.append(" seconds");
            buffer.append(ServerConstants.EOL);
            buffer.append("Maximum Password Reset Age:            ");
            buffer.append(this.configuration.getMaxPasswordResetAge());
            buffer.append(" seconds");
            buffer.append(ServerConstants.EOL);
            buffer.append("Expiration Warning Interval:           ");
            buffer.append(this.configuration.getPasswordExpirationWarningInterval());
            buffer.append(" seconds");
            buffer.append(ServerConstants.EOL);
            buffer.append("Expire Passwords Without Warning:      ");
            buffer.append(this.configuration.isExpirePasswordsWithoutWarning());
            buffer.append(ServerConstants.EOL);
            buffer.append("Allow Expired Password Changes:        ");
            buffer.append(this.configuration.isAllowExpiredPasswordChanges());
            buffer.append(ServerConstants.EOL);
            buffer.append("Grace Login Count:                     ");
            buffer.append(this.configuration.getGraceLoginCount());
            buffer.append(ServerConstants.EOL);
            buffer.append("Lockout Failure Count:                 ");
            buffer.append(this.configuration.getLockoutFailureCount());
            buffer.append(ServerConstants.EOL);
            buffer.append("Lockout Duration:                      ");
            buffer.append(this.configuration.getLockoutDuration());
            buffer.append(" seconds");
            buffer.append(ServerConstants.EOL);
            buffer.append("Lockout Count Expiration Interval:     ");
            buffer.append(this.configuration.getLockoutFailureExpirationInterval());
            buffer.append(" seconds");
            buffer.append(ServerConstants.EOL);
            buffer.append("Required Password Change By Time:      ");
            if (this.requireChangeByTime <= 0L) {
                buffer.append("{none specified}");
            } else {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                buffer.append(dateFormat.format(new Date(this.requireChangeByTime)));
            }
            buffer.append(ServerConstants.EOL);
            buffer.append("Last Login Time Attribute:             ");
            if (this.configuration.getLastLoginTimeAttribute() == null) {
                buffer.append("{none specified}");
            } else {
                buffer.append(this.configuration.getLastLoginTimeAttribute().getNameOrOID());
            }
            buffer.append(ServerConstants.EOL);
            buffer.append("Last Login Time Format:                ");
            if (this.configuration.getLastLoginTimeFormat() == null) {
                buffer.append("{none specified}");
            } else {
                buffer.append(this.configuration.getLastLoginTimeFormat());
            }
            buffer.append(ServerConstants.EOL);
            buffer.append("Previous Last Login Time Formats:      ");
            if (this.configuration.getPreviousLastLoginTimeFormat().isEmpty()) {
                buffer.append("{none specified}");
                buffer.append(ServerConstants.EOL);
            } else {
                iterator = this.configuration.getPreviousLastLoginTimeFormat().iterator();
                buffer.append((String)iterator.next());
                buffer.append(ServerConstants.EOL);
                while (iterator.hasNext()) {
                    buffer.append("                                       ");
                    buffer.append((String)iterator.next());
                    buffer.append(ServerConstants.EOL);
                }
            }
            buffer.append("Idle Lockout Interval:                 ");
            buffer.append(this.configuration.getIdleLockoutInterval());
            buffer.append(" seconds");
            buffer.append(ServerConstants.EOL);
            buffer.append("History Count:                         ");
            buffer.append(this.configuration.getPasswordHistoryCount());
            buffer.append(ServerConstants.EOL);
            buffer.append("Update Failure Policy:                 ");
            buffer.append(this.configuration.getStateUpdateFailurePolicy().toString());
            buffer.append(ServerConstants.EOL);
        }

        @Override
        public boolean isAllowExpiredPasswordChanges() {
            return this.configuration.isAllowExpiredPasswordChanges();
        }

        @Override
        public boolean isAllowMultiplePasswordValues() {
            return this.configuration.isAllowMultiplePasswordValues();
        }

        @Override
        public boolean isAllowPreEncodedPasswords() {
            return this.configuration.isAllowPreEncodedPasswords();
        }

        @Override
        public boolean isAllowUserPasswordChanges() {
            return this.configuration.isAllowUserPasswordChanges();
        }

        @Override
        public boolean isExpirePasswordsWithoutWarning() {
            return this.configuration.isExpirePasswordsWithoutWarning();
        }

        @Override
        public boolean isForceChangeOnAdd() {
            return this.configuration.isForceChangeOnAdd();
        }

        @Override
        public boolean isForceChangeOnReset() {
            return this.configuration.isForceChangeOnReset();
        }

        @Override
        public int getGraceLoginCount() {
            return this.configuration.getGraceLoginCount();
        }

        @Override
        public long getIdleLockoutInterval() {
            return this.configuration.getIdleLockoutInterval();
        }

        @Override
        public AttributeType getLastLoginTimeAttribute() {
            return this.configuration.getLastLoginTimeAttribute();
        }

        @Override
        public String getLastLoginTimeFormat() {
            return this.configuration.getLastLoginTimeFormat();
        }

        @Override
        public long getLockoutDuration() {
            return this.configuration.getLockoutDuration();
        }

        @Override
        public int getLockoutFailureCount() {
            return this.configuration.getLockoutFailureCount();
        }

        @Override
        public long getLockoutFailureExpirationInterval() {
            return this.configuration.getLockoutFailureExpirationInterval();
        }

        @Override
        public long getMaxPasswordAge() {
            return this.configuration.getMaxPasswordAge();
        }

        @Override
        public long getMaxPasswordResetAge() {
            return this.configuration.getMaxPasswordResetAge();
        }

        @Override
        public long getMinPasswordAge() {
            return this.configuration.getMinPasswordAge();
        }

        @Override
        public AttributeType getPasswordAttribute() {
            return this.configuration.getPasswordAttribute();
        }

        @Override
        public boolean isPasswordChangeRequiresCurrentPassword() {
            return this.configuration.isPasswordChangeRequiresCurrentPassword();
        }

        @Override
        public long getPasswordExpirationWarningInterval() {
            return this.configuration.getPasswordExpirationWarningInterval();
        }

        @Override
        public int getPasswordHistoryCount() {
            return this.configuration.getPasswordHistoryCount();
        }

        @Override
        public long getPasswordHistoryDuration() {
            return this.configuration.getPasswordHistoryDuration();
        }

        @Override
        public SortedSet<String> getPreviousLastLoginTimeFormats() {
            return this.configuration.getPreviousLastLoginTimeFormat();
        }

        @Override
        public boolean isRequireSecureAuthentication() {
            return this.configuration.isRequireSecureAuthentication();
        }

        @Override
        public boolean isRequireSecurePasswordChanges() {
            return this.configuration.isRequireSecurePasswordChanges();
        }

        @Override
        public boolean isSkipValidationForAdministrators() {
            return this.configuration.isSkipValidationForAdministrators();
        }

        @Override
        public PasswordPolicyCfgDefn.StateUpdateFailurePolicy getStateUpdateFailurePolicy() {
            return this.configuration.getStateUpdateFailurePolicy();
        }
    }
}

