/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.std.meta.QOSPolicyCfgDefn;
import org.opends.server.admin.std.server.NetworkGroupCfg;
import org.opends.server.admin.std.server.QOSPolicyCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.QOSPolicy;
import org.opends.server.api.QOSPolicyFactory;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.RootDseWorkflowTopology;
import org.opends.server.core.Workflow;
import org.opends.server.core.WorkflowImpl;
import org.opends.server.core.WorkflowTopology;
import org.opends.server.core.WorkflowTopologyNode;
import org.opends.server.core.networkgroups.ANDConnectionCriteria;
import org.opends.server.core.networkgroups.AuthMethodConnectionCriteria;
import org.opends.server.core.networkgroups.BindDNConnectionCriteria;
import org.opends.server.core.networkgroups.ConnectionCriteria;
import org.opends.server.core.networkgroups.IPConnectionCriteria;
import org.opends.server.core.networkgroups.NetworkGroupNamingContexts;
import org.opends.server.core.networkgroups.NetworkGroupStatistics;
import org.opends.server.core.networkgroups.ProtocolConnectionCriteria;
import org.opends.server.core.networkgroups.RequestFilteringPolicy;
import org.opends.server.core.networkgroups.RequestFilteringPolicyStatistics;
import org.opends.server.core.networkgroups.ResourceLimitsPolicy;
import org.opends.server.core.networkgroups.ResourceLimitsPolicyStatistics;
import org.opends.server.core.networkgroups.SecurityConnectionCriteria;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PreParseOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;
import org.opends.server.workflowelement.WorkflowElement;

public class NetworkGroup {
    private static final String ADMIN_NETWORK_GROUP_NAME = "admin";
    private static NetworkGroup adminNetworkGroup = new NetworkGroup("admin");
    private static final String DEFAULT_NETWORK_GROUP_NAME = "default";
    private static NetworkGroup defaultNetworkGroup = new NetworkGroup("default");
    private static final String INTERNAL_NETWORK_GROUP_NAME = "internal";
    private static NetworkGroup internalNetworkGroup = new NetworkGroup("internal");
    private static List<NetworkGroup> orderedNetworkGroups = new ArrayList<NetworkGroup>();
    private static TreeMap<String, NetworkGroup> registeredNetworkGroups = new TreeMap();
    private static Object registeredNetworkGroupsLock = new Object();
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final ChangeListener changeListener;
    private NetworkGroupCfg configuration = null;
    private ConnectionCriteria criteria = ConnectionCriteria.TRUE;
    private final boolean isAdminNetworkGroup;
    private final boolean isDefaultNetworkGroup;
    private final boolean isInternalNetworkGroup;
    private NetworkGroupNamingContexts namingContexts = new NetworkGroupNamingContexts();
    private final String networkGroupID;
    private final Map<DN, QOSPolicy> policies = new ConcurrentHashMap<DN, QOSPolicy>();
    private final QOSPolicyListener policyListener;
    private int priority = 100;
    private TreeMap<String, WorkflowTopologyNode> registeredWorkflowNodes = new TreeMap();
    private final Object registeredWorkflowNodesLock = new Object();
    private RequestFilteringPolicy requestFilteringPolicy = null;
    private ResourceLimitsPolicy resourceLimitsPolicy = null;
    private RootDseWorkflowTopology rootDSEWorkflowNode = null;
    private final NetworkGroupStatistics statistics;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterAllOnShutdown() {
        Object object = registeredNetworkGroupsLock;
        synchronized (object) {
            Collection<NetworkGroup> networkGroups = registeredNetworkGroups.values();
            for (NetworkGroup networkGroup : networkGroups) {
                networkGroup.invalidate();
            }
            defaultNetworkGroup.invalidate();
            adminNetworkGroup.invalidate();
            internalNetworkGroup.invalidate();
            registeredNetworkGroups = new TreeMap();
            orderedNetworkGroups = new ArrayList<NetworkGroup>();
            defaultNetworkGroup = new NetworkGroup(DEFAULT_NETWORK_GROUP_NAME);
            adminNetworkGroup = new NetworkGroup(ADMIN_NETWORK_GROUP_NAME);
            internalNetworkGroup = new NetworkGroup(INTERNAL_NETWORK_GROUP_NAME);
        }
    }

    static NetworkGroup findBindMatchingNetworkGroup(ClientConnection connection, DN dn, AuthenticationType authType, boolean isSecure) {
        for (NetworkGroup ng : orderedNetworkGroups) {
            if (!ng.matchAfterBind(connection, dn, authType, isSecure)) continue;
            return ng;
        }
        return defaultNetworkGroup;
    }

    static NetworkGroup findMatchingNetworkGroup(ClientConnection connection) {
        for (NetworkGroup ng : orderedNetworkGroups) {
            if (!ng.match(connection)) continue;
            return ng;
        }
        return defaultNetworkGroup;
    }

    public static NetworkGroup getAdminNetworkGroup() {
        return adminNetworkGroup;
    }

    public static NetworkGroup getDefaultNetworkGroup() {
        return defaultNetworkGroup;
    }

    public static NetworkGroup getInternalNetworkGroup() {
        return internalNetworkGroup;
    }

    public static NetworkGroup getNetworkGroup(String networkGroupID) {
        return registeredNetworkGroups.get(networkGroupID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetConfig() {
        defaultNetworkGroup.reset();
        adminNetworkGroup.reset();
        internalNetworkGroup.reset();
        Object object = registeredNetworkGroupsLock;
        synchronized (object) {
            registeredNetworkGroups = new TreeMap();
            orderedNetworkGroups = new ArrayList<NetworkGroup>();
        }
    }

    static NetworkGroup createUserNetworkGroup(NetworkGroupCfg configuration) throws InitializationException, ConfigException {
        NetworkGroup networkGroup = new NetworkGroup(configuration);
        try {
            networkGroup.priority = configuration.getPriority();
            networkGroup.criteria = NetworkGroup.decodeConnectionCriteriaConfiguration(configuration);
            for (String policyName : configuration.listNetworkGroupQOSPolicies()) {
                QOSPolicyCfg policyConfiguration = configuration.getNetworkGroupQOSPolicy(policyName);
                networkGroup.createNetworkGroupQOSPolicy(policyConfiguration);
            }
            WorkflowImpl rootDSEworkflow = (WorkflowImpl)WorkflowImpl.getWorkflow("__root.dse__#");
            networkGroup.registerWorkflow(rootDSEworkflow);
            for (String workflowID : configuration.getWorkflow()) {
                WorkflowImpl workflowImpl = (WorkflowImpl)WorkflowImpl.getWorkflow(workflowID);
                if (workflowImpl == null) {
                    Message message = CoreMessages.INFO_ERR_WORKFLOW_DOES_NOT_EXIST.get(workflowID, networkGroup.getID());
                    ErrorLogger.logError(message);
                    continue;
                }
                networkGroup.registerWorkflow(workflowImpl);
            }
            configuration.addChangeListener(networkGroup.changeListener);
            configuration.addNetworkGroupQOSPolicyAddListener(networkGroup.policyListener);
            configuration.addNetworkGroupQOSPolicyDeleteListener(networkGroup.policyListener);
            networkGroup.register();
        }
        catch (DirectoryException e) {
            networkGroup.finalizeNetworkGroup();
            throw new InitializationException(e.getMessageObject());
        }
        catch (InitializationException e) {
            networkGroup.finalizeNetworkGroup();
            throw e;
        }
        catch (ConfigException e) {
            networkGroup.finalizeNetworkGroup();
            throw e;
        }
        return networkGroup;
    }

    static boolean isConfigurationAcceptable(NetworkGroupCfg configuration, List<Message> unacceptableReasons) {
        if (!configuration.isEnabled()) {
            return true;
        }
        boolean isAcceptable = true;
        HashSet<String> allBaseDNs = new HashSet<String>();
        for (String workflowId : configuration.getWorkflow()) {
            WorkflowImpl workflow = (WorkflowImpl)WorkflowImpl.getWorkflow(workflowId);
            String baseDN = workflow.getBaseDN().toNormalizedString();
            if (allBaseDNs.contains(baseDN)) {
                Message message = CoreMessages.ERR_WORKFLOW_BASE_DN_DUPLICATED_IN_NG.get(baseDN, NetworkGroup.getNameFromConfiguration(configuration));
                unacceptableReasons.add(message);
                isAcceptable = false;
                break;
            }
            allBaseDNs.add(baseDN);
        }
        for (String policyName : configuration.listNetworkGroupQOSPolicies()) {
            try {
                QOSPolicyCfg policyCfg = configuration.getNetworkGroupQOSPolicy(policyName);
                if (NetworkGroup.isNetworkGroupQOSPolicyConfigurationAcceptable(policyCfg, unacceptableReasons)) continue;
                isAcceptable = false;
            }
            catch (ConfigException e) {
                unacceptableReasons.add(e.getMessageObject());
                return false;
            }
        }
        if (!configuration.getAllowedBindDN().isEmpty()) {
            try {
                BindDNConnectionCriteria.decode(configuration.getAllowedBindDN());
            }
            catch (DirectoryException e) {
                unacceptableReasons.add(e.getMessageObject());
                isAcceptable = false;
            }
        }
        return isAcceptable;
    }

    private static ConnectionCriteria decodeConnectionCriteriaConfiguration(NetworkGroupCfg configuration) throws ConfigException {
        LinkedList<ConnectionCriteria> filters = new LinkedList<ConnectionCriteria>();
        if (!configuration.getAllowedAuthMethod().isEmpty()) {
            filters.add(new AuthMethodConnectionCriteria(configuration.getAllowedAuthMethod()));
        }
        if (!configuration.getAllowedBindDN().isEmpty()) {
            try {
                filters.add(BindDNConnectionCriteria.decode(configuration.getAllowedBindDN()));
            }
            catch (DirectoryException e) {
                throw new ConfigException(e.getMessageObject());
            }
        }
        if (!configuration.getAllowedClient().isEmpty() || !configuration.getDeniedClient().isEmpty()) {
            filters.add(new IPConnectionCriteria(configuration.getAllowedClient(), configuration.getDeniedClient()));
        }
        if (!configuration.getAllowedProtocol().isEmpty()) {
            filters.add(new ProtocolConnectionCriteria(configuration.getAllowedProtocol()));
        }
        if (configuration.isIsSecurityMandatory()) {
            filters.add(SecurityConnectionCriteria.SECURITY_REQUIRED);
        }
        if (filters.isEmpty()) {
            return ConnectionCriteria.TRUE;
        }
        return new ANDConnectionCriteria(filters);
    }

    private static String getNameFromConfiguration(NetworkGroupCfg configuration) {
        DN dn = configuration.dn();
        return ((Object)dn.getRDN().getAttributeValue(0)).toString();
    }

    private static boolean isNetworkGroupQOSPolicyConfigurationAcceptable(QOSPolicyCfg policyConfiguration, List<Message> unacceptableReasons) {
        String className = policyConfiguration.getJavaClass();
        QOSPolicyCfgDefn d = QOSPolicyCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaClassPropertyDefinition();
        try {
            Class<QOSPolicyFactory> theClass = pd.loadClass(className, QOSPolicyFactory.class);
            QOSPolicyFactory factory = theClass.newInstance();
            Method method = theClass.getMethod("isConfigurationAcceptable", QOSPolicyCfg.class, List.class);
            Boolean acceptable = (Boolean)method.invoke((Object)factory, policyConfiguration, unacceptableReasons);
            if (!acceptable.booleanValue()) {
                return false;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            unacceptableReasons.add(ConfigMessages.ERR_CONFIG_NETWORK_GROUP_POLICY_CANNOT_INITIALIZE.get(String.valueOf(className), String.valueOf(policyConfiguration.dn()), StaticUtils.stackTraceToSingleLineString(e)));
            return false;
        }
        return true;
    }

    public NetworkGroup(String networkGroupID) {
        this.networkGroupID = networkGroupID;
        this.isInternalNetworkGroup = INTERNAL_NETWORK_GROUP_NAME.equals(networkGroupID);
        this.isAdminNetworkGroup = ADMIN_NETWORK_GROUP_NAME.equals(networkGroupID);
        this.isDefaultNetworkGroup = DEFAULT_NETWORK_GROUP_NAME.equals(networkGroupID);
        this.statistics = new NetworkGroupStatistics(this);
        this.configuration = null;
        this.changeListener = null;
        this.policyListener = null;
    }

    private NetworkGroup(NetworkGroupCfg configuration) {
        this.networkGroupID = NetworkGroup.getNameFromConfiguration(configuration);
        this.isInternalNetworkGroup = false;
        this.isAdminNetworkGroup = false;
        this.isDefaultNetworkGroup = false;
        this.statistics = new NetworkGroupStatistics(this);
        this.configuration = configuration;
        this.changeListener = new ChangeListener();
        this.policyListener = new QOSPolicyListener();
    }

    public void addConnection(ClientConnection connection) {
        if (this.resourceLimitsPolicy != null) {
            this.resourceLimitsPolicy.addConnection(connection);
        }
    }

    boolean checkRequestFilteringPolicy(PreParseOperation operation, List<Message> messages) {
        if (this.requestFilteringPolicy != null) {
            return this.requestFilteringPolicy.isAllowed(operation, messages);
        }
        return true;
    }

    boolean checkResourceLimitsPolicy(ClientConnection connection, PreParseOperation operation, boolean fullCheck, List<Message> messages) {
        if (this.resourceLimitsPolicy != null) {
            return this.resourceLimitsPolicy.isAllowed(connection, operation, fullCheck, messages);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workflow deregisterWorkflow(DN baseDN) {
        WorkflowImpl workflow = null;
        if (baseDN == null) {
            return workflow;
        }
        if (baseDN.isNullDN()) {
            this.deregisterWorkflow(this.rootDSEWorkflowNode);
            workflow = this.rootDSEWorkflowNode.getWorkflowImpl();
        } else {
            Object object = this.registeredWorkflowNodesLock;
            synchronized (object) {
                for (WorkflowTopologyNode node : this.registeredWorkflowNodes.values()) {
                    DN curDN = node.getBaseDN();
                    if (!curDN.equals(baseDN)) continue;
                    this.deregisterWorkflow(node);
                    workflow = node.getWorkflowImpl();
                    break;
                }
            }
        }
        if (!(workflow == null || this.isAdminNetworkGroup || this.isInternalNetworkGroup || this.isDefaultNetworkGroup)) {
            WorkflowImpl workflowImpl = workflow;
            workflowImpl.decrementReferenceCounter();
        }
        return workflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workflow deregisterWorkflow(String workflowID) {
        WorkflowImpl workflow = null;
        String rootDSEWorkflowID = null;
        if (this.rootDSEWorkflowNode != null) {
            rootDSEWorkflowID = this.rootDSEWorkflowNode.getWorkflowImpl().getWorkflowId();
        }
        if (workflowID.equalsIgnoreCase(rootDSEWorkflowID)) {
            this.deregisterWorkflow(this.rootDSEWorkflowNode);
            workflow = this.rootDSEWorkflowNode.getWorkflowImpl();
        } else {
            Object object = this.registeredWorkflowNodesLock;
            synchronized (object) {
                for (WorkflowTopologyNode node : this.registeredWorkflowNodes.values()) {
                    String curID = node.getWorkflowImpl().getWorkflowId();
                    if (!curID.equals(workflowID)) continue;
                    this.deregisterWorkflow(node);
                    workflow = node.getWorkflowImpl();
                    break;
                }
            }
        }
        if (!(workflow == null || this.isAdminNetworkGroup || this.isInternalNetworkGroup || this.isDefaultNetworkGroup)) {
            WorkflowImpl workflowImpl = workflow;
            workflowImpl.decrementReferenceCounter();
        }
        return workflow;
    }

    public void finalizeNetworkGroup() {
        if (this.configuration != null) {
            this.deregister();
            this.configuration.removeChangeListener(this.changeListener);
            this.configuration.removeNetworkGroupQOSPolicyAddListener(this.policyListener);
            this.configuration.removeNetworkGroupQOSPolicyDeleteListener(this.policyListener);
            this.configuration = null;
        }
        for (QOSPolicy policy : this.policies.values()) {
            policy.finalizeQOSPolicy();
        }
        this.requestFilteringPolicy = null;
        this.resourceLimitsPolicy = null;
        this.criteria = ConnectionCriteria.TRUE;
        this.policies.clear();
        this.statistics.finalizeStatistics();
    }

    public String getID() {
        return this.networkGroupID;
    }

    public int getMinSubstring() {
        if (this.resourceLimitsPolicy != null) {
            return this.resourceLimitsPolicy.getMinSubstring();
        }
        return 0;
    }

    public NetworkGroupNamingContexts getNamingContexts() {
        return this.namingContexts;
    }

    public <T extends QOSPolicy> T getNetworkGroupQOSPolicy(Class<T> clazz) {
        for (QOSPolicy policy : this.policies.values()) {
            if (!clazz.isAssignableFrom(policy.getClass())) continue;
            return (T)((QOSPolicy)clazz.cast(policy));
        }
        return null;
    }

    public int getSizeLimit() {
        if (this.resourceLimitsPolicy != null) {
            return this.resourceLimitsPolicy.getSizeLimit();
        }
        return DirectoryServer.getSizeLimit();
    }

    public int getTimeLimit() {
        if (this.resourceLimitsPolicy != null) {
            return this.resourceLimitsPolicy.getTimeLimit();
        }
        return DirectoryServer.getTimeLimit();
    }

    public Workflow getWorkflowCandidate(DN baseDN) {
        WorkflowTopology workflowCandidate;
        block3: {
            WorkflowTopologyNode curWorkflow;
            block2: {
                workflowCandidate = null;
                if (!baseDN.isNullDN()) break block2;
                workflowCandidate = this.rootDSEWorkflowNode;
                break block3;
            }
            Iterator<WorkflowTopologyNode> i$ = this.namingContexts.getPrivateNamingContexts().iterator();
            while (i$.hasNext() && (workflowCandidate = (curWorkflow = i$.next()).getWorkflowCandidate(baseDN)) == null) {
            }
            if (workflowCandidate != null) break block3;
            i$ = this.namingContexts.getPublicNamingContexts().iterator();
            while (i$.hasNext() && (workflowCandidate = (curWorkflow = i$.next()).getWorkflowCandidate(baseDN)) == null) {
            }
        }
        return workflowCandidate;
    }

    public void registerWorkflow(WorkflowImpl workflow) throws DirectoryException {
        this.registerWorkflow(workflow, null, null);
    }

    public void removeConnection(ClientConnection connection) {
        if (this.resourceLimitsPolicy != null) {
            this.resourceLimitsPolicy.removeConnection(connection);
        }
    }

    public void updateMessageRead(LDAPMessage message) {
        this.statistics.updateMessageRead(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregister() {
        Object object = registeredNetworkGroupsLock;
        synchronized (object) {
            TreeMap<String, NetworkGroup> networkGroups = new TreeMap<String, NetworkGroup>((SortedMap<String, NetworkGroup>)registeredNetworkGroups);
            networkGroups.remove(this.networkGroupID);
            registeredNetworkGroups = networkGroups;
            orderedNetworkGroups.remove(this);
            Object object2 = this.registeredWorkflowNodesLock;
            synchronized (object2) {
                for (WorkflowTopologyNode workflowNode : this.registeredWorkflowNodes.values()) {
                    WorkflowImpl workflowImpl = workflowNode.getWorkflowImpl();
                    workflowImpl.decrementReferenceCounter();
                }
            }
        }
    }

    RequestFilteringPolicyStatistics getRequestFilteringPolicyStatistics() {
        if (this.requestFilteringPolicy != null) {
            return this.requestFilteringPolicy.getStatistics();
        }
        return null;
    }

    ResourceLimitsPolicyStatistics getResourceLimitsPolicyStatistics() {
        if (this.resourceLimitsPolicy != null) {
            return this.resourceLimitsPolicy.getStatistics();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register() throws InitializationException {
        Validator.ensureNotNull(this.networkGroupID);
        Object object = registeredNetworkGroupsLock;
        synchronized (object) {
            if (registeredNetworkGroups.containsKey(this.networkGroupID)) {
                Message message = CoreMessages.ERR_REGISTER_NETWORK_GROUP_ALREADY_EXISTS.get(this.networkGroupID);
                throw new InitializationException(message);
            }
            TreeMap<String, NetworkGroup> newRegisteredNetworkGroups = new TreeMap<String, NetworkGroup>((SortedMap<String, NetworkGroup>)registeredNetworkGroups);
            newRegisteredNetworkGroups.put(this.networkGroupID, this);
            registeredNetworkGroups = newRegisteredNetworkGroups;
            int index = 0;
            for (NetworkGroup ng : registeredNetworkGroups.values()) {
                if (ng.equals(this) || this.priority <= ng.priority) continue;
                ++index;
            }
            orderedNetworkGroups.add(index, this);
        }
    }

    void setConnectionCriteria(ConnectionCriteria criteria) {
        this.criteria = criteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNetworkGroupPriority(int prio) {
        if (this.priority != prio) {
            Object object = registeredNetworkGroupsLock;
            synchronized (object) {
                this.priority = prio;
                if (registeredNetworkGroups.containsKey(this.networkGroupID)) {
                    orderedNetworkGroups.remove(this);
                    int index = 0;
                    for (NetworkGroup ng : registeredNetworkGroups.values()) {
                        if (ng.equals(this) || this.priority <= ng.priority) continue;
                        ++index;
                    }
                    orderedNetworkGroups.add(index, this);
                }
            }
        }
    }

    StringBuilder toString(String leftMargin) {
        StringBuilder sb = new StringBuilder();
        String newMargin = leftMargin + "   ";
        sb.append(leftMargin + "Networkgroup (" + this.networkGroupID + "\n");
        sb.append(leftMargin + "List of registered workflows:\n");
        for (WorkflowTopologyNode node : this.registeredWorkflowNodes.values()) {
            sb.append((CharSequence)node.toString(newMargin));
        }
        this.namingContexts.toString(leftMargin);
        sb.append(leftMargin + "rootDSEWorkflow:\n");
        if (this.rootDSEWorkflowNode == null) {
            sb.append(newMargin + "null\n");
        } else {
            sb.append((CharSequence)this.rootDSEWorkflowNode.toString(newMargin));
        }
        return sb;
    }

    private void checkWorkflowBaseDN(WorkflowTopologyNode workflowNode) throws DirectoryException {
        String workflowID = workflowNode.getWorkflowImpl().getWorkflowId();
        Validator.ensureNotNull(workflowID);
        if (this.isInternalNetworkGroup) {
            return;
        }
        if (this.isAdminNetworkGroup) {
            return;
        }
        for (WorkflowTopologyNode node : this.registeredWorkflowNodes.values()) {
            DN nodeBaseDN = node.getBaseDN();
            if (!nodeBaseDN.equals(workflowNode.getBaseDN())) continue;
            Message message = CoreMessages.ERR_REGISTER_WORKFLOW_BASE_DN_ALREADY_EXISTS.get(workflowID, this.networkGroupID, node.getWorkflowImpl().getWorkflowId(), workflowNode.getWorkflowImpl().getBaseDN().toString());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
    }

    private void createNetworkGroupQOSPolicy(QOSPolicyCfg policyConfiguration) throws ConfigException, InitializationException {
        QOSPolicy policy;
        QOSPolicyFactory factory;
        Class<QOSPolicyFactory> theClass;
        String className = policyConfiguration.getJavaClass();
        QOSPolicyCfgDefn d = QOSPolicyCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaClassPropertyDefinition();
        try {
            theClass = pd.loadClass(className, QOSPolicyFactory.class);
            factory = theClass.newInstance();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_NETWORK_GROUP_POLICY_CANNOT_INITIALIZE.get(String.valueOf(className), String.valueOf(policyConfiguration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
        try {
            Method method = theClass.getMethod("createQOSPolicy", policyConfiguration.configurationClass());
            policy = (QOSPolicy)method.invoke((Object)factory, policyConfiguration);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable t = e.getCause();
                if (t instanceof InitializationException) {
                    throw (InitializationException)t;
                }
                if (t instanceof ConfigException) {
                    throw (ConfigException)t;
                }
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_NETWORK_GROUP_POLICY_CANNOT_INITIALIZE.get(String.valueOf(className), String.valueOf(policyConfiguration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
        QOSPolicy oldPolicy = this.policies.put(policyConfiguration.dn(), policy);
        if (policy instanceof RequestFilteringPolicy) {
            this.requestFilteringPolicy = (RequestFilteringPolicy)policy;
        } else if (policy instanceof ResourceLimitsPolicy) {
            this.resourceLimitsPolicy = (ResourceLimitsPolicy)policy;
        }
        if (oldPolicy != null) {
            oldPolicy.finalizeQOSPolicy();
        }
    }

    private boolean deregisterWorkflow(Workflow workflow) {
        boolean deregistered = false;
        if (workflow == this.rootDSEWorkflowNode) {
            this.rootDSEWorkflowNode = null;
            deregistered = true;
        } else {
            WorkflowTopologyNode workflowNode = (WorkflowTopologyNode)workflow;
            this.deregisterWorkflowNode(workflowNode);
            deregistered = true;
            workflowNode.remove();
            this.rebuildNamingContextList();
        }
        return deregistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterWorkflowNode(WorkflowTopologyNode workflowNode) {
        Object object = this.registeredWorkflowNodesLock;
        synchronized (object) {
            TreeMap<String, WorkflowTopologyNode> newWorkflowNodes = new TreeMap<String, WorkflowTopologyNode>((SortedMap<String, WorkflowTopologyNode>)this.registeredWorkflowNodes);
            newWorkflowNodes.remove(workflowNode.getWorkflowImpl().getWorkflowId());
            this.registeredWorkflowNodes = newWorkflowNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getRegisteredWorkflows() {
        ArrayList<String> workflowIDs = new ArrayList<String>();
        Object object = this.registeredWorkflowNodesLock;
        synchronized (object) {
            for (WorkflowTopologyNode node : this.registeredWorkflowNodes.values()) {
                workflowIDs.add(node.getWorkflowImpl().getWorkflowId());
            }
        }
        return workflowIDs;
    }

    private void invalidate() {
        this.namingContexts = null;
        this.rootDSEWorkflowNode = null;
        this.registeredWorkflowNodes = null;
    }

    private boolean match(ClientConnection connection) {
        if (this.criteria != null) {
            return this.criteria.matches(connection);
        }
        return true;
    }

    private boolean matchAfterBind(ClientConnection connection, DN bindDN, AuthenticationType authType, boolean isSecure) {
        if (this.criteria != null) {
            return this.criteria.willMatchAfterBind(connection, bindDN, authType, isSecure);
        }
        return true;
    }

    private void rebuildNamingContextList() {
        this.namingContexts.resetLists();
        for (WorkflowTopologyNode workflowNode : this.registeredWorkflowNodes.values()) {
            WorkflowTopologyNode parent = workflowNode.getParent();
            if (parent != null) continue;
            this.namingContexts.addNamingContext(workflowNode);
        }
    }

    private void registerWorkflow(WorkflowImpl workflow, WorkflowElement<?>[] preWorkflowElements, WorkflowElement<?>[] postWorkflowElements) throws DirectoryException {
        DN baseDN = workflow.getBaseDN();
        if (baseDN.isNullDN()) {
            this.rootDSEWorkflowNode = new RootDseWorkflowTopology(workflow, this.namingContexts);
        } else {
            WorkflowTopologyNode workflowNode = new WorkflowTopologyNode(workflow, preWorkflowElements, postWorkflowElements);
            this.registerWorkflowNode(workflowNode);
            for (WorkflowTopologyNode curNode : this.registeredWorkflowNodes.values()) {
                if (!curNode.insertSubordinate(workflowNode) && !workflowNode.insertSubordinate(curNode)) continue;
            }
            this.rebuildNamingContextList();
            if (!(this.isAdminNetworkGroup || this.isInternalNetworkGroup || this.isDefaultNetworkGroup)) {
                workflow.incrementReferenceCounter();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWorkflowNode(WorkflowTopologyNode workflowNode) throws DirectoryException {
        String workflowID = workflowNode.getWorkflowImpl().getWorkflowId();
        Validator.ensureNotNull(workflowID);
        Object object = this.registeredWorkflowNodesLock;
        synchronized (object) {
            if (this.registeredWorkflowNodes.containsKey(workflowID)) {
                Message message = CoreMessages.ERR_REGISTER_WORKFLOW_NODE_ALREADY_EXISTS.get(workflowID, this.networkGroupID);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            this.checkWorkflowBaseDN(workflowNode);
            TreeMap<String, WorkflowTopologyNode> newRegisteredWorkflowNodes = new TreeMap<String, WorkflowTopologyNode>((SortedMap<String, WorkflowTopologyNode>)this.registeredWorkflowNodes);
            newRegisteredWorkflowNodes.put(workflowID, workflowNode);
            this.registeredWorkflowNodes = newRegisteredWorkflowNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        Object object = this.registeredWorkflowNodesLock;
        synchronized (object) {
            this.registeredWorkflowNodes = new TreeMap();
            this.rootDSEWorkflowNode = null;
            this.namingContexts = new NetworkGroupNamingContexts();
        }
    }

    private final class QOSPolicyListener
    implements ConfigurationAddListener<QOSPolicyCfg>,
    ConfigurationDeleteListener<QOSPolicyCfg> {
        private QOSPolicyListener() {
        }

        @Override
        public ConfigChangeResult applyConfigurationAdd(QOSPolicyCfg configuration) {
            ResultCode resultCode = ResultCode.SUCCESS;
            boolean adminActionRequired = false;
            ArrayList<Message> messages = new ArrayList<Message>();
            try {
                NetworkGroup.this.createNetworkGroupQOSPolicy(configuration);
            }
            catch (ConfigException e) {
                messages.add(e.getMessageObject());
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            catch (InitializationException e) {
                messages.add(e.getMessageObject());
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }

        @Override
        public ConfigChangeResult applyConfigurationDelete(QOSPolicyCfg configuration) {
            QOSPolicy policy = (QOSPolicy)NetworkGroup.this.policies.remove(configuration.dn());
            if (policy != null) {
                if (NetworkGroup.this.requestFilteringPolicy == policy) {
                    NetworkGroup.this.requestFilteringPolicy = null;
                } else if (NetworkGroup.this.resourceLimitsPolicy == policy) {
                    NetworkGroup.this.resourceLimitsPolicy = null;
                }
                policy.finalizeQOSPolicy();
            }
            return new ConfigChangeResult(ResultCode.SUCCESS, false);
        }

        @Override
        public boolean isConfigurationAddAcceptable(QOSPolicyCfg configuration, List<Message> unacceptableReasons) {
            return NetworkGroup.isNetworkGroupQOSPolicyConfigurationAcceptable(configuration, unacceptableReasons);
        }

        @Override
        public boolean isConfigurationDeleteAcceptable(QOSPolicyCfg configuration, List<Message> unacceptableReasons) {
            return true;
        }
    }

    private final class ChangeListener
    implements ConfigurationChangeListener<NetworkGroupCfg> {
        private ChangeListener() {
        }

        @Override
        public ConfigChangeResult applyConfigurationChange(NetworkGroupCfg configuration) {
            ResultCode resultCode = ResultCode.SUCCESS;
            boolean adminActionRequired = false;
            ArrayList<Message> messages = new ArrayList<Message>();
            NetworkGroup.this.setNetworkGroupPriority(configuration.getPriority());
            SortedSet<String> configWorkflows = configuration.getWorkflow();
            for (String id : NetworkGroup.this.getRegisteredWorkflows()) {
                if (configWorkflows.contains(id)) continue;
                NetworkGroup.this.deregisterWorkflow(id);
            }
            List ngWorkflows = NetworkGroup.this.getRegisteredWorkflows();
            for (String id : configuration.getWorkflow()) {
                if (ngWorkflows.contains(id)) continue;
                WorkflowImpl workflowImpl = (WorkflowImpl)WorkflowImpl.getWorkflow(id);
                try {
                    NetworkGroup.this.registerWorkflow(workflowImpl);
                }
                catch (DirectoryException e) {
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = e.getResultCode();
                    }
                    messages.add(e.getMessageObject());
                }
            }
            try {
                NetworkGroup.this.criteria = NetworkGroup.decodeConnectionCriteriaConfiguration(configuration);
            }
            catch (ConfigException e) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(e.getMessageObject());
            }
            NetworkGroup.this.configuration = configuration;
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }

        @Override
        public boolean isConfigurationChangeAcceptable(NetworkGroupCfg configuration, List<Message> unacceptableReasons) {
            return NetworkGroup.isConfigurationAcceptable(configuration, unacceptableReasons);
        }
    }
}

