/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.crypto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.opends.admin.ads.ADSContext;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.api.Backend;
import org.opends.server.api.BackendInitializationListener;
import org.opends.server.api.ChangeNotificationListener;
import org.opends.server.api.ClientConnection;
import org.opends.server.controls.EntryChangeNotificationControl;
import org.opends.server.controls.PersistentSearchChangeType;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.crypto.CryptoManagerImpl;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Control;
import org.opends.server.types.CryptoManagerException;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.types.operation.PostResponseAddOperation;
import org.opends.server.types.operation.PostResponseDeleteOperation;
import org.opends.server.types.operation.PostResponseModifyDNOperation;
import org.opends.server.types.operation.PostResponseModifyOperation;
import org.opends.server.util.StaticUtils;

public class CryptoManagerSync
implements BackendInitializationListener,
ChangeNotificationListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN adminSuffixDN;
    private DN instanceKeysDN;
    private DN secretKeysDN;
    private DN trustStoreRootDN;
    AttributeType attrCert;
    AttributeType attrAlias;
    AttributeType attrCompromisedTime;
    private SearchFilter keySearchFilter;
    private ObjectClass ocInstanceKey;
    private ObjectClass ocCipherKey;
    private ObjectClass ocMacKey;

    public CryptoManagerSync() throws InitializationException {
        this(true);
    }

    public CryptoManagerSync(boolean publishInstanceKey) throws InitializationException {
        try {
            if (publishInstanceKey) {
                CryptoManagerImpl.publishInstanceKeyEntryInADS();
            }
        }
        catch (CryptoManagerException ex) {
            throw new InitializationException(ex.getMessageObject());
        }
        DirectoryServer.registerBackendInitializationListener(this);
        try {
            this.adminSuffixDN = DN.decode(ADSContext.getAdministrationSuffixDN());
            this.instanceKeysDN = this.adminSuffixDN.concat(DN.decode("cn=instance keys"));
            this.secretKeysDN = this.adminSuffixDN.concat(DN.decode("cn=secret keys"));
            this.trustStoreRootDN = DN.decode("cn=ads-truststore");
            this.keySearchFilter = SearchFilter.createFilterFromString("(|(objectclass=ds-cfg-instance-key)(objectclass=ds-cfg-cipher-key)(objectclass=ds-cfg-mac-key))");
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
        this.ocInstanceKey = DirectoryServer.getObjectClass("ds-cfg-instance-key", true);
        this.ocCipherKey = DirectoryServer.getObjectClass("ds-cfg-cipher-key", true);
        this.ocMacKey = DirectoryServer.getObjectClass("ds-cfg-mac-key", true);
        this.attrCert = DirectoryServer.getAttributeType("ds-cfg-public-key-certificate", true);
        this.attrAlias = DirectoryServer.getAttributeType("ds-cfg-key-id", true);
        this.attrCompromisedTime = DirectoryServer.getAttributeType("ds-cfg-key-compromised-time", true);
        if (DirectoryServer.getBackendWithBaseDN(this.adminSuffixDN) != null) {
            this.searchAdminSuffix();
        }
        DirectoryServer.registerChangeNotificationListener(this);
    }

    private void searchAdminSuffix() {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        LinkedHashSet<String> attributes = new LinkedHashSet<String>(0);
        ArrayList<Control> controls = new ArrayList<Control>(0);
        InternalSearchOperation searchOperation = new InternalSearchOperation((ClientConnection)conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, this.adminSuffixDN, SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, this.keySearchFilter, attributes, null);
        searchOperation.run();
        ResultCode resultCode = searchOperation.getResultCode();
        if (resultCode != ResultCode.SUCCESS) {
            Message message = CoreMessages.INFO_TRUSTSTORESYNC_ADMIN_SUFFIX_SEARCH_FAILED.get(String.valueOf(this.adminSuffixDN), searchOperation.getErrorMessage().toString());
            ErrorLogger.logError(message);
        }
        for (SearchResultEntry searchEntry : searchOperation.getSearchEntries()) {
            try {
                this.handleInternalSearchEntry(searchEntry);
            }
            catch (DirectoryException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = CoreMessages.ERR_TRUSTSTORESYNC_EXCEPTION.get(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
            }
        }
    }

    @Override
    public void performBackendInitializationProcessing(Backend backend) {
        DN[] baseDNs = backend.getBaseDNs();
        if (baseDNs != null) {
            for (DN baseDN : baseDNs) {
                if (!baseDN.equals(this.adminSuffixDN)) continue;
                this.searchAdminSuffix();
            }
        }
    }

    @Override
    public void performBackendFinalizationProcessing(Backend backend) {
    }

    private void handleInternalSearchEntry(SearchResultEntry searchEntry) throws DirectoryException {
        if (searchEntry.hasObjectClass(this.ocInstanceKey)) {
            this.handleInstanceKeySearchEntry(searchEntry);
        } else {
            try {
                if (searchEntry.hasObjectClass(this.ocCipherKey)) {
                    DirectoryServer.getCryptoManager().importCipherKeyEntry(searchEntry);
                } else if (searchEntry.hasObjectClass(this.ocMacKey)) {
                    DirectoryServer.getCryptoManager().importMacKeyEntry(searchEntry);
                }
            }
            catch (CryptoManagerException e) {
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), e);
            }
        }
    }

    private void handleInstanceKeySearchEntry(SearchResultEntry searchEntry) throws DirectoryException {
        RDN srcRDN = searchEntry.getDN().getRDN();
        if (!srcRDN.isMultiValued() && srcRDN.getAttributeType(0).equals(this.attrAlias)) {
            DN dstDN = this.trustStoreRootDN.concat(srcRDN);
            EntryChangeNotificationControl ecn = null;
            List<Control> controls = searchEntry.getControls();
            try {
                for (Control c : controls) {
                    if (!c.getOID().equals("2.16.840.1.113730.3.4.7")) continue;
                    if (c instanceof LDAPControl) {
                        ecn = EntryChangeNotificationControl.DECODER.decode(c.isCritical(), ((LDAPControl)c).getValue());
                        continue;
                    }
                    ecn = (EntryChangeNotificationControl)c;
                }
            }
            catch (DirectoryException e) {
                // empty catch block
            }
            Entry dstEntry = DirectoryServer.getEntry(dstDN);
            if (ecn != null && ecn.getChangeType() == PersistentSearchChangeType.DELETE) {
                if (dstEntry != null) {
                    this.deleteEntry(dstDN);
                }
            } else if (searchEntry.hasAttribute(this.attrCompromisedTime)) {
                if (dstEntry != null) {
                    this.deleteEntry(dstDN);
                }
            } else if (dstEntry == null) {
                this.addEntry(searchEntry, dstDN);
            } else {
                this.modifyEntry(searchEntry, dstEntry);
            }
        }
    }

    private void modifyEntry(Entry srcEntry, Entry dstEntry) {
        List<Attribute> srcList = srcEntry.getAttribute(this.attrCert);
        List<Attribute> dstList = dstEntry.getAttribute(this.attrCert);
        boolean differ = false;
        if (srcList == null) {
            if (dstList != null) {
                differ = true;
            }
        } else if (dstList == null) {
            differ = true;
        } else if (srcList.size() != dstList.size()) {
            differ = true;
        } else if (!((Object)srcList).equals(dstList)) {
            differ = true;
        }
        if (differ) {
            DN dstDN = dstEntry.getDN();
            this.deleteEntry(dstDN);
            this.addEntry(srcEntry, dstDN);
        }
    }

    private void deleteEntry(DN dstDN) {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        DeleteOperation delOperation = conn.processDelete(dstDN);
        if (delOperation.getResultCode() != ResultCode.SUCCESS) {
            Message message = CoreMessages.INFO_TRUSTSTORESYNC_DELETE_FAILED.get(String.valueOf(dstDN), String.valueOf(delOperation.getErrorMessage()));
            ErrorLogger.logError(message);
        }
    }

    private void addEntry(Entry srcEntry, DN dstDN) {
        LinkedHashMap<ObjectClass, String> ocMap = new LinkedHashMap<ObjectClass, String>(2);
        ocMap.put(DirectoryServer.getTopObjectClass(), "top");
        ocMap.put(this.ocInstanceKey, "ds-cfg-instance-key");
        HashMap<AttributeType, List<Attribute>> userAttrs = new HashMap<AttributeType, List<Attribute>>();
        List<Attribute> attrList = srcEntry.getAttribute(this.attrAlias);
        if (attrList != null) {
            userAttrs.put(this.attrAlias, attrList);
        }
        if ((attrList = srcEntry.getAttribute(this.attrCert)) != null) {
            userAttrs.put(this.attrCert, attrList);
        }
        Entry addEntry = new Entry(dstDN, ocMap, userAttrs, null);
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        AddOperation addOperation = conn.processAdd(addEntry);
        if (addOperation.getResultCode() != ResultCode.SUCCESS) {
            Message message = CoreMessages.INFO_TRUSTSTORESYNC_ADD_FAILED.get(String.valueOf(dstDN), String.valueOf(addOperation.getErrorMessage()));
            ErrorLogger.logError(message);
        }
    }

    @Override
    public void handleAddOperation(PostResponseAddOperation addOperation, Entry entry) {
        if (addOperation.getEntryDN().isDescendantOf(this.instanceKeysDN)) {
            this.handleInstanceKeyAddOperation(entry);
        } else if (addOperation.getEntryDN().isDescendantOf(this.secretKeysDN)) {
            try {
                if (entry.hasObjectClass(this.ocCipherKey)) {
                    DirectoryServer.getCryptoManager().importCipherKeyEntry(entry);
                } else if (entry.hasObjectClass(this.ocMacKey)) {
                    DirectoryServer.getCryptoManager().importMacKeyEntry(entry);
                }
            }
            catch (CryptoManagerException e) {
                Message message = Message.raw("Failed to import key entry: %s", e.getMessage());
                ErrorLogger.logError(message);
            }
        }
    }

    private void handleInstanceKeyAddOperation(Entry entry) {
        RDN srcRDN = entry.getDN().getRDN();
        if (!srcRDN.isMultiValued() && srcRDN.getAttributeType(0).equals(this.attrAlias)) {
            DN dstDN = this.trustStoreRootDN.concat(srcRDN);
            if (!entry.hasAttribute(this.attrCompromisedTime)) {
                this.addEntry(entry, dstDN);
            }
        }
    }

    @Override
    public void handleDeleteOperation(PostResponseDeleteOperation deleteOperation, Entry entry) {
        if (!deleteOperation.getEntryDN().isDescendantOf(this.instanceKeysDN)) {
            return;
        }
        RDN srcRDN = entry.getDN().getRDN();
        if (!srcRDN.isMultiValued() && srcRDN.getAttributeType(0).equals(this.attrAlias)) {
            DN dstDN = this.trustStoreRootDN.concat(srcRDN);
            this.deleteEntry(dstDN);
        }
    }

    @Override
    public void handleModifyOperation(PostResponseModifyOperation modifyOperation, Entry oldEntry, Entry newEntry) {
        if (modifyOperation.getEntryDN().isDescendantOf(this.instanceKeysDN)) {
            this.handleInstanceKeyModifyOperation(newEntry);
        } else if (modifyOperation.getEntryDN().isDescendantOf(this.secretKeysDN)) {
            try {
                if (newEntry.hasObjectClass(this.ocCipherKey)) {
                    DirectoryServer.getCryptoManager().importCipherKeyEntry(newEntry);
                } else if (newEntry.hasObjectClass(this.ocMacKey)) {
                    DirectoryServer.getCryptoManager().importMacKeyEntry(newEntry);
                }
            }
            catch (CryptoManagerException e) {
                Message message = Message.raw("Failed to import modified key entry: %s", e.getMessage());
                ErrorLogger.logError(message);
            }
        }
    }

    private void handleInstanceKeyModifyOperation(Entry newEntry) {
        RDN srcRDN = newEntry.getDN().getRDN();
        if (!srcRDN.isMultiValued() && srcRDN.getAttributeType(0).equals(this.attrAlias)) {
            DN dstDN = this.trustStoreRootDN.concat(srcRDN);
            Entry dstEntry = null;
            try {
                dstEntry = DirectoryServer.getEntry(dstDN);
            }
            catch (DirectoryException e) {
                // empty catch block
            }
            if (newEntry.hasAttribute(this.attrCompromisedTime)) {
                if (dstEntry != null) {
                    this.deleteEntry(dstDN);
                }
            } else if (dstEntry == null) {
                this.addEntry(newEntry, dstDN);
            } else {
                this.modifyEntry(newEntry, dstEntry);
            }
        }
    }

    @Override
    public void handleModifyDNOperation(PostResponseModifyDNOperation modifyDNOperation, Entry oldEntry, Entry newEntry) {
    }
}

