/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.DynamicGroupImplementationCfg;
import org.opends.server.api.Group;
import org.opends.server.config.ConfigException;
import org.opends.server.extensions.DynamicGroupMemberList;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDAPURL;
import org.opends.server.types.MemberList;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.Validator;

public class DynamicGroup
extends Group<DynamicGroupImplementationCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN groupEntryDN;
    private LinkedHashSet<LDAPURL> memberURLs;

    public DynamicGroup() {
    }

    public DynamicGroup(DN groupEntryDN, LinkedHashSet<LDAPURL> memberURLs) {
        Validator.ensureNotNull(groupEntryDN, memberURLs);
        this.groupEntryDN = groupEntryDN;
        this.memberURLs = memberURLs;
    }

    @Override
    public void initializeGroupImplementation(DynamicGroupImplementationCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public DynamicGroup newInstance(Entry groupEntry) throws DirectoryException {
        Validator.ensureNotNull(groupEntry);
        LinkedHashSet<LDAPURL> memberURLs = new LinkedHashSet<LDAPURL>();
        AttributeType memberURLType = DirectoryConfig.getAttributeType("memberurl", true);
        List<Attribute> attrList = groupEntry.getAttribute(memberURLType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                for (AttributeValue v : a) {
                    try {
                        memberURLs.add(LDAPURL.decode(v.getValue().toString(), true));
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        Message message = ExtensionMessages.ERR_DYNAMICGROUP_CANNOT_DECODE_MEMBERURL.get(v.getValue().toString(), String.valueOf(groupEntry.getDN()), de.getMessageObject());
                        ErrorLogger.logError(message);
                    }
                }
            }
        }
        return new DynamicGroup(groupEntry.getDN(), memberURLs);
    }

    @Override
    public SearchFilter getGroupDefinitionFilter() throws DirectoryException {
        return SearchFilter.createFilterFromString("(objectClass=groupOfURLs)");
    }

    @Override
    public boolean isGroupDefinition(Entry entry) {
        Validator.ensureNotNull(entry);
        ObjectClass groupOfURLsClass = DirectoryConfig.getObjectClass("groupofurls", true);
        return entry.hasObjectClass(groupOfURLsClass);
    }

    @Override
    public DN getGroupDN() {
        return this.groupEntryDN;
    }

    @Override
    public void setGroupDN(DN groupDN) {
        this.groupEntryDN = groupDN;
    }

    public Set<LDAPURL> getMemberURLs() {
        return this.memberURLs;
    }

    @Override
    public boolean supportsNestedGroups() {
        return false;
    }

    @Override
    public List<DN> getNestedGroupDNs() {
        return Collections.emptyList();
    }

    @Override
    public void addNestedGroup(DN nestedGroupDN) throws UnsupportedOperationException, DirectoryException {
        Message message = ExtensionMessages.ERR_DYNAMICGROUP_NESTING_NOT_SUPPORTED.get();
        throw new UnsupportedOperationException(message.toString());
    }

    @Override
    public void removeNestedGroup(DN nestedGroupDN) throws UnsupportedOperationException, DirectoryException {
        Message message = ExtensionMessages.ERR_DYNAMICGROUP_NESTING_NOT_SUPPORTED.get();
        throw new UnsupportedOperationException(message.toString());
    }

    @Override
    public boolean isMember(DN userDN, Set<DN> examinedGroups) throws DirectoryException {
        if (!examinedGroups.add(this.getGroupDN())) {
            return false;
        }
        Entry entry = DirectoryConfig.getEntry(userDN);
        if (entry == null) {
            return false;
        }
        return this.isMember(entry);
    }

    @Override
    public boolean isMember(Entry userEntry, Set<DN> examinedGroups) throws DirectoryException {
        if (!examinedGroups.add(this.getGroupDN())) {
            return false;
        }
        for (LDAPURL memberURL : this.memberURLs) {
            if (!memberURL.matchesEntry(userEntry)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MemberList getMembers() throws DirectoryException {
        return new DynamicGroupMemberList(this.groupEntryDN, this.memberURLs);
    }

    @Override
    public MemberList getMembers(DN baseDN, SearchScope scope, SearchFilter filter) throws DirectoryException {
        if (baseDN == null && filter == null) {
            return new DynamicGroupMemberList(this.groupEntryDN, this.memberURLs);
        }
        return new DynamicGroupMemberList(this.groupEntryDN, this.memberURLs, baseDN, scope, filter);
    }

    @Override
    public boolean mayAlterMemberList() {
        return false;
    }

    @Override
    public void addMember(Entry userEntry) throws UnsupportedOperationException, DirectoryException {
        Message message = ExtensionMessages.ERR_DYNAMICGROUP_ALTERING_MEMBERS_NOT_SUPPORTED.get();
        throw new UnsupportedOperationException(message.toString());
    }

    @Override
    public void removeMember(DN userDN) throws UnsupportedOperationException, DirectoryException {
        Message message = ExtensionMessages.ERR_DYNAMICGROUP_ALTERING_MEMBERS_NOT_SUPPORTED.get();
        throw new UnsupportedOperationException(message.toString());
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("DynamicGroup(dn=");
        buffer.append(this.groupEntryDN);
        buffer.append(",urls={");
        if (!this.memberURLs.isEmpty()) {
            Iterator iterator = this.memberURLs.iterator();
            buffer.append("\"");
            ((LDAPURL)iterator.next()).toString(buffer, false);
            while (iterator.hasNext()) {
                buffer.append("\", ");
                ((LDAPURL)iterator.next()).toString(buffer, false);
            }
            buffer.append("\"");
        }
        buffer.append("})");
    }
}

