/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opends.server.extensions.DynamicGroupSearchThread;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPURL;
import org.opends.server.types.MemberList;
import org.opends.server.types.MembershipException;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;

public class DynamicGroupMemberList
extends MemberList {
    private boolean searchesCompleted;
    private final DN baseDN;
    private final DN groupDN;
    private final LinkedBlockingQueue<Object> resultQueue;
    private final SearchFilter filter;
    private final SearchScope scope;
    private final Set<LDAPURL> memberURLs;

    public DynamicGroupMemberList(DN groupDN, Set<LDAPURL> memberURLs) throws DirectoryException {
        this(groupDN, memberURLs, null, null, null);
    }

    public DynamicGroupMemberList(DN groupDN, Set<LDAPURL> memberURLs, DN baseDN, SearchScope scope, SearchFilter filter) throws DirectoryException {
        LinkedList urlList;
        this.groupDN = groupDN;
        this.memberURLs = memberURLs;
        this.baseDN = baseDN;
        this.filter = filter;
        this.scope = scope == null ? SearchScope.WHOLE_SUBTREE : scope;
        this.searchesCompleted = false;
        this.resultQueue = new LinkedBlockingQueue(10);
        LinkedHashMap<DN, LinkedList> baseDNs = new LinkedHashMap<DN, LinkedList>();
        for (LDAPURL memberURL : memberURLs) {
            DN urlBaseDN = memberURL.getBaseDN();
            if (baseDN != null) {
                if (baseDN.isDescendantOf(urlBaseDN)) {
                    urlBaseDN = baseDN;
                } else if (!urlBaseDN.isDescendantOf(baseDN)) continue;
            }
            if (baseDNs.isEmpty()) {
                urlList = new LinkedList();
                urlList.add(memberURL);
                baseDNs.put(urlBaseDN, urlList);
                continue;
            }
            urlList = (LinkedList)baseDNs.get(urlBaseDN);
            if (urlList == null) {
                boolean found = false;
                Iterator iterator = baseDNs.keySet().iterator();
                while (iterator.hasNext()) {
                    DN existingBaseDN = (DN)iterator.next();
                    if (urlBaseDN.isDescendantOf(existingBaseDN)) {
                        urlList = (LinkedList)baseDNs.get(existingBaseDN);
                        urlList.add(memberURL);
                        found = true;
                        break;
                    }
                    if (!existingBaseDN.isDescendantOf(urlBaseDN)) continue;
                    urlList = (LinkedList)baseDNs.get(existingBaseDN);
                    urlList.add(memberURL);
                    iterator.remove();
                    baseDNs.put(urlBaseDN, urlList);
                    found = true;
                    break;
                }
                if (found) continue;
                urlList = new LinkedList();
                urlList.add(memberURL);
                baseDNs.put(urlBaseDN, urlList);
                continue;
            }
            urlList.add(memberURL);
        }
        LinkedHashMap<DN, SearchFilter> searchMap = new LinkedHashMap<DN, SearchFilter>();
        for (DN urlBaseDN : baseDNs.keySet()) {
            SearchFilter combinedFilter;
            urlList = (LinkedList)baseDNs.get(urlBaseDN);
            LinkedHashSet<SearchFilter> urlFilters = new LinkedHashSet<SearchFilter>();
            for (LDAPURL url : urlList) {
                urlFilters.add(url.getFilter());
            }
            if (filter == null) {
                combinedFilter = urlFilters.size() == 1 ? (SearchFilter)urlFilters.iterator().next() : SearchFilter.createORFilter(urlFilters);
            } else if (urlFilters.size() == 1) {
                SearchFilter urlFilter = (SearchFilter)urlFilters.iterator().next();
                if (urlFilter.equals(filter)) {
                    combinedFilter = filter;
                } else {
                    LinkedHashSet<SearchFilter> filterSet = new LinkedHashSet<SearchFilter>();
                    filterSet.add(filter);
                    filterSet.add(urlFilter);
                    combinedFilter = SearchFilter.createANDFilter(filterSet);
                }
            } else if (urlFilters.contains(filter)) {
                combinedFilter = filter;
            } else {
                LinkedHashSet<SearchFilter> filterSet = new LinkedHashSet<SearchFilter>();
                filterSet.add(filter);
                filterSet.add(SearchFilter.createORFilter(urlFilters));
                combinedFilter = SearchFilter.createANDFilter(filterSet);
            }
            searchMap.put(urlBaseDN, combinedFilter);
        }
        DN[] baseDNArray = new DN[baseDNs.size()];
        SearchFilter[] filterArray = new SearchFilter[baseDNArray.length];
        LDAPURL[][] urlArray = new LDAPURL[baseDNArray.length][];
        Iterator iterator = baseDNs.keySet().iterator();
        for (int i = 0; i < baseDNArray.length; ++i) {
            baseDNArray[i] = (DN)iterator.next();
            filterArray[i] = (SearchFilter)searchMap.get(baseDNArray[i]);
            LinkedList urlList2 = (LinkedList)baseDNs.get(baseDNArray[i]);
            urlArray[i] = new LDAPURL[urlList2.size()];
            int j = 0;
            for (LDAPURL url : urlList2) {
                urlArray[i][j++] = url;
            }
        }
        DynamicGroupSearchThread searchThread = new DynamicGroupSearchThread(this, baseDNArray, filterArray, urlArray);
        searchThread.start();
    }

    public final DN getDynamicGroupDN() {
        return this.groupDN;
    }

    final void setSearchesCompleted() {
        this.searchesCompleted = true;
    }

    final boolean addResult(Entry entry) {
        try {
            return this.resultQueue.offer(entry, 10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    final boolean addResult(MembershipException membershipException) {
        try {
            return this.resultQueue.offer(membershipException, 10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    @Override
    public boolean hasMoreMembers() {
        while (!this.searchesCompleted) {
            if (this.resultQueue.peek() != null) {
                return true;
            }
            try {
                Thread.sleep(0L, 1000);
            }
            catch (Exception exception) {}
        }
        return this.resultQueue.peek() != null;
    }

    @Override
    public Entry nextMemberEntry() throws MembershipException {
        if (!this.hasMoreMembers()) {
            return null;
        }
        Object result = this.resultQueue.poll();
        if (result == null) {
            this.close();
            return null;
        }
        if (result instanceof Entry) {
            return (Entry)result;
        }
        if (result instanceof MembershipException) {
            MembershipException me = (MembershipException)result;
            if (!me.continueIterating()) {
                this.close();
            }
            throw me;
        }
        this.close();
        return null;
    }

    @Override
    public void close() {
        this.searchesCompleted = true;
        this.resultQueue.clear();
    }
}

