/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.CertificateMapperCfg;
import org.opends.server.admin.std.server.SubjectAttributeToUserAttributeCertificateMapperCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.CertificateMapper;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.IndexType;
import org.opends.server.types.InitializationException;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

public class SubjectAttributeToUserAttributeCertificateMapper
extends CertificateMapper<SubjectAttributeToUserAttributeCertificateMapperCfg>
implements ConfigurationChangeListener<SubjectAttributeToUserAttributeCertificateMapperCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN configEntryDN;
    private LinkedHashMap<String, AttributeType> attributeMap;
    private SubjectAttributeToUserAttributeCertificateMapperCfg currentConfig;
    private LinkedHashSet<String> requestedAttributes;

    @Override
    public void initializeCertificateMapper(SubjectAttributeToUserAttributeCertificateMapperCfg configuration) throws ConfigException, InitializationException {
        Message message;
        configuration.addSubjectAttributeToUserAttributeChangeListener(this);
        this.currentConfig = configuration;
        this.configEntryDN = configuration.dn();
        this.attributeMap = new LinkedHashMap();
        for (String mapStr : configuration.getSubjectAttributeMapping()) {
            String lowerMap = StaticUtils.toLowerCase(mapStr);
            int colonPos = lowerMap.indexOf(58);
            if (colonPos <= 0) {
                Message message2 = ExtensionMessages.ERR_SATUACM_INVALID_MAP_FORMAT.get(String.valueOf(this.configEntryDN), mapStr);
                throw new ConfigException(message2);
            }
            String certAttrName = lowerMap.substring(0, colonPos).trim();
            String userAttrName = lowerMap.substring(colonPos + 1).trim();
            if (certAttrName.length() == 0 || userAttrName.length() == 0) {
                message = ExtensionMessages.ERR_SATUACM_INVALID_MAP_FORMAT.get(String.valueOf(this.configEntryDN), mapStr);
                throw new ConfigException(message);
            }
            if (this.attributeMap.containsKey(certAttrName = SubjectAttributeToUserAttributeCertificateMapper.normalizeAttributeName(certAttrName))) {
                message = ExtensionMessages.ERR_SATUACM_DUPLICATE_CERT_ATTR.get(String.valueOf(this.configEntryDN), certAttrName);
                throw new ConfigException(message);
            }
            AttributeType userAttrType = DirectoryServer.getAttributeType(userAttrName, false);
            if (userAttrType == null) {
                Message message3 = ExtensionMessages.ERR_SATUACM_NO_SUCH_ATTR.get(mapStr, String.valueOf(this.configEntryDN), userAttrName);
                throw new ConfigException(message3);
            }
            for (AttributeType attrType : this.attributeMap.values()) {
                if (!attrType.equals(userAttrType)) continue;
                Message message4 = ExtensionMessages.ERR_SATUACM_DUPLICATE_USER_ATTR.get(String.valueOf(this.configEntryDN), attrType.getNameOrOID());
                throw new ConfigException(message4);
            }
            this.attributeMap.put(certAttrName, userAttrType);
        }
        Set<DN> cfgBaseDNs = configuration.getUserBaseDN();
        if (cfgBaseDNs == null || cfgBaseDNs.isEmpty()) {
            cfgBaseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        for (DN baseDN : cfgBaseDNs) {
            for (AttributeType t : this.attributeMap.values()) {
                Backend b = DirectoryServer.getBackend(baseDN);
                if (b == null || b.isIndexed(t, IndexType.EQUALITY)) continue;
                message = ExtensionMessages.WARN_SATUACM_ATTR_UNINDEXED.get(configuration.dn().toString(), t.getNameOrOID(), b.getBackendID());
                ErrorLogger.logError(message);
            }
        }
        this.requestedAttributes = new LinkedHashSet(2);
        this.requestedAttributes.add("*");
        this.requestedAttributes.add("+");
    }

    @Override
    public void finalizeCertificateMapper() {
        this.currentConfig.removeSubjectAttributeToUserAttributeChangeListener(this);
    }

    @Override
    public Entry mapCertificateToUser(Certificate[] certificateChain) throws DirectoryException {
        DN peerDN;
        X509Certificate peerCertificate;
        SubjectAttributeToUserAttributeCertificateMapperCfg config = this.currentConfig;
        LinkedHashMap<String, AttributeType> theAttributeMap = this.attributeMap;
        if (certificateChain == null || certificateChain.length == 0) {
            Message message = ExtensionMessages.ERR_SATUACM_NO_PEER_CERTIFICATE.get();
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message);
        }
        try {
            peerCertificate = (X509Certificate)certificateChain[0];
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_SATUACM_PEER_CERT_NOT_X509.get(String.valueOf(certificateChain[0].getType()));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message);
        }
        X500Principal peerPrincipal = peerCertificate.getSubjectX500Principal();
        String peerName = peerPrincipal.getName("RFC2253");
        try {
            peerDN = DN.decode(peerName);
        }
        catch (DirectoryException de) {
            Message message = ExtensionMessages.ERR_SATUACM_CANNOT_DECODE_SUBJECT_AS_DN.get(peerName, de.getMessageObject());
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, de);
        }
        LinkedList<SearchFilter> filterComps = new LinkedList<SearchFilter>();
        for (int i = 0; i < peerDN.getNumComponents(); ++i) {
            RDN rdn = peerDN.getRDN(i);
            for (int j = 0; j < rdn.getNumValues(); ++j) {
                String lowerName = StaticUtils.toLowerCase(rdn.getAttributeName(j));
                AttributeType attrType = theAttributeMap.get(lowerName = SubjectAttributeToUserAttributeCertificateMapper.normalizeAttributeName(lowerName));
                if (attrType == null) continue;
                filterComps.add(SearchFilter.createEqualityFilter(attrType, rdn.getAttributeValue(j)));
            }
        }
        if (filterComps.isEmpty()) {
            Message message = ExtensionMessages.ERR_SATUACM_NO_MAPPABLE_ATTRIBUTES.get(String.valueOf(peerDN));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message);
        }
        SearchFilter filter = SearchFilter.createANDFilter(filterComps);
        Set<DN> baseDNs = config.getUserBaseDN();
        if (baseDNs == null || baseDNs.isEmpty()) {
            baseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        SearchResultEntry userEntry = null;
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        for (DN baseDN : baseDNs) {
            InternalSearchOperation searchOperation = conn.processSearch(baseDN, SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 1, 10, false, filter, this.requestedAttributes);
            switch (searchOperation.getResultCode()) {
                case SUCCESS: {
                    break;
                }
                case NO_SUCH_OBJECT: {
                    break;
                }
                case SIZE_LIMIT_EXCEEDED: {
                    Message message = ExtensionMessages.ERR_SATUACM_MULTIPLE_SEARCH_MATCHING_ENTRIES.get(String.valueOf(peerDN));
                    throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message);
                }
                case TIME_LIMIT_EXCEEDED: 
                case ADMIN_LIMIT_EXCEEDED: {
                    Message message = ExtensionMessages.ERR_SATUACM_INEFFICIENT_SEARCH.get(String.valueOf(peerDN), String.valueOf(searchOperation.getErrorMessage()));
                    throw new DirectoryException(searchOperation.getResultCode(), message);
                }
                default: {
                    Message message = ExtensionMessages.ERR_SATUACM_SEARCH_FAILED.get(String.valueOf(peerDN), String.valueOf(searchOperation.getErrorMessage()));
                    throw new DirectoryException(searchOperation.getResultCode(), message);
                }
            }
            for (SearchResultEntry entry : searchOperation.getSearchEntries()) {
                if (userEntry == null) {
                    userEntry = entry;
                    continue;
                }
                Message message = ExtensionMessages.ERR_SATUACM_MULTIPLE_MATCHING_ENTRIES.get(String.valueOf(peerDN), String.valueOf(userEntry.getDN()), String.valueOf(entry.getDN()));
                throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message);
            }
        }
        return userEntry;
    }

    @Override
    public boolean isConfigurationAcceptable(CertificateMapperCfg configuration, List<Message> unacceptableReasons) {
        SubjectAttributeToUserAttributeCertificateMapperCfg config = (SubjectAttributeToUserAttributeCertificateMapperCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SubjectAttributeToUserAttributeCertificateMapperCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        DN cfgEntryDN = configuration.dn();
        LinkedHashMap<String, AttributeType> newAttributeMap = new LinkedHashMap<String, AttributeType>();
        block0: for (String mapStr : configuration.getSubjectAttributeMapping()) {
            String lowerMap = StaticUtils.toLowerCase(mapStr);
            int colonPos = lowerMap.indexOf(58);
            if (colonPos <= 0) {
                unacceptableReasons.add(ExtensionMessages.ERR_SATUACM_INVALID_MAP_FORMAT.get(String.valueOf(cfgEntryDN), mapStr));
                configAcceptable = false;
                break;
            }
            String certAttrName = lowerMap.substring(0, colonPos).trim();
            String userAttrName = lowerMap.substring(colonPos + 1).trim();
            if (certAttrName.length() == 0 || userAttrName.length() == 0) {
                unacceptableReasons.add(ExtensionMessages.ERR_SATUACM_INVALID_MAP_FORMAT.get(String.valueOf(cfgEntryDN), mapStr));
                configAcceptable = false;
                break;
            }
            if (newAttributeMap.containsKey(certAttrName = SubjectAttributeToUserAttributeCertificateMapper.normalizeAttributeName(certAttrName))) {
                unacceptableReasons.add(ExtensionMessages.ERR_SATUACM_DUPLICATE_CERT_ATTR.get(String.valueOf(cfgEntryDN), certAttrName));
                configAcceptable = false;
                break;
            }
            AttributeType userAttrType = DirectoryServer.getAttributeType(userAttrName, false);
            if (userAttrType == null) {
                unacceptableReasons.add(ExtensionMessages.ERR_SATUACM_NO_SUCH_ATTR.get(mapStr, String.valueOf(cfgEntryDN), userAttrName));
                configAcceptable = false;
                break;
            }
            for (AttributeType attrType : newAttributeMap.values()) {
                if (!attrType.equals(userAttrType)) continue;
                unacceptableReasons.add(ExtensionMessages.ERR_SATUACM_DUPLICATE_USER_ATTR.get(String.valueOf(cfgEntryDN), attrType.getNameOrOID()));
                configAcceptable = false;
                break block0;
            }
            newAttributeMap.put(certAttrName, userAttrType);
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SubjectAttributeToUserAttributeCertificateMapperCfg configuration) {
        Set<DN> cfgBaseDNs;
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        LinkedHashMap<String, AttributeType> newAttributeMap = new LinkedHashMap<String, AttributeType>();
        block0: for (String mapStr : configuration.getSubjectAttributeMapping()) {
            String lowerMap = StaticUtils.toLowerCase(mapStr);
            int colonPos = lowerMap.indexOf(58);
            if (colonPos <= 0) {
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                }
                messages.add(ExtensionMessages.ERR_SATUACM_INVALID_MAP_FORMAT.get(String.valueOf(this.configEntryDN), mapStr));
                break;
            }
            String certAttrName = lowerMap.substring(0, colonPos).trim();
            String userAttrName = lowerMap.substring(colonPos + 1).trim();
            if (certAttrName.length() == 0 || userAttrName.length() == 0) {
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                }
                messages.add(ExtensionMessages.ERR_SATUACM_INVALID_MAP_FORMAT.get(String.valueOf(this.configEntryDN), mapStr));
                break;
            }
            if (newAttributeMap.containsKey(certAttrName = SubjectAttributeToUserAttributeCertificateMapper.normalizeAttributeName(certAttrName))) {
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                }
                messages.add(ExtensionMessages.ERR_SATUACM_DUPLICATE_CERT_ATTR.get(String.valueOf(this.configEntryDN), certAttrName));
                break;
            }
            AttributeType userAttrType = DirectoryServer.getAttributeType(userAttrName, false);
            if (userAttrType == null) {
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                }
                messages.add(ExtensionMessages.ERR_SATUACM_NO_SUCH_ATTR.get(mapStr, String.valueOf(this.configEntryDN), userAttrName));
                break;
            }
            for (AttributeType attrType : newAttributeMap.values()) {
                if (!attrType.equals(userAttrType)) continue;
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                }
                messages.add(ExtensionMessages.ERR_SATUACM_DUPLICATE_USER_ATTR.get(String.valueOf(this.configEntryDN), attrType.getNameOrOID()));
                break block0;
            }
            newAttributeMap.put(certAttrName, userAttrType);
        }
        if ((cfgBaseDNs = configuration.getUserBaseDN()) == null || cfgBaseDNs.isEmpty()) {
            cfgBaseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        for (DN baseDN : cfgBaseDNs) {
            for (AttributeType t : newAttributeMap.values()) {
                Backend b = DirectoryServer.getBackend(baseDN);
                if (b == null || b.isIndexed(t, IndexType.EQUALITY)) continue;
                Message message = ExtensionMessages.WARN_SATUACM_ATTR_UNINDEXED.get(configuration.dn().toString(), t.getNameOrOID(), b.getBackendID());
                messages.add(message);
                ErrorLogger.logError(message);
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.attributeMap = newAttributeMap;
            this.currentConfig = configuration;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private static String normalizeAttributeName(String attrName) {
        String attrNameNormalized;
        AttributeType attrType = DirectoryServer.getAttributeType(attrName, false);
        if (attrType != null && (attrNameNormalized = attrType.getNormalizedPrimaryName()) != null) {
            attrName = attrNameNormalized;
        }
        return attrName;
    }
}

