/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageDescriptor;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.std.server.LogPublisherCfg;
import org.opends.server.api.LogPublisher;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.LogLevel;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public abstract class AbstractLogger<P extends LogPublisher<C>, C extends LogPublisherCfg>
implements ConfigurationAddListener<C>,
ConfigurationDeleteListener<C>,
ConfigurationChangeListener<C> {
    private final Class<P> logPublisherClass;
    private final MessageDescriptor.Arg3<CharSequence, CharSequence, CharSequence> invalidLoggerClassErrorMessage;

    protected abstract LoggerStorage<P, C> getStorage();

    protected abstract ClassPropertyDefinition getJavaClassPropertyDefinition();

    public AbstractLogger(Class<P> logPublisherClass, MessageDescriptor.Arg3<CharSequence, CharSequence, CharSequence> invalidLoggerClassErrorMessage) {
        this.logPublisherClass = logPublisherClass;
        this.invalidLoggerClassErrorMessage = invalidLoggerClassErrorMessage;
    }

    public void initializeLogger(List<C> configs) throws ConfigException, InitializationException {
        for (LogPublisherCfg config : configs) {
            config.addChangeListener(this);
            if (!config.isEnabled()) continue;
            this.getStorage().addLogPublisher(this.getLogPublisher(config));
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(C config, List<Message> unacceptableReasons) {
        return !config.isEnabled() || this.isJavaClassAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(C config, List<Message> unacceptableReasons) {
        return !config.isEnabled() || this.isJavaClassAcceptable(config, unacceptableReasons);
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(C config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        config.addChangeListener(this);
        if (config.isEnabled()) {
            try {
                this.getStorage().addLogPublisher(this.getLogPublisher(config));
            }
            catch (ConfigException e) {
                this.debugCaught(DebugLogLevel.ERROR, e);
                messages.add(e.getMessageObject());
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            catch (Exception e) {
                this.debugCaught(DebugLogLevel.ERROR, e);
                messages.add(ConfigMessages.ERR_CONFIG_LOGGER_CANNOT_CREATE_LOGGER.get(String.valueOf(config.dn().toString()), StaticUtils.stackTraceToSingleLineString(e)));
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private void debugCaught(LogLevel error, Exception e) {
        if (DebugLogger.debugEnabled()) {
            DebugLogger.getTracer().debugCaught(DebugLogLevel.ERROR, e);
        }
    }

    private P findLogPublisher(DN dn) {
        Collection<P> logPublishers = this.getStorage().getLogPublishers();
        for (LogPublisher publisher : logPublishers) {
            if (!publisher.getDN().equals(dn)) continue;
            return (P)publisher;
        }
        return null;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(C config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        P logPublisher = this.findLogPublisher(config.dn());
        if (logPublisher == null) {
            if (config.isEnabled()) {
                return this.applyConfigurationAdd(config);
            }
        } else if (config.isEnabled()) {
            String className = config.getJavaClass();
            if (!className.equals(logPublisher.getClass().getName())) {
                adminActionRequired = true;
            }
        } else {
            this.getStorage().removeLogPublisher(logPublisher);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(C config, List<Message> unacceptableReasons) {
        return this.findLogPublisher(config.dn()) != null;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(C config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        P logPublisher = this.findLogPublisher(config.dn());
        if (logPublisher != null) {
            this.getStorage().removeLogPublisher(logPublisher);
        } else {
            resultCode = ResultCode.NO_SUCH_OBJECT;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired);
    }

    private boolean isJavaClassAcceptable(C config, List<Message> unacceptableReasons) {
        String className = config.getJavaClass();
        ClassPropertyDefinition pd = this.getJavaClassPropertyDefinition();
        try {
            LogPublisher publisher = (LogPublisher)pd.loadClass(className, this.logPublisherClass).newInstance();
            return publisher.isConfigurationAcceptable(config, unacceptableReasons);
        }
        catch (Exception e) {
            Message message = this.invalidLoggerClassErrorMessage.get(className, config.dn().toString(), String.valueOf(e));
            unacceptableReasons.add(message);
            return false;
        }
    }

    private P getLogPublisher(C config) throws ConfigException {
        String className = config.getJavaClass();
        ClassPropertyDefinition pd = this.getJavaClassPropertyDefinition();
        try {
            LogPublisher logPublisher = (LogPublisher)pd.loadClass(className, this.logPublisherClass).newInstance();
            logPublisher.initializeLogPublisher(config);
            return (P)logPublisher;
        }
        catch (Exception e) {
            Message message = this.invalidLoggerClassErrorMessage.get(className, config.dn().toString(), String.valueOf(e));
            throw new ConfigException(message, (Throwable)e);
        }
    }

    protected static class LoggerStorage<P extends LogPublisher<C>, C extends LogPublisherCfg> {
        private Collection<P> logPublishers = new CopyOnWriteArrayList<P>();

        public synchronized void addLogPublisher(P publisher) {
            this.logPublishers.add(publisher);
        }

        public synchronized boolean removeLogPublisher(P publisher) {
            boolean removed = this.logPublishers.remove(publisher);
            if (removed) {
                publisher.close();
            }
            return removed;
        }

        public synchronized void removeAllLogPublishers() {
            StaticUtils.close(this.logPublishers);
            this.logPublishers.clear();
        }

        public Collection<P> getLogPublishers() {
            return this.logPublishers;
        }
    }
}

