/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.std.meta.ErrorLogPublisherCfgDefn;
import org.opends.server.admin.std.server.ErrorLogPublisherCfg;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.ErrorLogPublisher;
import org.opends.server.backends.task.Task;
import org.opends.server.loggers.AbstractLogger;

public class ErrorLogger
extends AbstractLogger<ErrorLogPublisher<ErrorLogPublisherCfg>, ErrorLogPublisherCfg> {
    private static AbstractLogger.LoggerStorage<ErrorLogPublisher<ErrorLogPublisherCfg>, ErrorLogPublisherCfg> loggerStorage = new AbstractLogger.LoggerStorage();
    private static final ErrorLogger instance = new ErrorLogger();

    public static ErrorLogger getInstance() {
        return instance;
    }

    public ErrorLogger() {
        super(ErrorLogPublisher.class, ConfigMessages.ERR_CONFIG_LOGGER_INVALID_ERROR_LOGGER_CLASS);
    }

    @Override
    protected ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return ErrorLogPublisherCfgDefn.getInstance().getJavaClassPropertyDefinition();
    }

    @Override
    protected AbstractLogger.LoggerStorage<ErrorLogPublisher<ErrorLogPublisherCfg>, ErrorLogPublisherCfg> getStorage() {
        return loggerStorage;
    }

    public static synchronized void addErrorLogPublisher(ErrorLogPublisher publisher) {
        loggerStorage.addLogPublisher(publisher);
    }

    public static synchronized boolean removeErrorLogPublisher(ErrorLogPublisher publisher) {
        return loggerStorage.removeLogPublisher(publisher);
    }

    public static synchronized void removeAllErrorLogPublishers() {
        loggerStorage.removeAllLogPublishers();
    }

    public static void logError(Message message) {
        DirectoryThread thread;
        Task task;
        for (ErrorLogPublisher<ErrorLogPublisherCfg> publisher : loggerStorage.getLogPublishers()) {
            publisher.logError(message);
        }
        if (Thread.currentThread() instanceof DirectoryThread && (task = (thread = (DirectoryThread)Thread.currentThread()).getAssociatedTask()) != null) {
            task.addLogMessage(message);
        }
    }
}

