/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.IOException;
import java.io.OutputStream;

class MeteredStream
extends OutputStream {
    OutputStream out;
    long written;

    MeteredStream(OutputStream out, long written) {
        this.out = out;
        this.written = written;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.written;
    }

    @Override
    public void write(byte[] buff) throws IOException {
        this.out.write(buff);
        this.written += (long)buff.length;
    }

    @Override
    public void write(byte[] buff, int off, int len) throws IOException {
        this.out.write(buff, off, len);
        this.written += (long)len;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

