/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers.debug;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.std.meta.DebugLogPublisherCfgDefn;
import org.opends.server.admin.std.server.DebugLogPublisherCfg;
import org.opends.server.api.DebugLogPublisher;
import org.opends.server.loggers.AbstractLogger;
import org.opends.server.loggers.LogLevel;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;

public class DebugLogger
extends AbstractLogger<DebugLogPublisher<DebugLogPublisherCfg>, DebugLogPublisherCfg> {
    static final LogLevel DEFAULT_CONSTRUCTOR_LEVEL = DebugLogLevel.VERBOSE;
    static final LogLevel DEFAULT_ENTRY_EXIT_LEVEL = DebugLogLevel.VERBOSE;
    static final LogLevel DEFAULT_THROWN_LEVEL = DebugLogLevel.ERROR;
    private static Map<String, DebugTracer> classTracers = new ConcurrentHashMap<String, DebugTracer>();
    static boolean enabled = false;
    private static final AbstractLogger.LoggerStorage<DebugLogPublisher<DebugLogPublisherCfg>, DebugLogPublisherCfg> loggerStorage = new AbstractLogger.LoggerStorage();
    static final DebugLogger instance = new DebugLogger();

    public DebugLogger() {
        super(DebugLogPublisher.class, ConfigMessages.ERR_CONFIG_LOGGER_INVALID_DEBUG_LOGGER_CLASS);
    }

    @Override
    protected ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return DebugLogPublisherCfgDefn.getInstance().getJavaClassPropertyDefinition();
    }

    @Override
    protected AbstractLogger.LoggerStorage<DebugLogPublisher<DebugLogPublisherCfg>, DebugLogPublisherCfg> getStorage() {
        return loggerStorage;
    }

    public static synchronized void addDebugLogPublisher(DebugLogPublisher publisher) {
        loggerStorage.addLogPublisher(publisher);
        DebugLogger.updateTracerSettings();
        enabled = true;
    }

    public static synchronized boolean removeDebugLogPublisher(DebugLogPublisher publisher) {
        boolean removed = loggerStorage.removeLogPublisher(publisher);
        DebugLogger.updateTracerSettings();
        enabled = !loggerStorage.getLogPublishers().isEmpty();
        return removed;
    }

    public static synchronized void removeAllDebugLogPublishers() {
        loggerStorage.removeAllLogPublishers();
        DebugLogger.updateTracerSettings();
        enabled = false;
    }

    static void updateTracerSettings() {
        DebugLogPublisher[] publishers = loggerStorage.getLogPublishers().toArray(new DebugLogPublisher[0]);
        for (DebugTracer tracer : classTracers.values()) {
            tracer.updateSettings(publishers);
        }
    }

    public static boolean debugEnabled() {
        return enabled;
    }

    public static DebugLogger getInstance() {
        return instance;
    }

    public static DebugTracer getTracer() {
        DebugTracer tracer = new DebugTracer(loggerStorage.getLogPublishers().toArray(new DebugLogPublisher[0]));
        classTracers.put(tracer.getTracedClassName(), tracer);
        return tracer;
    }

    public static DebugTracer getTracer(String className) {
        return classTracers.get(className);
    }

    public static @interface TraceThrown {
    }

    public static @interface NoExitDebugTracing {
    }

    public static @interface NoEntryDebugTracing {
    }

    public static @interface NoDebugTracing {
    }
}

