/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers.debug;

import org.opends.server.util.ServerConstants;

public class DebugStackTraceFormatter {
    public static final int COMPLETE_STACK = Integer.MAX_VALUE;
    public static final FrameFilter SMART_FRAME_FILTER = new SmartFrameFilter();

    public static String formatStackTrace(Throwable t) {
        return DebugStackTraceFormatter.formatStackTrace(t, Integer.MAX_VALUE, true);
    }

    public static String formatStackTrace(Throwable t, int maxDepth, boolean includeCause) {
        Throwable ourCause;
        StringBuilder buffer = new StringBuilder();
        StackTraceElement[] trace = t.getStackTrace();
        int frameLimit = Math.min(maxDepth, trace.length);
        for (int i = 0; i < frameLimit; ++i) {
            buffer.append("  at ");
            buffer.append(trace[i]);
            buffer.append(ServerConstants.EOL);
        }
        if (frameLimit < trace.length) {
            buffer.append("  ... ");
            buffer.append(trace.length - frameLimit);
            buffer.append(" more");
            buffer.append(ServerConstants.EOL);
        }
        if (includeCause && (ourCause = t.getCause()) != null) {
            DebugStackTraceFormatter.formatStackTraceForCause(ourCause, maxDepth, buffer, trace);
        }
        return buffer.toString();
    }

    private static void formatStackTraceForCause(Throwable t, int maxDepth, StringBuilder buffer, StackTraceElement[] causedTrace) {
        Throwable ourCause;
        StackTraceElement[] trace = t.getStackTrace();
        int framesToSkip = Math.max(trace.length - maxDepth, 0);
        int m = trace.length - 1 - framesToSkip;
        for (int n = causedTrace.length - 1 - framesToSkip; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        framesToSkip = trace.length - 1 - m;
        buffer.append("Caused by: ");
        buffer.append(t);
        buffer.append(ServerConstants.EOL);
        for (int i = 0; i <= m; ++i) {
            buffer.append("  at ");
            buffer.append(trace[i]);
            buffer.append(ServerConstants.EOL);
        }
        if (framesToSkip != 0) {
            buffer.append("  ... ");
            buffer.append(framesToSkip);
            buffer.append(" more");
            buffer.append(ServerConstants.EOL);
        }
        if ((ourCause = t.getCause()) != null) {
            DebugStackTraceFormatter.formatStackTraceForCause(ourCause, maxDepth, buffer, trace);
        }
    }

    public static String formatStackTrace(StackTraceElement[] stackTrace, int maxDepth) {
        int frameLimit;
        StringBuilder buffer = new StringBuilder();
        if (stackTrace != null && (frameLimit = Math.min(maxDepth, stackTrace.length)) > 0) {
            for (int i = 0; i < frameLimit; ++i) {
                buffer.append("  ");
                buffer.append(stackTrace[i]);
                buffer.append(ServerConstants.EOL);
            }
            if (frameLimit < stackTrace.length) {
                buffer.append("  ...(");
                buffer.append(stackTrace.length - frameLimit);
                buffer.append(" more)");
                buffer.append(ServerConstants.EOL);
            }
        }
        return buffer.toString();
    }

    private static class SmartFrameFilter
    implements FrameFilter {
        private SmartFrameFilter() {
        }

        private boolean isFrameForPackage(StackTraceElement frame, String packageName) {
            boolean isContained = false;
            if (frame != null) {
                String className = frame.getClassName();
                isContained = className != null && className.startsWith(packageName);
            }
            return isContained;
        }

        @Override
        public StackTraceElement[] getFilteredStackTrace(StackTraceElement[] frames) {
            StackTraceElement[] trimmedStack = null;
            if (frames != null && frames.length > 0) {
                int lastFrame;
                int firstFrame;
                for (firstFrame = 0; firstFrame < frames.length && this.isFrameForPackage(frames[firstFrame], "org.opends.server.loggers.debug"); ++firstFrame) {
                }
                for (lastFrame = frames.length - 1; lastFrame > firstFrame && !this.isFrameForPackage(frames[lastFrame], "org.opends"); --lastFrame) {
                }
                trimmedStack = new StackTraceElement[lastFrame - firstFrame + 1];
                for (int i = firstFrame; i <= lastFrame; ++i) {
                    trimmedStack[i - firstFrame] = frames[i];
                }
            }
            return trimmedStack;
        }
    }

    public static interface FrameFilter {
        public StackTraceElement[] getFilteredStackTrace(StackTraceElement[] var1);
    }
}

